/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.swap.model.data.hierarchy.elementary;

import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.communicator.ProtocolParser;
import org.tizen.dynamicanalyzer.protocol.Protocol;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.HierarchyUIObjectProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.PropertyValue;
import org.tizen.dynamicanalyzer.util.Logger;

public class ElmFlipProperties
extends HierarchyUIObjectProperties {
    private String interaction;
    private boolean frontVisible;

    public ElmFlipProperties(Protocol protocolVersion) {
        super(protocolVersion);
    }

    @Override
    public void parsePropertiesFromByte(ProtocolParser parser) {
        this.interaction = this.getInteractionMessage(parser.getChar());
        this.frontVisible = parser.getBoolean();
    }

    @Override
    public List<PropertyValue> getProperties() {
        ArrayList<PropertyValue> properties = new ArrayList<PropertyValue>();
        properties.add(new PropertyValue("interaction", this.interaction));
        properties.add(new PropertyValue("frontVisible", Boolean.toString(this.frontVisible)));
        return properties;
    }

    private String getInteractionMessage(int code) {
        switch (code) {
            case 0: {
                return "ELM_FLIP_INTERACTION_NONE";
            }
            case 1: {
                return "ELM_FLIP_INTERACTION_ROTATE";
            }
            case 2: {
                return "ELM_FLIP_INTERACTION_CUBE";
            }
            case 3: {
                return "ELM_FLIP_INTERACTION_PAGE";
            }
        }
        Logger.warning((Object)("Invalid code : " + code));
        return "-";
    }
}

