/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.common.explorer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridCellRenderer;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridHeaderRenderer;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.tizen.dynamicanalyzer.communicator.DACommunicator;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.ui.common.explorer.DAFileExplorerEmptyCellRenderer;
import org.tizen.dynamicanalyzer.ui.common.explorer.DeviceExplorerTableRenderer;
import org.tizen.dynamicanalyzer.ui.common.explorer.ExplorerUtil;
import org.tizen.dynamicanalyzer.ui.widgets.DAGrid;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableHeaderRenderer;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButton;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonClickEventListener;
import org.tizen.dynamicanalyzer.widgets.da.base.DAButton;
import org.tizen.dynamicanalyzer.widgets.da.base.DATextBox;
import org.tizen.dynamicanalyzer.widgets.tooltip.DACustomTooltip;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.service.FileEntry;
import org.tizen.sdblib.service.FileEntryType;

public class DeviceExplorer
extends Composite {
    protected static int FAIL = -1;
    protected static int FILE = 1;
    protected static int DIRECTORY = 2;
    private static int PERMISSION_STR_LENGTH = 10;
    private static int PERMISSION_FILTER_LENGTH = 3;
    protected Grid table = null;
    protected DATextBox inputText = null;
    protected DACustomButton goButton = null;
    protected IDevice device = null;
    protected FileEntry root = null;
    protected FileEntry currentDir = null;
    protected FileEntry selected = null;
    protected String nameFilter = null;
    protected String permissionFilterStr = null;
    private int permissionFilter = 0;
    protected String selectionStr = null;
    private SelectionListener tableSelectionListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            GridItem[] selections = DeviceExplorer.this.table.getSelection();
            GridItem selection = selections[0];
            FileEntry file = (FileEntry)selection.getData(ExplorerUtil.DATA_FIEL_KEY);
            Logger.debug((Object)("Selected : " + file.getFullPath()));
            DeviceExplorer.this.selected = file;
            DeviceExplorer.this.inputText.setBackground(ColorResources.WHITE);
            DeviceExplorer.this.inputText.getControl().setSelection(DeviceExplorer.this.inputText.getText().length());
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };
    private MouseListener tableMouseListener = new MouseListener(){

        public void mouseUp(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseDoubleClick(MouseEvent e) {
            if (DeviceExplorer.this.selected.isDirectory() || DeviceExplorer.this.selected.isRoot()) {
                DeviceExplorer.this.currentDir = DeviceExplorer.this.selected;
                DeviceExplorer.this.updateData();
            }
        }
    };
    private DACustomButtonClickEventListener goButtonClickListener = new DACustomButtonClickEventListener(){

        public void handleClickEvent(DACustomButton button) {
            DeviceExplorer.this.adjustInput();
        }
    };
    private KeyListener inputKeyListener = new KeyListener(){

        public void keyReleased(KeyEvent e) {
            if (e.keyCode == 13) {
                DeviceExplorer.this.adjustInput();
                DeviceExplorer.this.inputText.getControl().setSelection(DeviceExplorer.this.inputText.getText().length());
            }
        }

        public void keyPressed(KeyEvent e) {
        }
    };
    private FocusListener inputTextFocusListener = new FocusListener(){

        public void focusLost(FocusEvent e) {
        }

        public void focusGained(FocusEvent e) {
            GridItem[] selections = new GridItem[]{};
            DeviceExplorer.this.table.setSelection(selections);
            int length = DeviceExplorer.this.inputText.getText().length();
            DeviceExplorer.this.inputText.getControl().setSelection(0, length);
        }
    };
    private DACustomTooltip tooltip = new DACustomTooltip(){

        public void setTooltipMessage() {
            this.tooltipMessage.clear();
            String binaryDetailInfo = DACommunicator.getBinaryDetailInformation(this.getSelectedItem());
            if (binaryDetailInfo != null && !binaryDetailInfo.isEmpty()) {
                this.tooltipMessage.add(binaryDetailInfo);
            }
        }

        public void setTooltipMessage(String name) {
        }
    };
    private Listener tableTooltipListener = new Listener(){

        public void handleEvent(Event event) {
            if (event.type == 6 || event.type == 5) {
                GridItem item = DeviceExplorer.this.table.getItem(new Point(event.x, event.y));
                if (item == null) {
                    return;
                }
                FileEntry file = (FileEntry)item.getData(ExplorerUtil.DATA_FIEL_KEY);
                if (file.isDirectory() || file.isRoot()) {
                    DeviceExplorer.this.tooltip.setSeletedItem(null);
                    DeviceExplorer.this.tooltip.close();
                } else {
                    DeviceExplorer.this.tooltip.setSeletedItem(file.getFullPath());
                    DeviceExplorer.this.tooltip.openAndMove(DeviceExplorer.this.table.getShell());
                }
            }
            if (event.type == 7) {
                DeviceExplorer.this.tooltip.close();
            }
        }
    };

    public DeviceExplorer(Composite parent, boolean multiSelection) {
        super(parent, 0);
        this.setLayout((Layout)new FormLayout());
        this.setBackground(ColorResources.DIALOG_BG_UPPER);
        this.inputText = new DATextBox((Composite)this, 4);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 5);
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(100, -80);
        data.height = 15;
        this.inputText.setLayoutData((Object)data);
        this.inputText.getControl().addKeyListener(this.inputKeyListener);
        this.inputText.getControl().addFocusListener(this.inputTextFocusListener);
        this.goButton = new DAButton((Composite)this, 0);
        data = new FormData();
        data.top = new FormAttachment(0, 5);
        data.left = new FormAttachment((Control)this.inputText.getControl(), 5);
        data.right = new FormAttachment(100, -5);
        data.height = 19;
        this.goButton.setLayoutData((Object)data);
        this.goButton.setText("Go");
        this.goButton.addClickListener(this.goButtonClickListener);
        int style = 2560;
        style = multiSelection ? (style |= 2) : (style |= 4);
        this.table = new DAGrid(this, style);
        this.table.setBackground(ColorResources.TABLE_CONTENTS_NORMAL);
        this.table.setForeground(ColorResources.TABLE_CONTENTS_FONT_COLOR);
        this.setColumns();
        this.table.setEmptyCellRenderer((GridCellRenderer)new DAFileExplorerEmptyCellRenderer());
        this.table.setItemHeight(32);
        data = new FormData();
        data.top = new FormAttachment((Control)this.inputText.getControl(), 7);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        this.table.setLayoutData((Object)data);
        this.table.addSelectionListener(this.tableSelectionListener);
        this.table.addMouseListener(this.tableMouseListener);
        this.setTableToolTipListener();
    }

    public void setTableToolTipListener() {
        this.table.addListener(6, this.tableTooltipListener);
        this.table.addListener(7, this.tableTooltipListener);
        this.table.addListener(5, this.tableTooltipListener);
    }

    private void setColumns() {
        GridColumn fileColumn = new GridColumn(this.table, 0);
        fileColumn.setCellRenderer((GridCellRenderer)new DeviceExplorerTableRenderer());
        fileColumn.setHeaderRenderer((GridHeaderRenderer)new DATableHeaderRenderer());
        fileColumn.setText("File");
        fileColumn.setWidth(450);
    }

    public void updateData() {
        if (this.currentDir == null) {
            if (this.root == null) {
                Logger.debug((Object)"Root is empty");
                return;
            }
            this.currentDir = this.root;
        }
        this.table.removeAll();
        this.inputText.setText(this.currentDir.getFullPath());
        if (!this.currentDir.getFullPath().equals(this.root.getFullPath())) {
            GridItem parentItem = new GridItem(this.table, 0);
            parentItem.setText(ExplorerUtil.PARENT_STR);
            parentItem.setData(ExplorerUtil.DATA_FIEL_KEY, (Object)this.currentDir.getParent());
        }
        FileEntry[] children = this.currentDir.getChildren();
        int selectionIndex = -1;
        if (children != null) {
            int index;
            FileEntry child;
            int size = children.length;
            int i = 0;
            while (i < size) {
                child = children[i];
                if (child.isDirectory() && child.getType() != FileEntryType.DirectoryLink) {
                    GridItem item = new GridItem(this.table, 0);
                    item.setText(child.getName());
                    item.setData(ExplorerUtil.DATA_FIEL_KEY, (Object)child);
                    if (this.selectionStr != null && this.selectionStr.equals(child.getFullPath())) {
                        index = this.table.indexOf(item);
                        this.table.setSelection(index);
                        this.selected = child;
                        this.inputText.setText(child.getFullPath());
                        selectionIndex = index;
                    }
                }
                ++i;
            }
            i = 0;
            while (i < size) {
                int permission;
                child = children[i];
                if (!(child.isDirectory() || child.getType() == FileEntryType.Link || this.nameFilter != null && !child.getName().contains(this.nameFilter) || this.permissionFilter != 0 && ((permission = this.getPermission(child.getPermissions())) & this.permissionFilter) != this.permissionFilter)) {
                    GridItem item = new GridItem(this.table, 0);
                    item.setText(child.getName());
                    item.setData(ExplorerUtil.DATA_FIEL_KEY, (Object)child);
                    if (this.selectionStr != null && this.selectionStr.equals(child.getFullPath())) {
                        index = this.table.indexOf(item);
                        this.table.setSelection(index);
                        this.selected = child;
                        this.inputText.setText(child.getFullPath());
                        selectionIndex = index;
                    }
                }
                ++i;
            }
            this.table.getVerticalBar().setMaximum(size);
            this.table.getVerticalBar().setSelection(selectionIndex);
        }
        this.table.update();
    }

    public void setRoot(String r) {
        if (this.device != null && r != null && !r.isEmpty()) {
            FileEntry rootDir = this.device.getFileEntry(r);
            if (rootDir == null || !rootDir.isDirectory() && !rootDir.isRoot()) {
                Logger.debug((Object)"root path is invalid");
                return;
            }
            this.root = rootDir;
        }
    }

    public void addTableMouseListener(MouseListener listener) {
        this.table.addMouseListener(listener);
    }

    public List<FileEntry> getSelection() {
        String path;
        FileEntry file;
        GridItem[] selections = this.table.getSelection();
        ArrayList<FileEntry> fileEntries = new ArrayList<FileEntry>();
        if (selections.length > 0) {
            int i = 0;
            while (i < selections.length) {
                GridItem selection = selections[i];
                if (!selection.getText().equals(ExplorerUtil.PARENT_STR)) {
                    FileEntry entry = (FileEntry)selection.getData(ExplorerUtil.DATA_FIEL_KEY);
                    fileEntries.add(entry);
                }
                ++i;
            }
        } else if (this.inputText.getText() != null && !this.inputText.getText().isEmpty() && (file = this.device.getFileEntry(path = this.inputText.getText())) != null) {
            fileEntries.add(file);
        }
        return fileEntries;
    }

    public void setDevice(IDevice dev) {
        this.device = dev;
    }

    public int setCurrent(String path) {
        int result = FAIL;
        if (path != null && !path.isEmpty()) {
            FileEntry file = this.device.getFileEntry(path);
            if (file == null || file.getType() == FileEntryType.Unknown) {
                Logger.debug((Object)"invalid path");
                return result;
            }
            if (!file.isDirectory() && !file.isRoot()) {
                this.currentDir = file.getParent();
                this.selectionStr = file.getFullPath();
                result = FILE;
            } else {
                this.currentDir = file;
                this.selectionStr = "";
                result = DIRECTORY;
            }
            this.updateData();
        }
        return result;
    }

    private void adjustInput() {
        String errorstr = null;
        String path = this.inputText.getText();
        if (path != null && !path.isEmpty()) {
            if (path.contains(this.root.getFullPath())) {
                if (this.setCurrent(path) != FAIL) {
                    this.inputText.setBackground(ColorResources.WHITE);
                } else {
                    errorstr = "Failed to set current directory";
                }
            } else {
                errorstr = "Out of root range";
            }
        } else {
            errorstr = "path must not empty";
        }
        if (errorstr != null) {
            Logger.debug((Object)errorstr);
            this.inputText.setText(this.currentDir.getFullPath());
        }
    }

    private int getPermission(String permissionStr) {
        int permission = 0;
        if (permissionStr != null && permissionStr.length() == PERMISSION_STR_LENGTH) {
            int i = 1;
            while (i < permissionStr.length()) {
                permission <<= 1;
                switch (permissionStr.charAt(i)) {
                    case 'r': 
                    case 'w': 
                    case 'x': {
                        permission |= 1;
                        break;
                    }
                }
                ++i;
            }
        }
        return permission;
    }

    public void setNameFilter(String filter) {
        this.nameFilter = filter;
    }

    public void setPermissionFilter(String filter) {
        if (filter == null || filter.length() == PERMISSION_FILTER_LENGTH) {
            this.permissionFilterStr = filter;
            if (filter != null) {
                int userclass = filter.charAt(0) - 48;
                int groupclass = filter.charAt(1) - 48;
                int otherclass = filter.charAt(2) - 48;
                this.permissionFilter = userclass << 6 | groupclass << 3 | otherclass;
            } else {
                this.permissionFilter = 0;
            }
        }
    }
}

