/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.file;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.constant.CommonConstants;
import org.tizen.dynamicanalyzer.database.SqlConnectionManager;
import org.tizen.dynamicanalyzer.nl.AnalyzerLabels;
import org.tizen.dynamicanalyzer.nl.FilePageLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.ui.file.manager.FileDataManager;
import org.tizen.dynamicanalyzer.ui.file.model.FileAccessor;
import org.tizen.dynamicanalyzer.ui.file.model.FileSelectedData;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;

public class FileDetailInfoView
extends DAViewComposite {
    private Canvas canvas = null;
    private String fileName = AnalyzerLabels.EMPTY_STRING;
    private String filePath = AnalyzerLabels.EMPTY_STRING;
    private long fileSize = 0L;
    private long readSize = 0L;
    private long writeSize = 0L;
    private int apiCount = 0;
    private int failedApiCount = 0;
    private FileDataManager fileChartManager = FileDataManager.getInstance();
    private Text detailText = null;
    private Label labelMessage = null;

    private void init() {
        this.fileName = AnalyzerLabels.EMPTY_STRING;
        this.filePath = AnalyzerLabels.EMPTY_STRING;
        this.fileSize = 0L;
        this.readSize = 0L;
        this.writeSize = 0L;
        this.apiCount = 0;
        this.failedApiCount = 0;
    }

    public FileDetailInfoView(Composite parent, int style) {
        super(parent, style, false);
        this.setLayout((Layout)new FillLayout());
        this.setTitle(FilePageLabels.FILE_DETAILS_TITLE);
        Composite detailCom = this.getContentArea();
        detailCom.setBackground(ColorResources.VIEW_BG_COLOR);
        detailCom.setLayout((Layout)new FormLayout());
        FormData labelData = new FormData();
        labelData.top = new FormAttachment(0, 0);
        labelData.left = new FormAttachment(0, 0);
        labelData.right = new FormAttachment(100, 0);
        labelData.bottom = new FormAttachment(100, 0);
        detailCom.setLayoutData((Object)labelData);
        Composite contents = detailCom;
        contents.setBackground(ColorResources.VIEW_BG_COLOR);
        contents.setLayout((Layout)new FormLayout());
        this.detailText = new Text(contents, 2816);
        this.detailText.setBackground(ColorResources.VIEW_BG_COLOR);
        this.detailText.setForeground(ColorResources.TABLE_CONTENTS_FONT_COLOR);
        this.detailText.setFont(FontResources.DETAIL_INFO_FONT);
        FormData buttonData = new FormData();
        buttonData.top = new FormAttachment((Control)this.labelMessage, 0);
        buttonData.left = new FormAttachment(0, 0);
        buttonData.right = new FormAttachment(100, 0);
        buttonData.bottom = new FormAttachment(100, 0);
        this.detailText.setLayoutData((Object)buttonData);
        this.showDetailInfoContents();
    }

    public void updateView(DAViewData data) {
        FileSelectedData selectedData;
        DASelectionData selData;
        if (data instanceof DASelectionData && (selData = (DASelectionData)data).getData() instanceof FileSelectedData && (selectedData = (FileSelectedData)selData.getData()) != null) {
            this.updateData(selectedData);
        }
    }

    public void updateView() {
    }

    private void updateData(FileSelectedData selectData) {
        this.failedApiCount = 0;
        ResultSet rs = this.fileChartManager.getApiDB().selectAPI(selectData.getFileId(), selectData.getAccessorId(), selectData.isParentChart(), null);
        boolean isParentChart = selectData.isParentChart();
        FileAccessor accessor = selectData.getFileAccessor();
        String path = null;
        if (rs != null) {
            block22: {
                try {
                    try {
                        long readSize = 0L;
                        long writeSize = 0L;
                        int apiCount = 0;
                        while (rs.next()) {
                            ++apiCount;
                            if (rs.isFirst()) {
                                path = isParentChart ? rs.getString(11) : accessor.getFilePath();
                                boolean isFindSpliter = false;
                                int i = path.length() - 1;
                                while (i > 0) {
                                    char character = path.charAt(i);
                                    if (Character.toString(character).matches("\\/")) {
                                        this.filePath = path.substring(0, i + 1);
                                        this.fileName = path.substring(i + 1, path.length());
                                        isFindSpliter = true;
                                        break;
                                    }
                                    --i;
                                }
                                if (!isFindSpliter) {
                                    this.fileName = path;
                                    this.filePath = AnalyzerLabels.EMPTY_STRING;
                                }
                            } else if (rs.isLast()) {
                                this.fileSize = rs.getLong(7);
                            }
                            int apiType = rs.getInt(3);
                            long errno = rs.getInt(6);
                            long ioSize = rs.getLong(8);
                            switch (apiType) {
                                case 0: 
                                case 1: 
                                case 8: 
                                case 16: {
                                    if (errno == 0L) break;
                                    ++this.failedApiCount;
                                    break;
                                }
                                case 15: {
                                    if (errno != 0L) {
                                        ++this.failedApiCount;
                                    }
                                    --apiCount;
                                    break;
                                }
                                case 3: {
                                    if (errno != 0L) {
                                        ++this.failedApiCount;
                                    }
                                    readSize += ioSize;
                                    --apiCount;
                                    break;
                                }
                                case 5: {
                                    if (errno != 0L) {
                                        ++this.failedApiCount;
                                    }
                                    writeSize += ioSize;
                                    --apiCount;
                                    break;
                                }
                            }
                        }
                        this.apiCount = apiCount;
                        this.readSize = readSize;
                        this.writeSize = writeSize;
                    }
                    catch (SQLException e) {
                        Logger.exception((Throwable)e);
                        SqlConnectionManager.releaseResultSet(rs);
                        break block22;
                    }
                }
                catch (Throwable throwable) {
                    SqlConnectionManager.releaseResultSet(rs);
                    throw throwable;
                }
                SqlConnectionManager.releaseResultSet(rs);
            }
            this.showDetailInfoContents();
        }
    }

    private void showDetailInfoContents() {
        StringBuffer strDetailView = new StringBuffer(CommonConstants.DOUBLE_NEW_LINE);
        strDetailView.append("  " + FilePageLabels.FILE_DETAILS_FILE_PATH);
        strDetailView.append(this.filePath);
        strDetailView.append(CommonConstants.DOUBLE_NEW_LINE);
        strDetailView.append("  " + FilePageLabels.FILE_DETAILS_FILE_NAME);
        strDetailView.append(this.fileName);
        strDetailView.append(CommonConstants.DOUBLE_NEW_LINE);
        strDetailView.append("  " + FilePageLabels.FILE_DETAILS_TOTAL_SIZE);
        strDetailView.append(this.fileSize);
        strDetailView.append(CommonConstants.DOUBLE_NEW_LINE);
        strDetailView.append("  " + FilePageLabels.FILE_DETAILS_READ_SIZE);
        strDetailView.append(this.readSize);
        strDetailView.append(CommonConstants.DOUBLE_NEW_LINE);
        strDetailView.append("  " + FilePageLabels.FILE_DETAILS_WRITE_SIZE);
        strDetailView.append(this.writeSize);
        strDetailView.append(CommonConstants.DOUBLE_NEW_LINE);
        strDetailView.append("  " + FilePageLabels.FILE_DETAILS_API_COUNT);
        strDetailView.append(this.apiCount);
        strDetailView.append(CommonConstants.DOUBLE_NEW_LINE);
        strDetailView.append("  " + FilePageLabels.FILE_DETAILS_FAILED_API_COUNT);
        strDetailView.append(this.failedApiCount);
        strDetailView.append(CommonConstants.DOUBLE_NEW_LINE);
        this.detailText.setText(strDetailView.toString());
    }

    public Control getControl() {
        return this.canvas;
    }

    public void clear() {
        this.init();
        this.showDetailInfoContents();
    }
}

