/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.file.data;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.database.DBColumn;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.database.SqlConnectionManager;
import org.tizen.dynamicanalyzer.ui.file.model.FileEvent;
import org.tizen.dynamicanalyzer.util.Logger;

public class FileApiDB
extends DBTable {
    public static final String TABLENAME = "FILE_API";
    private static final String DBTYPE_RETURN_VALUE = "VARCHAR(1024)";
    private static final String DBTYPE_ARGUMENTS_VALUE = "VARCHAR(1024)";
    private static final String selectAllColumn = FileApiDB.selectAllColumn();
    private static final String SELECT_APIS_FOR_CHILD = "select SEQUENCE_NUMBER, FD, API_TYPE, EVENT_TIME, API_ID, ERROR_NUMBER, FILE_SIZE, IO_SIZE, RETURN_VALUE, ARGUMENT from FILE_API where ACCESSOR_ID = '%d'";
    private static final String SELECT_APIS_FOR_PARENT = "select api.SEQUENCE_NUMBER, api.FD, api.API_TYPE, api.EVENT_TIME, api.API_ID, api.ERROR_NUMBER, api.FILE_SIZE, api.IO_SIZE, api.RETURN_VALUE, api.ARGUMENT, accessor.FILE_PATH, accessor.PID, accessor.TID from FILE_API api, FILE_ACCESSOR accessor where api.FILE_ID = '%d' and api.ACCESSOR_ID = accessor.ACCESSOR_ID";
    private static final String SELECT_FILE_EVENT_BY_SEQ = "select " + COLUMN.ACCESSOR_ID.name + " from " + "FILE_API" + " where " + COLUMN.SEQUENCE_NUMBER.name + " = '%d'";
    private static final String SELECT_APIS_COUNT = "select COUNT(*) from FILE_API";
    private static final String SELECT_ALL = "select " + selectAllColumn + " from " + "FILE_API";

    @Override
    public String getTableName() {
        return TABLENAME;
    }

    public FileApiDB() {
        this.addColumn(new DBColumn(COLUMN.SEQUENCE_NUMBER.name, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.FILE_ID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.ACCESSOR_ID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.FD.name, "", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.API_TYPE.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.EVENT_TIME.name, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.API_ID.name, "", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.ERRNO.name, "", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.FILE_SIZE.name, "", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.IO_SIZE.name, "", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.RETURN_VALUE.name, "", "VARCHAR(1024)"));
        this.addColumn(new DBColumn(COLUMN.ARGUMENT.name, "", "VARCHAR(1024)"));
    }

    public ResultSet executeQuery(String query) {
        ResultSet rs = SqlConnectionManager.executeQueryRS(query);
        return rs;
    }

    public List<FileEvent> executeQueryRS(String query) {
        ArrayList<FileEvent> resultData = new ArrayList<FileEvent>();
        ResultSet rs = SqlConnectionManager.executeQueryRS(query);
        if (rs != null) {
            try {
                try {
                    while (rs.next()) {
                        FileEvent event = this.getDataFromResultSet(rs);
                        if (event == null) continue;
                        resultData.add(event);
                    }
                }
                catch (SQLException e) {
                    Logger.exception((Throwable)e);
                    SqlConnectionManager.releaseResultSet(rs);
                }
            }
            finally {
                SqlConnectionManager.releaseResultSet(rs);
            }
        }
        return resultData;
    }

    public FileEvent getDataFromResultSet(ResultSet rs) {
        FileEvent event = null;
        try {
            event = new FileEvent(rs.getLong(COLUMN.SEQUENCE_NUMBER.index), rs.getInt(COLUMN.FILE_ID.index), rs.getInt(COLUMN.ACCESSOR_ID.index), rs.getLong(COLUMN.FD.index), rs.getInt(COLUMN.API_TYPE.index), rs.getInt(COLUMN.API_ID.index), rs.getLong(COLUMN.EVENT_TIME.index), rs.getLong(COLUMN.FILE_SIZE.index), rs.getLong(COLUMN.IO_SIZE.index), rs.getString(COLUMN.ARGUMENT.index), rs.getString(COLUMN.RETURN_VALUE.index), rs.getLong(COLUMN.ERRNO.index));
        }
        catch (SQLException e) {
            Logger.exception((Throwable)e);
            return null;
        }
        return event;
    }

    public void insert(List<List<Object>> insertData) {
        this.insertData(insertData);
    }

    public ResultSet selectAPI(int fileId, int accessorId, boolean isParentChart, List<String> whereClause) {
        String query = null;
        query = isParentChart ? String.format(SELECT_APIS_FOR_PARENT, fileId) : String.format(SELECT_APIS_FOR_CHILD, accessorId);
        if (whereClause != null && whereClause.size() > 0) {
            int i = 0;
            while (i < whereClause.size()) {
                query = String.valueOf(query) + " and " + whereClause.get(i);
                ++i;
            }
        }
        return SqlConnectionManager.executeQueryRS(query);
    }

    public ResultSet selectFileEventBySeq(long seq) {
        String query = String.format(SELECT_FILE_EVENT_BY_SEQ, seq);
        return SqlConnectionManager.executeQueryRS(query);
    }

    public int getTotal() {
        String query = SELECT_APIS_COUNT;
        ResultSet rs = SqlConnectionManager.executeQueryRS(query);
        int totalCount = 0;
        if (rs != null) {
            try {
                try {
                    if (rs.next()) {
                        totalCount = rs.getInt(1);
                    }
                }
                catch (SQLException e) {
                    Logger.exception((Throwable)e);
                    SqlConnectionManager.releaseResultSet(rs);
                }
            }
            finally {
                SqlConnectionManager.releaseResultSet(rs);
            }
        }
        return totalCount;
    }

    public List<FileEvent> select() {
        String query = String.format(SELECT_ALL, new Object[0]);
        List<FileEvent> apiList = this.executeQueryRS(query);
        return apiList;
    }

    public static String selectAllColumn() {
        StringBuffer selectAllColumn = new StringBuffer();
        selectAllColumn.append(COLUMN.SEQUENCE_NUMBER.name);
        selectAllColumn.append(",");
        selectAllColumn.append(COLUMN.FILE_ID.name);
        selectAllColumn.append(",");
        selectAllColumn.append(COLUMN.ACCESSOR_ID.name);
        selectAllColumn.append(",");
        selectAllColumn.append(COLUMN.FD.name);
        selectAllColumn.append(",");
        selectAllColumn.append(COLUMN.API_TYPE.name);
        selectAllColumn.append(",");
        selectAllColumn.append(COLUMN.EVENT_TIME.name);
        selectAllColumn.append(",");
        selectAllColumn.append(COLUMN.API_ID.name);
        selectAllColumn.append(",");
        selectAllColumn.append(COLUMN.ERRNO.name);
        selectAllColumn.append(",");
        selectAllColumn.append(COLUMN.FILE_SIZE.name);
        selectAllColumn.append(",");
        selectAllColumn.append(COLUMN.IO_SIZE.name);
        selectAllColumn.append(",");
        selectAllColumn.append(COLUMN.RETURN_VALUE.name);
        selectAllColumn.append(",");
        selectAllColumn.append(COLUMN.ARGUMENT.name);
        return selectAllColumn.toString();
    }

    @Override
    public boolean prepare(PreparedStatement prep, List<Object> rowData) {
        boolean isPrepared = true;
        int columnsize = this.getColumnSize();
        if (columnsize != rowData.size()) {
            isPrepared = false;
        } else {
            try {
                prep.setLong(1, (Long)rowData.get(0));
                prep.setInt(2, (Integer)rowData.get(1));
                prep.setInt(3, (Integer)rowData.get(2));
                prep.setLong(4, (Long)rowData.get(3));
                prep.setInt(5, (Integer)rowData.get(4));
                prep.setLong(6, (Long)rowData.get(5));
                prep.setInt(7, (Integer)rowData.get(6));
                prep.setLong(8, (Long)rowData.get(7));
                prep.setLong(9, (Long)rowData.get(8));
                prep.setLong(10, (Long)rowData.get(9));
                prep.setString(11, (String)rowData.get(10));
                prep.setString(12, (String)rowData.get(11));
            }
            catch (SQLException e) {
                Logger.exception((Throwable)e);
                isPrepared = false;
            }
        }
        return isPrepared;
    }

    public static enum COLUMN {
        SEQUENCE_NUMBER(1, "SEQUENCE_NUMBER"),
        FILE_ID(2, "FILE_ID"),
        ACCESSOR_ID(3, "ACCESSOR_ID"),
        FD(4, "FD"),
        API_TYPE(5, "API_TYPE"),
        EVENT_TIME(6, "EVENT_TIME"),
        API_ID(7, "API_ID"),
        ERRNO(8, "ERROR_NUMBER"),
        FILE_SIZE(9, "FILE_SIZE"),
        IO_SIZE(10, "IO_SIZE"),
        RETURN_VALUE(11, "RETURN_VALUE"),
        ARGUMENT(12, "ARGUMENT");

        public final int index;
        public final String name;

        private COLUMN(int index, String name) {
            this.index = index;
            this.name = name;
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }
    }
}

