/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.memory.data;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.database.DBColumn;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.util.Logger;

public class MemLSanTable
extends DBTable {
    public static final String TABLENAME = "MEM_LSAN_DB";

    @Override
    public String getTableName() {
        return TABLENAME;
    }

    public MemLSanTable() {
        this.addColumn(new DBColumn(COLUMN.ALLOCATED_ADDRESS.name, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.ALLOCATED_MEMORY_SIZE.name, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.ALLOCATED_FIRST_FOUR_BYTES.name, "NOT NULL", "BIGINT"));
        this.addIndex(COLUMN.ALLOCATED_ADDRESS.index);
    }

    @Override
    public boolean prepare(PreparedStatement prep, List<Object> rowData) {
        boolean isPrepared = true;
        int columnsize = this.getColumnSize();
        if (columnsize != rowData.size()) {
            isPrepared = false;
        } else {
            try {
                prep.setLong(1, (Long)rowData.get(COLUMN.ALLOCATED_ADDRESS.index));
                prep.setLong(2, (Long)rowData.get(COLUMN.ALLOCATED_MEMORY_SIZE.index));
                prep.setLong(3, (Long)rowData.get(COLUMN.ALLOCATED_FIRST_FOUR_BYTES.index));
            }
            catch (SQLException e) {
                Logger.exception((Throwable)e);
                isPrepared = false;
            }
        }
        return isPrepared;
    }

    @Override
    public List<Object> extractDataFromResultSet(ResultSet rs) {
        ArrayList<Object> row = new ArrayList<Object>();
        try {
            row.add(rs.getLong(1));
            row.add(rs.getLong(2));
            row.add(rs.getLong(3));
        }
        catch (SQLException e) {
            Logger.exception((Throwable)e);
            return null;
        }
        return row;
    }

    public static enum COLUMN {
        ALLOCATED_ADDRESS(0, "ALLOCATED_ADDRESS"),
        ALLOCATED_MEMORY_SIZE(1, "ALLOCATED_MEMORY_SIZE"),
        ALLOCATED_FIRST_FOUR_BYTES(2, "ALLOCATED_FIRST_FOUR_BYTES");

        public final int index;
        public final String name;

        private COLUMN(int index, String name) {
            this.index = index;
            this.name = name;
        }
    }
}

