/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.network;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlotTooltip;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartRenderer;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeries;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeriesItem;

public class NetworkChartRenderer
extends DAChartRenderer {
    protected List<DAChartSeries> tooltipList = null;

    protected void drawTooltip(GC gc) {
        DAChartPlotTooltip tooltip = this.plot.getTooltip();
        if (tooltip == null || !tooltip.shouldBeDrawn() || tooltip.getStartVal() == -1.0) {
            return;
        }
        gc.setFont(tooltip.getFont());
        ArrayList<String> tooltipTexts = new ArrayList<String>();
        ArrayList<String> tooltipTimes = new ArrayList<String>();
        ArrayList<Color> tooltipColor = new ArrayList<Color>();
        boolean isMultiColumn = false;
        int seriesCountPerColumn = this.findColumnSeriesCount(this.seriesList.size(), this.r.height);
        if (seriesCountPerColumn < this.seriesList.size()) {
            isMultiColumn = true;
        }
        int textWidthMax = 0;
        double realXVal = tooltip.getStartVal();
        int tooltipSize = 0;
        this.tooltipList = new ArrayList<DAChartSeries>();
        this.tooltipList.add((DAChartSeries)this.seriesList.get(1));
        this.tooltipList.add((DAChartSeries)this.seriesList.get(0));
        this.tooltipList.add((DAChartSeries)this.seriesList.get(2));
        int i = 0;
        while (i < this.tooltipList.size()) {
            int textWidth;
            DAChartSeries series = this.tooltipList.get(i);
            int index = series.getPrevIndexByXvalue(realXVal);
            String time = "";
            String text = "";
            Color color = null;
            if (index >= 0) {
                color = ((DAChartSeriesItem)this.tooltipList.get(i).getSeriesItemList().get(index)).getColor();
                text = String.valueOf(this.tooltipList.get(i).getName()) + ": " + ((DAChartSeriesItem)this.tooltipList.get(i).getSeriesItemList().get(index)).getTooltipText();
                time = this.toTimeFormat(((DAChartSeriesItem)this.tooltipList.get(i).getSeriesItemList().get(index)).getX());
            } else {
                text = series.getName();
                color = null;
            }
            tooltipColor.add(color);
            tooltipTexts.add(text);
            tooltipTimes.add(time);
            int timeMargin = 20;
            if (isMultiColumn) {
                timeMargin = 10;
            }
            if (textWidthMax < (textWidth = gc.textExtent((String)((String)tooltipTexts.get((int)i))).x + timeMargin + gc.textExtent((String)((String)tooltipTimes.get((int)i))).x)) {
                textWidthMax = textWidth;
            }
            ++i;
        }
        int preTextWidthMargin = 14;
        int startX = this.getTooltipStartX(realXVal, (preTextWidthMargin + textWidthMax) * (tooltipSize / seriesCountPerColumn), 4);
        int totalHeight = seriesCountPerColumn * 10 + 4 + 5 + (seriesCountPerColumn - 1) * 8;
        int startY = this.r.y + this.r.height / 2 - totalHeight / 2;
        int tooltipBoxWidth = preTextWidthMargin + textWidthMax + 4;
        gc.setAlpha(150);
        gc.setBackground(tooltip.getBackgroundColor());
        gc.setForeground(tooltip.getForegroundColor());
        gc.fillGradientRectangle(startX, startY, tooltipBoxWidth, totalHeight, true);
        gc.setAlpha(255);
        gc.setForeground(tooltip.getLineColor());
        gc.drawRoundRectangle(startX, startY, tooltipBoxWidth, totalHeight, 5, 5);
        gc.setFont(tooltip.getFont());
        tooltipSize = -1;
        int i2 = 0;
        while (i2 < this.tooltipList.size()) {
            DAChartSeries series = this.tooltipList.get(i2);
            if (!series.isDisableTooltip()) {
                int y = startY + 10 * (++tooltipSize % seriesCountPerColumn) + 4 + i2 % seriesCountPerColumn * 8;
                Color col = (Color)tooltipColor.get(i2);
                if (col == null) {
                    gc.setBackground(series.getColor());
                } else {
                    gc.setBackground(col);
                }
                int startColumnX = startX + i2 / seriesCountPerColumn * (preTextWidthMargin + textWidthMax);
                gc.fillRectangle(startColumnX + 4, y + 5 - 3, 6, 6);
                gc.setBackground(tooltip.getBackgroundColor());
                gc.setForeground(tooltip.getTextColor());
                gc.drawText((String)tooltipTexts.get(i2), startColumnX + 4 + 6 + 4, y, 3);
                gc.setForeground(tooltip.getTimeColor());
                String timeStr = (String)tooltipTimes.get(i2);
                gc.drawText((String)tooltipTimes.get(i2), startX + 4 + 6 + 4 + textWidthMax - 4 - gc.textExtent((String)timeStr).x + i2 / seriesCountPerColumn * (preTextWidthMargin + textWidthMax), y, 3);
            }
            ++i2;
        }
    }
}

