/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.opengl.data;

import java.util.LinkedHashMap;
import org.tizen.dynamicanalyzer.swap.model.data.GLES20LogData;
import org.tizen.dynamicanalyzer.ui.opengl.GLUtil;
import org.tizen.dynamicanalyzer.ui.opengl.data.GLCommonStateDataMaker;
import org.tizen.dynamicanalyzer.ui.opengl.data.GLContextDataManager;
import org.tizen.dynamicanalyzer.ui.opengl.data.GLContextSharingDataMaker;
import org.tizen.dynamicanalyzer.ui.opengl.data.GLProgramStateDataMaker;
import org.tizen.dynamicanalyzer.ui.opengl.data.GLTextureStateDataMaker;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLContextNameEnum;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLES20ErrorDefine;

public class GLStateDataManager {
    public static final int API_TYPE_INIT = 0;
    public static final int API_TYPE_CONTEXT = 1;
    public static final int API_TYPE_NO_CONTEXT = 2;
    private LinkedHashMap<Long, GLContextDataManager> contextHashMap = null;
    private GLCommonStateDataMaker commonDataMaker = null;
    private GLProgramStateDataMaker programDataMaker = null;
    private GLTextureStateDataMaker textureDataMaker = null;
    private GLContextSharingDataMaker sharingDataMaker = null;
    private int frameRateIndexOfAPI = -1;
    private int frameTimeIndexOfAPI = -1;
    private long contextIDOfAPI = -1L;
    private long seqOfAPI = -1L;

    protected GLStateDataManager() {
        this.init();
    }

    protected void clear() {
        this.init();
    }

    protected void init() {
        this.commonDataMaker = new GLCommonStateDataMaker(this);
        this.programDataMaker = new GLProgramStateDataMaker(this);
        this.textureDataMaker = new GLTextureStateDataMaker(this);
        this.sharingDataMaker = new GLContextSharingDataMaker(this);
    }

    public GLCommonStateDataMaker getCommonMakeObject() {
        return this.commonDataMaker;
    }

    public GLProgramStateDataMaker getProgramMakeObject() {
        return this.programDataMaker;
    }

    public GLTextureStateDataMaker getTextureMakeObject() {
        return this.textureDataMaker;
    }

    protected void extractGLAPIParameter(GLES20LogData logData, int currentFrameTimeIndex) {
        this.setCurrentStateInfo(logData, currentFrameTimeIndex);
        this.commonDataMaker.extractGLCommonAPIParameter(logData);
        this.programDataMaker.extractGLProgramAPIParameter(logData);
        this.textureDataMaker.extractGLTextureAPIParameter(logData);
        this.sharingDataMaker.extractSharingContextAPIParameter(logData);
    }

    private void setCurrentStateInfo(GLES20LogData logData, int currentFrameTimeIndex) {
        this.frameRateIndexOfAPI = this.getCurretnFrameRateIndex(logData, currentFrameTimeIndex);
        this.frameTimeIndexOfAPI = currentFrameTimeIndex;
        this.contextIDOfAPI = logData.getCurrentContextID();
        this.seqOfAPI = logData.getSeq();
    }

    protected void updateStateAtCurrentContext(int featureIndex, Object value) {
        if (featureIndex == GLContextNameEnum.SEQ.ordinal()) {
            return;
        }
        this.getGLContextDataManager(this.contextIDOfAPI).updateStateData(this.contextIDOfAPI, this.seqOfAPI, featureIndex, value, this.frameRateIndexOfAPI, this.frameTimeIndexOfAPI);
    }

    protected GLContextDataManager getGLContextDataManager(long contextID) {
        GLContextDataManager returnGLContextDataManager = this.getStateHashMap().get(contextID);
        if (returnGLContextDataManager == null) {
            returnGLContextDataManager = new GLContextDataManager(contextID);
            this.getStateHashMap().put(contextID, returnGLContextDataManager);
        }
        return returnGLContextDataManager;
    }

    protected LinkedHashMap<Long, GLContextDataManager> getStateHashMap() {
        if (this.contextHashMap == null) {
            this.contextHashMap = new LinkedHashMap();
        }
        return this.contextHashMap;
    }

    private int getCurretnFrameRateIndex(GLES20LogData logData, int currentFrameIndex) {
        int currentFrameRateIndex = GLUtil.getTimeLineTime(logData);
        return currentFrameRateIndex;
    }

    protected boolean isNormalAPIStatusForExtractParameter(GLES20LogData logData) {
        return logData.getApiType() == 1 && (logData.getErrno() == GLES20ErrorDefine.EGL_SUCCESS || logData.getErrno() == GLES20ErrorDefine.GL_SUCCESS);
    }
}

