/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.opengl.data.type;

import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.swap.model.data.GLES20LogData;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLAPIData;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLES20ErrorDefine;

public class GLCurrentFrameDataManger {
    private List<GLAPIData> glAPIDataList = null;
    private int errorCount = 0;

    public GLCurrentFrameDataManger() {
        this.initFrameIndex();
    }

    public void initFrameIndex() {
        this.glAPIDataList = new ArrayList<GLAPIData>();
        this.errorCount = 0;
    }

    public void addAPIData(GLAPIData glAPIData) {
        this.glAPIDataList.add(glAPIData);
        if (glAPIData.getErrno() != GLES20ErrorDefine.EGL_SUCCESS && glAPIData.getErrno() != GLES20ErrorDefine.GL_SUCCESS) {
            ++this.errorCount;
        }
    }

    public long getFrametime() {
        long frameFirstAPITime = this.glAPIDataList.get(0).getTime();
        long frameLastAPITime = this.glAPIDataList.get(this.glAPIDataList.size() - 1).getTime();
        return frameLastAPITime - frameFirstAPITime;
    }

    public boolean hasError() {
        return this.errorCount != 0;
    }

    public List<GLAPIData> getAPIDataList() {
        return this.glAPIDataList;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public long getStartSeq() {
        return this.glAPIDataList.get(0).getSeq();
    }

    public long getEndSeq() {
        return this.glAPIDataList.get(this.glAPIDataList.size() - 1).getSeq();
    }

    public GLES20LogData getFirstLogData() {
        return this.glAPIDataList.get(0);
    }

    public int getPid() {
        return this.glAPIDataList.get(0).getPid();
    }
}

