/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.thread.type;

import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.nl.ThreadPageLabels;
import org.tizen.dynamicanalyzer.ui.thread.type.ThreadPageData;
import org.tizen.dynamicanalyzer.ui.thread.type.ThreadPageSyncData;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.utils.Formatter;

public class ThreadPageThreadData
extends ThreadPageData {
    private List<ThreadPageSyncData> syncs = new ArrayList<ThreadPageSyncData>();
    private long StartTime = -1L;
    private long EndTime = -1L;
    private int threadFuncID = -1;
    private int createTID = -1;
    private int joinTID = -1;
    private String threadClassName = "";
    public static final byte TYPE_MAIN = 0;
    public static final byte TYPE_PTHREAD = 1;
    public static final byte TYPE_TIZEN = 2;
    private static int internalSeq = 0;
    private int threadDataID = -1;

    public ThreadPageThreadData(int type, String pid, int tid, String attrType, int funcID) {
        super(type, String.valueOf(tid), pid, tid, attrType);
        this.threadFuncID = funcID;
        this.threadDataID = internalSeq++;
    }

    public ThreadPageThreadData(int id, int pid, int tid, int threadType, String attrType, long startTime, long endTime, int functionID, String className, int createTID, int joinTID) {
        super(threadType, String.valueOf(tid), String.valueOf(pid), tid, attrType);
        this.threadDataID = id;
        this.threadFuncID = functionID;
        this.StartTime = startTime;
        this.EndTime = endTime;
        this.threadClassName = className;
        this.createTID = createTID;
        this.joinTID = joinTID;
    }

    public int getThreadFuncID() {
        return this.threadFuncID;
    }

    public String getThreadFuncName() {
        if (this.threadFuncID < 0) {
            return "";
        }
        return Global.getFunctionName(this.threadFuncID);
    }

    public String getThreadClassName() {
        return this.threadClassName;
    }

    public void setThreadClassName(String className) {
        this.threadClassName = className;
    }

    public void pushSync(ThreadPageSyncData sync) {
        this.syncs.add(sync);
    }

    public ThreadPageSyncData findSyncData(String syncVal) {
        int size = this.syncs.size();
        int i = 0;
        while (i < size) {
            ThreadPageSyncData sync = this.syncs.get(i);
            if (sync.getKey().equals(syncVal)) {
                return sync;
            }
            ++i;
        }
        return null;
    }

    public String getTypeString() {
        switch (this.getType()) {
            case 0: {
                return ThreadPageLabels.THREAD_ITEM_TYPE_MAIN;
            }
            case 1: {
                return ThreadPageLabels.THREAD_ITEM_TYPE_PTHREAD;
            }
            case 2: {
                return ThreadPageLabels.THREAD_ITEM_TYPE_TIZEN;
            }
        }
        Logger.error((Object)"unknown thread type!!");
        return "";
    }

    public long getStartTime() {
        return this.StartTime;
    }

    public void setStartTime(long startTime) {
        this.StartTime = startTime;
    }

    public String getStartTimeString() {
        if (this.StartTime == -1L) {
            return null;
        }
        double startTime = Formatter.longTimeToDoubleTime(this.StartTime);
        return String.valueOf(startTime);
    }

    public long getEndTime() {
        return this.EndTime;
    }

    public void setEndTime(long endTime) {
        this.EndTime = endTime;
    }

    public String getEndTimeString() {
        if (this.EndTime == -1L) {
            return null;
        }
        double endTime = Formatter.longTimeToDoubleTime(this.EndTime);
        return String.valueOf(endTime);
    }

    public int getThreadDataID() {
        return this.threadDataID;
    }

    public static void clear() {
        internalSeq = 0;
    }

    public int getCreateTID() {
        return this.createTID;
    }

    public void setCreateTID(int createTID) {
        this.createTID = createTID;
    }

    public int getJoinTID() {
        return this.joinTID;
    }

    public void setJoinTID(int joinTID) {
        this.joinTID = joinTID;
    }
}

