/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.timeline.common;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.database.DBInserter;
import org.tizen.dynamicanalyzer.database.SqlConnectionManager;
import org.tizen.dynamicanalyzer.project.BinaryInfo;
import org.tizen.dynamicanalyzer.project.LibraryObject;
import org.tizen.dynamicanalyzer.project.ProcessMemoryMap;
import org.tizen.dynamicanalyzer.project.Project;
import org.tizen.dynamicanalyzer.swap.logparser.LogPackage;
import org.tizen.dynamicanalyzer.swap.logparser.Logs;
import org.tizen.dynamicanalyzer.swap.logparser.PageDataManager;
import org.tizen.dynamicanalyzer.swap.model.data.LifeCycleLogData;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.swap.model.data.MemoryData;
import org.tizen.dynamicanalyzer.swap.model.data.ProcessProfileData;
import org.tizen.dynamicanalyzer.swap.model.data.SystemData;
import org.tizen.dynamicanalyzer.swap.model.data.UIEventData;
import org.tizen.dynamicanalyzer.ui.info.screenshot.ScreenshotDataManager;
import org.tizen.dynamicanalyzer.ui.timeline.LifeCycleDBTable;
import org.tizen.dynamicanalyzer.ui.timeline.SystemDataDBTable;
import org.tizen.dynamicanalyzer.ui.timeline.TargetProcessDBTable;
import org.tizen.dynamicanalyzer.ui.timeline.UIEventDBTable;
import org.tizen.dynamicanalyzer.ui.timeline.logparser.LifecycleLogParser;
import org.tizen.dynamicanalyzer.util.Logger;

public class TimelineDataManager
extends PageDataManager {
    private static TimelineDataManager instance = new TimelineDataManager();
    private final LifecycleLogParser lifecycleLogParser = LifecycleLogParser.getInstance();
    private SystemDataDBTable systemDataTable = null;
    private UIEventDBTable uiEventDBTable = null;
    private TargetProcessDBTable targetProcessDBTable = null;
    private LifeCycleDBTable lifeCycleDBTable = null;
    private DBInserter systemDBInserter = null;
    private DBInserter targetProcessDBInserter = null;
    private DBInserter uiEventDBInserter = null;
    private DBInserter lifeCycleDBInserter = null;
    private static final int MEM_API_TYPE_ALLOC = 0;
    private static final int MEM_API_TYPE_FREE = 1;
    private static final int MEM_USER = 2;
    private Map<Integer, Long> allocByteMap = new HashMap<Integer, Long>();
    private Map<Integer, Map<Integer, Long>> libraryAllocByteMap = new HashMap<Integer, Map<Integer, Long>>();
    private HashMap<Long, Long> allocationSeriesDataSetMap = new HashMap();

    public static TimelineDataManager getInstance() {
        return instance;
    }

    private TimelineDataManager() {
        this.systemDataTable = new SystemDataDBTable();
        this.uiEventDBTable = new UIEventDBTable();
        this.targetProcessDBTable = new TargetProcessDBTable();
        this.lifeCycleDBTable = new LifeCycleDBTable();
        this.systemDBInserter = this.makeInserter(this.systemDataTable);
        this.targetProcessDBInserter = this.makeInserter(this.targetProcessDBTable);
        this.uiEventDBInserter = this.makeInserter(this.uiEventDBTable);
        this.lifeCycleDBInserter = this.makeInserter(this.lifeCycleDBTable);
    }

    @Override
    protected void resetBeforeStart() {
        super.resetBeforeStart();
        this.lifecycleLogParser.initialize(Global.getProject());
    }

    public void clear() {
        this.allocByteMap.clear();
        this.libraryAllocByteMap.clear();
        this.allocationSeriesDataSetMap.clear();
    }

    private void makeSystemDataTableData(Logs systemLogs, Logs memoryLogs) {
        List<LogData> systemLogList;
        int coreSize = Global.getProject().getDeviceStatusInfo().getCpuCount();
        List<LogData> memoryLogList = memoryLogs == null ? null : memoryLogs.getRawLogs();
        List<LogData> list = systemLogList = systemLogs == null ? null : systemLogs.getRawLogs();
        if (memoryLogList != null) {
            int size = memoryLogList.size();
            int i = 0;
            while (i < size) {
                LibraryObject lib;
                MemoryData logData = (MemoryData)memoryLogList.get(i);
                if (this.allocByteMap.get(logData.getPid()) == null) {
                    this.allocByteMap.put(logData.getPid(), new Long(0L));
                    this.libraryAllocByteMap.put(logData.getPid(), new HashMap());
                }
                int memApiType = logData.getMemoryApiType();
                int internalFlag = logData.getInternalCall();
                long errorNo = logData.getErrno();
                BinaryInfo binaryInfo = null;
                Project project = Global.getProject();
                ProcessMemoryMap pmap = project.getProcessInformation(logData.getPid()).getProcessMemoryMap(logData.getTime());
                if (pmap != null && (lib = pmap.getLibraryByAddress(logData.getCallerPcAddr())) != null && lib != pmap.getMainbinary()) {
                    binaryInfo = project.getDeviceStatusInfo().getBinaryInfo(lib.getBinaryID());
                }
                if (errorNo == 0L && 2 == internalFlag && (memApiType == 0 || 1 == memApiType)) {
                    this.addNewSeriesUserAllocData(memApiType, logData, binaryInfo);
                }
                ++i;
            }
        }
        if (systemLogList != null) {
            ArrayList systemDataList = new ArrayList();
            ArrayList targetProcessDataList = new ArrayList();
            int size = systemLogList.size();
            int i = 0;
            while (i < size) {
                SystemData log = (SystemData)systemLogList.get(i);
                ArrayList<Float> cpuLoadList = new ArrayList<Float>();
                ArrayList<Float> cpuFreqeuncyList = new ArrayList<Float>();
                double[] cpuLoads = log.getCpuLoad();
                double[] cpuFrequencies = log.getCpuFrequency();
                int ii = 0;
                while (ii < coreSize) {
                    cpuLoadList.add(new Float(cpuLoads[ii]));
                    cpuFreqeuncyList.add(new Float(cpuFrequencies[ii]));
                    ++ii;
                }
                ArrayList<Integer> pIDList = new ArrayList<Integer>();
                ArrayList<String> processLoadList = new ArrayList<String>();
                String[] processLoadDatas = log.getOtherProcessLoad().split(",");
                int ii2 = 0;
                while (ii2 < processLoadDatas.length) {
                    String processLoad = processLoadDatas[ii2];
                    if (processLoad != null && !processLoad.isEmpty()) {
                        pIDList.add(new Integer(processLoad));
                        processLoadList.add(processLoadDatas[++ii2]);
                    }
                    ++ii2;
                }
                ArrayList<Integer> deviceList = new ArrayList<Integer>();
                deviceList.add(new Integer(log.getWifi()));
                deviceList.add(new Integer(log.getBtStatus()));
                deviceList.add(new Integer(log.getGpsStatus()));
                deviceList.add(new Integer(log.getBrightness()));
                deviceList.add(new Integer(log.getDnet()));
                deviceList.add(new Integer(log.getCamera()));
                deviceList.add(new Integer(log.getSound()));
                deviceList.add(new Integer(log.getAudio()));
                deviceList.add(new Integer(log.getVibration()));
                deviceList.add(new Integer(log.getVoltage()));
                deviceList.add(new Integer(log.getRssi()));
                deviceList.add(new Integer(log.getVideo()));
                deviceList.add(new Integer(log.getCall()));
                ArrayList<Long> energyUsageDeviceList = new ArrayList<Long>();
                ArrayList<Long> energyUsageAppList = new ArrayList<Long>();
                String[] deviceEnergyUsages = log.getDeviceEnergyUsage().split(",");
                String[] deviceEnergyUsagesPerApp = log.getApplicationEnergyUsage().split(",");
                int ii3 = 0;
                while (ii3 < deviceEnergyUsages.length) {
                    energyUsageDeviceList.add(new Long(deviceEnergyUsages[ii3]));
                    energyUsageAppList.add(new Long(deviceEnergyUsagesPerApp[ii3]));
                    ++ii3;
                }
                double systemAvgCPULoad = log.getTotalCPULoad();
                ArrayList<Serializable> dbSystemData = new ArrayList<Serializable>();
                dbSystemData.add(new Long(log.getTime()));
                dbSystemData.add(new Float(systemAvgCPULoad));
                dbSystemData.add(new Integer(log.getOtherProcessCount()));
                dbSystemData.add(new Integer(log.getTargetProcessCount()));
                dbSystemData.add(new Long(log.getSystemMemoryUsed()));
                dbSystemData.add(new Long(log.getNetworkSendSize().getValue()));
                dbSystemData.add(new Long(log.getNetworkReceiveSize().getValue()));
                dbSystemData.add(new Long(log.getTotalUsedDrive().getValue()));
                dbSystemData.add(new Long(log.getDiskReadOpCount().getValue()));
                dbSystemData.add(new Long(log.getDiskReadByteSize().getValue()));
                dbSystemData.add(new Long(log.getDiskWriteOpCount().getValue()));
                dbSystemData.add(new Long(log.getDiskWrittenByteSize().getValue()));
                dbSystemData.add(new Long(log.getEnergyUsage().getValue()));
                dbSystemData.add(energyUsageDeviceList);
                dbSystemData.add(energyUsageAppList);
                dbSystemData.add(cpuLoadList);
                dbSystemData.add(cpuFreqeuncyList);
                dbSystemData.add(pIDList);
                dbSystemData.add(processLoadList);
                dbSystemData.add(deviceList);
                systemDataList.add(dbSystemData);
                ProcessProfileData[] targetProcessList = log.getProcessProfileDataList();
                if (targetProcessList != null) {
                    int ii4 = 0;
                    while (ii4 < targetProcessList.length) {
                        ProcessProfileData process = targetProcessList[ii4];
                        ArrayList<Serializable> dbTargetProcessData = new ArrayList<Serializable>();
                        dbTargetProcessData.add(new Long(log.getTime()));
                        dbTargetProcessData.add(new Integer(process.getPid()));
                        dbTargetProcessData.add(new Float(process.getProcessLoad()));
                        dbTargetProcessData.add(new Long(process.getVirtualMemory()));
                        dbTargetProcessData.add(new Long(process.getResidentMemory()));
                        dbTargetProcessData.add(new Long(process.getSharedMemory()));
                        dbTargetProcessData.add(new Long(process.getPssMemory()));
                        dbTargetProcessData.add(new Integer(process.getThreadCount()));
                        dbTargetProcessData.add(new Long(process.getTotalAllocSize()));
                        ArrayList<Integer> binaryIDList = new ArrayList<Integer>();
                        ArrayList<Long> allocByteList = new ArrayList<Long>();
                        binaryIDList.add(-10);
                        if (this.allocByteMap.get(process.getPid()) == null) {
                            allocByteList.add(new Long(0L));
                        } else {
                            allocByteList.add(this.allocByteMap.get(process.getPid()));
                        }
                        Map<Integer, Long> libraryList = this.libraryAllocByteMap.get(process.getPid());
                        if (libraryList == null) {
                            libraryList = new HashMap<Integer, Long>();
                        }
                        for (Integer binaryID : libraryList.keySet()) {
                            binaryIDList.add(binaryID);
                            allocByteList.add(libraryList.get(binaryID));
                        }
                        dbTargetProcessData.add(binaryIDList);
                        dbTargetProcessData.add(allocByteList);
                        ArrayList<Integer> threadIdList = new ArrayList<Integer>();
                        ArrayList<String> threadLoadList = new ArrayList<String>();
                        String[] threadLoads = process.getThreadLoad().split(",");
                        int iii = 0;
                        while (iii < threadLoads.length) {
                            String threadLoad = threadLoads[iii];
                            if (threadLoad != null && !threadLoad.isEmpty()) {
                                threadIdList.add(new Integer(threadLoad));
                                threadLoadList.add(threadLoads[++iii]);
                            }
                            ++iii;
                        }
                        dbTargetProcessData.add(threadIdList);
                        dbTargetProcessData.add(threadLoadList);
                        targetProcessDataList.add(dbTargetProcessData);
                        ++ii4;
                    }
                }
                ++i;
            }
            this.systemDBInserter.pushData(systemDataList);
            this.targetProcessDBInserter.pushData(targetProcessDataList);
        }
    }

    private void makeUIEventDBTableData(Logs uiEventLogs) {
        List<LogData> uiEventLogList;
        List<LogData> list = uiEventLogList = uiEventLogs == null ? null : uiEventLogs.getRawLogs();
        if (uiEventLogList != null) {
            ArrayList uiEventDataList = new ArrayList();
            int size = uiEventLogList.size();
            int i = 0;
            while (i < size) {
                UIEventData log = (UIEventData)uiEventLogList.get(i);
                ArrayList<Object> dbUIEventData = new ArrayList<Object>();
                dbUIEventData.add(new Long(log.getTime()));
                dbUIEventData.add(new Integer(log.getEventType()));
                dbUIEventData.add(new Integer(log.getDetailType()));
                dbUIEventData.add(new Integer(log.getX()));
                dbUIEventData.add(new Integer(log.getY()));
                dbUIEventData.add(log.getInfo1());
                dbUIEventData.add(new Integer(log.getInfo2()));
                uiEventDataList.add(dbUIEventData);
                ++i;
            }
            this.uiEventDBInserter.pushData(uiEventDataList);
        }
    }

    private void makeLifeCycleDBTableData(Logs lifecycleLogs) {
        List<LogData> lifeCycleLogList;
        List<LogData> list = lifeCycleLogList = lifecycleLogs == null ? null : lifecycleLogs.getRawLogs();
        if (lifeCycleLogList != null) {
            ArrayList lifeCycleDataList = new ArrayList();
            int size = lifeCycleLogList.size();
            int i = 0;
            while (i < size) {
                LifeCycleLogData log = (LifeCycleLogData)lifeCycleLogList.get(i);
                ArrayList<Number> dbLifeCycleData = new ArrayList<Number>();
                dbLifeCycleData.add(new Long(log.getTime()));
                dbLifeCycleData.add(new Integer(log.getApiId()));
                lifeCycleDataList.add(dbLifeCycleData);
                ++i;
            }
            this.lifeCycleDBInserter.pushData(lifeCycleDataList);
        }
    }

    private void addNewSeriesUserAllocData(int fdApiType, MemoryData log, BinaryInfo libraryInfo) {
        long size = 0L;
        Long allocByte = this.allocByteMap.get(log.getPid());
        long address = log.getAddress();
        if (address == 0L) {
            return;
        }
        if (fdApiType == 0) {
            try {
                size = log.getSize();
                if (libraryInfo == null) {
                    this.allocByteMap.put(log.getPid(), allocByte + size);
                } else {
                    Long libraryAllocByte = this.libraryAllocByteMap.get(log.getPid()).get(libraryInfo.getID());
                    if (libraryAllocByte == null) {
                        libraryAllocByte = new Long(0L);
                    }
                    this.libraryAllocByteMap.get(log.getPid()).put(libraryInfo.getID(), libraryAllocByte + size);
                }
                this.allocationSeriesDataSetMap.put(address, size);
            }
            catch (NumberFormatException ne) {
                Logger.exception((Throwable)ne);
            }
        } else if (1 == fdApiType) {
            if (!this.allocationSeriesDataSetMap.containsKey(address)) {
                return;
            }
            size = this.allocationSeriesDataSetMap.get(address);
            if (libraryInfo == null) {
                this.allocByteMap.put(log.getPid(), allocByte - size);
            } else {
                Long libraryAllocByte = this.libraryAllocByteMap.get(log.getPid()).get(libraryInfo.getID());
                this.libraryAllocByteMap.get(log.getPid()).put(libraryInfo.getID(), libraryAllocByte - size);
            }
        }
    }

    public List<List<Object>> getSystemDataFromDB(long start, long end) {
        String where = "WHERE SAMPLING_TIME BETWEEN " + start + " AND " + end + " ORDER BY SAMPLING_TIME";
        List<List<Object>> result = this.systemDataTable.selectAllColumnData(where);
        if (result != null) {
            return result;
        }
        return new ArrayList<List<Object>>();
    }

    public Object[] getCPULoadFromDB(long time) {
        Object[] cpuLoadList = null;
        String query = "SELECT CPU_LOAD FROM TIMELINE_SYSTEM_DATA WHERE SAMPLING_TIME = (SELECT MAX(SAMPLING_TIME) FROM TIMELINE_SYSTEM_DATA WHERE SAMPLING_TIME <= " + time + ")";
        ResultSet rs = SqlConnectionManager.executeQueryRS(query);
        if (rs != null) {
            try {
                try {
                    while (rs.next()) {
                        cpuLoadList = (Object[])rs.getArray("CPU_LOAD").getArray();
                    }
                }
                catch (SQLException e) {
                    Logger.exception((Throwable)e);
                    SqlConnectionManager.releaseResultSet(rs);
                }
            }
            finally {
                SqlConnectionManager.releaseResultSet(rs);
            }
        }
        return cpuLoadList;
    }

    public List<List<Object>> getUIEventDataFromDB(long start, long end) {
        String where = "WHERE EVENT_TIME BETWEEN " + start + " AND " + end + " ORDER BY EVENT_TIME";
        List<List<Object>> result = this.uiEventDBTable.selectAllColumnData(where);
        if (result != null) {
            return result;
        }
        return new ArrayList<List<Object>>();
    }

    public List<List<Object>> getLifeCycleDataFromDB() {
        List<List<Object>> result = this.lifeCycleDBTable.selectAllColumnData(null);
        if (result != null) {
            return result;
        }
        return new ArrayList<List<Object>>();
    }

    public List<List<Object>> getScreenShotDataFromDB(long start, long end) {
        String where = "WHERE CAPTURE_TIME BETWEEN " + start + " AND " + end + " ORDER BY CAPTURE_TIME";
        List<List<Object>> result = ScreenshotDataManager.getInstance().getScreenShotTable().selectAllColumnData(where);
        if (result != null) {
            return result;
        }
        return new ArrayList<List<Object>>();
    }

    public Map<Integer, List<List<Object>>> getTargetProcessDataFromDB(long start, long end, int targetPID) {
        List<List<Object>> queryResult;
        HashMap<Integer, List<List<Object>>> processedResult = new HashMap<Integer, List<List<Object>>>();
        String where = "WHERE SAMPLING_TIME BETWEEN " + start + " AND " + end;
        if (targetPID > 0) {
            where = String.valueOf(where) + " AND PID = " + targetPID;
        }
        if ((queryResult = this.targetProcessDBTable.selectAllColumnData(where = String.valueOf(where) + " ORDER BY SAMPLING_TIME")) == null) {
            return processedResult;
        }
        int i = 0;
        while (i < queryResult.size()) {
            List<Object> row = queryResult.get(i);
            Integer pid = (Integer)row.get(TargetProcessDBTable.COLUMN.PID.ordinal());
            ArrayList<List<Object>> processData = (ArrayList<List<Object>>)processedResult.get(pid);
            if (processData == null) {
                processData = new ArrayList<List<Object>>();
                processedResult.put(pid, processData);
            }
            processData.add(row);
            ++i;
        }
        return processedResult;
    }

    public long getProcessMemoriesFromDB(long time) {
        long processMemories = 0L;
        String query = "SELECT MEMORY_RESIDENT FROM TIMELINE_TARGET_PROCESS WHERE SAMPLING_TIME = (SELECT MAX(SAMPLING_TIME) FROM TIMELINE_TARGET_PROCESS WHERE SAMPLING_TIME <= " + time + ")";
        ResultSet rs = SqlConnectionManager.executeQueryRS(query);
        if (rs != null) {
            try {
                try {
                    while (rs.next()) {
                        processMemories += rs.getLong(1);
                    }
                }
                catch (SQLException e) {
                    Logger.exception((Throwable)e);
                    SqlConnectionManager.releaseResultSet(rs);
                }
            }
            finally {
                SqlConnectionManager.releaseResultSet(rs);
            }
        }
        return processMemories;
    }

    @Override
    protected void makeData(LogPackage pack) {
        Logs systemLogs = pack.getLogs(5);
        Logs memoryLogs = pack.getLogs(257);
        Logs uiEventLogs = pack.getLogs(259);
        this.makeSystemDataTableData(systemLogs, memoryLogs);
        this.makeUIEventDBTableData(uiEventLogs);
        Logs lifecycleLogs = pack.getLogs(261);
        if (lifecycleLogs != null && !lifecycleLogs.getRawLogs().isEmpty()) {
            this.lifecycleLogParser.parseLogPackage(pack);
            this.makeLifeCycleDBTableData(lifecycleLogs);
        }
    }

    @Override
    public void openData(Map<String, String> dataMap) {
        this.lifecycleLogParser.initialize(Global.getProject());
        List<List<Object>> logDataList = this.getLifeCycleDataFromDB();
        int i = 0;
        while (i < logDataList.size()) {
            List<Object> row = logDataList.get(i);
            long lifeChangeTime = (Long)row.get(LifeCycleDBTable.COLUMN.LIFE_CHANGE_TIME.ordinal());
            int lifeStatus = (Integer)row.get(LifeCycleDBTable.COLUMN.LIFE_STATUS.ordinal());
            this.lifecycleLogParser.parseLog(lifeChangeTime, lifeStatus);
            ++i;
        }
    }
}

