/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.timeline.uievent;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.nebula.widgets.grid.GridCellRenderer;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridHeaderRenderer;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.tizen.dynamicanalyzer.model.TableInput;
import org.tizen.dynamicanalyzer.nl.TimelinePageLabels;
import org.tizen.dynamicanalyzer.nl.WidgetLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.ui.timeline.uievent.UIEventListDialogTableCellRenderer;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableComposite;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableHeaderRenderer;
import org.tizen.dynamicanalyzer.ui.widgets.table.DefaultTableComparator;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButton;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonClickEventListener;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeries;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeriesItem;
import org.tizen.dynamicanalyzer.widgets.da.base.DAButton;

public class UIEventListDialog
extends Dialog {
    static final String KEY_START_OLD_CHECKED_ITEM = "start_old_checked_item";
    static final String KEY_END_OLD_CHECKED_ITEM = "end_old_checked_item";
    static final String KEY_OLD_HOVERED_ITEM = "old_hovered_item";
    static final String KEY_OLD_HOVERED_INDEX = "old_hovered_INDEX";
    static final String KEY_START_TIME = "start_time";
    static final String KEY_END_TIME = "end_time";
    private Shell shell;
    private Shell parent;
    private UIEventListTable uiEventListTable;
    private List<DAChartSeries> chartSeriesList;
    private String[] columnNames = new String[]{TimelinePageLabels.UI_EVENT_LIST_TIME, TimelinePageLabels.UI_EVENT_LIST_TYPE, TimelinePageLabels.UI_EVENT_LIST_NAME, TimelinePageLabels.UI_EVENT_LIST_DETAIL};
    private int[] columnSizes = new int[]{100, 100, 175, 425};
    private boolean[] columnVisibility = new boolean[]{true, true, true, true};
    int[] sortTypes = new int[]{4, 3, 3, 3};
    DefaultTableComparator comparator = new DefaultTableComparator();
    private DACustomButtonClickEventListener okButtonListener = new DACustomButtonClickEventListener(){

        public void handleClickEvent(DACustomButton button) {
            UIEventListDialog.this.shell.dispose();
        }
    };
    private DACustomButtonClickEventListener cancelButtonListener = new DACustomButtonClickEventListener(){

        public void handleClickEvent(DACustomButton button) {
            UIEventListDialog.this.uiEventListTable.getTable().setData(UIEventListDialog.KEY_START_TIME, (Object)-1.0);
            UIEventListDialog.this.uiEventListTable.getTable().setData(UIEventListDialog.KEY_END_TIME, (Object)-1.0);
            UIEventListDialog.this.shell.dispose();
        }
    };

    public UIEventListDialog(Shell parent) {
        super(parent);
        this.parent = parent;
    }

    public int open() {
        this.shell = new Shell(this.parent, 67680);
        this.shell.setText("Event list");
        this.shell.setSize(825, 450);
        this.shell.setLayout((Layout)new FormLayout());
        Composite tableComp = new Composite((Composite)this.shell, 0);
        tableComp.setBackground(ColorResources.CONFIGURATION_TABLE_COVER_BACKGROUND_COLOR);
        tableComp.setLayout((Layout)new FormLayout());
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, -49);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        tableComp.setLayoutData((Object)data);
        this.uiEventListTable = new UIEventListTable(tableComp, 0, 768);
        this.uiEventListTable.setColumns(this.columnNames);
        this.uiEventListTable.setColumnSize(this.columnSizes);
        this.uiEventListTable.setColumnVisibility(this.columnVisibility);
        this.uiEventListTable.setSortTypes(this.sortTypes);
        this.comparator.setColumn(0);
        this.comparator.setType(4);
        this.uiEventListTable.setComparator(this.comparator);
        this.uiEventListTable.getTable().setData(KEY_START_TIME, (Object)-1.0);
        this.uiEventListTable.getTable().setData(KEY_END_TIME, (Object)-1.0);
        data = new FormData();
        data.top = new FormAttachment((Control)tableComp, 15);
        data.bottom = new FormAttachment(100, -15);
        data.left = new FormAttachment(0, 6);
        data.right = new FormAttachment(100, -6);
        this.uiEventListTable.setLayoutData(data);
        Composite buttonComp = new Composite((Composite)this.shell, 0);
        buttonComp.setBackground(ColorResources.CONFIGURATION_BUTTON_COVER_BACKGROUND_COLOR);
        buttonComp.setLayout((Layout)new FormLayout());
        data = new FormData();
        data.top = new FormAttachment((Control)tableComp, 0);
        data.bottom = new FormAttachment(100, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        buttonComp.setLayoutData((Object)data);
        DAButton okButton = new DAButton(buttonComp, 8);
        okButton.addClickListener(this.okButtonListener);
        okButton.setText(WidgetLabels.OK);
        okButton.setFont(FontResources.EDIT_CHART_DLG_BUTTON);
        data = new FormData();
        data.top = new FormAttachment(0, 8);
        data.left = new FormAttachment(0, 569);
        data.width = 86;
        data.height = 24;
        okButton.setLayoutData((Object)data);
        DAButton cancelButton = new DAButton(buttonComp, 8);
        cancelButton.addClickListener(this.cancelButtonListener);
        cancelButton.setText(WidgetLabels.CANCEL);
        cancelButton.setFont(FontResources.EDIT_CHART_DLG_BUTTON);
        data = new FormData();
        data.top = new FormAttachment(0, 8);
        data.left = new FormAttachment((Control)okButton, 8);
        data.width = 86;
        data.height = 24;
        cancelButton.setLayoutData((Object)data);
        buttonComp.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Composite comp = (Composite)e.widget;
                Rectangle rect = comp.getClientArea();
                e.gc.setForeground(ColorResources.DIALOG_SUNKEN_1);
                e.gc.drawLine(rect.x, rect.y, rect.x + rect.width, rect.y);
                e.gc.setForeground(ColorResources.DIALOG_SUNKEN_2);
                e.gc.drawLine(rect.x, rect.y + 1, rect.x + rect.width, rect.y + 1);
            }
        });
        this.uiEventListTable.updateTable();
        this.shell.open();
        return 0;
    }

    public void setSelectedEventInfo(List<DAChartSeries> chartSeriesList) {
        this.chartSeriesList = chartSeriesList;
    }

    private class UIEventListTable
    extends DATableComposite {
        private UIEventListTable(Composite parent, int style, int tableStyle) {
            super(parent, style, tableStyle);
        }

        @Override
        protected List<TableInput> makeTableInput() {
            ArrayList<TableInput> inputList = new ArrayList<TableInput>();
            if (UIEventListDialog.this.chartSeriesList == null && UIEventListDialog.this.chartSeriesList.size() == 0) {
                return null;
            }
            int i = 0;
            while (i < UIEventListDialog.this.chartSeriesList.size()) {
                String seriesName = ((DAChartSeries)UIEventListDialog.this.chartSeriesList.get(i)).getName();
                List subItemList = ((DAChartSeries)UIEventListDialog.this.chartSeriesList.get(i)).getSeriesItemList();
                for (DAChartSeriesItem item : subItemList) {
                    String[] eventDetailDatas = item.getTooltipText().split("\n");
                    String eventName = eventDetailDatas[0];
                    String detailData = "";
                    String[] stringArray = eventDetailDatas;
                    int n = eventDetailDatas.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String tmpDetail = stringArray[n2];
                        detailData = detailData.concat(tmpDetail).concat("|");
                        ++n2;
                    }
                    detailData = (detailData = detailData.split(eventName)[1]).length() > 1 ? detailData.substring(1, detailData.length() - 1) : "";
                    ArrayList<String> columnTexts = new ArrayList<String>();
                    columnTexts.add(String.valueOf(item.getX()));
                    columnTexts.add(seriesName);
                    columnTexts.add(eventName);
                    columnTexts.add(detailData);
                    TableInput tableInput = new TableInput();
                    tableInput.setText(columnTexts);
                    DATableDataFormat dataFormat = new DATableDataFormat(0L);
                    dataFormat.setObject(item.getX());
                    tableInput.setData(dataFormat);
                    inputList.add(tableInput);
                }
                ++i;
            }
            return inputList;
        }

        @Override
        public void setColumns(String[] columnNames) {
            int size = columnNames.length;
            int i = 0;
            while (i < size) {
                GridColumn column = new GridColumn(this.table, 0);
                column.setText(columnNames[i]);
                column.setCellRenderer((GridCellRenderer)new UIEventListDialogTableCellRenderer());
                column.setHeaderRenderer((GridHeaderRenderer)new DATableHeaderRenderer());
                column.pack();
                ++i;
            }
        }
    }
}

