/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.widgets.table;

import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import org.tizen.dynamicanalyzer.model.TableInput;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.util.Logger;

public class DefaultTableComparator
implements Comparator<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected int type = 3;
    protected int column = 0;
    protected int oldColumn = 0;
    protected boolean dirUp = true;

    public void setType(int type) {
        this.type = type;
    }

    public void setColumn(int column) {
        this.column = column;
    }

    public void setDirection(boolean dirUp) {
        this.dirUp = dirUp;
    }

    public void reverseDirection() {
        if (this.column == this.oldColumn) {
            this.dirUp = !this.dirUp;
        }
        this.oldColumn = this.column;
    }

    @Override
    public int compare(Object arg0, Object arg1) {
        return this.userCompare(arg0, arg1);
    }

    protected int compareItem(TableInput item1, TableInput item2) {
        String str1 = null;
        String str2 = null;
        int rc = 0;
        if (this.type != 3 && this.type != 4) {
            DATableDataFormat tableData1 = (DATableDataFormat)item1.getData();
            DATableDataFormat tableData2 = (DATableDataFormat)item2.getData();
            List<Object> data1 = tableData1.getData();
            List<Object> data2 = tableData2.getData();
            str1 = data1.get(this.column).toString();
            str2 = data2.get(this.column).toString();
        } else {
            List<String> text1 = item1.getText();
            List<String> text2 = item2.getText();
            str1 = text1.get(this.column);
            str2 = text2.get(this.column);
        }
        switch (this.type) {
            case 1: {
                try {
                    long returnData = Long.parseLong(str1) - Long.parseLong(str2);
                    if (returnData > 0L) {
                        rc = 1;
                        break;
                    }
                    if (returnData < 0L) {
                        rc = -1;
                        break;
                    }
                    rc = 0;
                }
                catch (NumberFormatException e) {
                    Logger.exception((Throwable)e);
                }
                break;
            }
            case 4: {
                try {
                    double returnData = Double.parseDouble(str1) - Double.parseDouble(str2);
                    if (returnData > 0.0) {
                        rc = 1;
                        break;
                    }
                    if (returnData < 0.0) {
                        rc = -1;
                        break;
                    }
                    rc = 0;
                }
                catch (NumberFormatException e) {
                    Logger.exception((Throwable)e);
                }
                break;
            }
            case 2: 
            case 3: {
                rc = str1.compareTo(str2);
                break;
            }
            default: {
                return rc;
            }
        }
        if (!this.dirUp) {
            rc = -rc;
        }
        return rc;
    }

    public int userCompare(Object obj1, Object obj2) {
        TableInput input1 = (TableInput)obj1;
        TableInput input2 = (TableInput)obj2;
        return this.compareItem(input1, input2);
    }
}

