/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.chart;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlot;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartRenderer;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeries;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartTooltip;
import org.tizen.dynamicanalyzer.widgets.chart.DAScreenshotChartPlot;
import org.tizen.dynamicanalyzer.widgets.chart.DAUIEventChartPlot;
import org.tizen.dynamicanalyzer.widgets.helper.ColorResources;

public class DAChart
extends Canvas {
    Composite parent = null;
    private List<DAChartSeries> seriesList = new ArrayList<DAChartSeries>();
    private DAChartPlot plot = null;
    private DAChartRenderer chartRenderer = new DAChartRenderer();
    private boolean bTooltip = false;
    private Image chartBuffer;
    public static final int CHART_STYLE_NORMAL = 0;
    public static final int CHART_STYLE_SCREENSHOT = 1;
    public static final int CHART_STYLE_MULTI = 2;
    private static Color[] seriesColors;
    private static final int autoColorSize = 10;
    private int autoColorIndex = 0;
    private boolean isSelected = false;
    private String information;
    private PaintListener chartPaintListener = new PaintListener(){

        public void paintControl(PaintEvent e) {
            DAChart.this.redrawChart();
            DAChart.this.chartRenderer.draw(e.gc, (DAChart)e.widget, DAChart.this.chartBuffer);
        }
    };
    private ControlListener chartControlListener = new ControlListener(){

        public void controlMoved(ControlEvent e) {
        }

        public void controlResized(ControlEvent e) {
            DAChart.this.redrawBuffer();
        }
    };
    private Listener chartTooltipListener = new Listener(){

        public void handleEvent(Event event) {
            switch (event.type) {
                case 5: {
                    if (DAChart.this.plot == null) break;
                    DAChartTooltip.getInstance().move();
                    break;
                }
                case 6: {
                    Logger.debug((Object)"MouseEnter");
                    if (DAChart.this.plot == null) break;
                    Shell shell = DAChart.this.parent.getShell();
                    DAChartTooltip.getInstance().open(shell, DAChart.this.plot);
                    break;
                }
                case 7: {
                    Logger.debug((Object)"MouseExit");
                    DAChartTooltip.getInstance().close();
                    break;
                }
            }
        }
    };

    private DAChart(Composite parent) {
        super(parent, 0x60040000);
        this.parent = parent;
        this.addListeners();
        this.plot = new DAChartPlot(this);
        seriesColors = new Color[10];
        DAChart.seriesColors[0] = ColorResources.CHART_SERIES_BLUE;
        DAChart.seriesColors[1] = ColorResources.CHART_SERIES_EMERALD;
        DAChart.seriesColors[2] = ColorResources.CHART_SERIES_PINK;
        DAChart.seriesColors[3] = ColorResources.CHART_SERIES_ORANGE;
        DAChart.seriesColors[4] = ColorResources.CHART_SERIES_PURPLE;
        DAChart.seriesColors[5] = ColorResources.CHART_SERIES_RED;
        DAChart.seriesColors[6] = ColorResources.CHART_SERIES_YELLOW;
        DAChart.seriesColors[7] = ColorResources.CHART_SERIES_GRAY;
        DAChart.seriesColors[8] = ColorResources.CHART_SERIES_YELLOWGREEN;
        DAChart.seriesColors[9] = ColorResources.CHART_SERIES_BROWN;
    }

    public DAChart(Composite parent, String name, DAChartSeries series) {
        this(parent);
        this.seriesList.add(series);
    }

    public DAChart(Composite parent, String name, int chartStyle) {
        this(parent);
        switch (chartStyle) {
            case 0: {
                this.plot = new DAChartPlot(this);
                break;
            }
            case 1: {
                this.plot = new DAScreenshotChartPlot(this);
                break;
            }
            case 2: {
                this.plot = new DAUIEventChartPlot(this);
                break;
            }
        }
    }

    private void addListeners() {
        this.addPaintListener(this.chartPaintListener);
        this.addControlListener(this.chartControlListener);
    }

    public DAChartPlot getPlot() {
        return this.plot;
    }

    public List<DAChartSeries> getSeriesList() {
        return this.seriesList;
    }

    public DAChartSeries getSeries(int index) {
        if (this.seriesList == null) {
            return null;
        }
        if (this.seriesList.size() < index) {
            return null;
        }
        return this.seriesList.get(index);
    }

    public DAChartSeries getSeries(String name) {
        if (this.seriesList == null) {
            return null;
        }
        int i = 0;
        while (i < this.seriesList.size()) {
            DAChartSeries series = this.seriesList.get(i);
            if (series.getName().compareTo(name) == 0) {
                return series;
            }
            ++i;
        }
        return null;
    }

    public void addSeries(DAChartSeries series) {
        this.seriesList.add(series);
        if (series.getColor() == null) {
            series.setColor(seriesColors[this.autoColorIndex++ % 10]);
        }
    }

    public void clear() {
        this.seriesList.clear();
        this.plot.clear();
        if (this.chartBuffer != null) {
            this.chartBuffer.dispose();
        }
    }

    public void contentsClear() {
        int i = 0;
        while (i < this.seriesList.size()) {
            this.seriesList.get(i).clear();
            ++i;
        }
    }

    protected void redrawBuffer() {
        Rectangle rt = this.getClientArea();
        if (this.chartBuffer != null) {
            this.chartBuffer.dispose();
        }
        if (rt.width > 0 && rt.height > 0) {
            this.chartBuffer = new Image((Device)Display.getDefault(), rt.width, rt.height);
            this.chartRenderer.drawBuffer(this.chartBuffer, this);
        }
    }

    protected void redrawChart() {
        boolean needUpdate = false;
        for (DAChartSeries series : this.seriesList) {
            if (!series.hasUpdate()) continue;
            series.setUpdate(false);
            needUpdate = true;
        }
        if (this.plot.hasUpdate()) {
            this.plot.setUpdate(false);
            needUpdate = true;
        }
        if (needUpdate) {
            this.redrawBuffer();
        }
    }

    public void redrawForce() {
        this.redrawBuffer();
        this.redraw();
    }

    public void showTooltip(boolean show) {
        if (this.bTooltip == show) {
            return;
        }
        if (show) {
            this.addListener(5, this.chartTooltipListener);
            this.addListener(6, this.chartTooltipListener);
            this.addListener(7, this.chartTooltipListener);
        } else {
            this.removeListener(5, this.chartTooltipListener);
            this.removeListener(6, this.chartTooltipListener);
            this.removeListener(7, this.chartTooltipListener);
        }
    }

    public void setChartRenderer(DAChartRenderer chartRenderer) {
        this.chartRenderer = chartRenderer;
    }

    public void setSelectCell(boolean selectCell) {
        this.isSelected = selectCell;
        this.redraw();
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public String getInformation() {
        return this.information;
    }

    public void setInformation(String information) {
        this.information = information;
    }

    public void setDirty(boolean isDirty) {
        this.plot.setUpdate(isDirty);
    }
}

