/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.chartBoard;

import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButton;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonClickEventListener;
import org.tizen.dynamicanalyzer.widgets.button.toggle.DACustomToggleButton;
import org.tizen.dynamicanalyzer.widgets.chart.DAChart;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardItem;
import org.tizen.dynamicanalyzer.widgets.helper.ColorResources;

public class DAChartBoardItemCell
extends Composite {
    private static final int DEFAULT_FOLD_TOGGLE_BUTTON_SIZE = 9;
    private static final int DEFAULT_EXPAND_TOGGLE_BUTTON_SIZE = 12;
    private static final int DEFAULT_TOGGLE_BUTTON_MARGIN = 1;
    private static final int DEFAULT_TOGGLE_BUTTON_TOP_MARGIN = 8;
    private static final int DEFAULT_TOGGLE_BUTTON_RIGHT_MARGIN = 8;
    private static final int DEFAULT_FOLD_TOGGLE_BUTTON_MARGIN = 23;
    private static final int NAME_ICON_X = 19;
    private static final int NAME_ICON_Y = 20;
    private static final int NAME_CELL_DEFAULT_MARGIN = 7;
    private static final int NAME_CELL_IMAGE_NAME_MARGIN = 50;
    private DAChartBoardItem parentItem;
    private Canvas nameCell;
    private DAChart chartCell;
    private DACustomToggleButton childFoldButton;
    private DACustomToggleButton expandButton;
    private int nameCellWidth = 190;
    private Color nameCellNormalBGColorStart;
    private Color nameCellNormalBGColorEnd;
    private Color nameCellSelectBGColorStart;
    private Color nameCellSelectBGColorEnd;
    private Color nameCellCurrentBGColorStart;
    private Color nameCellCurrentBGColorEnd;
    private String itemName;
    private Image itemIcon;
    private Image foldBackBuffer;
    private PaintListener nameCellPaintListener;
    private boolean hasAdditionalInfo = false;
    private String itemFullName = null;

    public String getItemName() {
        return this.itemName;
    }

    protected DAChartBoardItemCell(final DAChartBoardItem parent, String name, Image icon, int chartStyle) {
        super((Composite)parent, 0);
        this.parentItem = parent;
        this.itemName = name;
        this.itemIcon = icon;
        this.setBackground(ColorResources.GRAY_170);
        this.setLayout((Layout)new FormLayout());
        this.nameCell = new Canvas((Composite)this, 0);
        if (parent.getDepth() == 0) {
            this.nameCellNormalBGColorStart = ColorResources.CHART_NAME_PARENT_NORMAL_START;
            this.nameCellNormalBGColorEnd = ColorResources.CHART_NAME_PARENT_NORMAL_END;
            this.nameCellSelectBGColorStart = ColorResources.CHART_NAME_PARENT_SELECT_START;
            this.nameCellSelectBGColorEnd = ColorResources.CHART_NAME_PARENT_SELECT_END;
        } else {
            this.nameCellNormalBGColorStart = ColorResources.GRAY_230;
            this.nameCellNormalBGColorEnd = ColorResources.GRAY_230;
            this.nameCellSelectBGColorStart = ColorResources.CHART_NAME_CHILD_SELECT_START;
            this.nameCellSelectBGColorEnd = ColorResources.CHART_NAME_CHILD_SELECT_END;
        }
        this.nameCellCurrentBGColorStart = this.nameCellNormalBGColorStart;
        this.nameCellCurrentBGColorEnd = this.nameCellNormalBGColorEnd;
        this.redrawFoldBackground();
        this.nameCellPaintListener = new PaintListener(){

            public void paintControl(PaintEvent e) {
                Rectangle rect = ((Canvas)e.widget).getClientArea();
                DAChartBoardItemCell.this.drawNameCellBackGround(e.gc, rect);
                int cfr_ignored_0 = rect.height / 2;
                if (rect.height > 50 && DAChartBoardItemCell.this.itemIcon != null) {
                    e.gc.drawImage(DAChartBoardItemCell.this.itemIcon, 19, rect.height / 2 - 19);
                }
                e.gc.setForeground(ColorResources.BLACK);
                e.gc.setFont(parent.getNameFont());
                if (DAChartBoardItemCell.this.itemIcon == null) {
                    DAChartBoardItemCell.this.drawText(e.gc, DAChartBoardItemCell.this.itemName, rect, rect.height / 2 - 13);
                } else {
                    e.gc.drawText(DAChartBoardItemCell.this.itemName, 67, rect.height / 2 - 7, true);
                }
            }
        };
        this.nameCell.addPaintListener(this.nameCellPaintListener);
        this.nameCell.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                parent.callbackSelect(true);
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                if (DAChartBoardItemCell.this.childFoldButton == null) {
                    return;
                }
                if (DAChartBoardItemCell.this.childFoldButton.isToggled()) {
                    DAChartBoardItemCell.this.childFoldButton.setToggled(false);
                    DAChartBoardItemCell.this.parentItem.foldChild();
                } else {
                    DAChartBoardItemCell.this.childFoldButton.setToggled(true);
                    DAChartBoardItemCell.this.parentItem.unFoldChild();
                }
            }
        });
        this.nameCell.setLayout((Layout)new FormLayout());
        this.chartCell = new DAChart((Composite)this, this.itemName, chartStyle);
        this.chartCell.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                parent.callbackSelect(true);
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, -1);
        data.left = new FormAttachment(0, 0);
        data.width = this.nameCellWidth;
        this.nameCell.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, -1);
        data.left = new FormAttachment((Control)this.nameCell, 0);
        data.right = new FormAttachment(100, 0);
        this.chartCell.setLayoutData(data);
    }

    public void setFoldButtonTrue() {
        boolean isFold;
        if (this.childFoldButton == null) {
            return;
        }
        boolean bl = isFold = !this.childFoldButton.isToggled();
        if (!isFold) {
            return;
        }
        this.childFoldButton.setToggled(true);
    }

    void addChildFoldToggleButton() {
        if (this.childFoldButton != null) {
            return;
        }
        this.childFoldButton = new DACustomToggleButton((Composite)this.nameCell, ImageResources.CHILD_CHART_FOLD, ImageResources.CHILD_CHART_FOLD, ImageResources.CHILD_CHART_FOLD_HOVER, null, ImageResources.CHILD_CHART_UNFOLD, ImageResources.CHILD_CHART_UNFOLD_HOVER, null);
        this.childFoldButton.addClickListener(new DACustomButtonClickEventListener(){

            @Override
            public void handleClickEvent(DACustomButton button) {
                DAChartBoardItemCell.this.parentItem.callbackSelect(true);
                if (DAChartBoardItemCell.this.childFoldButton.isToggled()) {
                    DAChartBoardItemCell.this.parentItem.unFoldChild();
                } else {
                    DAChartBoardItemCell.this.parentItem.foldChild();
                }
                DAChartBoardItemCell.this.nameCell.redraw();
            }
        });
        FormData data = new FormData();
        data.top = !this.hasAdditionalInfo ? new FormAttachment(100, -10) : new FormAttachment(0, 23);
        data.left = new FormAttachment(0, 0);
        data.width = 190;
        data.height = 11;
        this.childFoldButton.setLayoutData(data);
        this.childFoldButton.setVisible(true);
        this.nameCell.layout();
        this.foldBackBuffer = new Image((Device)Display.getDefault(), 9, 9);
        this.redrawFoldBackground();
    }

    void addExpandToggleButton() {
        if (this.expandButton != null) {
            return;
        }
        this.expandButton = new DACustomToggleButton((Composite)this.nameCell, ImageResources.CHART_FULL_NORMAL, ImageResources.CHART_FULL_PUSH, ImageResources.CHART_FULL_HOVER, null, ImageResources.CHART_RESTORE_NORMAL, ImageResources.CHART_RESTORE_HOVER, null, ImageResources.CHART_RESTORE_PUSH);
        this.expandButton.addClickListener(new DACustomButtonClickEventListener(){

            @Override
            public void handleClickEvent(DACustomButton button) {
                boolean bToggled = DAChartBoardItemCell.this.expandButton.isToggled();
                DAChartBoardItemCell.this.parentItem.callbackSelect(true);
                DAChartBoardItemCell.this.parentItem.callbackExpand(bToggled);
                PaintListener fullNameCellPaintListener = new PaintListener(){

                    public void paintControl(PaintEvent e) {
                        Rectangle rect = ((Canvas)e.widget).getClientArea();
                        DAChartBoardItemCell.this.drawNameCellBackGround(e.gc, rect);
                        Point point = e.gc.textExtent(DAChartBoardItemCell.this.itemFullName, 2);
                        int startY = rect.height / 2 - point.y / 2 + 7;
                        e.gc.setForeground(ColorResources.BLACK);
                        DAChartBoardItemCell.this.drawText(e.gc, DAChartBoardItemCell.this.itemFullName, rect, startY);
                    }
                };
                if (DAChartBoardItemCell.this.itemFullName != null) {
                    if (bToggled) {
                        DAChartBoardItemCell.this.nameCell.addPaintListener(fullNameCellPaintListener);
                    } else {
                        DAChartBoardItemCell.this.nameCell.addPaintListener(DAChartBoardItemCell.this.nameCellPaintListener);
                    }
                }
                DAChartBoardItemCell.this.nameCell.redraw();
            }
        });
        FormData data = new FormData();
        data.top = new FormAttachment(0, 8);
        data.right = new FormAttachment(100, -8);
        data.width = 12;
        data.height = 12;
        this.expandButton.setLayoutData(data);
        this.expandButton.setVisible(true);
        this.nameCell.layout();
    }

    void removeExpandToggleButton() {
        this.expandButton.dispose();
        this.expandButton = null;
    }

    void setExpandButtonNormal() {
        if (this.expandButton != null) {
            this.expandButton.setToggled(false);
        }
    }

    DAChart getChartCell() {
        return this.chartCell;
    }

    void setSelectCell(boolean selectCell) {
        if (selectCell) {
            this.nameCellCurrentBGColorStart = this.nameCellSelectBGColorStart;
            this.nameCellCurrentBGColorEnd = this.nameCellSelectBGColorEnd;
        } else {
            this.nameCellCurrentBGColorStart = this.nameCellNormalBGColorStart;
            this.nameCellCurrentBGColorEnd = this.nameCellNormalBGColorEnd;
        }
        this.redrawFoldBackground();
        this.redrawExpandBackground();
        this.nameCell.redraw();
        this.chartCell.setSelectCell(selectCell);
    }

    private void redrawExpandBackground() {
        if (this.expandButton == null) {
            return;
        }
        this.expandButton.setBackground(this.nameCellCurrentBGColorStart);
        this.expandButton.redraw();
    }

    private void redrawFoldBackground() {
        if (this.childFoldButton == null) {
            return;
        }
        GC bufGc = new GC((Drawable)this.foldBackBuffer);
        bufGc.setBackground(this.nameCellCurrentBGColorStart);
        bufGc.fillRectangle(0, 0, 9, 9);
        this.childFoldButton.setBackgroundImage(this.foldBackBuffer);
        this.childFoldButton.redraw();
        bufGc.dispose();
    }

    void clear() {
        if (this.foldBackBuffer != null) {
            this.foldBackBuffer.dispose();
            this.foldBackBuffer = null;
        }
        if (this.chartCell != null) {
            this.chartCell.clear();
            this.chartCell.dispose();
        }
        if (this.nameCell != null) {
            this.nameCell.dispose();
        }
    }

    void contentsClear() {
        if (this.chartCell != null) {
            this.chartCell.contentsClear();
        }
    }

    private void drawNameCellBackGround(GC gc, Rectangle rect) {
        gc.setForeground(this.nameCellCurrentBGColorStart);
        gc.setBackground(this.nameCellCurrentBGColorEnd);
        gc.fillGradientRectangle(rect.x, rect.y, rect.width, rect.height, false);
    }

    private void drawNameImage(GC gc, Image image, Rectangle rect, int x, int y) {
        if (image != null) {
            gc.drawImage(image, x, y);
        }
    }

    private int drawText(GC gc, String text, Rectangle rect, int startY) {
        String[] temp = text.split("\n");
        int lineLength = temp.length;
        Point[] p = new Point[lineLength];
        int middleX = rect.width / 2 - 5;
        int i = 0;
        while (i < lineLength) {
            p[i] = gc.textExtent(temp[i]);
            gc.drawText(temp[i], middleX - p[i].x / 2, startY, true);
            startY += p[i].y;
            ++i;
        }
        return startY;
    }

    public void setNameCellBGColor(Color startColor, Color endColor) {
        this.nameCellNormalBGColorStart = startColor;
        this.nameCellNormalBGColorEnd = endColor;
        this.nameCellSelectBGColorStart = startColor;
        this.nameCellSelectBGColorEnd = endColor;
        this.nameCellCurrentBGColorStart = startColor;
        this.nameCellCurrentBGColorEnd = endColor;
        this.nameCell.redraw();
    }

    public void setFullName(String fullName) {
        this.itemFullName = fullName;
    }

    public void showChildFoldToggleButton() {
        if (this.childFoldButton != null) {
            this.childFoldButton.setVisible(true);
        }
    }

    public void hideChildFoldToggleButton() {
        if (this.childFoldButton != null) {
            this.childFoldButton.setVisible(false);
        }
    }
}

