/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.chartBoard;

import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoard;

public class DAChartBoardManager {
    private static final int SCALE_100 = 1;
    private static final int SCALE_200 = 2;
    private static final int SCALE_400 = 4;
    private static final int SCALE_800 = 8;
    private static final int SCALE_1600 = 16;
    private static final int[] DEFAULT_SCALE_VALUES = new int[]{1, 2, 4, 8, 16};
    private int[] scaleValues;
    private int currentScaleValueIndex = 0;
    private int chartWidth = 0;
    private double totalStartTime = 0.0;
    private double totalEndTime = 0.0;
    private double visibleStartTime = 0.0;
    private double thumb = 1.0;
    private DAChartBoard board = null;

    public DAChartBoardManager(DAChartBoard board) {
        this.board = board;
        this.scaleValues = DEFAULT_SCALE_VALUES;
    }

    public double getTotalStartTime() {
        return this.totalStartTime;
    }

    public void setTotalStartTime(double totalStartTime) {
        this.totalStartTime = totalStartTime;
    }

    public double getTotalEndTime() {
        return this.totalEndTime;
    }

    public void setTotalEndTime(double totalEndTime) {
        this.totalEndTime = totalEndTime;
    }

    public double getVisibleStartTime() {
        return this.visibleStartTime;
    }

    public void updateVisibleStartTime() {
        this.visibleStartTime = this.totalEndTime - this.thumb;
    }

    public double getVisibleEndTime() {
        return this.visibleStartTime + this.thumb;
    }

    public int getScaleVal() {
        return this.scaleValues[this.currentScaleValueIndex];
    }

    public void setScaleValues(int[] scaleValues) {
        this.scaleValues = scaleValues;
        double newThumb = this.computeThumb(this.chartWidth, scaleValues[this.currentScaleValueIndex]);
        this.visibleStartTime = this.computeVisibleStartTime(this.thumb, newThumb, this.totalEndTime);
        this.thumb = newThumb;
        this.board.notifyScaleChanged(scaleValues[this.currentScaleValueIndex], this.thumb, this.visibleStartTime);
    }

    public void scaleChanged(int scaleValIndex) {
        if (this.currentScaleValueIndex == scaleValIndex) {
            return;
        }
        if (scaleValIndex > 4) {
            scaleValIndex = 4;
        }
        this.currentScaleValueIndex = scaleValIndex;
        double newThumb = this.computeThumb(this.chartWidth, this.scaleValues[this.currentScaleValueIndex]);
        this.visibleStartTime = this.computeVisibleStartTime(this.thumb, newThumb, this.totalEndTime);
        this.thumb = newThumb;
        this.board.notifyScaleChanged(this.scaleValues[this.currentScaleValueIndex], this.thumb, this.visibleStartTime);
    }

    public void scrollbarSelectionChanged(int sel) {
        this.visibleStartTime = (double)sel / 1000.0;
        this.board.notifyScrollChanged(this.visibleStartTime);
    }

    public void startTimeChanged(double time) {
        if (time + this.thumb > this.totalEndTime) {
            time = this.totalEndTime - this.thumb;
        }
        if (time < 0.0) {
            time = 0.0;
        }
        this.visibleStartTime = time;
        this.board.notifyVisibleStartTimeChanged(this.visibleStartTime);
    }

    public void middleTimeChanged(double middleTime) {
        double startTime = middleTime - this.thumb / 2.0;
        this.startTimeChanged(startTime);
    }

    public void totalEndTimeChanged(double totalEndTime, boolean changeVisibleStartTime) {
        this.board.setScrollMaximum((int)((totalEndTime += 1.0) * 1000.0));
        this.board.setScrollThumb((int)(this.thumb * 1000.0));
        int visibleEnd = (int)(this.visibleStartTime * 1000.0) + (int)(this.thumb * 1000.0);
        int realEnd = (int)(this.totalEndTime * 1000.0);
        int distance = realEnd - visibleEnd;
        if (distance > -1000 && distance < 1000) {
            if (changeVisibleStartTime) {
                this.visibleStartTime = totalEndTime - this.thumb;
                if (this.visibleStartTime < 0.0) {
                    this.visibleStartTime = 0.0;
                }
            }
            this.board.setScrollSelection((int)(this.visibleStartTime * 1000.0));
            this.board.notifyScrollChanged(this.visibleStartTime);
        }
        this.totalEndTime = totalEndTime;
    }

    private double computeThumb(int width, int scale) {
        if (width == 0) {
            return 0.0;
        }
        double ret = (double)this.chartWidth / (double)(this.board.getInterval() * scale);
        return ret;
    }

    private double computeVisibleStartTime(double oldThumb, double newThumb, double totalEndTime) {
        double ret = 0.0;
        if (0.0 == this.visibleStartTime) {
            return ret;
        }
        if (Math.abs(totalEndTime - this.visibleStartTime - oldThumb) < 1.0E-9) {
            ret = totalEndTime - newThumb;
        } else {
            ret = this.visibleStartTime + oldThumb / 2.0 - newThumb / 2.0;
            if (ret + newThumb > totalEndTime) {
                ret = totalEndTime - newThumb;
            }
        }
        if (ret < 0.0) {
            ret = 0.0;
        }
        return ret;
    }

    public void timelineWidthChanged(int width) {
        if (width == 0) {
            return;
        }
        this.chartWidth = width;
        this.thumb = this.computeThumb(this.chartWidth, this.scaleValues[this.currentScaleValueIndex]);
        this.board.setScrollThumb((int)(this.thumb * 1000.0));
    }
}

