/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.timeline;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.tizen.dynamicanalyzer.widgets.timeline.DATimelineMarker;
import org.tizen.dynamicanalyzer.widgets.timeline.DATimelineRenderer;
import org.tizen.dynamicanalyzer.widgets.timeline.DATimelineTimeRenderer;
import org.tizen.dynamicanalyzer.widgets.timeline.MarkerManager;
import org.tizen.dynamicanalyzer.widgets.timeline.markers.IEventListener;
import org.tizen.dynamicanalyzer.widgets.timeline.markers.MarkerEvent;

public class DATimeline
extends Canvas {
    public static final int SCALE_100 = 1;
    public static final int SCALE_400 = 4;
    public static final int SCALE_800 = 8;
    private double startTime = 0.0;
    private int scale = 1;
    List<Double> stickyTimeList = new ArrayList<Double>();
    private double totalEndTime = 0.0;
    private boolean drawDetailedTime = false;
    private double detailedTime;
    private int detailedTimePosition;
    private int detailedFrame = -1;
    private DATimelineRenderer timelineRenderer;
    private PaintListener chartPaintListener = new PaintListener(){

        public void paintControl(PaintEvent e) {
            DATimeline.this.timelineRenderer.draw(e.gc, (DATimeline)e.widget);
        }
    };

    public DATimeline(Composite parent, boolean useMarker) {
        super(parent, 0x20000000);
        this.addPaintListener(this.chartPaintListener);
        this.timelineRenderer = new DATimelineTimeRenderer();
        if (useMarker) {
            this.addMouseListener((MouseListener)new RangeMarkerMouseEventListener());
            this.addMouseMoveListener(new RangeMarkerMouseMoveEventListener());
            this.addMouseTrackListener((MouseTrackListener)new RangeMarkerMouseTrackListener());
            MarkerManager.INSTANCE.addEventListener(new IEventListener(){

                @Override
                public void handleEvent(MarkerEvent event) {
                    DATimeline.this.redraw();
                }
            });
        }
    }

    public void setRenderer(DATimelineRenderer renderer) {
        this.timelineRenderer = renderer;
    }

    public double getStartTime() {
        return this.startTime;
    }

    public void setStartTime(double startTime) {
        this.startTime = startTime;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public void setDrawDetailTime(boolean draw) {
        this.drawDetailedTime = draw;
    }

    public boolean getDrawDetailedTime() {
        return this.drawDetailedTime;
    }

    public void setDetailTime(double detailedTime) {
        this.detailedTime = detailedTime;
    }

    public double getDetailedTime() {
        return this.detailedTime;
    }

    public void setDetailTimePosition(int position) {
        this.detailedTimePosition = position;
    }

    public int getDetailedTimePosition() {
        return this.detailedTimePosition;
    }

    private double secondToPixel(double second) {
        return (second - this.startTime) * (double)this.scale * 5.0;
    }

    private double pixelToSecond(int pixel) {
        return (double)pixel / (double)this.scale / 5.0 + this.startTime;
    }

    public void setTotalEndTime(double time) {
        this.totalEndTime = time;
    }

    public double getTotalEndTime() {
        return this.totalEndTime;
    }

    public List<Double> getStickyTimeList() {
        return this.stickyTimeList;
    }

    public void addStickyTime(double time) {
        this.stickyTimeList.add(time);
    }

    public Font getTimeTickFont() {
        return this.timelineRenderer.getTimeTickFont();
    }

    public void setTimeTickFont(Font font) {
        this.timelineRenderer.setTimeTickFont(font);
    }

    public Font getTimeBalloonFont() {
        return this.timelineRenderer.getTimeBalloonFont();
    }

    public void setTimeBalloonFont(Font font) {
        this.timelineRenderer.setTimeBalloonFont(font);
    }

    public void clear() {
        this.setStartTime(0.0);
        this.stickyTimeList.clear();
        this.detailedFrame = -1;
    }

    public int getDetailedFrame() {
        return this.detailedFrame;
    }

    public void setDetailFrame(int detailedFrame) {
        this.detailedFrame = detailedFrame;
    }

    private void setStatusInMarkerImage(int x, int y, DATimelineMarker.MARKER_STATUS status) {
        for (DATimelineMarker marker : MarkerManager.INSTANCE.getMarkerList()) {
            double markerPosition = this.secondToPixel(marker.getTime());
            if (!((double)x >= markerPosition - (double)(marker.getImage().getBounds().width / 2 + 1)) || !((double)x <= markerPosition + (double)(marker.getImage().getBounds().width / 2 + 1))) continue;
            marker.setStatus(status);
            this.redraw();
            break;
        }
    }

    private class RangeMarkerMouseEventListener
    extends MouseAdapter {
        private RangeMarkerMouseEventListener() {
        }

        public void mouseDown(MouseEvent e) {
            DATimeline.this.setStatusInMarkerImage(e.x, e.y, DATimelineMarker.MARKER_STATUS.PUSH);
        }

        public void mouseUp(MouseEvent e) {
            List<DATimelineMarker> markerList = MarkerManager.INSTANCE.getMarkerList();
            int i = 0;
            while (i < markerList.size()) {
                DATimelineMarker marker = markerList.get(i);
                if (marker.isPushed()) {
                    marker.setStatus(DATimelineMarker.MARKER_STATUS.NORMAL);
                    MarkerManager.INSTANCE.updateOrder(i);
                    break;
                }
                ++i;
            }
        }

        public void mouseDoubleClick(MouseEvent e) {
            List<DATimelineMarker> markerList = MarkerManager.INSTANCE.getMarkerList();
            int i = 0;
            while (i < markerList.size()) {
                DATimelineMarker marker = markerList.get(i);
                Rectangle markerRect = marker.getImage().getBounds();
                if ((double)e.x >= DATimeline.this.secondToPixel(marker.getTime()) - (double)markerRect.width / 2.0 && (double)e.x <= DATimeline.this.secondToPixel(marker.getTime()) + (double)markerRect.width / 2.0) {
                    MarkerManager.INSTANCE.removeMarker(i);
                    return;
                }
                ++i;
            }
            double newMarkerTime = DATimeline.this.pixelToSecond(e.x);
            if (newMarkerTime <= DATimeline.this.totalEndTime) {
                MarkerManager.INSTANCE.addMarker(newMarkerTime);
            }
        }
    }

    private class RangeMarkerMouseMoveEventListener
    implements MouseMoveListener {
        private RangeMarkerMouseMoveEventListener() {
        }

        public void mouseMove(MouseEvent e) {
            double stickyTime;
            if (DATimeline.this.stickyTimeList.size() == 0) {
                stickyTime = 0.0;
            } else if (DATimeline.this.stickyTimeList.size() == 1) {
                stickyTime = DATimeline.this.stickyTimeList.get(0);
            } else {
                double eTime = DATimeline.this.pixelToSecond(e.x);
                double minGapTime = DATimeline.this.stickyTimeList.get(0);
                int i = 1;
                while (i < DATimeline.this.stickyTimeList.size()) {
                    if (Math.abs(eTime - minGapTime) > Math.abs(eTime - DATimeline.this.stickyTimeList.get(i))) {
                        minGapTime = DATimeline.this.stickyTimeList.get(i);
                    }
                    ++i;
                }
                if (Math.abs(eTime - minGapTime) > Math.abs(eTime - DATimeline.this.totalEndTime)) {
                    minGapTime = DATimeline.this.totalEndTime;
                }
                stickyTime = minGapTime;
            }
            int timePixel = (int)DATimeline.this.secondToPixel(stickyTime);
            if (e.x - timePixel < 5 && e.x - timePixel > -5) {
                e.x = timePixel;
            }
            List<DATimelineMarker> markerList = MarkerManager.INSTANCE.getMarkerList();
            int i = 0;
            while (i < markerList.size()) {
                if (markerList.get(i).isPushed()) {
                    if (e.x < 0) {
                        e.x = 0;
                    } else if (e.x > DATimeline.this.getBounds().width) {
                        e.x = DATimeline.this.getBounds().width;
                    }
                    double movedTime = DATimeline.this.pixelToSecond(e.x);
                    if (movedTime > DATimeline.this.totalEndTime) {
                        movedTime = DATimeline.this.totalEndTime;
                    }
                    MarkerManager.INSTANCE.weakUpdateMarkerTime(i, movedTime);
                }
                ++i;
            }
        }
    }

    private class RangeMarkerMouseTrackListener
    extends MouseTrackAdapter {
        private RangeMarkerMouseTrackListener() {
        }

        public void mouseHover(MouseEvent e) {
        }

        public void mouseExit(MouseEvent e) {
            for (DATimelineMarker marker : MarkerManager.INSTANCE.getMarkerList()) {
                marker.setStatus(DATimelineMarker.MARKER_STATUS.NORMAL);
            }
            DATimeline.this.redraw();
        }
    }
}

