/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.util;

import org.tizen.dynamicanalyzer.util.Logger;

public class UnsignedInt {
    public static final long MAX_VALUE = 0xFFFFFFFFL;
    public static final long MIN_VALUE = 0L;
    private long value;

    public UnsignedInt() {
        this.value = 0L;
    }

    public UnsignedInt(int value) {
        this.value = (long)value & 0xFFFFFFFFL;
    }

    public UnsignedInt(long value) {
        if (value > 0xFFFFFFFFL || value < 0L) {
            Logger.error("Invalid input : " + value + ". 0 will be set.");
            this.value = 0L;
        } else {
            this.value = value;
        }
    }

    public UnsignedInt clone() {
        return new UnsignedInt(this.value);
    }

    public boolean equals(Object o) {
        if (o instanceof Long) {
            Long l = (Long)o;
            return l == this.value;
        }
        if (o instanceof Integer) {
            Integer i = (Integer)o;
            return i.longValue() == this.value;
        }
        return false;
    }

    public String toString() {
        return Long.toString(this.value);
    }

    public long getValue() {
        return this.value;
    }

    public void add(UnsignedInt operand) {
        this.add(operand.getValue());
    }

    public void minus(UnsignedInt operand) {
        this.minus(operand.getValue());
    }

    public void multiply(UnsignedInt operand) {
        this.multiply(operand.getValue());
    }

    public void divide(UnsignedInt operand) {
        this.divide(operand.getValue());
    }

    private void add(long operand) {
        long temp = this.value + operand;
        if (temp > 0xFFFFFFFFL) {
            Logger.error("exceed Max unsigned int size : " + temp);
            throw new RuntimeException("Overflow occured");
        }
        this.value = temp;
    }

    private void minus(long operand) {
        long temp = this.value - operand;
        if (temp < 0L) {
            Logger.error("result is a negative : " + temp);
            throw new RuntimeException("Underflow occured");
        }
        this.value = temp;
    }

    private void multiply(long operand) {
        long temp = this.value * operand;
        if (temp > 0xFFFFFFFFL) {
            Logger.error("exceed Max unsigned int size : " + temp);
            throw new RuntimeException("Overflow occured");
        }
        this.value = temp;
    }

    private void divide(long operand) {
        this.value /= operand;
    }
}

