/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.disassembler;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.edc.disassembler.CodeBufferUnderflowException;
import org.eclipse.cdt.debug.edc.disassembler.IDisassembledInstruction;
import org.eclipse.cdt.debug.edc.disassembler.IDisassembler;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.services.ITargetEnvironment;
import org.eclipse.cdt.dsf.debug.service.IDisassembly;
import org.eclipse.core.runtime.CoreException;

public abstract class AbstractDisassembler
implements IDisassembler {
    private final ITargetEnvironment targetEnvironment;

    private AbstractDisassembler() {
        this.targetEnvironment = null;
    }

    protected AbstractDisassembler(ITargetEnvironment env) {
        this.targetEnvironment = env;
    }

    protected ITargetEnvironment getTargetEnvironment() {
        return this.targetEnvironment;
    }

    @Override
    public List<IDisassembledInstruction> disassembleInstructions(IAddress startAddress, IAddress endAddress, ByteBuffer codeBuffer, Map<String, Object> options, IDisassembly.IDisassemblyDMContext dmc) throws CoreException {
        IDisassembledInstruction inst = null;
        ArrayList<IDisassembledInstruction> result = new ArrayList<IDisassembledInstruction>();
        IAddress address = startAddress;
        while (codeBuffer.hasRemaining() && address.compareTo((Object)endAddress) < 0) {
            try {
                inst = this.disassembleOneInstruction(address, codeBuffer, options, dmc);
                result.add(inst);
                address = address.add((long)inst.getSize());
            }
            catch (CodeBufferUnderflowException e) {
                if (result.size() != 0) break;
                if (options.containsKey("AddressIsPC")) {
                    this.throwAnnotated(e, address);
                }
                throw e;
            }
            catch (CoreException e) {
                this.throwAnnotated(e, address);
            }
        }
        return result;
    }

    private void throwAnnotated(CoreException e, IAddress address) throws CoreException {
        throw EDCDebugger.newCoreException("Fail to disassemble instruction at " + address.toHexAddressString() + "\nCause: " + e.getLocalizedMessage(), e);
    }
}

