/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.formatter;

import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.edc.formatter.AbstractVariableConverter;
import org.eclipse.cdt.debug.edc.formatter.FormatUtils;
import org.eclipse.cdt.debug.edc.formatter.ITypeContentProvider;
import org.eclipse.cdt.debug.edc.formatter.IVariableFormatProvider;
import org.eclipse.cdt.debug.edc.internal.symbols.IArrayType;
import org.eclipse.cdt.debug.edc.services.IEDCExpression;
import org.eclipse.cdt.debug.edc.symbols.IMemoryVariableLocation;
import org.eclipse.cdt.debug.edc.symbols.IType;
import org.eclipse.cdt.debug.edc.symbols.IVariableLocation;
import org.eclipse.cdt.debug.edc.symbols.TypeUtils;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;

public abstract class AbstractStringFormatter
implements IVariableFormatProvider {
    protected int getMaximumLength() {
        IEclipsePreferences scope = InstanceScope.INSTANCE.getNode("org.eclipse.debug.ui");
        return scope.getInt("org.eclipse.debug.ui.max_detail_length", 256);
    }

    @Override
    public ITypeContentProvider getTypeContentProvider(IType type) {
        return null;
    }

    public class DefaultNullTerminatedStringConverter
    extends AbstractVariableConverter {
        public DefaultNullTerminatedStringConverter(IType type, boolean forDetails) {
            super(type, forDetails);
        }

        @Override
        protected String getDetailsValue(IExpressions.IExpressionDMContext variable) throws CoreException {
            return this.getValueString(variable);
        }

        @Override
        protected String getSummaryValue(IExpressions.IExpressionDMContext variable) throws CoreException {
            return this.getValueString(variable);
        }

        private String getValueString(IExpressions.IExpressionDMContext variable) throws CoreException {
            Number value;
            long boundLength;
            IEDCExpression expressionDMC = (IEDCExpression)variable;
            expressionDMC.evaluateExpression();
            IType baseType = TypeUtils.getBaseType(expressionDMC.getEvaluatedType());
            int size = baseType.getByteSize();
            if (expressionDMC.getEvaluationError() != null) {
                return expressionDMC.getEvaluationError().getMessage();
            }
            IVariableLocation exprLoc = expressionDMC.getEvaluatedLocation();
            if (exprLoc instanceof IMemoryVariableLocation && ((IMemoryVariableLocation)exprLoc).getAddress().isZero()) {
                return "0";
            }
            int maximumLength = AbstractStringFormatter.this.getMaximumLength();
            if (expressionDMC.getEvaluatedType() instanceof IArrayType && (boundLength = ((IArrayType)expressionDMC.getEvaluatedType()).getBound(0).getBoundCount()) > 0L) {
                maximumLength = (int)Math.min(boundLength, (long)maximumLength);
            }
            if ((value = expressionDMC.getEvaluatedValue()) == null) {
                if (expressionDMC.getEvaluatedValueString() != null) {
                    return String.valueOf('\"') + expressionDMC.getEvaluatedValueString() + '\"';
                }
                return null;
            }
            IAddress address = FormatUtils.getPointerValue(value);
            if (address == null) {
                return value.toString();
            }
            if (address.isZero()) {
                return "0";
            }
            String formattedString = FormatUtils.getFormattedNullTermString(variable, address, size, maximumLength);
            return this.quoteString(formattedString);
        }

        private String quoteString(String str) {
            StringBuilder sb = new StringBuilder("\"");
            sb.append(str);
            sb.append('\"');
            return sb.toString();
        }
    }
}

