/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal;

import java.io.File;
import java.util.Collection;
import org.eclipse.cdt.debug.core.executables.Executable;
import org.eclipse.cdt.debug.core.executables.ExecutablesManager;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.PathUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.containers.AbstractSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;

public class ExecutablesSourceContainer
extends AbstractSourceContainer {
    public static final String TYPE_ID = String.valueOf(EDCDebugger.getUniqueIdentifier()) + ".containerType.executables";

    public Object[] findSourceElements(String name) throws CoreException {
        IPath path = PathUtils.findExistingPathIfCaseSensitive(PathUtils.createPath(name));
        String slashAndLowerFileName = String.valueOf(File.separator) + path.lastSegment().toLowerCase();
        String absoluteLowerPath = path.makeAbsolute().toOSString().toLowerCase();
        Collection executables = ExecutablesManager.getExecutablesManager().getExecutables(true);
        for (Executable e : executables) {
            String p = e.getPath().makeAbsolute().toOSString().toLowerCase();
            if (!p.endsWith(absoluteLowerPath) && !p.endsWith(slashAndLowerFileName)) continue;
            return new LocalFileStorage[]{new LocalFileStorage(e.getPath().toFile())};
        }
        return new Object[0];
    }

    public String getName() {
        return "Executables";
    }

    public ISourceContainerType getType() {
        return this.getSourceContainerType(TYPE_ID);
    }
}

