/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.ASTEvalMessages;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.SimpleInstruction;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.VariableWithValue;
import org.eclipse.cdt.debug.edc.internal.services.dsf.Symbols;
import org.eclipse.cdt.debug.edc.internal.symbols.InvalidVariableLocation;
import org.eclipse.cdt.debug.edc.services.EDCServicesTracker;
import org.eclipse.cdt.debug.edc.services.IEDCModuleDMContext;
import org.eclipse.cdt.debug.edc.services.IEDCModules;
import org.eclipse.cdt.debug.edc.services.Stack;
import org.eclipse.cdt.debug.edc.symbols.ILocationProvider;
import org.eclipse.cdt.debug.edc.symbols.IVariableLocation;
import org.eclipse.cdt.debug.edc.symbols.TypeUtils;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.core.runtime.CoreException;

public class EvaluateID
extends SimpleInstruction {
    private String name;
    private final ICPPASTQualifiedName qualifiedName;

    public EvaluateID(IASTIdExpression idExpression) {
        IASTName lookupName;
        if (idExpression.getName() instanceof ICPPASTQualifiedName) {
            this.qualifiedName = (ICPPASTQualifiedName)idExpression.getName();
            lookupName = this.qualifiedName.getLastName();
        } else {
            lookupName = idExpression.getName();
            this.qualifiedName = null;
        }
        this.name = new String(lookupName.getLookupKey());
    }

    public EvaluateID(String name) {
        this.name = name;
        this.qualifiedName = null;
    }

    @Override
    public void execute() throws CoreException {
        IEDCModuleDMContext module;
        Stack.EnumeratorDMC enumerator;
        IDMContext context = this.getContext();
        if (!(context instanceof Stack.StackFrameDMC)) {
            throw EDCDebugger.newCoreException(MessageFormat.format(ASTEvalMessages.EvaluateID_CannotResolveName, this.name));
        }
        Stack.StackFrameDMC frame = (Stack.StackFrameDMC)context;
        EDCServicesTracker servicesTracker = frame.getEDCServicesTracker();
        IEDCModules modules = servicesTracker.getService(IEDCModules.class);
        Stack.IVariableEnumeratorContext variableOrEnumerator = frame.findVariableOrEnumeratorByName(this.name, this.qualifiedName != null ? this.qualifiedName.getRawSignature() : null, false);
        Stack.VariableDMC variable = variableOrEnumerator instanceof Stack.VariableDMC ? (Stack.VariableDMC)variableOrEnumerator : null;
        Stack.EnumeratorDMC enumeratorDMC = enumerator = variableOrEnumerator instanceof Stack.EnumeratorDMC ? (Stack.EnumeratorDMC)variableOrEnumerator : null;
        if (variable != null && modules != null) {
            IVariableLocation valueLocation = null;
            ILocationProvider provider = variable.getVariable().getLocationProvider();
            IEDCModuleDMContext module2 = frame.getModule();
            if (module2 != null && provider != null) {
                valueLocation = provider.getLocation(servicesTracker, frame, module2.toLinkAddress(frame.getInstructionPtrAddress()), TypeUtils.isConstType(variable.getVariable().getType()));
            }
            if (valueLocation == null) {
                valueLocation = new InvalidVariableLocation(MessageFormat.format(ASTEvalMessages.EvaluateID_NameHasNoLocation, variable.getName()));
            }
            VariableWithValue varWval = new VariableWithValue(servicesTracker, frame, variable.getVariable());
            varWval.setValueLocation(valueLocation);
            this.push(varWval);
            return;
        }
        if (enumerator != null) {
            this.pushNewValue(this.fInterpreter.getTypeEngine().getIntegerTypeOfSize(4, true), enumerator.getEnumerator().getValue());
            return;
        }
        Symbols symbolsService = servicesTracker.getService(Symbols.class);
        if (symbolsService != null && (module = frame.getModule()) != null) {
            List<IAddress> addresses;
            String searchName = this.name;
            if (this.qualifiedName != null) {
                searchName = this.qualifiedName.getRawSignature();
            }
            if ((addresses = symbolsService.getFunctionAddress(module, searchName)).size() > 0) {
                this.pushNewValue(this.fInterpreter.getTypeEngine().getIntegerTypeOfSize(4, false), addresses.get(0).getValue().longValue());
                return;
            }
            this.name = searchName;
        }
        throw EDCDebugger.newCoreException(MessageFormat.format(ASTEvalMessages.EvaluateID_VariableNotFound, this.name));
    }
}

