/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.services.dsf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.cdt.debug.core.model.ICWatchpoint;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.EDCTrace;
import org.eclipse.cdt.debug.edc.internal.services.dsf.Modules;
import org.eclipse.cdt.debug.edc.internal.services.dsf.Symbols;
import org.eclipse.cdt.debug.edc.launch.EDCLaunch;
import org.eclipse.cdt.debug.edc.services.ITargetEnvironment;
import org.eclipse.cdt.debug.edc.symbols.ILineEntryProvider;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.BreakpointsMediator2;
import org.eclipse.cdt.dsf.debug.service.IBreakpointAttributeTranslator2;
import org.eclipse.cdt.dsf.debug.service.IBreakpoints;
import org.eclipse.cdt.dsf.debug.service.IModules;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;

public class BreakpointAttributeTranslator
implements IBreakpointAttributeTranslator2 {
    private DsfServicesTracker dsfServicesTracker;
    private DsfSession dsfSession;
    private ITargetEnvironment targetEnvService;

    public BreakpointAttributeTranslator(DsfSession dsfSession) {
        this.dsfSession = dsfSession;
        this.dsfServicesTracker = new DsfServicesTracker(EDCDebugger.getDefault().getBundle().getBundleContext(), dsfSession.getId());
        this.targetEnvService = (ITargetEnvironment)this.dsfServicesTracker.getService(ITargetEnvironment.class);
        assert (this.targetEnvService != null);
    }

    public boolean canUpdateAttributes(IBreakpoints.IBreakpointDMContext bp, Map<String, Object> delta) {
        if (delta == null || delta.size() == 0) {
            return true;
        }
        return !delta.containsKey("lineNumber") && !delta.containsKey("org.eclipse.debug.core.enabled") && !delta.containsKey("org.eclipse.cdt.debug.core.function") && !delta.containsKey("org.eclipse.cdt.debug.core.address") && !delta.containsKey("org.eclipse.cdt.debug.core.expression") && !delta.containsKey("org.eclipse.cdt.debug.core.read") && !delta.containsKey("org.eclipse.cdt.debug.core.write");
    }

    public void dispose() {
        if (this.dsfServicesTracker != null) {
            this.dsfServicesTracker.dispose();
        }
        this.dsfSession = null;
    }

    public List<Map<String, Object>> getBreakpointAttributes(IBreakpoint bp, boolean bpManagerEnabled) throws CoreException {
        ArrayList<Map<String, Object>> retVal = new ArrayList<Map<String, Object>>(1);
        return retVal;
    }

    public void initialize(BreakpointsMediator2 mediator) {
    }

    public boolean supportsBreakpoint(IBreakpoint bp) {
        return bp instanceof ICBreakpoint;
    }

    public void updateBreakpointStatus(IBreakpoint bp) {
    }

    public void updateBreakpointsStatus(Map<IBreakpoint, Map<IBreakpoints.IBreakpointsTargetDMContext, BreakpointsMediator2.ITargetBreakpointInfo[]>> bpsInfo, BreakpointsMediator2.BreakpointEventType eventType) {
        block9: for (IBreakpoint bp : bpsInfo.keySet()) {
            if (!(bp instanceof ICBreakpoint)) {
                return;
            }
            ICBreakpoint icbp = (ICBreakpoint)bp;
            Map<IBreakpoints.IBreakpointsTargetDMContext, BreakpointsMediator2.ITargetBreakpointInfo[]> targetBpPerContext = bpsInfo.get(bp);
            switch (eventType) {
                case ADDED: {
                    int installCountTotal = 0;
                    for (BreakpointsMediator2.ITargetBreakpointInfo[] tbpInfos : targetBpPerContext.values()) {
                        int installCountPerContext = 0;
                        BreakpointsMediator2.ITargetBreakpointInfo[] iTargetBreakpointInfoArray = tbpInfos;
                        int n = tbpInfos.length;
                        int n2 = 0;
                        while (n2 < n) {
                            BreakpointsMediator2.ITargetBreakpointInfo tbp = iTargetBreakpointInfoArray[n2];
                            if (tbp.getTargetBreakpoint() != null) {
                                ++installCountPerContext;
                            }
                            ++n2;
                        }
                        installCountTotal += installCountPerContext;
                    }
                    int i = 0;
                    while (i < installCountTotal) {
                        try {
                            icbp.incrementInstallCount();
                        }
                        catch (CoreException e) {
                            EDCDebugger.getMessageLogger().log(e.getStatus());
                        }
                        ++i;
                    }
                    continue block9;
                }
                case MODIFIED: {
                    break;
                }
                case REMOVED: {
                    int removeCountTotal = 0;
                    for (BreakpointsMediator2.ITargetBreakpointInfo[] tbpInfos : targetBpPerContext.values()) {
                        removeCountTotal += tbpInfos.length;
                    }
                    int i = 0;
                    while (i < removeCountTotal) {
                        try {
                            if (icbp.isRegistered()) {
                                icbp.decrementInstallCount();
                            }
                        }
                        catch (CoreException e) {
                            EDCDebugger.getMessageLogger().log(e.getStatus());
                        }
                        ++i;
                    }
                    continue block9;
                }
            }
        }
    }

    public Map<String, Object> convertAttributes(Map<String, Object> platformBPAttrDelta) {
        return new HashMap<String, Object>(platformBPAttrDelta);
    }

    public void resolveBreakpoint(IBreakpoints.IBreakpointsTargetDMContext context, IBreakpoint breakpoint, final Map<String, Object> attributes, final DataRequestMonitor<List<Map<String, Object>>> drm) {
        final ArrayList<HashMap<String, Object>> targetBPAttrs = new ArrayList<HashMap<String, Object>>(1);
        if (EDCTrace.BREAKPOINTS_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)("Resolving breakpoint " + EDCTrace.fixArg(breakpoint) + " in context " + EDCTrace.fixArg(context)));
        }
        if (this.dsfSession == null) {
            drm.setData(targetBPAttrs);
            drm.done();
            if (EDCTrace.BREAKPOINTS_TRACE_ON) {
                EDCTrace.getTrace().traceExit(null, (Object)"null session");
            }
            return;
        }
        Modules.ModuleDMC module = (Modules.ModuleDMC)context;
        String bpType = (String)attributes.get("org.eclipse.cdt.debug.edc.breakpoint.subtype");
        if (bpType.equals("address_bp")) {
            String addr = (String)attributes.get("org.eclipse.cdt.debug.core.address");
            assert (addr != null);
            HashMap<String, Object> oneBPAttr = new HashMap<String, Object>(attributes);
            String s = addr.toLowerCase().startsWith("0x") ? addr.substring(2) : addr;
            oneBPAttr.put("org.eclipse.cdt.debug.edc.breakpoint.runtime_addr", s);
            targetBPAttrs.add(oneBPAttr);
            drm.setData(targetBPAttrs);
            drm.done();
        } else if (bpType.equals("function_bp")) {
            String function = (String)attributes.get("org.eclipse.cdt.debug.core.function");
            assert (function != null && function.length() > 0);
            Symbols symService = (Symbols)this.dsfServicesTracker.getService(Symbols.class);
            List<IAddress> addrs = symService.getFunctionAddress(module, function);
            for (IAddress a : addrs) {
                HashMap<String, Object> oneBPAttr = new HashMap<String, Object>(attributes);
                oneBPAttr.put("org.eclipse.cdt.debug.edc.breakpoint.runtime_addr", a.toString(16));
                targetBPAttrs.add(oneBPAttr);
            }
            drm.setData(targetBPAttrs);
            drm.done();
        } else {
            assert (bpType.equals("line_bp"));
            final String bpFile = (String)attributes.get("org.eclipse.cdt.debug.core.sourceHandle");
            final Integer line = (Integer)attributes.get("lineNumber");
            IRunControl.IExecutionDMContext exe_dmc = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)context, IRunControl.IExecutionDMContext.class);
            final ICBreakpoint icBP = (ICBreakpoint)breakpoint;
            assert (exe_dmc != null) : "ExecutionDMContext is unknown in resolveBreakpoint().";
            Modules modulesService = (Modules)this.dsfServicesTracker.getService(Modules.class);
            IModules.ISymbolDMContext sym_dmc = (IModules.ISymbolDMContext)DMContexts.getAncestorOfType((IDMContext)context, IModules.ISymbolDMContext.class);
            String compileFile = EDCLaunch.getLaunchForSession(this.dsfSession.getId()).getCompilationPath(bpFile);
            if (EDCTrace.BREAKPOINTS_TRACE_ON) {
                EDCTrace.getTrace().trace(null, "BP file: " + bpFile + " Compile file: " + compileFile);
            }
            modulesService.findClosestLineWithCode(sym_dmc, compileFile, line, 5, new DataRequestMonitor<ILineEntryProvider.ILineAddresses>((Executor)this.dsfSession.getExecutor(), drm){

                protected void handleCompleted() {
                    if (!this.isSuccess()) {
                        drm.setStatus(this.getStatus());
                        drm.done();
                        if (EDCTrace.BREAKPOINTS_TRACE_ON) {
                            EDCTrace.getTrace().trace(null, "findClosestLineWithCode failed: " + drm.getStatus());
                        }
                        return;
                    }
                    ILineEntryProvider.ILineAddresses codeLine = (ILineEntryProvider.ILineAddresses)this.getData();
                    IAddress[] addresses = codeLine.getAddress();
                    if (addresses.length > 0) {
                        IAddress address = addresses[0];
                        int i = 1;
                        while (i < addresses.length) {
                            if (addresses[i].getValue().longValue() < address.getValue().longValue()) {
                                address = addresses[i];
                            }
                            ++i;
                        }
                        HashMap<String, String> targetAttr = new HashMap<String, String>(attributes);
                        targetAttr.put("org.eclipse.cdt.debug.edc.breakpoint.runtime_addr", address.toString(16));
                        targetBPAttrs.add(targetAttr);
                    }
                    drm.setData((Object)targetBPAttrs);
                    int actualCodeLine = codeLine.getLineNumber();
                    if (actualCodeLine == line) {
                        drm.done();
                    } else {
                        int newLine = actualCodeLine;
                        if (BreakpointAttributeTranslator.findUserBreakpointAt(bpFile, newLine) == null) {
                            try {
                                icBP.getMarker().setAttribute("lineNumber", newLine);
                            }
                            catch (CoreException coreException) {}
                            drm.done();
                        } else {
                            targetBPAttrs.clear();
                            drm.done();
                        }
                    }
                }
            });
        }
        if (EDCTrace.BREAKPOINTS_TRACE_ON) {
            EDCTrace.getTrace().traceExit(null);
        }
    }

    public Map<String, Object> getAllBreakpointAttributes(IBreakpoint platformBP, boolean bpManagerEnabled) throws CoreException {
        IMarker marker = platformBP.getMarker();
        if (marker == null || !marker.exists()) {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 5012, "Breakpoint marker does not exist", null));
        }
        Map platformBpAttrs = marker.getAttributes();
        HashMap<String, Object> attrs = new HashMap<String, Object>(platformBpAttrs);
        if (platformBP instanceof ICWatchpoint) {
            attrs.put("org.eclipse.cdt.debug.edc.breakpoint.type", "watchpoint");
        } else if (platformBP instanceof ICLineBreakpoint) {
            attrs.put("org.eclipse.cdt.debug.edc.breakpoint.type", "breakpoint");
            String file = (String)attrs.get("org.eclipse.cdt.debug.core.sourceHandle");
            String address = (String)attrs.get("org.eclipse.cdt.debug.core.address");
            String function = (String)attrs.get("org.eclipse.cdt.debug.core.function");
            Integer line = (Integer)attrs.get("lineNumber");
            if (address != null && address.length() > 0) {
                attrs.put("org.eclipse.cdt.debug.edc.breakpoint.subtype", "address_bp");
            } else if (function != null && function.length() > 0) {
                attrs.put("org.eclipse.cdt.debug.edc.breakpoint.subtype", "function_bp");
            } else {
                assert (file != null && file.length() > 0 && line != null);
                attrs.put("org.eclipse.cdt.debug.edc.breakpoint.subtype", "line_bp");
            }
        }
        if (!bpManagerEnabled) {
            attrs.put("org.eclipse.debug.core.enabled", false);
        }
        return attrs;
    }

    public boolean canUpdateAttributes(IBreakpoint bp, IBreakpoints.IBreakpointsTargetDMContext context, Map<String, Object> attrDelta) {
        return this.canUpdateAttributes(null, attrDelta);
    }

    private static IBreakpoint findUserBreakpointAt(String bpFile, int bpLine) {
        IBreakpoint[] platformBPs;
        IBreakpoint[] iBreakpointArray = platformBPs = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints();
        int n = platformBPs.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker;
            IBreakpoint pbp = iBreakpointArray[n2];
            if (pbp instanceof ICLineBreakpoint && (marker = pbp.getMarker()) != null && marker.exists()) {
                try {
                    Map attrs = marker.getAttributes();
                    String file = (String)attrs.get("org.eclipse.cdt.debug.core.sourceHandle");
                    Integer line = (Integer)attrs.get("lineNumber");
                    if (bpFile.equals(file) && bpLine == line) {
                        return pbp;
                    }
                }
                catch (Exception exception) {}
            }
            ++n2;
        }
        return null;
    }
}

