/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.services.dsf;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.debug.edc.MemoryUtils;
import org.eclipse.cdt.debug.edc.formatter.ITypeContentProvider;
import org.eclipse.cdt.debug.edc.formatter.IVariableValueConverter;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.EDCTrace;
import org.eclipse.cdt.debug.edc.internal.NumberFormatUtils;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.ASTEvaluationEngine;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.IArrayDimensionType;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.InstructionSequence;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.Interpreter;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.OperandValue;
import org.eclipse.cdt.debug.edc.internal.formatter.FormatExtensionManager;
import org.eclipse.cdt.debug.edc.internal.services.dsf.EDCServicesMessages;
import org.eclipse.cdt.debug.edc.internal.symbols.IAggregate;
import org.eclipse.cdt.debug.edc.internal.symbols.IArrayType;
import org.eclipse.cdt.debug.edc.internal.symbols.ICPPBasicType;
import org.eclipse.cdt.debug.edc.internal.symbols.ICompositeType;
import org.eclipse.cdt.debug.edc.internal.symbols.IEnumeration;
import org.eclipse.cdt.debug.edc.internal.symbols.IField;
import org.eclipse.cdt.debug.edc.internal.symbols.IPointerType;
import org.eclipse.cdt.debug.edc.internal.symbols.IReferenceType;
import org.eclipse.cdt.debug.edc.internal.symbols.ISubroutineType;
import org.eclipse.cdt.debug.edc.launch.EDCLaunch;
import org.eclipse.cdt.debug.edc.services.AbstractEDCService;
import org.eclipse.cdt.debug.edc.services.DMContext;
import org.eclipse.cdt.debug.edc.services.IEDCDMContext;
import org.eclipse.cdt.debug.edc.services.IEDCExpression;
import org.eclipse.cdt.debug.edc.services.IEDCExpressions;
import org.eclipse.cdt.debug.edc.services.Stack;
import org.eclipse.cdt.debug.edc.symbols.IEnumerator;
import org.eclipse.cdt.debug.edc.symbols.IInvalidVariableLocation;
import org.eclipse.cdt.debug.edc.symbols.IType;
import org.eclipse.cdt.debug.edc.symbols.IVariableLocation;
import org.eclipse.cdt.debug.edc.symbols.TypeUtils;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.Immutable;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.AbstractDMContext;
import org.eclipse.cdt.dsf.datamodel.AbstractDMEvent;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.cdt.dsf.debug.service.IExpressions2;
import org.eclipse.cdt.dsf.debug.service.IFormattedValues;
import org.eclipse.cdt.dsf.debug.service.IRegisters;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.service.IDsfService;
import org.eclipse.cdt.utils.Addr64;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class Expressions
extends AbstractEDCService
implements IEDCExpressions {
    public Expressions(DsfSession session) {
        super(session, new String[]{IExpressions.class.getName(), Expressions.class.getName(), IExpressions2.class.getName()});
    }

    public boolean canWriteExpression(IEDCExpression expressionDMC) {
        EDCLaunch launch = EDCLaunch.getLaunchForSession(this.getSession().getId());
        if (launch.isSnapshotLaunch()) {
            return false;
        }
        IVariableValueConverter converter = this.getCustomValueConverter(expressionDMC);
        if (converter != null) {
            return converter.canEditValue();
        }
        return !this.isComposite(expressionDMC);
    }

    public void canWriteExpression(IExpressions.IExpressionDMContext exprContext, DataRequestMonitor<Boolean> rm) {
        IEDCExpression expressionDMC = (IEDCExpression)exprContext;
        rm.setData((Object)this.canWriteExpression(expressionDMC));
        rm.done();
    }

    private boolean isComposite(IEDCExpression expressionDMC) {
        IType exprType = TypeUtils.getStrippedType(expressionDMC.getEvaluatedType());
        return exprType instanceof ICompositeType;
    }

    public IExpressions.IExpressionDMContext createExpression(IDMContext context, String expression) {
        Stack.StackFrameDMC frameDmc = (Stack.StackFrameDMC)DMContexts.getAncestorOfType((IDMContext)context, Stack.StackFrameDMC.class);
        if (frameDmc != null) {
            return new ExpressionDMC((IDMContext)frameDmc, expression);
        }
        return new InvalidContextExpressionDMC(this.getSession().getId(), expression, context);
    }

    public IExpressions2.ICastedExpressionDMContext createCastedExpression(IExpressions.IExpressionDMContext exprDMC, IExpressions2.CastInfo castInfo) {
        if (exprDMC instanceof IEDCExpression) {
            CastedExpressionDMC castedDMC = new CastedExpressionDMC((IEDCExpression)exprDMC, exprDMC.getExpression(), ((IEDCExpression)exprDMC).getName(), castInfo);
            return castedDMC;
        }
        assert (false);
        return null;
    }

    public void getBaseExpressions(IExpressions.IExpressionDMContext exprContext, DataRequestMonitor<IExpressions.IExpressionDMContext[]> rm) {
        rm.setData((Object)new IEDCExpression[0]);
        rm.done();
    }

    public void getExpressionAddressData(final IExpressions.IExpressionDMContext exprContext, final DataRequestMonitor<IExpressions.IExpressionDMAddress> rm) {
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (exprContext instanceof IEDCExpression) {
                    rm.setData((Object)new ExpressionDMAddress(exprContext));
                } else {
                    rm.setData((Object)new ExpressionDMAddress(null));
                }
                rm.done();
            }
        }, (RequestMonitor)rm);
    }

    public void getExpressionData(final IExpressions.IExpressionDMContext exprContext, final DataRequestMonitor<IExpressions.IExpressionDMData> rm) {
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (exprContext instanceof IEDCExpression) {
                    rm.setData((Object)new ExpressionData((IEDCExpression)exprContext));
                } else {
                    rm.setData((Object)new ExpressionData(null));
                }
                rm.done();
            }
        }, (RequestMonitor)rm);
    }

    public void getSubExpressionCount(final IExpressions.IExpressionDMContext exprContext, final DataRequestMonitor<Integer> rm) {
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                IExpressions2.CastInfo cast = null;
                if (exprContext instanceof IEDCExpression && (cast = ((IEDCExpression)exprContext).getCastInfo()) != null && cast.getArrayCount() > 0) {
                    if (((IEDCExpression)exprContext).getEvaluationError() != null) {
                        rm.setData((Object)0);
                        rm.done();
                        return;
                    }
                    rm.setData((Object)cast.getArrayCount());
                    rm.done();
                    return;
                }
                if (!(exprContext instanceof IEDCExpression)) {
                    rm.setData((Object)0);
                    rm.done();
                    return;
                }
                IEDCExpression expr = (IEDCExpression)exprContext;
                if (expr.getEvaluatedValue() == null && expr.getEvaluatedValueString() != null) {
                    expr.evaluateExpression();
                }
                IType exprType = TypeUtils.getStrippedType(expr.getEvaluatedType());
                boolean pointerType = exprType instanceof IPointerType;
                boolean referenceType = exprType instanceof IReferenceType;
                IType pointedTo = null;
                if (referenceType) {
                    pointedTo = TypeUtils.getStrippedType(((IReferenceType)exprType).getType());
                }
                if (!(exprType instanceof IAggregate || pointerType || referenceType && (pointedTo instanceof IAggregate || pointedTo instanceof IPointerType))) {
                    rm.setData((Object)0);
                    rm.done();
                    return;
                }
                ITypeContentProvider customProvider = FormatExtensionManager.instance().getTypeContentProvider(exprType);
                if (customProvider != null) {
                    try {
                        rm.setData((Object)customProvider.getChildCount(expr));
                        rm.done();
                        return;
                    }
                    catch (Throwable throwable) {}
                }
                Expressions.this.getSubExpressions(exprContext, new DataRequestMonitor<IExpressions.IExpressionDMContext[]>((Executor)Expressions.this.getExecutor(), (RequestMonitor)rm){

                    protected void handleSuccess() {
                        rm.setData((Object)((IExpressions.IExpressionDMContext[])this.getData()).length);
                        rm.done();
                    }
                });
            }
        }, (RequestMonitor)rm);
    }

    public void getSubExpressions(final IExpressions.IExpressionDMContext exprContext, final DataRequestMonitor<IExpressions.IExpressionDMContext[]> rm) {
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!(exprContext instanceof IEDCExpression) || ((IEDCExpression)exprContext).getFrame() == null) {
                    rm.setData((Object)new IEDCExpression[0]);
                    rm.done();
                    return;
                }
                IEDCExpression expr = (IEDCExpression)exprContext;
                if (expr.getEvaluatedValue() == null && expr.getEvaluatedValueString() != null) {
                    expr.evaluateExpression();
                }
                Stack.StackFrameDMC frame = (Stack.StackFrameDMC)expr.getFrame();
                IType exprType = TypeUtils.getStrippedType(expr.getEvaluatedType());
                IExpressions2.CastInfo castInfo = expr.getCastInfo();
                if (castInfo != null && castInfo.getArrayCount() > 0) {
                    try {
                        exprType = frame.getTypeEngine().convertToArrayType(exprType, castInfo.getArrayCount());
                    }
                    catch (CoreException e) {
                        rm.setStatus(e.getStatus());
                        rm.done();
                        return;
                    }
                }
                boolean pointerType = exprType instanceof IPointerType;
                boolean referenceType = exprType instanceof IReferenceType;
                IType pointedTo = null;
                if (referenceType) {
                    exprType = pointedTo = TypeUtils.getStrippedType(((IReferenceType)exprType).getType());
                }
                if (!(exprType instanceof IAggregate || pointerType || referenceType && (pointedTo instanceof IAggregate || pointedTo instanceof IPointerType))) {
                    rm.setData((Object)new IEDCExpression[0]);
                    rm.done();
                    return;
                }
                ITypeContentProvider customProvider = FormatExtensionManager.instance().getTypeContentProvider(exprType);
                if (customProvider != null) {
                    Expressions.this.getSubExpressions(expr, frame, exprType, customProvider, (DataRequestMonitor<IExpressions.IExpressionDMContext[]>)rm);
                } else {
                    Expressions.this.getSubExpressions(expr, (DataRequestMonitor<IExpressions.IExpressionDMContext[]>)rm);
                }
            }
        }, (RequestMonitor)rm);
    }

    public void getSubExpressions(final IExpressions.IExpressionDMContext exprContext, final int startIndex_, final int length_, final DataRequestMonitor<IExpressions.IExpressionDMContext[]> rm) {
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                Expressions.this.getSubExpressions(exprContext, new DataRequestMonitor<IExpressions.IExpressionDMContext[]>((Executor)Expressions.this.getExecutor(), (RequestMonitor)rm){

                    protected void handleSuccess() {
                        IExpressions.IExpressionDMContext[] allExprs = (IExpressions.IExpressionDMContext[])this.getData();
                        if (startIndex_ == 0 && length_ >= allExprs.length) {
                            rm.setData((Object)allExprs);
                            rm.done();
                        } else {
                            int startIndex = startIndex_;
                            int length = length_;
                            if (startIndex > allExprs.length) {
                                startIndex = allExprs.length;
                                length = 0;
                            } else if (startIndex + length > allExprs.length && (length = allExprs.length - startIndex) < 0) {
                                length = 0;
                            }
                            IExpressions.IExpressionDMContext[] result = new IExpressions.IExpressionDMContext[length];
                            System.arraycopy(allExprs, startIndex, result, 0, length);
                            rm.setData((Object)result);
                            rm.done();
                        }
                    }
                });
            }
        }, (RequestMonitor)rm);
    }

    private void getSubExpressions(IEDCExpression expr, Stack.StackFrameDMC frame, IType exprType, ITypeContentProvider customProvider, DataRequestMonitor<IExpressions.IExpressionDMContext[]> rm) {
        ArrayList<IExpressions.IExpressionDMContext> children = new ArrayList<IExpressions.IExpressionDMContext>();
        try {
            Iterator<IExpressions.IExpressionDMContext> childIterator = customProvider.getChildIterator(expr);
            while (childIterator.hasNext() && !rm.isCanceled()) {
                children.add(childIterator.next());
            }
            rm.setData((Object)children.toArray(new IExpressions.IExpressionDMContext[children.size()]));
            rm.done();
        }
        catch (CoreException coreException) {
            this.getSubExpressions(expr, rm);
        }
        catch (Throwable e) {
            EDCDebugger.getMessageLogger().logError(String.valueOf(EDCServicesMessages.Expressions_ErrorInVariableFormatter) + customProvider.getClass().getName(), e);
            this.getSubExpressions(expr, rm);
        }
    }

    private void getSubExpressions(IEDCExpression expr, DataRequestMonitor<IExpressions.IExpressionDMContext[]> rm) {
        rm.setData((Object)this.getLogicalSubExpressions(expr));
        rm.done();
    }

    public IEDCExpression[] getLogicalSubExpressions(IEDCExpression expr) {
        IType exprType = TypeUtils.getUnRefStrippedType(expr.getEvaluatedType());
        IExpressions2.CastInfo castInfo = expr.getCastInfo();
        if (castInfo != null && castInfo.getArrayCount() > 0) {
            String exprName = expr.getExpression();
            if (exprName.contains("(")) {
                exprName = String.valueOf('(') + exprName + ')';
            }
            long lowerBound = castInfo.getArrayStartIndex();
            long count = castInfo.getArrayCount();
            ArrayList<ExpressionDMC> arrayChildren = new ArrayList<ExpressionDMC>();
            int i = 0;
            while ((long)i < count) {
                String arrayElement = "[" + ((long)i + lowerBound) + "]";
                ExpressionDMC newExpr = new ExpressionDMC((IDMContext)expr.getFrame(), String.valueOf(exprName) + arrayElement, String.valueOf(expr.getName()) + arrayElement);
                ExpressionDMC exprChild = newExpr;
                if (exprChild != null) {
                    arrayChildren.add(exprChild);
                }
                ++i;
            }
            return arrayChildren.toArray(new IEDCExpression[arrayChildren.size()]);
        }
        if (exprType instanceof IPointerType) {
            ExpressionDMC exprChild;
            String exprName = expr.getExpression();
            IType typePointedTo = TypeUtils.getStrippedType(exprType.getType());
            boolean indirected = false;
            if (exprName.startsWith("&")) {
                ExpressionDMC newExpr;
                exprName = exprName.substring(1);
                exprChild = newExpr = new ExpressionDMC((IDMContext)expr.getFrame(), exprName);
                indirected = true;
            } else {
                ExpressionDMC newExpr;
                if (typePointedTo instanceof ICPPBasicType && ((ICPPBasicType)typePointedTo).getBaseType() == 1) {
                    return new IEDCExpression[0];
                }
                if (expr.getEvaluatedValue() != null && expr.getEvaluatedValue().intValue() == 0) {
                    return new IEDCExpression[0];
                }
                exprChild = newExpr = new ExpressionDMC((IDMContext)expr.getFrame(), "*" + exprName, "*" + expr.getName());
            }
            return this.doGetLogicalSubExpressions(exprChild, typePointedTo, indirected);
        }
        if (exprType instanceof IReferenceType) {
            IType typePointedTo = TypeUtils.getStrippedType(exprType.getType());
            return this.doGetLogicalSubExpressions(expr, typePointedTo, false);
        }
        return this.doGetLogicalSubExpressions(expr, exprType, false);
    }

    private IEDCExpression[] doGetLogicalSubExpressions(IEDCExpression expr, IType exprType, boolean indirected) {
        ArrayList<IEDCExpression> exprList = new ArrayList<IEDCExpression>();
        String expression = expr.getExpression();
        if (expression.contains("(")) {
            expression = String.valueOf('(') + expression + ')';
        }
        if (exprType instanceof ICompositeType) {
            ExpressionDMC exprChild;
            expression = expression.startsWith("*") ? (expression.startsWith("**") ? "(" + expression.substring(1) + ")->" : String.valueOf(expression.substring(1)) + "->") : String.valueOf(expression) + '.';
            ICompositeType compositeType = (ICompositeType)exprType;
            IType[] iTypeArray = compositeType.getFields();
            int n = iTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IField field = iTypeArray[n2];
                String fieldName = field.getName();
                if (fieldName.length() == 0) {
                    assert (false);
                } else {
                    exprChild = new ExpressionDMC((IDMContext)expr.getFrame(), String.valueOf(expression) + fieldName, fieldName);
                    if (exprChild != null) {
                        exprList.add(exprChild);
                    }
                }
                ++n2;
            }
            iTypeArray = compositeType.getInheritances();
            n = iTypeArray.length;
            n2 = 0;
            while (n2 < n) {
                IType inherited = iTypeArray[n2];
                String inheritedName = inherited.getName();
                if (inheritedName.length() == 0) {
                    assert (false);
                } else if (!inheritedName.contains("<")) {
                    exprChild = new ExpressionDMC((IDMContext)expr.getFrame(), String.valueOf(expression) + inheritedName, inheritedName);
                    if (exprChild != null) {
                        exprList.add(exprChild);
                    }
                } else {
                    IType inheritedType = inherited.getType();
                    if (inheritedType instanceof ICompositeType) {
                        IField[] iFieldArray = ((ICompositeType)inheritedType).getFields();
                        int n3 = iFieldArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IField field = iFieldArray[n4];
                            String fieldName = field.getName();
                            if (fieldName.length() == 0) {
                                assert (false);
                            } else {
                                exprChild = new ExpressionDMC((IDMContext)expr.getFrame(), String.valueOf(expression) + fieldName, fieldName);
                                if (exprChild != null) {
                                    exprList.add(exprChild);
                                }
                            }
                            ++n4;
                        }
                    }
                }
                ++n2;
            }
        } else if (exprType instanceof IArrayType) {
            IArrayType arrayType = (IArrayType)exprType;
            if (arrayType.getBoundsCount() > 0) {
                long lowerBound = expr.getCastInfo() != null && expr.getCastInfo().getArrayCount() > 0 ? expr.getCastInfo().getArrayStartIndex() : 0;
                long upperBound = arrayType.getBound(0).getBoundCount();
                if (upperBound == 0L) {
                    upperBound = 1L;
                }
                int i = 0;
                while ((long)i < upperBound) {
                    String arrayElementName = "[" + ((long)i + lowerBound) + "]";
                    ExpressionDMC newExpr = new ExpressionDMC((IDMContext)expr.getFrame(), String.valueOf(expression) + arrayElementName, String.valueOf(expr.getName()) + arrayElementName);
                    ExpressionDMC exprChild = newExpr;
                    if (exprChild != null) {
                        exprList.add(exprChild);
                    }
                    ++i;
                }
            }
        } else if (exprType instanceof IArrayDimensionType) {
            IArrayDimensionType arrayDimensionType = (IArrayDimensionType)((Object)exprType);
            IArrayType arrayType = arrayDimensionType.getArrayType();
            if (arrayType.getBoundsCount() > arrayDimensionType.getDimensionCount()) {
                long lowerBound = expr.getCastInfo() != null && expr.getCastInfo().getArrayCount() > 0 ? expr.getCastInfo().getArrayStartIndex() : 0;
                long upperBound = arrayType.getBound(arrayDimensionType.getDimensionCount()).getBoundCount();
                int i = 0;
                while ((long)i < upperBound) {
                    String arrayElement = "[" + ((long)i + lowerBound) + "]";
                    ExpressionDMC newExpr = new ExpressionDMC((IDMContext)expr.getFrame(), String.valueOf(expression) + arrayElement, String.valueOf(expr.getName()) + arrayElement);
                    ExpressionDMC exprChild = newExpr;
                    if (exprChild != null) {
                        exprList.add(exprChild);
                    }
                    ++i;
                }
            }
        } else {
            exprList.add(expr);
        }
        return exprList.toArray(new IEDCExpression[exprList.size()]);
    }

    public void writeExpression(final IExpressions.IExpressionDMContext exprContext, final String expressionValue, final String formatId, final RequestMonitor rm) {
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                IEDCExpression expressionDMC = (IEDCExpression)exprContext;
                if (Expressions.this.isComposite(expressionDMC)) {
                    rm.setStatus(EDCDebugger.dsfRequestFailedStatus(EDCServicesMessages.Expressions_CannotModifyCompositeValue, null));
                    rm.done();
                    return;
                }
                IType exprType = TypeUtils.getStrippedType(expressionDMC.getEvaluatedType());
                Number number = NumberFormatUtils.parseIntegerByFormat(expressionValue, formatId);
                if (number == null) {
                    IEDCExpression temp = (IEDCExpression)Expressions.this.createExpression((IDMContext)expressionDMC.getFrame(), expressionValue);
                    temp.evaluateExpression();
                    number = temp.getEvaluatedValue();
                    if (number == null) {
                        rm.setStatus(EDCDebugger.dsfRequestFailedStatus(EDCServicesMessages.Expressions_CannotParseExpression, null));
                        rm.done();
                        return;
                    }
                }
                BigInteger value = null;
                try {
                    value = MemoryUtils.convertValueToMemory(exprType, number);
                }
                catch (CoreException e) {
                    rm.setStatus(e.getStatus());
                    rm.done();
                    return;
                }
                IVariableLocation variableLocation = expressionDMC.getValueLocation();
                if (variableLocation == null) {
                    rm.setStatus(EDCDebugger.dsfRequestFailedStatus(EDCServicesMessages.Expressions_ExpressionNoLocation, null));
                    rm.done();
                    return;
                }
                try {
                    variableLocation.writeValue(exprType.getByteSize(), value);
                    Expressions.this.getSession().dispatchEvent((Object)new ExpressionChangedDMEvent(exprContext), Expressions.this.getProperties());
                }
                catch (CoreException e) {
                    rm.setStatus(e.getStatus());
                }
                rm.done();
            }
        }, rm);
    }

    public void getAvailableFormats(IFormattedValues.IFormattedDataDMContext formattedDataContext, DataRequestMonitor<String[]> rm) {
        rm.setData((Object)new String[]{"NATURAL.Format", "DECIMAL.Format", "HEX.Format", "OCTAL.Format", "BINARY.Format"});
        rm.done();
    }

    public void getFormattedExpressionValue(final IFormattedValues.FormattedValueDMContext formattedDataContext, final DataRequestMonitor<IFormattedValues.FormattedValueDMData> rm) {
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    rm.setData((Object)Expressions.this.getFormattedExpressionValue(formattedDataContext));
                    rm.done();
                }
                catch (CoreException ce) {
                    rm.setStatus(ce.getStatus());
                    rm.done();
                    return;
                }
            }
        }, (RequestMonitor)rm);
    }

    public String getExpressionValueString(IExpressions.IExpressionDMContext expression, String format) throws CoreException {
        IFormattedValues.FormattedValueDMContext formattedDataContext = this.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)expression, format);
        IFormattedValues.FormattedValueDMData formattedValue = this.getFormattedExpressionValue(formattedDataContext);
        return formattedValue != null ? formattedValue.getFormattedValue() : "";
    }

    public IFormattedValues.FormattedValueDMData getFormattedExpressionValue(IFormattedValues.FormattedValueDMContext formattedDataContext) throws CoreException {
        IDMContext idmContext = formattedDataContext.getParents()[0];
        IFormattedValues.FormattedValueDMData formattedValue = null;
        IEDCExpression exprDMC = null;
        if (idmContext instanceof IEDCExpression) {
            IVariableValueConverter customConverter;
            exprDMC = (IEDCExpression)formattedDataContext.getParents()[0];
            exprDMC.evaluateExpression();
            if (exprDMC != null && exprDMC.getEvaluationError() != null) {
                throw new CoreException(exprDMC.getEvaluationError());
            }
            formattedValue = exprDMC.getFormattedValue(formattedDataContext);
            if (formattedDataContext.getFormatID().equals("NATURAL.Format") && (customConverter = this.getCustomValueConverter(exprDMC)) != null) {
                IFormattedValues.FormattedValueDMData customFormattedValue = null;
                try {
                    formattedValue = customFormattedValue = new IFormattedValues.FormattedValueDMData(customConverter.getValue(exprDMC));
                }
                catch (Throwable t) {
                    EDCDebugger.getMessageLogger().logError(String.valueOf(EDCServicesMessages.Expressions_ErrorInVariableFormatter) + customConverter.getClass().getName(), t);
                }
            }
        } else {
            formattedValue = new IFormattedValues.FormattedValueDMData("");
        }
        return formattedValue;
    }

    private IVariableValueConverter getCustomValueConverter(IEDCExpression exprDMC) {
        IType exprType = TypeUtils.getUnRefStrippedType(exprDMC.getEvaluatedType());
        return FormatExtensionManager.instance().getVariableValueConverter(exprType);
    }

    public IFormattedValues.FormattedValueDMContext getFormattedValueContext(IFormattedValues.IFormattedDataDMContext formattedDataContext, String formatId) {
        return new IFormattedValues.FormattedValueDMContext((IDsfService)this, (IDMContext)formattedDataContext, formatId);
    }

    public void getModelData(IDMContext context, DataRequestMonitor<?> rm) {
    }

    public String getExpressionValue(IExpressions.IExpressionDMContext expression) {
        final StringBuffer holder = new StringBuffer();
        IFormattedValues.FormattedValueDMContext formattedValueContext = this.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)expression, "NATURAL.Format");
        this.getFormattedExpressionValue(formattedValueContext, new DataRequestMonitor<IFormattedValues.FormattedValueDMData>(ImmediateExecutor.getInstance(), null){

            protected void handleSuccess() {
                holder.append(((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue());
            }

            protected void handleFailure() {
            }
        });
        return holder.toString();
    }

    public void loadExpressionValues(IExpressions.IExpressionDMContext expression, int depth) {
        this.loadExpressionValues(expression, new Integer[]{depth});
    }

    private void loadExpressionValues(IExpressions.IExpressionDMContext expression, final Integer[] depth) {
        this.getExpressionValue(expression);
        if (depth[0] > 0) {
            this.getSubExpressions(expression, new DataRequestMonitor<IExpressions.IExpressionDMContext[]>(ImmediateExecutor.getInstance(), null){

                protected void handleSuccess() {
                    IExpressions.IExpressionDMContext[] subExpressions;
                    depth[0] = depth[0] - 1;
                    IExpressions.IExpressionDMContext[] iExpressionDMContextArray = subExpressions = (IExpressions.IExpressionDMContext[])this.getData();
                    int n = subExpressions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IExpressions.IExpressionDMContext iExpressionDMContext = iExpressionDMContextArray[n2];
                        Expressions.this.loadExpressionValues(iExpressionDMContext, depth);
                        ++n2;
                    }
                }
            });
        }
    }

    public abstract class BaseEDCExpressionDMC
    extends DMContext
    implements IEDCExpression {
        protected String expression;
        private InstructionSequence parsedExpression;
        private final ASTEvaluationEngine engine;
        private final Stack.StackFrameDMC frame;
        protected Number value;
        protected IStatus valueError;
        private IVariableLocation valueLocation;
        private IType valueType;
        private boolean hasChildren;
        private String valueString;

        public BaseEDCExpressionDMC(IDMContext parent, String expression, String name) {
            super((IDsfService)Expressions.this, new IDMContext[]{parent}, name, String.valueOf(((IEDCDMContext)parent).getID()) + "." + name);
            this.hasChildren = false;
            this.expression = expression;
            this.frame = (Stack.StackFrameDMC)DMContexts.getAncestorOfType((IDMContext)parent, Stack.StackFrameDMC.class);
            this.engine = new ASTEvaluationEngine(Expressions.this.getEDCServicesTracker(), (IDMContext)this.frame, this.frame.getTypeEngine());
        }

        public BaseEDCExpressionDMC(IDMContext parent, String expression) {
            this(parent, expression, expression);
        }

        @Override
        public String toString() {
            return this.getExpression();
        }

        @Override
        public IStack.IFrameDMContext getFrame() {
            return this.frame;
        }

        public String getExpression() {
            return this.expression;
        }

        @Override
        public synchronized void evaluateExpression() {
            Interpreter interpreter;
            if (this.value != null || this.valueError != null) {
                return;
            }
            String expression = this.getExpression();
            if (this.parsedExpression == null) {
                try {
                    this.parsedExpression = this.engine.getCompiledExpression(expression);
                }
                catch (CoreException e) {
                    this.value = null;
                    this.valueError = e.getStatus();
                    this.valueLocation = null;
                    this.valueType = null;
                    return;
                }
            }
            if (this.parsedExpression.getInstructions().length == 0) {
                this.value = null;
                this.valueError = new Status(4, "org.eclipse.cdt.debug.edc", EDCServicesMessages.Expressions_SyntaxError);
                this.valueLocation = null;
                this.valueType = null;
                return;
            }
            try {
                interpreter = this.engine.evaluateCompiledExpression(this.parsedExpression);
            }
            catch (CoreException e) {
                this.value = null;
                this.valueError = e.getStatus();
                this.valueLocation = null;
                this.valueType = null;
                return;
            }
            OperandValue variableValue = interpreter.getResult();
            if (variableValue == null) {
                this.value = null;
                this.valueError = null;
                this.valueLocation = null;
                this.valueType = null;
                return;
            }
            this.valueLocation = variableValue.getValueLocation();
            this.valueType = variableValue.getValueType();
            try {
                this.value = variableValue.getValue();
                this.valueString = variableValue.getStringValue();
            }
            catch (CoreException e1) {
                this.value = null;
                this.valueError = e1.getStatus();
                return;
            }
            if (this.valueType instanceof IAggregate && this.valueLocation != null) {
                try {
                    this.value = variableValue.getValueLocationAddress();
                }
                catch (CoreException e) {
                    this.value = null;
                    this.valueError = e.getStatus();
                }
                if (!(this.value instanceof IInvalidVariableLocation)) {
                    this.hasChildren = true;
                }
            }
            if (this.valueLocation instanceof IInvalidVariableLocation) {
                this.value = null;
                this.valueError = new Status(4, "org.eclipse.cdt.debug.edc", ((IInvalidVariableLocation)this.valueLocation).getMessage());
                this.valueLocation = null;
                return;
            }
        }

        @Override
        public IFormattedValues.FormattedValueDMData getFormattedValue(IFormattedValues.FormattedValueDMContext dmc) {
            if (EDCTrace.VARIABLE_VALUE_TRACE_ON) {
                EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(dmc));
            }
            this.evaluateExpression();
            String result = "";
            if (this.valueError != null) {
                result = this.valueError.getMessage();
            } else if (this.value != null) {
                result = this.value.toString();
                IType unqualifiedType = TypeUtils.getUnRefStrippedType(this.valueType);
                String temp = null;
                String formatID = dmc.getFormatID();
                if (formatID.equals("HEX.Format")) {
                    temp = NumberFormatUtils.toHexString(this.value);
                } else if (formatID.equals("OCTAL.Format")) {
                    temp = NumberFormatUtils.toOctalString(this.value);
                } else if (formatID.equals("BINARY.Format")) {
                    temp = NumberFormatUtils.asBinary(this.value);
                } else if (formatID.equals("NATURAL.Format")) {
                    long enumeratorValue;
                    IEnumerator enumerator;
                    if (unqualifiedType instanceof ICPPBasicType) {
                        ICPPBasicType basicType = (ICPPBasicType)unqualifiedType;
                        switch (basicType.getBaseType()) {
                            case 2: {
                                temp = NumberFormatUtils.toCharString(this.value, this.valueType);
                                break;
                            }
                            case 7: {
                                temp = NumberFormatUtils.toCharString(this.value, this.valueType);
                                break;
                            }
                            case 6: {
                                temp = Boolean.toString(this.value.longValue() != 0L);
                                break;
                            }
                            default: {
                                if (basicType.getName().equals("wchar_t")) {
                                    temp = NumberFormatUtils.toCharString(this.value, this.valueType);
                                    break;
                                } else {
                                    break;
                                }
                            }
                        }
                    } else if (unqualifiedType instanceof IAggregate || unqualifiedType instanceof IPointerType) {
                        temp = NumberFormatUtils.toHexString(this.value);
                    }
                    if (unqualifiedType instanceof IEnumeration && (enumerator = ((IEnumeration)unqualifiedType).getEnumeratorByValue(enumeratorValue = this.value.longValue())) != null) {
                        if (temp == null) {
                            temp = result;
                        }
                        temp = String.valueOf(enumerator.getName()) + " [" + temp + "]";
                    }
                }
                if (temp != null) {
                    result = temp;
                }
            }
            if (EDCTrace.VARIABLE_VALUE_TRACE_ON) {
                EDCTrace.getTrace().traceExit(null, (Object)EDCTrace.fixArg(result));
            }
            return new IFormattedValues.FormattedValueDMData(result);
        }

        @Override
        public IVariableLocation getValueLocation() {
            this.evaluateExpression();
            return this.getEvaluatedLocation();
        }

        @Override
        public IStatus getEvaluationError() {
            return this.valueError;
        }

        @Override
        public Number getEvaluatedValue() {
            return this.value;
        }

        @Override
        public String getEvaluatedValueString() {
            if (this.valueError != null) {
                return this.valueError.getMessage();
            }
            if (this.valueString != null) {
                return this.valueString;
            }
            this.valueString = this.value != null ? this.value.toString() : "";
            return this.valueString;
        }

        @Override
        public void setEvaluatedValueString(String string) {
            this.valueString = string;
        }

        @Override
        public void setEvaluatedValue(Number value) {
            this.value = value;
        }

        @Override
        public IVariableLocation getEvaluatedLocation() {
            return this.valueLocation;
        }

        @Override
        public IType getEvaluatedType() {
            return this.valueType;
        }

        @Override
        public String getTypeName() {
            this.evaluateExpression();
            if (this.valueType == null) {
                if (this.valueError != null) {
                    return "";
                }
                return "<UNKNOWN>";
            }
            return this.engine.getTypeEngine().getTypeName(this.valueType);
        }

        @Override
        public boolean hasChildren() {
            return this.hasChildren;
        }

        @Override
        public Expressions getExpressionsService() {
            return Expressions.this;
        }

        @Override
        public Executor getExecutor() {
            return Expressions.this.getSession().getExecutor();
        }
    }

    class CastInfoCachedData {
        private IExpressions2.CastInfo info;
        private IType type;
        private IStatus error;
        private Stack.StackFrameDMC frameDmc;

        public CastInfoCachedData(ExpressionDMC exprDMC, IExpressions2.CastInfo info) {
            this.info = info;
            this.frameDmc = (Stack.StackFrameDMC)DMContexts.getAncestorOfType((IDMContext)exprDMC, Stack.StackFrameDMC.class);
        }

        public String getTypeString() {
            return this.info.getTypeString();
        }

        public int getArrayStartIndex() {
            return this.info.getArrayStartIndex();
        }

        public int getArrayCount() {
            return this.info.getArrayCount();
        }

        public IType getType() {
            if (this.info.getTypeString() == null) {
                return null;
            }
            if (this.type == null && this.error == null) {
                if (this.frameDmc != null) {
                    ASTEvaluationEngine engine = new ASTEvaluationEngine(Expressions.this.getEDCServicesTracker(), (IDMContext)this.frameDmc, this.frameDmc.getTypeEngine());
                    try {
                        IASTTypeId typeId = engine.getCompiledType(this.info.getTypeString());
                        this.type = engine.getTypeEngine().getTypeForTypeId(typeId);
                    }
                    catch (CoreException e) {
                        this.error = e.getStatus();
                    }
                } else {
                    this.error = EDCDebugger.dsfRequestFailedStatus(EDCServicesMessages.Expressions_CannotCastOutsideFrame, null);
                }
            }
            return this.type;
        }

        public IStatus getError() {
            if (this.type == null && this.error == null) {
                this.getType();
            }
            return this.error;
        }
    }

    private class CastedExpressionDMC
    extends BaseEDCExpressionDMC
    implements IExpressions2.ICastedExpressionDMContext {
        private final IExpressions2.CastInfo castInfo;
        private IType castType;
        private IStatus castError;

        public CastedExpressionDMC(IEDCExpression exprDMC, String expression, String name, IExpressions2.CastInfo castInfo) {
            super((IDMContext)exprDMC, name);
            this.castType = null;
            this.castInfo = castInfo;
            String castType = castInfo.getTypeString();
            String castExpression = expression;
            if (castType != null) {
                if (castInfo.getArrayCount() > 0) {
                    castType = String.valueOf(castType) + "[]";
                    exprDMC.evaluateExpression();
                    IType exprType = TypeUtils.getStrippedType(exprDMC.getEvaluatedType());
                    if (exprType != null && !(exprType instanceof IPointerType) && !(exprType instanceof IArrayType)) {
                        expression = "&" + expression;
                    }
                }
                castExpression = "reinterpret_cast<" + castType + ">(" + expression + ")";
            } else if (castInfo.getArrayCount() > 0) {
                exprDMC.evaluateExpression();
                IType exprType = TypeUtils.getStrippedType(exprDMC.getEvaluatedType());
                if (exprType != null && !(exprType instanceof IPointerType) && !(exprType instanceof IArrayType)) {
                    castExpression = "(" + exprDMC.getTypeName() + "[])&" + expression;
                }
            }
            this.expression = castExpression;
        }

        @Override
        public void evaluateExpression() {
            if (this.castError != null) {
                return;
            }
            super.evaluateExpression();
        }

        @Override
        public IType getEvaluatedType() {
            if (this.castType != null) {
                return this.castType;
            }
            return super.getEvaluatedType();
        }

        @Override
        public IExpressions2.CastInfo getCastInfo() {
            return this.castInfo;
        }
    }

    @Immutable
    private static class ExpressionChangedDMEvent
    extends AbstractDMEvent<IExpressions.IExpressionDMContext>
    implements IExpressions.IExpressionChangedDMEvent {
        ExpressionChangedDMEvent(IExpressions.IExpressionDMContext expression) {
            super((IDMContext)expression);
        }
    }

    public class ExpressionDMAddress
    implements IExpressions.IExpressionDMLocation {
        private final IVariableLocation valueLocation;

        public ExpressionDMAddress(IExpressions.IExpressionDMContext exprContext) {
            this.valueLocation = exprContext instanceof IEDCExpression ? ((IEDCExpression)exprContext).getValueLocation() : null;
        }

        public IAddress getAddress() {
            IAddress address;
            if (this.valueLocation != null && (address = this.valueLocation.getAddress()) != null) {
                return address;
            }
            return new Addr64(BigInteger.ZERO);
        }

        public int getSize() {
            return 4;
        }

        public String getLocation() {
            if (this.valueLocation instanceof IInvalidVariableLocation) {
                return ((IInvalidVariableLocation)this.valueLocation).getMessage();
            }
            if (this.valueLocation == null) {
                return "";
            }
            return this.valueLocation.getLocationName();
        }
    }

    private class ExpressionDMC
    extends BaseEDCExpressionDMC {
        public ExpressionDMC(IDMContext parent, String expression) {
            super(parent, expression);
        }

        public ExpressionDMC(IDMContext parent, String expression, String name) {
            super(parent, expression, name);
        }

        @Override
        public IExpressions2.CastInfo getCastInfo() {
            return null;
        }
    }

    public class ExpressionData
    implements IExpressions.IExpressionDMData {
        private final IEDCExpression dmc;
        private String typeName = "";

        public ExpressionData(IEDCExpression dmc) {
            this.dmc = dmc;
            if (dmc != null) {
                this.typeName = dmc.getTypeName();
            }
        }

        public IExpressions.IExpressionDMData.BasicType getBasicType() {
            IExpressions.IExpressionDMData.BasicType basicType = IExpressions.IExpressionDMData.BasicType.unknown;
            if (this.dmc == null) {
                return basicType;
            }
            IType type = this.dmc.getEvaluatedType();
            if ((type = TypeUtils.getStrippedType(type)) instanceof IArrayType) {
                basicType = IExpressions.IExpressionDMData.BasicType.array;
            } else if (type instanceof IBasicType) {
                basicType = IExpressions.IExpressionDMData.BasicType.basic;
            } else if (type instanceof ICompositeType) {
                basicType = IExpressions.IExpressionDMData.BasicType.composite;
            } else if (type instanceof IEnumeration) {
                basicType = IExpressions.IExpressionDMData.BasicType.enumeration;
            } else if (type instanceof IPointerType) {
                basicType = IExpressions.IExpressionDMData.BasicType.pointer;
            } else if (type instanceof ISubroutineType) {
                basicType = IExpressions.IExpressionDMData.BasicType.function;
            }
            return basicType;
        }

        public String getEncoding() {
            return null;
        }

        public Map<String, Integer> getEnumerations() {
            return null;
        }

        public String getName() {
            if (this.dmc != null) {
                return this.dmc.getName();
            }
            return "";
        }

        public IRegisters.IRegisterDMContext getRegister() {
            return null;
        }

        public String getTypeId() {
            return "TYPEID_INTEGER";
        }

        public String getTypeName() {
            return this.typeName;
        }
    }

    protected static class InvalidContextExpressionDMC
    extends AbstractDMContext
    implements IExpressions.IExpressionDMContext {
        private final String expression;

        public InvalidContextExpressionDMC(String sessionId, String expr, IDMContext parent) {
            super(sessionId, new IDMContext[]{parent});
            this.expression = expr;
        }

        public boolean equals(Object other) {
            return super.baseEquals(other) && this.expression == null ? ((InvalidContextExpressionDMC)((Object)other)).getExpression() == null : this.expression.equals(((InvalidContextExpressionDMC)((Object)other)).getExpression());
        }

        public int hashCode() {
            return this.expression == null ? super.baseHashCode() : super.baseHashCode() ^ this.expression.hashCode();
        }

        public String toString() {
            return String.valueOf(this.baseToString()) + ".invalid_expr[" + this.expression + "]";
        }

        public String getExpression() {
            return this.expression;
        }
    }
}

