/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.services.dsf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.cdt.debug.edc.internal.services.dsf.Modules;
import org.eclipse.cdt.debug.edc.symbols.ILineEntry;
import org.eclipse.cdt.debug.edc.symbols.ILineEntryProvider;
import org.eclipse.cdt.debug.edc.symbols.IModuleLineEntryProvider;
import org.eclipse.cdt.dsf.debug.service.IModules;
import org.eclipse.core.runtime.IPath;

public class LineEntryMapper {
    private static final int toEOF = -1;

    public static Collection<IModules.AddressRange> getAddressRangesAtSource(IModuleLineEntryProvider moduleLineEntryProvider, IPath sourceFile, int line) {
        Collection<IModules.AddressRange> range = LineEntryMapper.getAddressRangesAtSource(moduleLineEntryProvider, sourceFile, line, line);
        if (range != null && range.isEmpty()) {
            range = LineEntryMapper.getAddressRangesAtSource(moduleLineEntryProvider, sourceFile, line, -1);
        }
        return range;
    }

    private static Collection<IModules.AddressRange> getAddressRangesAtSource(IModuleLineEntryProvider moduleLineEntryProvider, IPath sourceFile, int startLine, int endLine) {
        Collection<ILineEntryProvider> fileProviders = moduleLineEntryProvider.getLineEntryProvidersForFile(sourceFile);
        if (fileProviders.isEmpty()) {
            return null;
        }
        int lastColumn = -1;
        IPath lastFile = null;
        int bestLine = endLine;
        ArrayList<Modules.EDCAddressRange> addrRanges = null;
        block0: for (ILineEntryProvider fileProvider : fileProviders) {
            Collection<ILineEntry> entries = fileProvider.getLineEntriesForLines(sourceFile, startLine, endLine);
            if (addrRanges == null && !entries.isEmpty()) {
                addrRanges = new ArrayList<Modules.EDCAddressRange>();
            }
            for (ILineEntry entry : entries) {
                int entryLine = entry.getLineNumber();
                if (entryLine < bestLine && addrRanges != null) {
                    addrRanges.clear();
                    bestLine = entryLine;
                } else if (bestLine == -1) {
                    bestLine = entryLine;
                } else if (entryLine > bestLine) continue block0;
                IPath entryPath = entry.getFilePath();
                int entryColumn = entry.getColumnNumber();
                if (addrRanges != null) {
                    if (addrRanges.isEmpty() || !entryPath.equals((Object)lastFile) || lastColumn == entryColumn) {
                        addrRanges.add(new Modules.EDCAddressRange(entry.getLowAddress(), entry.getHighAddress()));
                    } else {
                        Modules.EDCAddressRange range = (Modules.EDCAddressRange)addrRanges.remove(addrRanges.size() - 1);
                        range.setEndAddress(entry.getHighAddress());
                        addrRanges.add(range);
                    }
                }
                lastColumn = entryColumn;
                lastFile = entryPath;
            }
        }
        if (addrRanges == null) {
            return Collections.emptyList();
        }
        ArrayList<Modules.EDCAddressRange> returnRanges = addrRanges;
        return Collections.unmodifiableCollection(returnRanges);
    }
}

