/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.services.dsf;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.edc.IAddressExpressionEvaluator;
import org.eclipse.cdt.debug.edc.IJumpToAddress;
import org.eclipse.cdt.debug.edc.disassembler.IDisassembledInstruction;
import org.eclipse.cdt.debug.edc.disassembler.IDisassembler;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.EDCTrace;
import org.eclipse.cdt.debug.edc.internal.formatter.FormatExtensionManager;
import org.eclipse.cdt.debug.edc.internal.services.dsf.Breakpoints;
import org.eclipse.cdt.debug.edc.internal.services.dsf.Expressions;
import org.eclipse.cdt.debug.edc.internal.services.dsf.Memory;
import org.eclipse.cdt.debug.edc.internal.services.dsf.Modules;
import org.eclipse.cdt.debug.edc.internal.services.dsf.Symbols;
import org.eclipse.cdt.debug.edc.internal.snapshot.Album;
import org.eclipse.cdt.debug.edc.internal.snapshot.SnapshotUtils;
import org.eclipse.cdt.debug.edc.services.AbstractEDCService;
import org.eclipse.cdt.debug.edc.services.DMContext;
import org.eclipse.cdt.debug.edc.services.Disassembly;
import org.eclipse.cdt.debug.edc.services.IDSFServiceUsingTCF;
import org.eclipse.cdt.debug.edc.services.IEDCExecutionDMC;
import org.eclipse.cdt.debug.edc.services.IEDCModuleDMContext;
import org.eclipse.cdt.debug.edc.services.IEDCModules;
import org.eclipse.cdt.debug.edc.services.IEDCSymbols;
import org.eclipse.cdt.debug.edc.services.ITargetEnvironment;
import org.eclipse.cdt.debug.edc.services.Registers;
import org.eclipse.cdt.debug.edc.services.Stack;
import org.eclipse.cdt.debug.edc.snapshot.IAlbum;
import org.eclipse.cdt.debug.edc.snapshot.ISnapshotContributor;
import org.eclipse.cdt.debug.edc.symbols.IEDCSymbolReader;
import org.eclipse.cdt.debug.edc.symbols.IFunctionScope;
import org.eclipse.cdt.debug.edc.symbols.ILineEntry;
import org.eclipse.cdt.debug.edc.symbols.IModuleLineEntryProvider;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Immutable;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.AbstractDMEvent;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IBreakpoints;
import org.eclipse.cdt.dsf.debug.service.ICachingService;
import org.eclipse.cdt.dsf.debug.service.IDisassembly;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.cdt.dsf.debug.service.IMemory;
import org.eclipse.cdt.dsf.debug.service.IModules;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.IRegisters;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.IRunControl2;
import org.eclipse.cdt.dsf.debug.service.ISourceLookup;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.utils.Addr64;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.tm.tcf.protocol.IService;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.protocol.Protocol;
import org.eclipse.tm.tcf.services.IRunControl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RunControl
extends AbstractEDCService
implements IRunControl2,
ICachingService,
ISnapshotContributor,
IDSFServiceUsingTCF {
    public static final String EXECUTION_CONTEXT = "execution_context";
    public static final String EXECUTION_CONTEXT_REGISTERS = "execution_context_registers";
    public static final String EXECUTION_CONTEXT_MODULES = "execution_context_modules";
    public static final String EXECUTION_CONTEXT_FRAMES = "execution_context_frames";
    public static final String PROP_PARENT_ID = "ParentID";
    public static final String PROP_IS_CONTAINER = "IsContainer";
    public static final String PROP_HAS_STATE = "HasState";
    public static final String PROP_CAN_RESUME = "CanResume";
    public static final String PROP_CAN_COUNT = "CanCount";
    public static final String PROP_CAN_SUSPEND = "CanSuspend";
    public static final String PROP_CAN_TERMINATE = "CanTerminate";
    public static final String PROP_IS_SUSPENDED = "State";
    public static final String PROP_MESSAGE = "Message";
    public static final String PROP_SUSPEND_PC = "SuspendPC";
    public static final String PROP_DISABLE_STEPPING = "DisableStepping";
    private static final int RESUME_NOTIFICATION_DELAY = 1000;
    private static final String EXECUTION_CONTEXTS = "execution_contexts";
    private org.eclipse.tm.tcf.services.IRunControl tcfRunService;
    private RootExecutionDMC rootExecutionDMC;
    private final Map<String, ExecutionDMC> dmcsByID = new HashMap<String, ExecutionDMC>();
    private static long steppingStartTime = 0L;
    private final IRunControl.RunControlListener runListener = new IRunControl.RunControlListener(){

        public void containerResumed(String[] context_ids) {
        }

        public void containerSuspended(String context, String pc, String reason, Map<String, Object> params, String[] suspended_ids) {
        }

        public void contextAdded(final IRunControl.RunControlContext[] contexts) {
            RunControl.this.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    IRunControl.RunControlContext[] runControlContextArray = contexts;
                    int n = contexts.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IRunControl.RunControlContext ctx = runControlContextArray[n2];
                        ExecutionDMC dmc = RunControl.this.rootExecutionDMC;
                        String parentID = ctx.getParentID();
                        if (parentID != null) {
                            dmc = (ExecutionDMC)RunControl.this.dmcsByID.get(parentID);
                        }
                        if (dmc != null) {
                            ((ExecutionDMC)dmc).contextAdded(ctx.getProperties(), ctx);
                        }
                        ++n2;
                    }
                }
            });
        }

        public void contextChanged(IRunControl.RunControlContext[] contexts) {
        }

        public void contextException(final String context, final String msg) {
            RunControl.this.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    ExecutionDMC dmc = RunControl.this.getContext(context);
                    if (dmc != null) {
                        dmc.contextException(msg);
                    }
                }
            });
        }

        public void contextRemoved(final String[] context_ids) {
            RunControl.this.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    String[] stringArray = context_ids;
                    int n = context_ids.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String contextID = stringArray[n2];
                        ExecutionDMC dmc = RunControl.this.getContext(contextID);
                        if (!$assertionsDisabled && dmc == null) {
                            throw new AssertionError();
                        }
                        if (dmc != null) {
                            dmc.purgeFromDebugger();
                        }
                        ++n2;
                    }
                }
            });
        }

        public void contextResumed(final String context) {
            RunControl.this.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    ExecutionDMC dmc = RunControl.this.getContext(context);
                    if (dmc != null) {
                        dmc.contextResumed(false);
                    }
                }
            });
        }

        public void contextSuspended(final String context, final String pc, final String reason, final Map<String, Object> params) {
            RunControl.this.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    ExecutionDMC dmc = RunControl.this.getContext(context);
                    if (dmc != null) {
                        dmc.contextSuspended(pc, reason, params);
                    } else {
                        EDCDebugger.getMessageLogger().logError(MessageFormat.format("Unkown context [{0}] is reported in suspended event. Make sure TCF agent has reported contextAdded event first.", context), null);
                    }
                }
            });
        }
    };

    private static IRunControl.StateChangeReason toDsfStateChangeReason(String tcfReason) {
        if (tcfReason == null) {
            return IRunControl.StateChangeReason.UNKNOWN;
        }
        if (tcfReason.equals("Suspended")) {
            return IRunControl.StateChangeReason.USER_REQUEST;
        }
        if (tcfReason.equals("Step")) {
            return IRunControl.StateChangeReason.STEP;
        }
        if (tcfReason.equals("Breakpoint")) {
            return IRunControl.StateChangeReason.BREAKPOINT;
        }
        if (tcfReason.equals("Exception")) {
            return IRunControl.StateChangeReason.EXCEPTION;
        }
        if (tcfReason.equals("Container")) {
            return IRunControl.StateChangeReason.CONTAINER;
        }
        if (tcfReason.equals("Watchpoint")) {
            return IRunControl.StateChangeReason.WATCHPOINT;
        }
        if (tcfReason.equals("Signal")) {
            return IRunControl.StateChangeReason.SIGNAL;
        }
        if (tcfReason.equals("Shared Library")) {
            return IRunControl.StateChangeReason.SHAREDLIB;
        }
        if (tcfReason.equals("Error")) {
            return IRunControl.StateChangeReason.ERROR;
        }
        return IRunControl.StateChangeReason.UNKNOWN;
    }

    public RunControl(DsfSession session) {
        super(session, new String[]{IRunControl.class.getName(), IRunControl2.class.getName(), RunControl.class.getName(), ISnapshotContributor.class.getName()});
        this.initializeRootExecutionDMC();
    }

    private void initializeRootExecutionDMC() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("ID", "root");
        this.rootExecutionDMC = new RootExecutionDMC(props);
    }

    public void canResume(IRunControl.IExecutionDMContext context, DataRequestMonitor<Boolean> rm) {
        rm.setData((Object)(((ExecutionDMC)context).isSuspended() ? Boolean.TRUE : Boolean.FALSE));
        rm.done();
    }

    public void canStep(IRunControl.IExecutionDMContext context, IRunControl.StepType stepType, DataRequestMonitor<Boolean> rm) {
        rm.setData((Object)(((ExecutionDMC)context).canStep() ? Boolean.TRUE : Boolean.FALSE));
        rm.done();
    }

    public void canSuspend(IRunControl.IExecutionDMContext context, DataRequestMonitor<Boolean> rm) {
        if (this.isSnapshot()) {
            rm.setData((Object)Album.getAlbumBySession(this.getSession().getId()).isPlayingSnapshots());
        } else {
            rm.setData((Object)(((ExecutionDMC)context).isSuspended() ? Boolean.FALSE : Boolean.TRUE));
        }
        rm.done();
    }

    public void getExecutionContexts(IRunControl.IContainerDMContext c, DataRequestMonitor<IRunControl.IExecutionDMContext[]> rm) {
        if (c instanceof ProcessExecutionDMC) {
            ProcessExecutionDMC edmc = (ProcessExecutionDMC)c;
            ExecutionDMC[] threads = edmc.getChildren();
            IRunControl.IExecutionDMContext[] threadArray = new IRunControl.IExecutionDMContext[threads.length];
            System.arraycopy(threads, 0, threadArray, 0, threads.length);
            rm.setData((Object)threadArray);
        }
        rm.done();
    }

    public void getExecutionData(IRunControl.IExecutionDMContext dmc, DataRequestMonitor<IRunControl.IExecutionDMData> rm) {
        if (dmc instanceof ExecutionDMC) {
            ExecutionDMC exedmc = (ExecutionDMC)dmc;
            if (exedmc.isSuspended()) {
                rm.setData((Object)new ExecutionData(exedmc.getStateChangeReason(), exedmc.getStateChangeDetails()));
            } else {
                rm.setData((Object)new ExecutionData(IRunControl.StateChangeReason.UNKNOWN, null));
            }
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10002, "Given context: " + dmc + " is not a recognized execution context.", null));
        }
        rm.done();
    }

    public boolean isStepping(IRunControl.IExecutionDMContext context) {
        if (context instanceof ExecutionDMC) {
            ExecutionDMC exedmc = (ExecutionDMC)context;
            return exedmc.isStepping();
        }
        return false;
    }

    public boolean isSuspended(IRunControl.IExecutionDMContext context) {
        if (context instanceof ExecutionDMC) {
            ExecutionDMC exedmc = (ExecutionDMC)context;
            return exedmc.isSuspended();
        }
        return false;
    }

    protected void preprocessOnSuspend(final ExecutionDMC dmc, final String pc, final DataRequestMonitor<Boolean> drm) {
        assert (this.getExecutor().isInExecutorThread());
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    Breakpoints.BreakpointDMData bp;
                    Breakpoints bpService = RunControl.this.getService(Breakpoints.class);
                    Registers regService = RunControl.this.getService(Registers.class);
                    String pcString = pc;
                    if (pc == null) {
                        pcString = regService.getRegisterValue((IRunControl.IExecutionDMContext)dmc, RunControl.this.getTargetEnvironmentService().getPCRegisterID());
                    }
                    dmc.setPC(pcString);
                    if (dmc.getStateChangeReason() != IRunControl.StateChangeReason.BREAKPOINT) {
                        drm.setData((Object)true);
                        drm.done();
                        return;
                    }
                    if (!bpService.usesTCFBreakpointService()) {
                        long pcValue = Long.valueOf(pcString, 16);
                        pcString = Long.toHexString(pcValue -= (long)RunControl.this.getTargetEnvironmentService().getBreakpointInstruction((IDMContext)dmc, (IAddress)new Addr64(pcString, 16)).length);
                        if (bpService.findBreakpoint((IAddress)new Addr64(pcString, 16)) != null) {
                            regService.writeRegister(dmc, RunControl.this.getTargetEnvironmentService().getPCRegisterID(), pcString);
                            dmc.setPC(pcString);
                        }
                    }
                    if ((bp = bpService.findUserBreakpoint((IAddress)new Addr64(pcString, 16))) != null) {
                        bpService.evaluateBreakpointCondition(dmc, bp, (DataRequestMonitor<Boolean>)drm);
                    } else {
                        drm.setData((Object)true);
                        drm.done();
                    }
                }
                catch (CoreException e) {
                    Status s = new Status(4, EDCDebugger.getUniqueIdentifier(), null, (Throwable)e);
                    EDCDebugger.getMessageLogger().log((IStatus)s);
                    drm.setStatus((IStatus)s);
                    drm.done();
                }
                if (EDCTrace.RUN_CONTROL_TRACE_ON) {
                    EDCTrace.getTrace().traceExit(null, (Object)EDCTrace.fixArg(drm.getData()));
                }
            }
        }, (RequestMonitor)drm);
    }

    public void resume(IRunControl.IExecutionDMContext context, final RequestMonitor rm) {
        if (EDCTrace.RUN_CONTROL_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(MessageFormat.format("resume context {0}", context)));
        }
        if (!(context instanceof ExecutionDMC)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10002, MessageFormat.format("The context [{0}] is not a recognized execution context.", context), null));
            rm.done();
        }
        final ExecutionDMC dmc = (ExecutionDMC)context;
        this.prepareToRun(dmc, new DataRequestMonitor<Boolean>((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                dmc.resume(rm);
                if (EDCTrace.RUN_CONTROL_TRACE_ON) {
                    EDCTrace.getTrace().traceExit(null, (Object)EDCTrace.fixArg(MessageFormat.format("resume() done on context {0}", dmc)));
                }
            }
        });
    }

    private void prepareToRun(final ExecutionDMC dmc, DataRequestMonitor<Boolean> drm) {
        Breakpoints bpService = this.getService(Breakpoints.class);
        if (bpService.usesTCFBreakpointService()) {
            drm.setData((Object)false);
            drm.done();
            return;
        }
        String latestPC = dmc.getPC();
        if (latestPC != null) {
            Breakpoints.BreakpointDMData bp = bpService.findUserBreakpoint((IAddress)new Addr64(latestPC, 16));
            if (bp != null) {
                bpService.disableBreakpoint(bp, new RequestMonitor((Executor)this.getExecutor(), (RequestMonitor)drm, (DataRequestMonitor)drm, bpService, bp){
                    private final /* synthetic */ DataRequestMonitor val$drm;
                    private final /* synthetic */ Breakpoints val$bpService;
                    private final /* synthetic */ Breakpoints.BreakpointDMData val$bp;
                    {
                        this.val$drm = dataRequestMonitor;
                        this.val$bpService = breakpoints;
                        this.val$bp = breakpointDMData;
                        super($anonymous0, $anonymous1);
                    }

                    protected void handleSuccess() {
                        dmc.setSuspendEventsEnabled(false);
                        dmc.singleStep(true, new RequestMonitor((Executor)RunControl.this.getExecutor(), (RequestMonitor)this.val$drm){

                            protected void handleCompleted() {
                                dmc.setSuspendEventsEnabled(true);
                                super.handleCompleted();
                            }

                            protected void handleSuccess() {
                                val$drm.setData((Object)true);
                                val$bpService.enableBreakpoint(val$bp, (RequestMonitor)val$drm);
                            }
                        });
                    }
                });
            } else {
                drm.setData((Object)false);
                drm.done();
            }
        } else {
            drm.setData((Object)false);
            drm.done();
        }
    }

    public static boolean timeStepping() {
        return false;
    }

    public static long getSteppingStartTime() {
        return steppingStartTime;
    }

    public void step(final IRunControl.IExecutionDMContext context, final IRunControl.StepType outerStepType, final RequestMonitor rm) {
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                IRunControl.StepType stepType = outerStepType;
                if (EDCTrace.RUN_CONTROL_TRACE_ON) {
                    EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(MessageFormat.format("{0} context {1}", stepType, context)));
                }
                if (!(context instanceof ExecutionDMC)) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10002, MessageFormat.format("The context [{0}] is not a recognized execution context.", context), null));
                    rm.done();
                }
                if (RunControl.timeStepping()) {
                    steppingStartTime = System.currentTimeMillis();
                }
                ExecutionDMC dmc = (ExecutionDMC)context;
                dmc.setStepping(true);
                Addr64 pcAddress = null;
                if (dmc.getPC() == null) {
                    stepType = IRunControl.StepType.INSTRUCTION_STEP_INTO;
                } else {
                    pcAddress = new Addr64(dmc.getPC(), 16);
                }
                if (stepType == IRunControl.StepType.STEP_RETURN) {
                    stepType = IRunControl.StepType.INSTRUCTION_STEP_RETURN;
                }
                if (stepType == IRunControl.StepType.STEP_OVER || stepType == IRunControl.StepType.STEP_INTO) {
                    IModules.ISymbolDMContext symCtx;
                    IEDCModules moduleService = RunControl.this.getService(Modules.class);
                    IEDCModuleDMContext module = moduleService.getModuleByAddress(symCtx = (IModules.ISymbolDMContext)DMContexts.getAncestorOfType((IDMContext)context, IModules.ISymbolDMContext.class), (IAddress)pcAddress);
                    if (module != null) {
                        IEDCSymbolReader reader = module.getSymbolReader();
                        if (!$assertionsDisabled && pcAddress == null) {
                            throw new AssertionError();
                        }
                        if (reader != null) {
                            IAddress linkAddress = module.toLinkAddress((IAddress)pcAddress);
                            IModuleLineEntryProvider lineEntryProvider = reader.getModuleScope().getModuleLineEntryProvider();
                            ILineEntry line = lineEntryProvider.getLineEntryAtAddress(linkAddress);
                            if (line != null) {
                                Collection<ILineEntry> ranges;
                                IAddress endAddr = module.toRuntimeAddress(line.getHighAddress());
                                ILineEntry nextLine = lineEntryProvider.getNextLineEntry(lineEntryProvider.getLineEntryAtAddress(linkAddress), stepType == IRunControl.StepType.STEP_OVER);
                                if (nextLine != null) {
                                    endAddr = module.toRuntimeAddress(nextLine.getLowAddress());
                                } else {
                                    IEDCSymbols symbolsService = RunControl.this.getService(Symbols.class);
                                    IFunctionScope functionScope = symbolsService.getFunctionAtAddress(dmc.getSymbolDMContext(), (IAddress)pcAddress);
                                    if (stepType == IRunControl.StepType.STEP_OVER) {
                                        while (functionScope != null && functionScope.getParent() instanceof IFunctionScope) {
                                            functionScope = (IFunctionScope)functionScope.getParent();
                                        }
                                    }
                                    if (functionScope != null) {
                                        endAddr = module.toRuntimeAddress(functionScope.getHighAddress());
                                    }
                                }
                                if (stepType == IRunControl.StepType.STEP_OVER && (ranges = lineEntryProvider.getLineEntriesForLines(line.getFilePath(), line.getLineNumber(), line.getLineNumber())).size() > 1) {
                                    for (ILineEntry iLineEntry : ranges) {
                                        dmc.addDisabledRange(module.toRuntimeAddress(iLineEntry.getLowAddress()), module.toRuntimeAddress(iLineEntry.getHighAddress()));
                                    }
                                }
                                RunControl.this.stepAddressRange(dmc, stepType == IRunControl.StepType.STEP_INTO, (IAddress)pcAddress, endAddr, rm);
                                if (EDCTrace.RUN_CONTROL_TRACE_ON) {
                                    EDCTrace.getTrace().traceExit(null, (Object)"source level stepping.");
                                }
                                return;
                            }
                        }
                    }
                    stepType = stepType == IRunControl.StepType.STEP_INTO ? IRunControl.StepType.INSTRUCTION_STEP_INTO : IRunControl.StepType.INSTRUCTION_STEP_OVER;
                }
                if (stepType == IRunControl.StepType.INSTRUCTION_STEP_OVER) {
                    RunControl.this.stepOverOneInstruction(dmc, (IAddress)pcAddress, rm);
                } else if (stepType == IRunControl.StepType.INSTRUCTION_STEP_INTO) {
                    RunControl.this.stepIntoOneInstruction(dmc, rm);
                } else if (stepType == IRunControl.StepType.INSTRUCTION_STEP_RETURN) {
                    RunControl.this.stepOut(dmc, (IAddress)pcAddress, rm);
                }
                if (EDCTrace.RUN_CONTROL_TRACE_ON) {
                    EDCTrace.getTrace().traceExit(null);
                }
            }
        }, rm);
    }

    private void stepOut(final ExecutionDMC dmc, IAddress pcAddress, final RequestMonitor rm) {
        IStack.IFrameDMContext[] frames;
        if (EDCTrace.RUN_CONTROL_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)("Step out from address " + pcAddress.toHexAddressString()));
        }
        if (dmc.supportsStepMode(IRunControl.StepType.STEP_RETURN)) {
            dmc.stepOut(rm);
            return;
        }
        Stack stackService = this.getService(Stack.class);
        try {
            frames = stackService.getFramesForDMC(dmc, 0, 1);
        }
        catch (CoreException e) {
            Status s = new Status(4, EDCDebugger.getUniqueIdentifier(), null, (Throwable)e);
            EDCDebugger.getMessageLogger().log((IStatus)s);
            rm.setStatus((IStatus)s);
            rm.done();
            return;
        }
        if (frames.length <= 1) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10004, "Cannot step out as no caller frame is available.", null));
            rm.done();
            return;
        }
        if (this.handleSteppingOutOfInLineFunctions(dmc, frames, rm)) {
            return;
        }
        final IAddress stepToAddress = ((Stack.StackFrameDMC)frames[1]).getInstructionPtrAddress();
        final Breakpoints bpService = this.getService(Breakpoints.class);
        this.prepareToRun(dmc, new DataRequestMonitor<Boolean>((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                Addr64 newPC;
                boolean goon = true;
                if (((Boolean)this.getData()).booleanValue() && (newPC = new Addr64(dmc.getPC(), 16)).equals((Object)stepToAddress)) {
                    goon = false;
                }
                if (goon) {
                    bpService.setTempBreakpoint(dmc, stepToAddress, new RequestMonitor((Executor)RunControl.this.getExecutor(), rm){

                        protected void handleSuccess() {
                            dmc.resumeForStepping(rm);
                        }
                    });
                } else {
                    rm.done();
                }
            }
        });
    }

    protected void handleModuleLoadedEvent(IEDCExecutionDMC dmc, Map<String, Object> moduleProperties) {
        IModules.ISymbolDMContext symbolContext = dmc.getSymbolDMContext();
        if (symbolContext != null) {
            Modules modulesService = this.getService(Modules.class);
            modulesService.moduleLoaded(symbolContext, dmc, moduleProperties);
        }
    }

    protected void handleModuleUnloadedEvent(IEDCExecutionDMC dmc, Map<String, Object> moduleProperties) {
        IModules.ISymbolDMContext symbolContext = dmc.getSymbolDMContext();
        if (symbolContext != null) {
            Modules modulesService = this.getService(Modules.class);
            modulesService.moduleUnloaded(symbolContext, dmc, moduleProperties);
        }
    }

    private boolean handleSteppingOutOfInLineFunctions(ExecutionDMC dmc, IStack.IFrameDMContext[] frames, final RequestMonitor rm) {
        IFunctionScope func;
        assert (frames.length > 1 && frames[0] instanceof Stack.StackFrameDMC);
        Stack.StackFrameDMC currentFrame = (Stack.StackFrameDMC)frames[0];
        IEDCModuleDMContext module = currentFrame.getModule();
        if (module != null && (func = currentFrame.getFunctionScope()) != null && func.getParent() instanceof IFunctionScope) {
            IAddress frameInstrPtr;
            if (currentFrame.isInlineShouldBeHidden(null)) {
                return false;
            }
            IAddress functRuntimeHighAddr = module.toRuntimeAddress(func.getHighAddress());
            if (functRuntimeHighAddr.equals((Object)(frameInstrPtr = currentFrame.getInstructionPtrAddress()))) {
                return false;
            }
            this.stepAddressRange(dmc, false, frameInstrPtr, functRuntimeHighAddr, new RequestMonitor((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    rm.done();
                }
            });
            return true;
        }
        return false;
    }

    private void stepOverOneInstruction(final ExecutionDMC dmc, final IAddress pcAddress, final RequestMonitor rm) {
        IDisassembler disassembler;
        if (EDCTrace.RUN_CONTROL_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)("address " + pcAddress.toHexAddressString()));
        }
        if (dmc.supportsStepMode(IRunControl.StepType.INSTRUCTION_STEP_OVER)) {
            dmc.singleStep(false, rm);
            return;
        }
        ITargetEnvironment env = this.getTargetEnvironmentService();
        IDisassembler iDisassembler = disassembler = env != null ? env.getDisassembler() : null;
        if (disassembler == null) {
            rm.setStatus(Disassembly.statusNoDisassembler());
            rm.done();
            return;
        }
        Memory memoryService = this.getService(Memory.class);
        IMemory.IMemoryDMContext mem_dmc = (IMemory.IMemoryDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IMemory.IMemoryDMContext.class);
        int maxInstLength = env.getLongestInstructionLength();
        memoryService.getMemory(mem_dmc, pcAddress, 0L, 1, maxInstLength, new DataRequestMonitor<MemoryByte[]>((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                IDisassembledInstruction inst;
                ByteBuffer codeBuf = Disassembly.translateMemoryBytes((MemoryByte[])this.getData(), pcAddress, rm);
                if (codeBuf == null) {
                    return;
                }
                IDisassembly.IDisassemblyDMContext dis_dmc = (IDisassembly.IDisassemblyDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IDisassembly.IDisassemblyDMContext.class);
                HashMap<String, Object> options = new HashMap<String, Object>();
                options.put("AddressIsPC", 1);
                try {
                    inst = disassembler.disassembleOneInstruction(pcAddress, codeBuf, options, dis_dmc);
                }
                catch (CoreException e) {
                    rm.setStatus(e.getStatus());
                    rm.done();
                    return;
                }
                final boolean isSubroutineCall = inst.getJumpToAddress() != null && inst.getJumpToAddress().isSubroutineAddress();
                final IAddress nextInstructionAddress = pcAddress.add((long)inst.getSize());
                RunControl.this.stepIntoOneInstruction(dmc, new RequestMonitor((Executor)RunControl.this.getExecutor(), rm){

                    protected void handleSuccess() {
                        if (!isSubroutineCall) {
                            rm.done();
                        } else {
                            Breakpoints bpService = RunControl.this.getService(Breakpoints.class);
                            bpService.setTempBreakpoint(dmc, nextInstructionAddress, new RequestMonitor((Executor)RunControl.this.getExecutor(), rm){

                                protected void handleSuccess() {
                                    dmc.resumeForStepping(rm);
                                }
                            });
                        }
                    }
                });
            }
        });
    }

    private void stepAddressRange(final ExecutionDMC dmc, final boolean stepIn, final IAddress startAddr, final IAddress endAddr, final RequestMonitor rm) {
        IDisassembler disassembler;
        if (EDCTrace.RUN_CONTROL_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object)MessageFormat.format("address range [{0},{1})", startAddr.toHexAddressString(), endAddr.toHexAddressString()));
        }
        if (dmc.supportsStepMode(stepIn ? IRunControl.StepType.STEP_INTO : IRunControl.StepType.STEP_OVER)) {
            dmc.stepRange(stepIn, startAddr, endAddr, rm);
            return;
        }
        ITargetEnvironment env = this.getTargetEnvironmentService();
        IDisassembler iDisassembler = disassembler = env != null ? env.getDisassembler() : null;
        if (disassembler == null) {
            rm.setStatus(Disassembly.statusNoDisassembler());
            rm.done();
            return;
        }
        final Memory memoryService = this.getService(Memory.class);
        IMemory.IMemoryDMContext mem_dmc = (IMemory.IMemoryDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IMemory.IMemoryDMContext.class);
        int memSize = startAddr.distanceTo(endAddr).intValue();
        final IAddress pcAddress = startAddr;
        memoryService.getMemory(mem_dmc, startAddr, 0L, 1, memSize, new DataRequestMonitor<MemoryByte[]>((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                List<IDisassembledInstruction> instList;
                ByteBuffer codeBuf = Disassembly.translateMemoryBytes((MemoryByte[])this.getData(), startAddr, rm);
                if (codeBuf == null) {
                    return;
                }
                IDisassembly.IDisassemblyDMContext dis_dmc = (IDisassembly.IDisassemblyDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IDisassembly.IDisassemblyDMContext.class);
                HashMap<String, Object> options = new HashMap<String, Object>();
                try {
                    instList = disassembler.disassembleInstructions(startAddr, endAddr, codeBuf, options, dis_dmc);
                }
                catch (CoreException e) {
                    rm.setStatus(e.getStatus());
                    rm.done();
                    return;
                }
                final ArrayList<IAddress> stopPoints = new ArrayList<IAddress>();
                ArrayList<IAddress> runToAndCheckPoints = new ArrayList<IAddress>();
                boolean insertBPatRangeEnd = true;
                for (IDisassembledInstruction inst : instList) {
                    IJumpToAddress jta;
                    IAddress instAddr = inst.getAddress();
                    if (!insertBPatRangeEnd) {
                        insertBPatRangeEnd = true;
                    }
                    if ((jta = inst.getJumpToAddress()) == null) continue;
                    if (!jta.isImmediate()) {
                        if (inst.getAddress().equals((Object)pcAddress)) {
                            IAddress addr;
                            String expr = (String)jta.getValue();
                            if (expr.equals("ret-far") || expr.equals("ret-near") || expr.equals("lr")) {
                                RunControl.this.stepIntoOneInstruction(dmc, rm);
                                return;
                            }
                            if (jta.isSubroutineAddress() && !stepIn) continue;
                            IAddressExpressionEvaluator evaluator = RunControl.this.getTargetEnvironmentService().getAddressExpressionEvaluator();
                            if (evaluator == null) {
                                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10004, "No evaluator for address expression yet.", null));
                                rm.done();
                                return;
                            }
                            Registers regService = RunControl.this.getService(Registers.class);
                            try {
                                addr = evaluator.evaluate(dmc, expr, regService, memoryService);
                            }
                            catch (CoreException e) {
                                rm.setStatus(e.getStatus());
                                rm.done();
                                return;
                            }
                            if (stopPoints.contains(addr)) continue;
                            stopPoints.add(addr);
                            continue;
                        }
                        if (runToAndCheckPoints.contains(instAddr)) continue;
                        runToAndCheckPoints.add(instAddr);
                        continue;
                    }
                    IAddress jumpAddress = (IAddress)jta.getValue();
                    if (jta.isSoleDestination()) {
                        if (jta.isSubroutineAddress()) {
                            if (!stepIn || stopPoints.contains(jumpAddress)) continue;
                            stopPoints.add(jumpAddress);
                            continue;
                        }
                        if (startAddr.compareTo((Object)jumpAddress) <= 0 && jumpAddress.compareTo((Object)endAddr) < 0) continue;
                        insertBPatRangeEnd = false;
                        if (stopPoints.contains(jumpAddress)) continue;
                        stopPoints.add(jumpAddress);
                        continue;
                    }
                    if (startAddr.compareTo((Object)jumpAddress) <= 0 && jumpAddress.compareTo((Object)endAddr) < 0 || stopPoints.contains(jumpAddress)) continue;
                    stopPoints.add(jumpAddress);
                }
                if (insertBPatRangeEnd && !stopPoints.contains(endAddr)) {
                    stopPoints.add(endAddr);
                }
                if (runToAndCheckPoints.size() > 0) {
                    if (runToAndCheckPoints.size() > 1) {
                        EDCDebugger.getMessageLogger().log((IStatus)new Status(2, "org.eclipse.cdt.debug.edc", MessageFormat.format("More than one run-to-check points in the address range [{0},{1}). Stepping might fail.", startAddr.toHexAddressString(), endAddr.toHexAddressString())));
                    }
                    RunControl.this.stepAddressRange(dmc, stepIn, startAddr, (IAddress)runToAndCheckPoints.get(0), new RequestMonitor((Executor)RunControl.this.getExecutor(), rm){

                        protected void handleSuccess() {
                            Addr64 newPC = new Addr64(dmc.getPC(), 16);
                            boolean doneWithStepping = false;
                            for (IAddress addr : stopPoints) {
                                if (!newPC.equals((Object)addr)) continue;
                                doneWithStepping = true;
                                break;
                            }
                            Breakpoints bpService = RunControl.this.getService(Breakpoints.class);
                            if (bpService.findUserBreakpoint((IAddress)newPC) != null) {
                                doneWithStepping = true;
                            }
                            if (!doneWithStepping) {
                                RunControl.this.stepAddressRange(dmc, stepIn, (IAddress)newPC, endAddr, rm);
                            } else {
                                rm.done();
                            }
                        }
                    });
                } else {
                    RunControl.this.prepareToRun(dmc, (DataRequestMonitor<Boolean>)((DataRequestMonitor)new DataRequestMonitor<Boolean>((Executor)RunControl.this.getExecutor(), rm){

                        protected void handleSuccess() {
                            boolean goon = true;
                            Breakpoints bpService = RunControl.this.getService(Breakpoints.class);
                            if (((Boolean)this.getData()).booleanValue()) {
                                Addr64 newPC = new Addr64(dmc.getPC(), 16);
                                if (bpService.findUserBreakpoint((IAddress)newPC) != null) {
                                    goon = false;
                                } else {
                                    for (IAddress addr : stopPoints) {
                                        if (!newPC.equals((Object)addr)) continue;
                                        goon = false;
                                        break;
                                    }
                                }
                            }
                            if (goon) {
                                CountingRequestMonitor setTempBpRM = new CountingRequestMonitor((Executor)RunControl.this.getExecutor(), rm){

                                    protected void handleSuccess() {
                                        dmc.resumeForStepping(rm);
                                    }
                                };
                                setTempBpRM.setDoneCount(stopPoints.size());
                                for (IAddress addr : stopPoints) {
                                    bpService.setTempBreakpoint(dmc, addr, (RequestMonitor)setTempBpRM);
                                }
                            } else {
                                rm.done();
                            }
                        }
                    }));
                }
            }
        });
    }

    private void stepIntoOneInstruction(final ExecutionDMC dmc, final RequestMonitor rm) {
        this.prepareToRun(dmc, new DataRequestMonitor<Boolean>((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                if (((Boolean)this.getData()).booleanValue()) {
                    rm.done();
                } else {
                    dmc.singleStep(true, rm);
                }
            }
        });
    }

    public void suspend(IRunControl.IExecutionDMContext context, RequestMonitor requestMonitor) {
        if (context instanceof ExecutionDMC) {
            ((ExecutionDMC)context).suspend(requestMonitor);
        } else {
            requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10002, MessageFormat.format("The context [{0}] is not a recognized execution context.", context), null));
            requestMonitor.done();
        }
    }

    public void getModelData(IDMContext dmc, DataRequestMonitor<?> rm) {
        rm.done();
    }

    public void flushCache(IDMContext context) {
        if (this.isSnapshot()) {
            return;
        }
        Registers regService = this.getService(Registers.class);
        regService.flushCache(context);
    }

    @Override
    public void shutdown(RequestMonitor monitor) {
        if (this.tcfRunService != null) {
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    RunControl.this.tcfRunService.removeListener(RunControl.this.runListener);
                }
            });
        }
        this.unregister();
        super.shutdown(monitor);
    }

    public RootExecutionDMC getRootDMC() {
        return this.rootExecutionDMC;
    }

    @Override
    public Element takeSnapshot(IAlbum album, Document document, IProgressMonitor monitor) throws Exception {
        Element contextsElement = document.createElement(EXECUTION_CONTEXTS);
        ExecutionDMC[] dmcs = this.rootExecutionDMC.getChildren();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(dmcs.length * 1000));
        ExecutionDMC[] executionDMCArray = dmcs;
        int n = dmcs.length;
        int n2 = 0;
        while (n2 < n) {
            ExecutionDMC executionDMC = executionDMCArray[n2];
            Element dmcElement = executionDMC.takeSnapshot(album, document, (IProgressMonitor)progress.newChild(1000));
            contextsElement.appendChild(dmcElement);
            ++n2;
        }
        return contextsElement;
    }

    public ExecutionDMC getContext(String contextID) {
        return this.dmcsByID.get(contextID);
    }

    @Override
    public void loadSnapshot(Element snapshotRoot) throws Exception {
        NodeList ecElements = snapshotRoot.getElementsByTagName(EXECUTION_CONTEXTS);
        this.rootExecutionDMC.resumeAll();
        this.initializeRootExecutionDMC();
        this.rootExecutionDMC.loadSnapshot((Element)ecElements.item(0));
    }

    @Override
    public void tcfServiceReady(IService service) {
        if (service instanceof org.eclipse.tm.tcf.services.IRunControl) {
            this.tcfRunService = (org.eclipse.tm.tcf.services.IRunControl)service;
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    RunControl.this.tcfRunService.addListener(RunControl.this.runListener);
                }
            });
        } else assert (false);
    }

    private void detachAllContexts() {
        this.getRootDMC().detach();
    }

    public void terminateAllContexts(final RequestMonitor rm) {
        CountingRequestMonitor crm = new CountingRequestMonitor((Executor)this.getExecutor(), rm){

            protected void handleError() {
                RunControl.this.detachAllContexts();
                if (rm != null) {
                    rm.done();
                }
            }
        };
        ExecutionDMC[] processes = this.getRootDMC().getChildren();
        crm.setDoneCount(processes.length);
        ExecutionDMC[] executionDMCArray = processes;
        int n = processes.length;
        int n2 = 0;
        while (n2 < n) {
            ExecutionDMC e = executionDMCArray[n2];
            e.terminate((RequestMonitor)crm);
            ++n2;
        }
    }

    public void canRunToLine(IRunControl.IExecutionDMContext context, String sourceFile, int lineNumber, DataRequestMonitor<Boolean> rm) {
        rm.setData((Object)true);
        rm.done();
    }

    public void runToLine(final IRunControl.IExecutionDMContext context, String sourceFile, int lineNumber, boolean skipBreakpoints, final RequestMonitor rm) {
        this.getLineAddress(context, sourceFile, lineNumber, new DataRequestMonitor<List<IAddress>>((Executor)this.getExecutor(), rm){

            protected void handleCompleted() {
                if (!this.isSuccess()) {
                    rm.setStatus(this.getStatus());
                    rm.done();
                } else {
                    RunControl.this.runToAddresses(context, (List)this.getData(), rm);
                }
            }
        });
    }

    private void runToAddresses(IRunControl.IExecutionDMContext context, final List<IAddress> addrs, final RequestMonitor rm) {
        final ExecutionDMC dmc = (ExecutionDMC)context;
        assert (dmc != null);
        this.prepareToRun(dmc, new DataRequestMonitor<Boolean>((Executor)this.getExecutor(), rm){

            protected void handleCompleted() {
                if (!this.isSuccess()) {
                    rm.setStatus(this.getStatus());
                    rm.done();
                    return;
                }
                CountingRequestMonitor settingBP_crm = new CountingRequestMonitor((Executor)RunControl.this.getExecutor(), rm){

                    protected void handleCompleted() {
                        if (!this.isSuccess()) {
                            rm.setStatus(this.getStatus());
                            rm.done();
                        } else {
                            dmc.resume(rm);
                        }
                    }
                };
                settingBP_crm.setDoneCount(addrs.size());
                Breakpoints bpService = RunControl.this.getService(Breakpoints.class);
                for (IAddress a : addrs) {
                    bpService.setTempBreakpoint(dmc, a, (RequestMonitor)settingBP_crm);
                }
            }
        });
    }

    public void canRunToAddress(IRunControl.IExecutionDMContext context, IAddress address, DataRequestMonitor<Boolean> rm) {
        rm.setData((Object)true);
        rm.done();
    }

    public void runToAddress(IRunControl.IExecutionDMContext context, IAddress address, boolean skipBreakpoints, RequestMonitor rm) {
        ArrayList<IAddress> addrs = new ArrayList<IAddress>(1);
        addrs.add(address);
        this.runToAddresses(context, addrs, rm);
    }

    public void canMoveToLine(IRunControl.IExecutionDMContext context, String sourceFile, int lineNumber, boolean resume, DataRequestMonitor<Boolean> rm) {
        rm.setData((Object)true);
        rm.done();
    }

    public void moveToLine(final IRunControl.IExecutionDMContext context, String sourceFile, int lineNumber, final boolean resume, final RequestMonitor rm) {
        this.getLineAddress(context, sourceFile, lineNumber, new DataRequestMonitor<List<IAddress>>((Executor)this.getExecutor(), rm){

            protected void handleCompleted() {
                if (!this.isSuccess()) {
                    rm.setStatus(this.getStatus());
                    rm.done();
                } else {
                    List addrs = (List)this.getData();
                    RunControl.this.moveToAddress(context, (IAddress)addrs.get(0), resume, rm);
                }
            }
        });
    }

    public void canMoveToAddress(IRunControl.IExecutionDMContext context, IAddress address, boolean resume, DataRequestMonitor<Boolean> rm) {
        rm.setData((Object)true);
        rm.done();
    }

    public void moveToAddress(IRunControl.IExecutionDMContext context, IAddress address, boolean resume, RequestMonitor rm) {
        Registers regService = this.getService(Registers.class);
        assert (context instanceof ExecutionDMC);
        ExecutionDMC dmc = (ExecutionDMC)context;
        String newPC = address.toString(16);
        if (!newPC.equals(dmc.getPC())) {
            try {
                String regID = this.getTargetEnvironmentService().getPCRegisterID();
                Registers.RegisterDMC regDMC = regService.findRegisterDMCByName(dmc, regID);
                assert (regDMC != null);
                regService.writeRegister(regDMC, newPC, "HEX.Format");
            }
            catch (CoreException e) {
                Status s = new Status(4, EDCDebugger.getUniqueIdentifier(), "Error adjusting the PC register", (Throwable)e);
                EDCDebugger.getMessageLogger().log((IStatus)s);
                rm.setStatus((IStatus)s);
                rm.done();
                return;
            }
            dmc.setPC(newPC);
        }
        if (resume) {
            this.resume(context, rm);
        } else {
            rm.done();
        }
    }

    private void getLineAddress(IRunControl.IExecutionDMContext context, String sourceFile, int lineNumber, DataRequestMonitor<List<IAddress>> drm) {
        ArrayList addrs = new ArrayList(1);
        ExecutionDMC dmc = (ExecutionDMC)context;
        if (dmc == null || !dmc.isSuspended()) {
            drm.setData(addrs);
            drm.done();
            return;
        }
        Modules moduleService = this.getService(Modules.class);
        moduleService.getLineAddress(dmc, sourceFile, lineNumber, drm);
    }

    public static boolean isNonContainer(IDMContext dmc) {
        return !(dmc instanceof IRunControl.IContainerDMContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadExecutionDMC[] getSuspendedThreads() {
        ExecutionDMC[] dmcs = null;
        ArrayList<ThreadExecutionDMC> result = new ArrayList<ThreadExecutionDMC>();
        Map<String, ExecutionDMC> map = this.dmcsByID;
        synchronized (map) {
            Collection<ExecutionDMC> allDMCs = this.dmcsByID.values();
            dmcs = allDMCs.toArray(new ExecutionDMC[allDMCs.size()]);
        }
        ExecutionDMC[] executionDMCArray = dmcs;
        int n = dmcs.length;
        int n2 = 0;
        while (n2 < n) {
            ExecutionDMC executionDMC = executionDMCArray[n2];
            if (executionDMC instanceof ThreadExecutionDMC && executionDMC.isSuspended()) {
                result.add((ThreadExecutionDMC)executionDMC);
            }
            ++n2;
        }
        return result.toArray(new ThreadExecutionDMC[result.size()]);
    }

    private static boolean getProperty(Map<String, Object> properties, String name, boolean defaultValue) {
        Boolean b = (Boolean)properties.get(name);
        return b == null ? defaultValue : b;
    }

    public class BareDeviceExecutionDMC
    extends ThreadExecutionDMC
    implements IProcesses.IProcessDMContext,
    IModules.ISymbolDMContext,
    IBreakpoints.IBreakpointsTargetDMContext {
        public BareDeviceExecutionDMC(ExecutionDMC parent, Map<String, Object> properties, IRunControl.RunControlContext tcfContext) {
            super(parent, properties, tcfContext);
            assert (!RunControl.getProperty(properties, RunControl.PROP_IS_CONTAINER, true));
        }

        @Override
        protected DMCSuspendedEvent createSuspendedEvent(IRunControl.StateChangeReason reason, Map<String, Object> properties) {
            return new ContainerSuspendedEvent(this, reason, properties);
        }

        @Override
        protected DMCResumedEvent createResumedEvent() {
            return new ContainerResumedEvent(this);
        }

        @Override
        public boolean canDetach() {
            return true;
        }
    }

    public static class ContainerResumedEvent
    extends DMCResumedEvent
    implements IRunControl.IContainerResumedDMEvent {
        public ContainerResumedEvent(IRunControl.IExecutionDMContext dmc) {
            super(dmc);
        }

        public IRunControl.IExecutionDMContext[] getTriggeringContexts() {
            return new IRunControl.IExecutionDMContext[]{(IRunControl.IExecutionDMContext)this.getDMContext()};
        }
    }

    public static class ContainerSuspendedEvent
    extends DMCSuspendedEvent
    implements IRunControl.IContainerSuspendedDMEvent {
        public ContainerSuspendedEvent(IRunControl.IExecutionDMContext dmc, IRunControl.StateChangeReason reason, Map<String, Object> params) {
            super(dmc, reason, params);
        }

        public IRunControl.IExecutionDMContext[] getTriggeringContexts() {
            return new IRunControl.IExecutionDMContext[]{(IRunControl.IExecutionDMContext)this.getDMContext()};
        }
    }

    public static abstract class DMCResumedEvent
    extends AbstractDMEvent<IRunControl.IExecutionDMContext> {
        public DMCResumedEvent(IRunControl.IExecutionDMContext dmc) {
            super((IDMContext)dmc);
        }

        public IRunControl.StateChangeReason getReason() {
            return IRunControl.StateChangeReason.USER_REQUEST;
        }
    }

    public static abstract class DMCSuspendedEvent
    extends AbstractDMEvent<IRunControl.IExecutionDMContext> {
        private final IRunControl.StateChangeReason reason;
        private final Map<String, Object> params;

        public DMCSuspendedEvent(IRunControl.IExecutionDMContext dmc, IRunControl.StateChangeReason reason, Map<String, Object> params) {
            super((IDMContext)dmc);
            if (EDCTrace.RUN_CONTROL_TRACE_ON) {
                EDCTrace.getTrace().traceEntry(null, (Object[])EDCTrace.fixArgs(new Object[]{dmc, reason, params}));
            }
            this.reason = reason;
            this.params = params;
        }

        public IRunControl.StateChangeReason getReason() {
            return this.reason;
        }

        public Map<String, Object> getParams() {
            return this.params;
        }
    }

    public abstract class ExecutionDMC
    extends DMContext
    implements IRunControl.IExecutionDMContext,
    ISnapshotContributor,
    IEDCExecutionDMC {
        private final List<ExecutionDMC> children;
        private IRunControl.StateChangeReason stateChangeReason;
        private String stateChangeDetails;
        private final IRunControl.RunControlContext tcfContext;
        private final ExecutionDMC parentExecutionDMC;
        private String latestPC;
        private RequestMonitor steppingRM;
        private boolean isStepping;
        private int countOfScheduledNotifications;
        private boolean isTerminatingThanDisconnecting;
        private List<Modules.EDCAddressRange> disabledRanges;
        private boolean suspendEventsEnabled;

        public ExecutionDMC(ExecutionDMC parent, Map<String, Object> props, IRunControl.RunControlContext tcfContext) {
            IDMContext[] iDMContextArray;
            if (parent == null) {
                iDMContextArray = new IDMContext[]{};
            } else {
                IDMContext[] iDMContextArray2 = new IDMContext[1];
                iDMContextArray = iDMContextArray2;
                iDMContextArray2[0] = parent;
            }
            super(RunControl.this, iDMContextArray, props);
            this.children = Collections.synchronizedList(new ArrayList());
            this.stateChangeReason = IRunControl.StateChangeReason.UNKNOWN;
            this.stateChangeDetails = null;
            this.latestPC = null;
            this.steppingRM = null;
            this.isStepping = false;
            this.countOfScheduledNotifications = 0;
            this.isTerminatingThanDisconnecting = false;
            this.disabledRanges = Collections.synchronizedList(new ArrayList());
            this.suspendEventsEnabled = true;
            if (EDCTrace.RUN_CONTROL_TRACE_ON) {
                EDCTrace.getTrace().traceEntry(null, (Object[])EDCTrace.fixArgs(new Object[]{parent, this.properties}));
            }
            this.parentExecutionDMC = parent;
            this.tcfContext = tcfContext;
            if (props != null) {
                RunControl.this.dmcsByID.put(this.getID(), this);
            }
            if (parent != null) {
                parent.addChild(this);
            }
            if (EDCTrace.RUN_CONTROL_TRACE_ON) {
                EDCTrace.getTrace().traceExit(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addChild(ExecutionDMC executionDMC) {
            List<ExecutionDMC> list = this.children;
            synchronized (list) {
                this.children.add(executionDMC);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeChild(IEDCExecutionDMC executionDMC) {
            List<ExecutionDMC> list = this.children;
            synchronized (list) {
                this.children.remove(executionDMC);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ExecutionDMC[] getChildren() {
            List<ExecutionDMC> list = this.children;
            synchronized (list) {
                return this.children.toArray(new ExecutionDMC[this.children.size()]);
            }
        }

        @Override
        public boolean wantFocusInUI() {
            Boolean wantFocus = (Boolean)this.properties.get("WantFocusInUI");
            if (wantFocus == null) {
                wantFocus = true;
            }
            return wantFocus;
        }

        public abstract ExecutionDMC contextAdded(Map<String, Object> var1, IRunControl.RunControlContext var2);

        public abstract boolean canDetach();

        public abstract boolean canStep();

        @Override
        public void loadSnapshot(Element element) throws Exception {
            if (EDCTrace.RUN_CONTROL_TRACE_ON) {
                EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(element));
            }
            NodeList ecElements = element.getElementsByTagName(RunControl.EXECUTION_CONTEXT);
            int numcontexts = ecElements.getLength();
            int i = 0;
            while (i < numcontexts) {
                Element contextElement = (Element)ecElements.item(i);
                if (contextElement.getParentNode().equals(element)) {
                    try {
                        Element propElement = (Element)contextElement.getElementsByTagName("properties").item(0);
                        HashMap<String, Object> properties = new HashMap<String, Object>();
                        SnapshotUtils.initializeFromXML(propElement, properties);
                        ExecutionDMC exeDMC = this.contextAdded(properties, null);
                        exeDMC.loadSnapshot(contextElement);
                    }
                    catch (CoreException e) {
                        EDCDebugger.getMessageLogger().logError(null, e);
                    }
                }
                ++i;
            }
            if (EDCTrace.RUN_CONTROL_TRACE_ON) {
                EDCTrace.getTrace().traceExit(null);
            }
        }

        @Override
        public Element takeSnapshot(IAlbum album, Document document, IProgressMonitor monitor) throws Exception {
            Element contextElement = document.createElement(RunControl.EXECUTION_CONTEXT);
            contextElement.setAttribute("ID", this.getID());
            Element propsElement = SnapshotUtils.makeXMLFromProperties(document, this.getProperties());
            contextElement.appendChild(propsElement);
            ExecutionDMC[] dmcs = this.getChildren();
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(dmcs.length * 1000));
            progress.subTask(this.getName());
            ExecutionDMC[] executionDMCArray = dmcs;
            int n = dmcs.length;
            int n2 = 0;
            while (n2 < n) {
                ExecutionDMC executionDMC = executionDMCArray[n2];
                Element dmcElement = executionDMC.takeSnapshot(album, document, (IProgressMonitor)progress.newChild(1000));
                contextElement.appendChild(dmcElement);
                ++n2;
            }
            return contextElement;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isSuspended() {
            Map map = this.properties;
            synchronized (map) {
                return RunControl.getProperty(this.properties, RunControl.PROP_IS_SUSPENDED, false);
            }
        }

        public IRunControl.StateChangeReason getStateChangeReason() {
            return this.stateChangeReason;
        }

        public String getStateChangeDetails() {
            return this.stateChangeDetails;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setIsSuspended(boolean isSuspended) {
            Map map = this.properties;
            synchronized (map) {
                this.properties.put(RunControl.PROP_IS_SUSPENDED, isSuspended);
            }
            if (this.getParent() != null) {
                this.getParent().childIsSuspended(isSuspended);
            }
        }

        private void childIsSuspended(boolean isSuspended) {
            if (isSuspended) {
                this.setIsSuspended(true);
            } else {
                boolean anySuspended = false;
                ExecutionDMC[] executionDMCArray = this.getChildren();
                int n = executionDMCArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ExecutionDMC childDMC = executionDMCArray[n2];
                    if (childDMC.isSuspended()) {
                        anySuspended = true;
                        break;
                    }
                    ++n2;
                }
                if (!anySuspended) {
                    this.setIsSuspended(false);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void contextException(String msg) {
            assert (RunControl.this.getExecutor().isInExecutorThread());
            this.setIsSuspended(true);
            Map map = this.properties;
            synchronized (map) {
                this.properties.put(RunControl.PROP_MESSAGE, msg);
            }
            this.stateChangeReason = IRunControl.StateChangeReason.EXCEPTION;
            RunControl.this.getSession().dispatchEvent((Object)this.createSuspendedEvent(IRunControl.StateChangeReason.EXCEPTION, new HashMap<String, Object>()), RunControl.this.getProperties());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void contextSuspended(String pc, String reason, final Map<String, Object> params) {
            assert (RunControl.this.getExecutor().isInExecutorThread());
            if (EDCTrace.RUN_CONTROL_TRACE_ON) {
                EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(new Object[]{pc, reason, params}));
            }
            if (pc != null) {
                pc = Long.toHexString(Long.parseLong(pc));
            }
            this.latestPC = pc;
            this.setIsSuspended(true);
            Map map = this.properties;
            synchronized (map) {
                this.properties.put(RunControl.PROP_MESSAGE, reason);
                this.properties.put(RunControl.PROP_SUSPEND_PC, pc);
            }
            this.stateChangeReason = RunControl.toDsfStateChangeReason(reason);
            if (this.stateChangeReason == IRunControl.StateChangeReason.SHAREDLIB) {
                this.handleModuleEvent(this, params);
            } else {
                this.properties.put(RunControl.PROP_DISABLE_STEPPING, params.get("disable_stepping"));
                this.properties.put("WantFocusInUI", params.get("WantFocusInUI"));
                this.stateChangeDetails = (String)params.get("message");
                Boolean isForeground = (Boolean)params.get("IsForeground");
                if (isForeground != null) {
                    this.stateChangeDetails = String.valueOf(this.stateChangeDetails) + (isForeground != false ? " [foreground]" : "");
                }
                final ExecutionDMC dmc = this;
                DataRequestMonitor<Boolean> preprocessDrm = new DataRequestMonitor<Boolean>((Executor)RunControl.this.getExecutor(), null){

                    protected void handleCompleted() {
                        Boolean honorSuspend = (Boolean)this.getData();
                        if (honorSuspend != null && honorSuspend.booleanValue()) {
                            if (ExecutionDMC.this.steppingRM != null) {
                                ExecutionDMC.this.steppingRM.done();
                                ExecutionDMC.this.steppingRM = null;
                            }
                            ExecutionDMC.this.setStepping(false);
                            Breakpoints bpService = RunControl.this.getService(Breakpoints.class);
                            bpService.removeAllTempBreakpoints(new RequestMonitor((Executor)RunControl.this.getExecutor(), null));
                            Addr64 pcAddress = new Addr64(dmc.getPC(), 16);
                            Modules.EDCAddressRange disabledRange = dmc.getDisabledRange((IAddress)pcAddress);
                            if (disabledRange != null) {
                                RunControl.this.stepAddressRange(dmc, false, (IAddress)pcAddress, disabledRange.getEndAddress(), new RequestMonitor((Executor)RunControl.this.getExecutor(), null));
                            } else if (dmc.suspendEventsEnabled()) {
                                RunControl.this.getSession().dispatchEvent((Object)dmc.createSuspendedEvent(ExecutionDMC.this.stateChangeReason, params), RunControl.this.getProperties());
                            }
                            dmc.clearDisabledRanges();
                        } else {
                            RunControl.this.resume(dmc, new RequestMonitor((Executor)RunControl.this.getExecutor(), null));
                        }
                    }
                };
                RunControl.this.preprocessOnSuspend(dmc, this.latestPC, preprocessDrm);
            }
            if (EDCTrace.RUN_CONTROL_TRACE_ON) {
                EDCTrace.getTrace().traceExit(null);
            }
        }

        protected boolean suspendEventsEnabled() {
            return this.suspendEventsEnabled;
        }

        protected void setSuspendEventsEnabled(boolean enabled) {
            this.suspendEventsEnabled = enabled;
        }

        protected void clearDisabledRanges() {
            this.disabledRanges.clear();
        }

        private void handleModuleEvent(final IEDCExecutionDMC dmc, final Map<String, Object> moduleProperties) {
            RunControl.this.getSession().getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    boolean loaded = true;
                    Object loadedValue = moduleProperties.get("Loaded");
                    if (loadedValue != null && loadedValue instanceof Boolean) {
                        loaded = (Boolean)loadedValue;
                    }
                    if (loaded) {
                        RunControl.this.handleModuleLoadedEvent(dmc, moduleProperties);
                    } else {
                        RunControl.this.handleModuleUnloadedEvent(dmc, moduleProperties);
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Boolean canTerminate() {
            if (EDCTrace.RUN_CONTROL_TRACE_ON) {
                EDCTrace.getTrace().traceEntry(null);
            }
            boolean result = false;
            Map map = this.properties;
            synchronized (map) {
                result = RunControl.getProperty(this.properties, RunControl.PROP_CAN_TERMINATE, result);
            }
            if (EDCTrace.RUN_CONTROL_TRACE_ON) {
                EDCTrace.getTrace().traceExit(null, (Object)result);
            }
            return result;
        }

        public boolean supportsStepMode(IRunControl.StepType type) {
            if (EDCTrace.RUN_CONTROL_TRACE_ON) {
                EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(this));
            }
            int mode = 0;
            switch (type) {
                case STEP_OVER: {
                    mode = 12;
                    break;
                }
                case STEP_INTO: {
                    mode = 13;
                    break;
                }
                case STEP_RETURN: {
                    mode = 5;
                    break;
                }
                case INSTRUCTION_STEP_OVER: {
                    mode = 1;
                    break;
                }
                case INSTRUCTION_STEP_INTO: {
                    mode = 2;
                }
            }
            if (this.hasTCFContext()) {
                return this.getTCFContext().canResume(mode);
            }
            return false;
        }

        public void resume(final RequestMonitor rm) {
            if (EDCTrace.RUN_CONTROL_TRACE_ON) {
                EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(this));
            }
            RunControl.this.flushCache((IDMContext)this);
            if (this.hasTCFContext()) {
                Protocol.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ExecutionDMC.this.getTCFContext().resume(0, 0, new IRunControl.DoneCommand(){

                            public void doneCommand(IToken token, final Exception error) {
                                RunControl.this.getExecutor().execute(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (error == null) {
                                            ExecutionDMC.this.contextResumed(true);
                                            if (EDCTrace.RUN_CONTROL_TRACE_ON) {
                                                EDCTrace.getTrace().trace(null, "Resume command succeeded.");
                                            }
                                        } else {
                                            if (EDCTrace.RUN_CONTROL_TRACE_ON) {
                                                EDCTrace.getTrace().trace(null, "Resume command failed.");
                                            }
                                            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10004, "Resume failed.", null));
                                        }
                                        rm.done();
                                    }
                                });
                            }
                        });
                    }
                });
            }
            if (EDCTrace.RUN_CONTROL_TRACE_ON) {
                EDCTrace.getTrace().traceExit(null);
            }
        }

        protected void resumeForStepping(final RequestMonitor rm) {
            if (EDCTrace.RUN_CONTROL_TRACE_ON) {
                EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(this));
            }
            this.setStepping(true);
            RunControl.this.flushCache((IDMContext)this);
            if (this.hasTCFContext()) {
                Protocol.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ExecutionDMC.this.getTCFContext().resume(0, 0, new IRunControl.DoneCommand(){

                            public void doneCommand(IToken token, final Exception error) {
                                RunControl.this.getExecutor().execute(new Runnable(){

                                    @Override
                                    public void run() {
                                        ExecutionDMC.this.handleTCFResumeDoneForStepping("ResumeForStepping", error, rm);
                                    }
                                });
                            }
                        });
                    }
                });
            }
            if (EDCTrace.RUN_CONTROL_TRACE_ON) {
                EDCTrace.getTrace().traceExit(null);
            }
        }

        private void handleTCFResumeDoneForStepping(String command, Exception tcfError, RequestMonitor rm) {
            assert (RunControl.this.getExecutor().isInExecutorThread());
            String msg = command;
            if (tcfError == null) {
                msg = String.valueOf(msg) + " succeeded.";
                if (EDCTrace.RUN_CONTROL_TRACE_ON) {
                    EDCTrace.getTrace().trace(null, msg);
                }
                this.contextResumed(false);
                assert (this.steppingRM == null);
                this.steppingRM = rm;
            } else {
                msg = String.valueOf(msg) + " failed.";
                if (EDCTrace.RUN_CONTROL_TRACE_ON) {
                    EDCTrace.getTrace().trace(null, msg);
                }
                this.setStepping(false);
                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10004, msg, (Throwable)tcfError));
                rm.done();
            }
        }

        public void suspend(final RequestMonitor requestMonitor) {
            if (EDCTrace.RUN_CONTROL_TRACE_ON) {
                EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(this));
            }
            if (RunControl.this.isSnapshot()) {
                Album.getAlbumBySession(RunControl.this.getSession().getId()).stopPlayingSnapshots();
            } else if (this.hasTCFContext()) {
                Protocol.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ExecutionDMC.this.getTCFContext().suspend(new IRunControl.DoneCommand(){

                            public void doneCommand(IToken token, Exception error) {
                                if (EDCTrace.RUN_CONTROL_TRACE_ON) {
                                    EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(this));
                                }
                                requestMonitor.done();
                                if (EDCTrace.RUN_CONTROL_TRACE_ON) {
                                    EDCTrace.getTrace().traceExit(null);
                                }
                            }
                        });
                    }
                });
            }
            if (EDCTrace.RUN_CONTROL_TRACE_ON) {
                EDCTrace.getTrace().traceExit(null);
            }
        }

        public void terminate(final RequestMonitor requestMonitor) {
            if (EDCTrace.RUN_CONTROL_TRACE_ON) {
                EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(this));
            }
            this.isTerminatingThanDisconnecting = true;
            if (this.hasTCFContext()) {
                Protocol.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ExecutionDMC.this.getTCFContext().terminate(new IRunControl.DoneCommand(){

                            public void doneCommand(IToken token, Exception error) {
                                if (EDCTrace.RUN_CONTROL_TRACE_ON) {
                                    EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(this));
                                }
                                if (error != null) {
                                    requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", "terminate() failed.", (Throwable)error));
                                }
                                requestMonitor.done();
                                if (EDCTrace.RUN_CONTROL_TRACE_ON) {
                                    EDCTrace.getTrace().traceExit(null);
                                }
                            }
                        });
                    }
                });
            } else {
                RunControl.this.detachAllContexts();
            }
            if (EDCTrace.RUN_CONTROL_TRACE_ON) {
                EDCTrace.getTrace().traceExit(null);
            }
        }

        protected ExecutionDMC getParent() {
            return this.parentExecutionDMC;
        }

        public String getPC() {
            return this.latestPC;
        }

        private void setPC(String pc) {
            this.latestPC = pc;
        }

        public void detach() {
            this.isTerminatingThanDisconnecting = false;
            this.purgeFromDebugger();
        }

        public void purgeFromDebugger() {
            if (EDCTrace.RUN_CONTROL_TRACE_ON) {
                EDCTrace.getTrace().traceEntry(null);
            }
            ExecutionDMC[] executionDMCArray = this.getChildren();
            int n = executionDMCArray.length;
            int n2 = 0;
            while (n2 < n) {
                ExecutionDMC e = executionDMCArray[n2];
                e.purgeFromDebugger();
                ++n2;
            }
            ExecutionDMC parent = this.getParent();
            if (parent != null) {
                parent.removeChild(this);
            }
            RunControl.this.getSession().dispatchEvent((Object)new ExitedEvent(this, this.isTerminatingThanDisconnecting), RunControl.this.getProperties());
            if (RunControl.this.getRootDMC().getChildren().length == 0) {
                RunControl.this.getSession().dispatchEvent((Object)new ExitedEvent(RunControl.this.getRootDMC(), this.isTerminatingThanDisconnecting), RunControl.this.getProperties());
            }
            if (EDCTrace.RUN_CONTROL_TRACE_ON) {
                EDCTrace.getTrace().traceExit(null);
            }
        }

        public void resumeAll() {
            this.contextResumed(true);
            ExecutionDMC[] executionDMCArray = this.getChildren();
            int n = executionDMCArray.length;
            int n2 = 0;
            while (n2 < n) {
                ExecutionDMC e = executionDMCArray[n2];
                e.resumeAll();
                ++n2;
            }
        }

        protected void contextResumed(boolean fireResumeEventNow) {
            assert (RunControl.this.getExecutor().isInExecutorThread());
            if (this.children.size() > 0) {
                for (ExecutionDMC e : this.children) {
                    e.contextResumed(fireResumeEventNow);
                }
                return;
            }
            if (EDCTrace.RUN_CONTROL_TRACE_ON) {
                EDCTrace.getTrace().traceEntry(null, (Object[])EDCTrace.fixArgs(new Object[]{this, fireResumeEventNow}));
            }
            this.setIsSuspended(false);
            if (fireResumeEventNow) {
                RunControl.this.getSession().dispatchEvent((Object)this.createResumedEvent(), RunControl.this.getProperties());
            } else {
                this.scheduleResumeEvent();
            }
            if (EDCTrace.RUN_CONTROL_TRACE_ON) {
                EDCTrace.getTrace().traceExit(null);
            }
        }

        private void scheduleResumeEvent() {
            ++this.countOfScheduledNotifications;
            final ExecutionDMC dmc = this;
            Runnable notifyPlatformTask = new Runnable(){

                @Override
                public void run() {
                    ExecutionDMC executionDMC = ExecutionDMC.this;
                    executionDMC.countOfScheduledNotifications = executionDMC.countOfScheduledNotifications - 1;
                    if (ExecutionDMC.this.countOfScheduledNotifications == 0 && !ExecutionDMC.this.isSuspended()) {
                        RunControl.this.getSession().dispatchEvent((Object)dmc.createResumedEvent(), RunControl.this.getProperties());
                    }
                }
            };
            RunControl.this.getExecutor().schedule(notifyPlatformTask, 1000L, TimeUnit.MILLISECONDS);
        }

        protected void singleStep(final boolean stepInto, final RequestMonitor rm) {
            if (EDCTrace.RUN_CONTROL_TRACE_ON) {
                EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(this.getName()));
            }
            this.setStepping(true);
            RunControl.this.flushCache((IDMContext)this);
            if (this.hasTCFContext()) {
                Protocol.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        int mode = stepInto ? 2 : 1;
                        ExecutionDMC.this.getTCFContext().resume(mode, 1, new IRunControl.DoneCommand(){

                            public void doneCommand(IToken token, final Exception error) {
                                RunControl.this.getExecutor().execute(new Runnable(){

                                    @Override
                                    public void run() {
                                        ExecutionDMC.this.handleTCFResumeDoneForStepping("SingleStep", error, rm);
                                    }
                                });
                            }
                        });
                    }
                });
            }
            if (EDCTrace.RUN_CONTROL_TRACE_ON) {
                EDCTrace.getTrace().traceExit(null);
            }
        }

        protected void stepOut(final RequestMonitor rm) {
            if (EDCTrace.RUN_CONTROL_TRACE_ON) {
                EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(this.getName()));
            }
            this.setStepping(true);
            RunControl.this.flushCache((IDMContext)this);
            if (this.hasTCFContext()) {
                Protocol.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ExecutionDMC.this.getTCFContext().resume(5, 0, new IRunControl.DoneCommand(){

                            public void doneCommand(IToken token, final Exception error) {
                                RunControl.this.getExecutor().execute(new Runnable(){

                                    @Override
                                    public void run() {
                                        ExecutionDMC.this.handleTCFResumeDoneForStepping("StepOut", error, rm);
                                    }
                                });
                            }
                        });
                    }
                });
            }
            if (EDCTrace.RUN_CONTROL_TRACE_ON) {
                EDCTrace.getTrace().traceExit(null);
            }
        }

        protected void stepRange(final boolean stepInto, final IAddress rangeStart, final IAddress rangeEnd, final RequestMonitor rm) {
            if (EDCTrace.RUN_CONTROL_TRACE_ON) {
                EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(this.getName()));
            }
            this.setStepping(true);
            RunControl.this.flushCache((IDMContext)this);
            if (this.hasTCFContext()) {
                Protocol.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        int mode = stepInto ? 13 : 12;
                        HashMap<String, BigInteger> params = new HashMap<String, BigInteger>();
                        params.put("RANGE_START", rangeStart.getValue());
                        params.put("RANGE_END", rangeEnd.getValue());
                        ExecutionDMC.this.getTCFContext().resume(mode, 0, params, new IRunControl.DoneCommand(){

                            public void doneCommand(IToken token, final Exception error) {
                                RunControl.this.getExecutor().execute(new Runnable(){

                                    @Override
                                    public void run() {
                                        ExecutionDMC.this.handleTCFResumeDoneForStepping("StepRange", error, rm);
                                    }
                                });
                            }
                        });
                    }
                });
            }
            if (EDCTrace.RUN_CONTROL_TRACE_ON) {
                EDCTrace.getTrace().traceExit(null);
            }
        }

        public void setStepping(boolean isStepping) {
            this.isStepping = isStepping;
        }

        public boolean isStepping() {
            return this.isStepping;
        }

        public void addDisabledRange(IAddress lowAddress, IAddress highAddress) {
            this.disabledRanges.add(new Modules.EDCAddressRange(lowAddress, highAddress));
        }

        public Modules.EDCAddressRange getDisabledRange(IAddress address) {
            for (Modules.EDCAddressRange dRange : this.disabledRanges) {
                if (!dRange.contains(address)) continue;
                return dRange;
            }
            return null;
        }

        protected DMCSuspendedEvent createSuspendedEvent(IRunControl.StateChangeReason reason, Map<String, Object> properties) {
            return new SuspendedEvent(this, reason, properties);
        }

        protected DMCResumedEvent createResumedEvent() {
            return new ResumedEvent(this);
        }

        public IRunControl.RunControlContext getTCFContext() {
            return this.tcfContext;
        }

        public boolean hasTCFContext() {
            return this.tcfContext != null;
        }
    }

    @Immutable
    private static class ExecutionData
    implements IRunControl.IExecutionDMData2 {
        private final IRunControl.StateChangeReason reason;
        private final String details;

        ExecutionData(IRunControl.StateChangeReason reason, String details) {
            this.reason = reason;
            this.details = details;
        }

        public IRunControl.StateChangeReason getStateChangeReason() {
            return this.reason;
        }

        public String getDetails() {
            return this.details;
        }
    }

    public static class ExitedEvent
    extends AbstractDMEvent<IRunControl.IExecutionDMContext>
    implements IRunControl.IExitedDMEvent {
        private boolean isTerminatedThanDisconnected;

        public ExitedEvent(IRunControl.IExecutionDMContext context, boolean isTerminatedThanDisconnected) {
            super((IDMContext)context);
            this.isTerminatedThanDisconnected = isTerminatedThanDisconnected;
        }

        public boolean isTerminatedThanDisconnected() {
            return this.isTerminatedThanDisconnected;
        }
    }

    public class ProcessExecutionDMC
    extends ExecutionDMC
    implements IRunControl.IContainerDMContext,
    IProcesses.IProcessDMContext,
    IModules.ISymbolDMContext,
    IBreakpoints.IBreakpointsTargetDMContext,
    IDisassembly.IDisassemblyDMContext {
        public ProcessExecutionDMC(ExecutionDMC parent, Map<String, Object> properties, IRunControl.RunControlContext tcfContext) {
            super(parent, properties, tcfContext);
        }

        @Override
        public ExecutionDMC contextAdded(Map<String, Object> properties, IRunControl.RunControlContext tcfContext) {
            if (EDCTrace.RUN_CONTROL_TRACE_ON) {
                EDCTrace.getTrace().traceEntry(null, (Object)EDCTrace.fixArg(properties));
            }
            ThreadExecutionDMC newDMC = new ThreadExecutionDMC(this, properties, tcfContext);
            RunControl.this.getSession().dispatchEvent((Object)new StartedEvent(newDMC), RunControl.this.getProperties());
            if (EDCTrace.RUN_CONTROL_TRACE_ON) {
                EDCTrace.getTrace().traceExit(null, (Object)EDCTrace.fixArg(newDMC));
            }
            return newDMC;
        }

        @Override
        public IModules.ISymbolDMContext getSymbolDMContext() {
            return this;
        }

        @Override
        public void loadSnapshot(Element element) throws Exception {
            Modules modulesService = RunControl.this.getService(Modules.class);
            modulesService.loadModulesForContext(this, element);
            super.loadSnapshot(element);
        }

        @Override
        public Element takeSnapshot(IAlbum album, Document document, IProgressMonitor monitor) throws Exception {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1000);
            progress.subTask(this.getName());
            Element contextElement = super.takeSnapshot(album, document, (IProgressMonitor)progress.newChild(500));
            Element modulesElement = document.createElement(RunControl.EXECUTION_CONTEXT_MODULES);
            Modules modulesService = RunControl.this.getService(Modules.class);
            IModules.IModuleDMContext[] modules = modulesService.getModulesForContext(this.getID());
            SubMonitor modulesMonitor = progress.newChild(500);
            modulesMonitor.setWorkRemaining(modules.length * 1000);
            modulesMonitor.subTask("Modules");
            IModules.IModuleDMContext[] iModuleDMContextArray = modules;
            int n = modules.length;
            int n2 = 0;
            while (n2 < n) {
                IModules.IModuleDMContext moduleContext = iModuleDMContextArray[n2];
                Modules.ModuleDMC moduleDMC = (Modules.ModuleDMC)moduleContext;
                modulesElement.appendChild(moduleDMC.takeSnapshot(album, document, (IProgressMonitor)modulesMonitor.newChild(1000)));
                ++n2;
            }
            contextElement.appendChild(modulesElement);
            return contextElement;
        }

        @Override
        public boolean canDetach() {
            return this.hasTCFContext();
        }

        @Override
        public boolean canStep() {
            return false;
        }
    }

    public static class ResumedEvent
    extends DMCResumedEvent
    implements IRunControl.IResumedDMEvent {
        public ResumedEvent(IRunControl.IExecutionDMContext dmc) {
            super(dmc);
        }
    }

    public class RootExecutionDMC
    extends ExecutionDMC
    implements ISourceLookup.ISourceLookupDMContext {
        public RootExecutionDMC(Map<String, Object> props) {
            super(null, props, null);
        }

        @Override
        public ExecutionDMC contextAdded(Map<String, Object> properties, IRunControl.RunControlContext tcfContext) {
            ExecutionDMC newDMC = RunControl.getProperty(properties, RunControl.PROP_IS_CONTAINER, true) ? new ProcessExecutionDMC(this, properties, tcfContext) : new BareDeviceExecutionDMC(this, properties, tcfContext);
            RunControl.this.getSession().dispatchEvent((Object)new StartedEvent(newDMC), RunControl.this.getProperties());
            return newDMC;
        }

        @Override
        public IModules.ISymbolDMContext getSymbolDMContext() {
            return null;
        }

        @Override
        public boolean canDetach() {
            return false;
        }

        @Override
        public boolean canStep() {
            return false;
        }
    }

    public static class StartedEvent
    extends AbstractDMEvent<IRunControl.IExecutionDMContext>
    implements IRunControl.IStartedDMEvent {
        public StartedEvent(IRunControl.IExecutionDMContext context) {
            super((IDMContext)context);
        }
    }

    public static class SuspendedEvent
    extends DMCSuspendedEvent
    implements IRunControl.ISuspendedDMEvent {
        public SuspendedEvent(IRunControl.IExecutionDMContext dmc, IRunControl.StateChangeReason reason, Map<String, Object> params) {
            super(dmc, reason, params);
        }
    }

    public class ThreadExecutionDMC
    extends ExecutionDMC
    implements IProcesses.IThreadDMContext,
    IDisassembly.IDisassemblyDMContext {
        public ThreadExecutionDMC(ExecutionDMC parent, Map<String, Object> properties, IRunControl.RunControlContext tcfContext) {
            super(parent, properties, tcfContext);
            if (EDCTrace.RUN_CONTROL_TRACE_ON) {
                EDCTrace.getTrace().traceEntry(null, (Object[])EDCTrace.fixArgs(new Object[]{parent, properties}));
                EDCTrace.getTrace().traceExit(null);
            }
        }

        @Override
        public IModules.ISymbolDMContext getSymbolDMContext() {
            return (IModules.ISymbolDMContext)DMContexts.getAncestorOfType((IDMContext)this, IModules.ISymbolDMContext.class);
        }

        @Override
        public void loadSnapshot(Element element) throws Exception {
            super.loadSnapshot(element);
            Registers regService = RunControl.this.getService(Registers.class);
            regService.loadGroupsForContext(this, element);
            Stack stackService = RunControl.this.getService(Stack.class);
            NodeList frameElements = element.getElementsByTagName(RunControl.EXECUTION_CONTEXT_FRAMES);
            int i = 0;
            while (i < frameElements.getLength()) {
                Element frameElement = (Element)frameElements.item(i);
                stackService.loadFramesForContext(this, frameElement);
                ++i;
            }
            RunControl.this.getSession().dispatchEvent((Object)this.createSuspendedEvent(IRunControl.StateChangeReason.EXCEPTION, new HashMap<String, Object>()), RunControl.this.getProperties());
        }

        @Override
        public Element takeSnapshot(IAlbum album, Document document, IProgressMonitor monitor) throws Exception {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1000);
            progress.subTask(this.getName());
            Element contextElement = super.takeSnapshot(album, document, (IProgressMonitor)progress.newChild(100));
            Element registersElement = document.createElement(RunControl.EXECUTION_CONTEXT_REGISTERS);
            Registers regService = RunControl.this.getService(Registers.class);
            IRegisters.IRegisterGroupDMContext[] regGroups = regService.getGroupsForContext(this);
            SubMonitor registerMonitor = progress.newChild(300);
            registerMonitor.setWorkRemaining(regGroups.length * 1000);
            registerMonitor.subTask("Registers");
            IRegisters.IRegisterGroupDMContext[] iRegisterGroupDMContextArray = regGroups;
            int n = regGroups.length;
            int n2 = 0;
            while (n2 < n) {
                IRegisters.IRegisterGroupDMContext registerGroupDMContext = iRegisterGroupDMContextArray[n2];
                Registers.RegisterGroupDMC regDMC = (Registers.RegisterGroupDMC)registerGroupDMContext;
                registersElement.appendChild(regDMC.takeSnapshot(album, document, (IProgressMonitor)registerMonitor.newChild(1000)));
                ++n2;
            }
            contextElement.appendChild(registersElement);
            Element framesElement = document.createElement(RunControl.EXECUTION_CONTEXT_FRAMES);
            Stack stackService = RunControl.this.getService(Stack.class);
            Expressions expressionsService = RunControl.this.getService(Expressions.class);
            IStack.IFrameDMContext[] frames = stackService.getFramesForDMC(this, 0, -1);
            SubMonitor framesMonitor = progress.newChild(600);
            framesMonitor.setWorkRemaining(frames.length * 2000);
            framesMonitor.subTask("Stack Frames");
            IStack.IFrameDMContext[] iFrameDMContextArray = frames;
            int n3 = frames.length;
            int n4 = 0;
            while (n4 < n3) {
                IStack.IFrameDMContext frameDMContext = iFrameDMContextArray[n4];
                Stack.StackFrameDMC frameDMC = (Stack.StackFrameDMC)frameDMContext;
                IStack.IVariableDMContext[] variables = frameDMC.getLocals();
                SubMonitor variablesMonitor = framesMonitor.newChild(1000);
                variablesMonitor.setWorkRemaining(variables.length * 10);
                variablesMonitor.subTask("Variables");
                IStack.IVariableDMContext[] iVariableDMContextArray = variables;
                int n5 = variables.length;
                int n6 = 0;
                while (n6 < n5) {
                    IStack.IVariableDMContext iVariableDMContext = iVariableDMContextArray[n6];
                    Stack.VariableDMC varDMC = (Stack.VariableDMC)iVariableDMContext;
                    IExpressions.IExpressionDMContext expression = expressionsService.createExpression((IDMContext)frameDMContext, varDMC.getName());
                    boolean wasEnabled = FormatExtensionManager.instance().isEnabled();
                    FormatExtensionManager.instance().setEnabled(true);
                    expressionsService.loadExpressionValues(expression, Album.getVariableCaptureDepth());
                    FormatExtensionManager.instance().setEnabled(wasEnabled);
                    variablesMonitor.worked(10);
                    variablesMonitor.subTask("Variables - " + varDMC.getName());
                    ++n6;
                }
                framesElement.appendChild(frameDMC.takeSnapshot(album, document, (IProgressMonitor)framesMonitor.newChild(1000)));
                ++n4;
            }
            contextElement.appendChild(framesElement);
            return contextElement;
        }

        @Override
        public ExecutionDMC contextAdded(Map<String, Object> properties, IRunControl.RunControlContext tcfContext) {
            assert (false);
            return null;
        }

        @Override
        public boolean canDetach() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean canStep() {
            if (this.isSuspended()) {
                Map map = this.properties;
                synchronized (map) {
                    return !RunControl.getProperty(this.properties, RunControl.PROP_DISABLE_STEPPING, false);
                }
            }
            return false;
        }
    }
}

