/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.symbols.dwarf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.edc.internal.symbols.CompileUnitScope;
import org.eclipse.cdt.debug.edc.internal.symbols.dwarf.DwarfDebugInfoProvider;
import org.eclipse.cdt.debug.edc.internal.symbols.dwarf.DwarfInfoReader;
import org.eclipse.cdt.debug.edc.symbols.IFunctionScope;
import org.eclipse.cdt.debug.edc.symbols.ILineEntry;
import org.eclipse.cdt.debug.edc.symbols.IModuleScope;
import org.eclipse.cdt.debug.edc.symbols.IScope;
import org.eclipse.cdt.debug.edc.symbols.IVariable;
import org.eclipse.core.runtime.IPath;

public class DwarfCompileUnit
extends CompileUnitScope {
    protected DwarfDebugInfoProvider provider;
    protected DwarfDebugInfoProvider.AttributeList attributes;
    private List<IPath> fileList;
    private boolean rangesDirty;
    protected final DwarfDebugInfoProvider.CompilationUnitHeader header;
    protected boolean parsedForVarsAndAddresses = false;
    protected boolean parsedForTypes = false;

    public DwarfCompileUnit(DwarfDebugInfoProvider provider, IModuleScope parent, IPath filePath, IAddress lowAddress, IAddress highAddress, DwarfDebugInfoProvider.CompilationUnitHeader header, boolean hasChildren, DwarfDebugInfoProvider.AttributeList attributes) {
        super(filePath, parent, lowAddress, highAddress);
        this.provider = provider;
        this.attributes = attributes;
        this.header = header;
        if (!hasChildren) {
            this.parsedForVarsAndAddresses = true;
            this.parsedForTypes = true;
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.header.debugInfoOffset;
        result = 31 * result + this.provider.getSymbolFile().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DwarfCompileUnit other = (DwarfCompileUnit)obj;
        if (this.header.debugInfoOffset != other.header.debugInfoOffset) {
            return false;
        }
        return this.provider.getSymbolFile().equals((Object)other.provider.getSymbolFile());
    }

    public DwarfDebugInfoProvider.AttributeList getAttributeList() {
        return this.attributes;
    }

    @Override
    protected Collection<ILineEntry> parseLineTable() {
        DwarfInfoReader reader = new DwarfInfoReader(this.provider);
        this.fileList = new ArrayList<IPath>();
        return reader.parseLineTable(this, this.attributes, this.fileList);
    }

    @Override
    public void setLowAddress(IAddress address) {
        this.lowAddress = address;
    }

    @Override
    public void setHighAddress(IAddress address) {
        this.highAddress = address;
    }

    @Override
    public IAddress getLowAddress() {
        return super.getLowAddress();
    }

    @Override
    public IAddress getHighAddress() {
        return super.getHighAddress();
    }

    @Override
    public IFunctionScope getFunctionAtAddress(IAddress linkAddress) {
        if (this.rangesDirty) {
            this.fixupRanges();
        }
        this.ensureParsedForAddresses();
        return super.getFunctionAtAddress(linkAddress);
    }

    @Override
    public Collection<IFunctionScope> getFunctions() {
        this.ensureParsedForAddresses();
        return super.getFunctions();
    }

    protected void fixupRanges() {
        if (this.hasEmptyRange() && this.parsedForVarsAndAddresses) {
            this.fixupRanges(this.provider.getBaseLinkAddress());
        }
        this.rangesDirty = false;
    }

    @Override
    public Collection<IScope> getChildren() {
        return super.getChildren();
    }

    public void setAttributes(DwarfDebugInfoProvider.AttributeList attributes) {
        this.attributes = attributes;
    }

    public boolean isParsedForAddresses() {
        return this.parsedForVarsAndAddresses;
    }

    public boolean isParsedForVariables() {
        return this.parsedForVarsAndAddresses;
    }

    public boolean isParsedForTypes() {
        return this.parsedForTypes;
    }

    @Override
    public Collection<IVariable> getVariables() {
        this.ensureParsedForVariables();
        return super.getVariables();
    }

    public void setParsedForAddresses(boolean parsedForAddresses) {
        this.parsedForVarsAndAddresses = parsedForAddresses;
    }

    public void setParsedForVariables(boolean parsedForVariables) {
        this.parsedForVarsAndAddresses = parsedForVariables;
    }

    public void setParsedForTypes(boolean parsedForTypes) {
        this.parsedForTypes = parsedForTypes;
    }

    private void ensureParsedForAddresses() {
        if (!this.parsedForVarsAndAddresses) {
            DwarfInfoReader reader = new DwarfInfoReader(this.provider);
            reader.parseCompilationUnitForAddresses(this);
        }
    }

    public IPath getFileEntry(int declFileNum) {
        if (this.fileList == null) {
            this.parseLineTable();
        }
        if (declFileNum <= 0 || declFileNum > this.fileList.size()) {
            return null;
        }
        return this.fileList.get(declFileNum - 1);
    }

    private void ensureParsedForVariables() {
        if (!this.parsedForVarsAndAddresses) {
            DwarfInfoReader reader = new DwarfInfoReader(this.provider);
            reader.parseCompilationUnitForAddresses(this);
        }
    }

    @Override
    public IScope getScopeAtAddress(IAddress linkAddress) {
        this.ensureParsedForAddresses();
        return super.getScopeAtAddress(linkAddress);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DwarfCompileUnit [");
        builder.append("SymFile=");
        builder.append(this.provider.getSymbolFile().lastSegment());
        builder.append(", SectionOffset=0x");
        builder.append(Integer.toHexString(this.header.debugInfoOffset));
        builder.append(", lowAddr=");
        builder.append(this.lowAddress != null ? this.lowAddress.toHexAddressString() : null);
        builder.append(", highAddr=");
        builder.append(this.highAddress != null ? this.highAddress.toHexAddressString() : null);
        if (this.filePath != null) {
            builder.append(", path=");
            builder.append(this.filePath.toOSString());
        }
        builder.append(", parsedForVarsAndAddresses=");
        builder.append(this.parsedForVarsAndAddresses);
        builder.append(", parsedForTypes=");
        builder.append(this.parsedForTypes);
        builder.append("]\n");
        return builder.toString();
    }

    @Override
    public void addChild(IScope scope) {
        super.addChild(scope);
        if (this.hasEmptyRange()) {
            this.rangesDirty = true;
        } else {
            this.mergeScopeRange(scope);
        }
        this.addLineInfoToParent(scope);
    }
}

