/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.symbols.files;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.debug.edc.IStreamBuffer;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.FileStreamBuffer;
import org.eclipse.cdt.debug.edc.internal.MemoryStreamBuffer;
import org.eclipse.cdt.debug.edc.internal.symbols.files.FileStatistics;
import org.eclipse.cdt.debug.edc.internal.symbols.files.ISectionMapper;
import org.eclipse.cdt.debug.edc.internal.symbols.files.SectionInfo;
import org.eclipse.cdt.utils.ERandomAccessFile;
import org.eclipse.core.runtime.IPath;

public class SectionMapper
implements ISectionMapper {
    private final IPath hostFile;
    private final boolean isLE;
    private ERandomAccessFile efile;
    private Map<SectionInfo, IStreamBuffer> loadedSections;
    private Map<SectionInfo, IStreamBuffer> mappedBuffers;

    public SectionMapper(IPath hostFile, boolean isLE) {
        this.hostFile = hostFile;
        this.isLE = isLE;
        this.efile = null;
        this.loadedSections = new HashMap<SectionInfo, IStreamBuffer>();
        this.mappedBuffers = new HashMap<SectionInfo, IStreamBuffer>();
    }

    @Override
    public void dispose() {
        for (Map.Entry<SectionInfo, IStreamBuffer> entry : this.loadedSections.entrySet()) {
            IStreamBuffer buffer = entry.getValue();
            if (buffer == null) continue;
            if (this.mappedBuffers.containsKey(entry.getKey())) {
                FileStatistics.currentMemoryMappedBuffers -= buffer.capacity();
                continue;
            }
            FileStatistics.currentHeapAllocatedBuffers -= buffer.capacity();
        }
        this.loadedSections.clear();
        this.mappedBuffers.clear();
        this.close();
    }

    @Override
    public IPath getMappedFile() {
        return this.hostFile;
    }

    private void ensureOpen() throws IOException {
        if (this.efile == null) {
            FileStatistics.log("Opening " + this.hostFile.toFile());
            ++FileStatistics.executablesOpened;
            ++FileStatistics.executablesOpen;
            this.efile = new ERandomAccessFile(this.hostFile.toFile(), "r");
        }
    }

    private void close() {
        if (!this.mappedBuffers.isEmpty()) {
            throw new IllegalStateException("cannot close file; mapped buffers open");
        }
        if (this.efile != null) {
            try {
                FileStatistics.log("Closing " + this.hostFile.toFile());
                --FileStatistics.executablesOpen;
                this.efile.close();
            }
            catch (IOException iOException) {}
        }
        this.efile = null;
    }

    @Override
    public IStreamBuffer getSectionBuffer(SectionInfo section) throws IOException {
        this.ensureOpen();
        IStreamBuffer buffer = this.loadedSections.get(section);
        if (buffer == null) {
            buffer = this.loadSection(section);
            this.loadedSections.put(section, buffer);
        }
        return buffer;
    }

    private IStreamBuffer loadSection(SectionInfo section) throws IOException {
        FileStatistics.log("Loading " + section + " from " + this.hostFile.toFile());
        IStreamBuffer buffer = null;
        try {
            buffer = section.sectionSize > 0x400000L ? this.loadSectionIntoFileStreamBuffer(section) : this.loadSectionIntoHeap(section);
        }
        catch (IOException iOException) {
            buffer = this.loadSectionIntoHeap(section);
        }
        return buffer;
    }

    private IStreamBuffer loadSectionIntoFileStreamBuffer(SectionInfo section) throws IOException {
        FileStreamBuffer buffer = null;
        try {
            buffer = new FileStreamBuffer((RandomAccessFile)this.efile, this.isLE ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN, section.fileOffset, section.sectionSize);
            this.mappedBuffers.put(section, buffer);
            FileStatistics.currentMemoryMappedBuffers += buffer.capacity();
            FileStatistics.totalMemoryMappedBuffers += buffer.capacity();
        }
        catch (Throwable e2) {
            EDCDebugger.getMessageLogger().logError("Failed to make buffer for section " + section, e2);
        }
        return buffer;
    }

    private IStreamBuffer loadSectionIntoHeap(SectionInfo section) throws IOException {
        byte[] data = new byte[(int)section.sectionSize];
        this.efile.seek(section.fileOffset);
        this.efile.read(data);
        MemoryStreamBuffer buffer = new MemoryStreamBuffer(data, this.isLE ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
        FileStatistics.currentHeapAllocatedBuffers += (long)data.length;
        FileStatistics.totalHeapAllocatedBuffers += (long)data.length;
        return buffer;
    }

    @Override
    public void releaseSectionBuffer(SectionInfo section) {
        IStreamBuffer buffer = this.loadedSections.remove(section);
        if (buffer != null) {
            if (this.mappedBuffers.remove(section) != null) {
                FileStatistics.currentMemoryMappedBuffers -= buffer.capacity();
                if (this.mappedBuffers.isEmpty()) {
                    this.close();
                }
            } else {
                FileStatistics.currentHeapAllocatedBuffers -= buffer.capacity();
            }
        }
    }
}

