/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sdblib.receiver;

import java.util.ArrayList;
import java.util.Collection;
import org.tizen.sdblib.dlog.DlogFormat;
import org.tizen.sdblib.dlog.DlogInfo;
import org.tizen.sdblib.receiver.MultiLineReceiver;
import org.tizen.sdblib.util.DlogUtil;

public class DlogReceiver
extends MultiLineReceiver {
    private DlogFormat dlogFormat;
    private Collection<DlogInfo> dlogUtilLogs = new ArrayList<DlogInfo>();

    public DlogReceiver(DlogFormat format) {
        this.dlogFormat = format;
    }

    @Override
    public void processNewLines(String[] lines) {
        DlogInfo[] infos = DlogUtil.getDlogInfos(this.dlogFormat, lines);
        if (infos != null) {
            DlogInfo[] dlogInfoArray = infos;
            int n = infos.length;
            int n2 = 0;
            while (n2 < n) {
                DlogInfo info = dlogInfoArray[n2];
                this.dlogUtilLogs.add(info);
                ++n2;
            }
        }
    }

    public DlogInfo[] getDlogInfos() {
        return this.dlogUtilLogs.toArray(new DlogInfo[this.dlogUtilLogs.size()]);
    }

    protected DlogFormat getDlogFormat() {
        return this.dlogFormat;
    }

    public void setDlogFormat(DlogFormat dlogFormat) {
        this.dlogFormat = dlogFormat;
    }
}

