/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.setting;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.tizen.dynamicanalyzer.protocol.Protocol;
import org.tizen.dynamicanalyzer.setting.Feature;
import org.tizen.dynamicanalyzer.setting.FeatureValueData;
import org.tizen.dynamicanalyzer.setting.FlatFeature;
import org.tizen.dynamicanalyzer.setting.FlatPreferences;
import org.tizen.dynamicanalyzer.setting.SettingDataManager;
import org.tizen.dynamicanalyzer.setting.Template;

public class TargetData {
    private String targetName = null;
    private Protocol protocolVersion = Protocol.VERSION_UNKNOWN;
    private List<FlatFeature> availableFlatFeatures = new ArrayList<FlatFeature>();
    private List<FlatFeature> initFlatFeatures = new ArrayList<FlatFeature>();
    private List<FlatFeature> selectedFlatFeatures = new ArrayList<FlatFeature>();
    private List<String> availableChartList = new ArrayList<String>();

    public TargetData(String targetName) {
        this.targetName = targetName;
    }

    protected void cloneProperties(TargetData source) {
        this.protocolVersion = source.protocolVersion;
        this.availableFlatFeatures.clear();
        this.availableFlatFeatures.addAll(source.availableFlatFeatures);
        this.selectedFlatFeatures.clear();
        this.selectedFlatFeatures.addAll(source.selectedFlatFeatures);
        this.availableChartList.clear();
        this.availableChartList.addAll(source.availableChartList);
    }

    public String getTargetName() {
        return this.targetName;
    }

    public Protocol getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setAvailableChartList(List<String> availableChartList) {
        this.availableChartList.clear();
        this.availableChartList.addAll(availableChartList);
    }

    @Deprecated
    public Template getSelectedTemplate() {
        return null;
    }

    @Deprecated
    public void setSelectedTemplate(Template template) {
    }

    @Deprecated
    public List<Template> getAvailableTemplateList() {
        return new ArrayList<Template>();
    }

    @Deprecated
    public List<Feature> getAvailableFeatureList() {
        return new ArrayList<Feature>();
    }

    public List<FlatFeature> getAvailableFlatFeatures() {
        return Collections.unmodifiableList(this.availableFlatFeatures);
    }

    public List<String> getAvailableChartList() {
        return Collections.unmodifiableList(this.availableChartList);
    }

    @Deprecated
    public void setSelectedFeatureList(List<FeatureValueData> selectedFeatureList) {
    }

    public void setSelectedFlatFeatures(Set<FlatFeature> set) {
        this.selectedFlatFeatures.clear();
        this.selectedFlatFeatures.addAll(set);
    }

    @Deprecated
    public void addSelectedFeature(String featureName) {
    }

    public void addSelectedFlatFeature(String featureName) {
        FlatFeature feature = FlatFeature.getFlatFeature(featureName);
        if (feature != null) {
            if (!this.selectedFlatFeatures.contains((Object)feature)) {
                this.selectedFlatFeatures.add(feature);
            }
            if (feature == FlatFeature.SCREENSHOT) {
                SettingDataManager.INSTANCE.setPreferenceSelected(FlatPreferences.SCREENSHOT_ON_SCENE_TRANSITION, true);
            } else if (feature == FlatFeature.THREAD_ANALYSIS) {
                SettingDataManager.INSTANCE.deletePreference(FlatPreferences.LEAK_SANITIZER);
            }
        }
    }

    @Deprecated
    public void removeSelectedFeature(String featureName) {
    }

    public void removeSelectedFlatFeature(String featureName) {
        FlatFeature feature = FlatFeature.getFlatFeature(featureName);
        if (feature != null) {
            this.selectedFlatFeatures.remove((Object)feature);
            if (feature == FlatFeature.SCREENSHOT) {
                SettingDataManager.INSTANCE.deletePreference(FlatPreferences.SCREENSHOT_ON_SCENE_TRANSITION);
                SettingDataManager.INSTANCE.deletePreference(FlatPreferences.SCREENSHOT_PERIODICALLY);
            }
            if (feature == FlatFeature.MEMORY_ALLOC) {
                SettingDataManager.INSTANCE.deletePreference(FlatPreferences.LEAK_SANITIZER);
            }
        }
    }

    @Deprecated
    public void clearSelectedFeature() {
    }

    @Deprecated
    public List<FeatureValueData> getSelectedFeatureList() {
        return new ArrayList<FeatureValueData>();
    }

    public List<FlatFeature> getSelectedFlatFeatures() {
        return Collections.unmodifiableList(this.selectedFlatFeatures);
    }

    public boolean isSelectedFlatFeature(String name) {
        FlatFeature feature = FlatFeature.getFlatFeature(name);
        return this.selectedFlatFeatures.contains((Object)feature);
    }

    @Deprecated
    public void changeSelectedFeatureList(Template template) {
    }

    @Deprecated
    public int getSelectedFeatureValue(Feature feature) {
        return -1;
    }

    public void makeDetailInformation(String[] list) {
        if (list[1].equals("Protocol Version")) {
            this.protocolVersion = Protocol.getVersion(list[2]);
        } else if (list[1].equals("Available FlatFeature List")) {
            this.makeAvailableFlatFeatureList(list);
        } else if (list[1].equals("Selected FlatFeature List")) {
            this.makeSelectedFlatFeatureList(list);
        } else if (list[1].equals("Available Chart List")) {
            this.makeAvailableChartList(list);
        }
    }

    private void makeAvailableFlatFeatureList(String[] list) {
        this.availableFlatFeatures.clear();
        if (list != null) {
            int i = 2;
            while (i < list.length) {
                this.availableFlatFeatures.add(FlatFeature.getFlatFeature(Integer.parseInt(list[i])));
                ++i;
            }
        }
    }

    private void makeSelectedFlatFeatureList(String[] list) {
        this.selectedFlatFeatures.clear();
        int i = 2;
        while (i < list.length) {
            String[] valueList = list[i].split(":");
            FlatFeature feature = FlatFeature.getFlatFeature(Integer.parseInt(valueList[0]));
            this.selectedFlatFeatures.add(feature);
            ++i;
        }
        this.copyFlatFeatures(this.selectedFlatFeatures, this.initFlatFeatures);
    }

    private void makeAvailableChartList(String[] list) {
        this.availableChartList.clear();
        if (list != null) {
            int i = 2;
            while (i < list.length) {
                this.availableChartList.add(list[i]);
                ++i;
            }
        }
    }

    public void writeSelectedData(PrintWriter writer) throws IOException {
        writer.println(String.valueOf(this.targetName) + "|" + "Protocol Version" + "|" + (Object)((Object)this.protocolVersion));
        writer.println(String.valueOf(this.targetName) + "|" + "Available FlatFeature List" + "|" + this.writeAvailableFlatFeaturesData());
        writer.println(String.valueOf(this.targetName) + "|" + "Selected FlatFeature List" + "|" + this.writeSelectedFlatFeaturesData());
        writer.println(String.valueOf(this.targetName) + "|" + "Available Chart List" + "|" + this.writeAvailableChartListData());
        writer.checkError();
    }

    private String writeSelectedFlatFeaturesData() {
        StringBuffer buffer = new StringBuffer();
        Iterator<FlatFeature> iter = this.selectedFlatFeatures.iterator();
        while (iter.hasNext()) {
            FlatFeature feature = iter.next();
            buffer.append(feature.getIndex());
            if (!iter.hasNext()) continue;
            buffer.append("|");
        }
        return buffer.toString();
    }

    private String writeAvailableChartListData() {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.availableChartList.size()) {
            if (i < this.availableChartList.size() - 1) {
                buffer.append(String.valueOf(this.availableChartList.get(i)) + "|");
            } else {
                buffer.append(this.availableChartList.get(i));
            }
            ++i;
        }
        return buffer.toString();
    }

    private String writeAvailableFlatFeaturesData() {
        StringBuffer buffer = new StringBuffer();
        Iterator<FlatFeature> iter = this.availableFlatFeatures.iterator();
        while (iter.hasNext()) {
            FlatFeature feature = iter.next();
            if (iter.hasNext()) {
                buffer.append(String.valueOf(feature.getIndex()) + "|");
                continue;
            }
            buffer.append(feature.getIndex());
        }
        return buffer.toString();
    }

    public boolean changedFlatFeatures() {
        if (this.selectedFlatFeatures.size() != this.initFlatFeatures.size()) {
            return true;
        }
        return !this.selectedFlatFeatures.containsAll(this.initFlatFeatures);
    }

    public void applySettingData() {
        this.copyFlatFeatures(this.selectedFlatFeatures, this.initFlatFeatures);
    }

    public void revertSettingData() {
        this.copyFlatFeatures(this.initFlatFeatures, this.selectedFlatFeatures);
    }

    private void copyFlatFeatures(List<FlatFeature> source, List<FlatFeature> dest) {
        dest.clear();
        if (source.isEmpty()) {
            return;
        }
        dest.addAll(source);
    }
}

