/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.swap.communicator;

import java.util.List;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.common.DAResult;
import org.tizen.dynamicanalyzer.communicator.DeviceInfo;
import org.tizen.dynamicanalyzer.communicator.DeviceManager;
import org.tizen.dynamicanalyzer.communicator.UnsupportedProtocolException;
import org.tizen.dynamicanalyzer.util.Logger;

public class HeartBeatThread
implements Runnable {
    private static int interval = 1000;

    @Override
    public void run() {
        List<DeviceInfo> devices = null;
        try {
            while (true) {
                devices = DeviceManager.getDevices();
                for (DeviceInfo device : devices) {
                    DAResult result;
                    try {
                        result = device.getCommunicator().getSubCommunicator().sendKeepAliveMessage(null);
                    }
                    catch (UnsupportedProtocolException unsupportedProtocolException) {
                        result = new DAResult(DAResult.ErrorCode.ERR_PROTOCOL_NOT_SUPPORTED);
                    }
                    if (!result.isSuccess()) {
                        Logger.warning((Object)result.toString());
                    }
                    HeartBeatThread.testExit();
                }
                Thread.sleep(interval);
                HeartBeatThread.testExit();
            }
        }
        catch (InterruptedException e) {
            Logger.exception((Throwable)e);
            return;
        }
    }

    public static void setInterval(int miliSec) {
        interval = miliSec;
    }

    private static void testExit() throws InterruptedException {
        if (AnalyzerManager.isExit()) {
            throw new InterruptedException();
        }
    }
}

