/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.swap.model.data.hierarchy.evas;

import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.communicator.ProtocolParser;
import org.tizen.dynamicanalyzer.protocol.Protocol;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.HierarchyUIObjectProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.PropertyValue;
import org.tizen.dynamicanalyzer.util.Logger;

public class EvasImageProperties
extends HierarchyUIObjectProperties {
    private double loadDpi;
    private boolean sourceClip;
    private boolean filled;
    private String contentHint;
    private boolean alpha;
    private int[] border = new int[4];
    private double borderScale;
    private boolean pixelDirty;
    private boolean loadOrientation;
    private String borderCenterFill;
    private int[] size = new int[2];
    private boolean sourceVisible;
    private int[] fill = new int[4];
    private int loadScaleDown;
    private String scaleHint;
    private boolean sourceEvents;
    private int animatedFrameCount;
    private int stride;

    public EvasImageProperties(Protocol protocolVersion) {
        super(protocolVersion);
    }

    @Override
    public void parsePropertiesFromByte(ProtocolParser parser) {
        this.loadDpi = parser.getFloat();
        this.sourceClip = parser.getBoolean();
        this.filled = parser.getBoolean();
        this.contentHint = this.getContentHintMessage(parser.getChar());
        this.alpha = parser.getBoolean();
        this.border[0] = parser.getInt();
        this.border[1] = parser.getInt();
        this.border[2] = parser.getInt();
        this.border[3] = parser.getInt();
        this.borderScale = parser.getFloat();
        this.pixelDirty = parser.getBoolean();
        this.loadOrientation = parser.getBoolean();
        this.borderCenterFill = this.getBorderCenterFillMessage(parser.getChar());
        this.size[0] = parser.getInt();
        this.size[1] = parser.getInt();
        if (this.protocolVersion != Protocol.VERSION_30_UIHV) {
            this.sourceVisible = parser.getBoolean();
        }
        this.fill[0] = parser.getInt();
        this.fill[1] = parser.getInt();
        this.fill[2] = parser.getInt();
        this.fill[3] = parser.getInt();
        this.loadScaleDown = parser.getInt();
        this.scaleHint = this.getScaleHintMessage(parser.getChar());
        if (this.protocolVersion != Protocol.VERSION_30_UIHV) {
            this.sourceEvents = parser.getBoolean();
            this.animatedFrameCount = parser.getInt();
        }
        this.stride = parser.getInt();
    }

    @Override
    public List<PropertyValue> getProperties() {
        ArrayList<PropertyValue> properties = new ArrayList<PropertyValue>();
        properties.add(new PropertyValue("loadDpi", Double.toString(this.loadDpi)));
        properties.add(new PropertyValue("sourceClip", Boolean.toString(this.sourceClip)));
        properties.add(new PropertyValue("filled", Boolean.toString(this.filled)));
        properties.add(new PropertyValue("contentHint", this.contentHint));
        properties.add(new PropertyValue("alpha", Boolean.toString(this.alpha)));
        properties.add(new PropertyValue("border", "[" + this.border[0] + ", " + this.border[1] + ", " + this.border[2] + ", " + this.border[3] + "]"));
        properties.add(new PropertyValue("borderScale", Double.toString(this.borderScale)));
        properties.add(new PropertyValue("pixelDirty", Boolean.toString(this.pixelDirty)));
        properties.add(new PropertyValue("loadOrientation", Boolean.toString(this.loadOrientation)));
        properties.add(new PropertyValue("borderCenterFill", this.borderCenterFill));
        properties.add(new PropertyValue("size", "[" + this.size[0] + ", " + this.size[1] + "]"));
        if (this.protocolVersion != Protocol.VERSION_30_UIHV) {
            properties.add(new PropertyValue("sourceVisible", Boolean.toString(this.sourceVisible)));
        }
        properties.add(new PropertyValue("loadScaleDown", Integer.toString(this.loadScaleDown)));
        properties.add(new PropertyValue("scaleHint", this.scaleHint));
        if (this.protocolVersion != Protocol.VERSION_30_UIHV) {
            properties.add(new PropertyValue("sourceEvents", Boolean.toString(this.sourceEvents)));
            properties.add(new PropertyValue("animatedFrameCount", Integer.toString(this.animatedFrameCount)));
        }
        properties.add(new PropertyValue("stride", Integer.toString(this.stride)));
        return properties;
    }

    private String getContentHintMessage(int code) {
        switch (code) {
            case 0: {
                return "EVAS_IMAGE_CONTENT_HINT_NONE";
            }
            case 1: {
                return "EVAS_IMAGE_CONTENT_HINT_DYNAMIC";
            }
            case 2: {
                return "EVAS_IMAGE_CONTENT_HINT_STATIC";
            }
        }
        Logger.warning((Object)("Invalid code : " + code));
        return "-";
    }

    private String getBorderCenterFillMessage(int code) {
        switch (code) {
            case 0: {
                return "EVAS_BORDER_FILL_NONE";
            }
            case 1: {
                return "EVAS_BORDER_FILL_DEFAULT";
            }
            case 2: {
                return "EVAS_BORDER_FILL_SOLID";
            }
        }
        Logger.warning((Object)("Invalid code : " + code));
        return "-";
    }

    private String getScaleHintMessage(int code) {
        switch (code) {
            case 0: {
                return "EVAS_IMAGE_SCALE_HINT_NONE";
            }
            case 1: {
                return "EVAS_IMAGE_SCALE_HINT_DYNAMIC";
            }
            case 2: {
                return "EVAS_IMAGE_SCALE_HINT_STATIC";
            }
        }
        Logger.warning((Object)("Invalid code : " + code));
        return "-";
    }
}

