/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.swap.platform.ui;

import java.io.File;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.tizen.dynamicanalyzer.common.path.PathManager;
import org.tizen.dynamicanalyzer.nl.AnalyzerLabels;
import org.tizen.dynamicanalyzer.nl.WidgetLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.swap.platform.ui.SettingSaveTable;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableComposite;
import org.tizen.dynamicanalyzer.ui.widgets.table.DefaultTableComparator;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButton;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonClickEventListener;
import org.tizen.dynamicanalyzer.widgets.da.base.DAButton;
import org.tizen.dynamicanalyzer.widgets.da.base.DAMessageBox;

public class LoadSettingDialog
extends DAMessageBox {
    public static int SAVE_FOLDER = 0;
    public static int TEMP_FOLDER = 1;
    public static String VERSION_KEY = "version";
    public static int VERSION_INVALID = 0;
    public static int VERSION_VALID = 1;
    public static String CURRENT_KEY = "current";
    public static int CURRENT = 0;
    public static int OTHERS = 1;
    private DATableComposite saveTable = null;
    private DACustomButton okButton = null;
    private DACustomButton cancelButton = null;
    private String[] columnNames = new String[]{"File name"};
    private int[] columnSizes = new int[]{390};
    private boolean[] columnVisibility = new boolean[]{true};
    int[] sortTypes = new int[]{3};
    private DACustomButtonClickEventListener okButtonListener = new DACustomButtonClickEventListener(){

        public void handleClickEvent(DACustomButton button) {
            Grid selectedTable = LoadSettingDialog.this.saveTable.getTable();
            GridItem[] selections = selectedTable.getSelection();
            if (selections == null || selections.length == 0) {
                return;
            }
            GridItem selection = selections[0];
            String openPath = String.valueOf(PathManager.DA_SETTING_PATH) + File.separator + selection.getText();
            LoadSettingDialog.this.openAction(openPath);
            LoadSettingDialog.this.shell.dispose();
        }
    };
    private DACustomButtonClickEventListener cancelButtonListener = new DACustomButtonClickEventListener(){

        public void handleClickEvent(DACustomButton button) {
            LoadSettingDialog.this.shell.dispose();
        }
    };
    private MouseListener mouseListener = new MouseListener(){

        public void mouseUp(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseDoubleClick(MouseEvent e) {
            Grid grid = (Grid)e.widget;
            GridItem[] items = grid.getSelection();
            if (items.length == 0) {
                return;
            }
            GridItem item = items[0];
            String openPath = String.valueOf(PathManager.DA_SETTING_PATH) + File.separator + item.getText();
            LoadSettingDialog.this.openAction(openPath);
            LoadSettingDialog.this.shell.dispose();
        }
    };
    private KeyListener keyListener = new KeyListener(){

        public void keyReleased(KeyEvent e) {
            if (e.keyCode == 127) {
                Grid grid = (Grid)e.widget;
                GridItem[] items = grid.getSelection();
                if (items.length == 0) {
                    return;
                }
                int index = grid.getSelectionIndex();
                GridItem item = items[0];
                String openPath = String.valueOf(PathManager.DA_SETTING_PATH) + File.separator + item.getText();
                if (AnalyzerUtil.deleteFile(new File(openPath))) {
                    grid.remove(index);
                } else {
                    Logger.debug((Object)"delete save file failed...");
                }
            }
        }

        public void keyPressed(KeyEvent e) {
        }
    };

    public LoadSettingDialog(Shell parent) {
        super(parent);
    }

    protected boolean run() {
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setSize(400, 204);
        AnalyzerUtil.setCenter(this.shell);
        this.shell.setText("Load Binary Settings");
        Composite tableComp = new Composite((Composite)this.shell, 0);
        tableComp.setLayout((Layout)new FormLayout());
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.height = 131;
        tableComp.setLayoutData((Object)data);
        tableComp.setBackground(ColorResources.DIALOG_BG_UPPER);
        Label saveFile = new Label(tableComp, 0x40000000);
        saveFile.setText(AnalyzerLabels.OPEN_TRACE_DLG_SAVED_FILE);
        saveFile.setBackground(ColorResources.DIALOG_BG_UPPER);
        saveFile.setAlignment(16384);
        saveFile.setForeground(ColorResources.OPEN_TRACE_LABEL_COLOR);
        saveFile.setFont(FontResources.OPEN_TRACE_INNER_TITLE);
        this.saveTable = new SettingSaveTable(tableComp, 2564);
        this.saveTable.setTableName(AnalyzerLabels.OPEN_TRACE_DLG_SAVE_TABLE_NAME);
        this.saveTable.setComparator(new DefaultTableComparator());
        this.saveTable.setSortTypes(this.sortTypes);
        this.saveTable.setColumns(this.columnNames);
        this.saveTable.setColumnSize(this.columnSizes);
        this.saveTable.setColumnVisibility(this.columnVisibility);
        this.saveTable.setTableToolTipEnable(false);
        this.saveTable.getTable().addMouseListener(this.mouseListener);
        this.saveTable.getTable().addKeyListener(this.keyListener);
        data = new FormData();
        data.top = new FormAttachment(0, 5);
        data.left = new FormAttachment(0, 7);
        data.height = 18;
        saveFile.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)saveFile, 0);
        data.left = new FormAttachment(0, 6);
        data.right = new FormAttachment(100, -6);
        data.height = 100;
        this.saveTable.setLayoutData(data);
        Composite buttonComp = new Composite((Composite)this.shell, 0);
        FormLayout compLayout = new FormLayout();
        buttonComp.setLayout((Layout)compLayout);
        buttonComp.setBackground(ColorResources.OPEN_TRACE_BUTTON_COMPOSITE_BG_COLOR);
        FormData compData = new FormData();
        compData.top = new FormAttachment((Control)tableComp, 0);
        compData.left = new FormAttachment(0, 0);
        compData.right = new FormAttachment(100, 0);
        compData.height = 51;
        buttonComp.setLayoutData((Object)compData);
        buttonComp.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Composite comp = (Composite)e.widget;
                Rectangle rect = comp.getClientArea();
                e.gc.setForeground(ColorResources.DIALOG_SUNKEN_1);
                e.gc.drawLine(rect.x, rect.y, rect.x + rect.width, rect.y);
                e.gc.setForeground(ColorResources.DIALOG_SUNKEN_2);
                e.gc.drawLine(rect.x, rect.y + 1, rect.x + rect.width, rect.y + 1);
            }
        });
        this.okButton = new DAButton(buttonComp, 0);
        this.okButton.addClickListener(this.okButtonListener);
        this.okButton.setText(WidgetLabels.OPEN);
        this.okButton.setFont(FontResources.DIALOG_BUTTON_FONT);
        FormData okData = new FormData();
        okData.top = new FormAttachment(0, 7);
        okData.left = new FormAttachment(50, -90);
        okData.width = 86;
        okData.height = 24;
        this.okButton.setLayoutData((Object)okData);
        this.cancelButton = new DAButton(buttonComp, 0);
        this.cancelButton.addClickListener(this.cancelButtonListener);
        this.cancelButton.setText(WidgetLabels.CLOSE);
        this.cancelButton.setFont(FontResources.DIALOG_BUTTON_FONT);
        FormData cancelData = new FormData();
        cancelData.top = new FormAttachment(0, 7);
        cancelData.left = new FormAttachment(50, 4);
        cancelData.width = 86;
        cancelData.height = 24;
        this.cancelButton.setLayoutData((Object)cancelData);
        this.saveTable.updateTable();
        return true;
    }

    private void openAction(String path) {
        if (path == null) {
            return;
        }
        File saveFile = new File(path);
        if (!saveFile.exists() || !saveFile.isFile()) {
            this.setResult(null);
            return;
        }
        this.setResult(path);
    }
}

