/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.file.data;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.database.DBColumn;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.database.SqlConnectionManager;
import org.tizen.dynamicanalyzer.ui.file.model.FileAccess;
import org.tizen.dynamicanalyzer.util.Logger;

public class FileAccessDB
extends DBTable {
    public static final String TABLENAME = "FILE_ACCESS";
    private static final String DBTYPE_TOOLTIP = "VARCHAR(256)";
    private static final String selectAll = FileAccessDB.selectAll();
    private static final String SELECT_QUERY = "select " + selectAll + " from " + "FILE_ACCESS";

    public FileAccessDB() {
        this.addColumn(new DBColumn(COLUMN.ACCESSOR_ID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.API_TYPE.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.START_TIME.name, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.END_TIME.name, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.TOOLTIP.name, "", DBTYPE_TOOLTIP));
    }

    @Override
    public String getTableName() {
        return TABLENAME;
    }

    public List<FileAccess> executeQueryRS(String query) {
        ArrayList<FileAccess> resultData = new ArrayList<FileAccess>();
        ResultSet rs = SqlConnectionManager.executeQueryRS(query);
        if (rs != null) {
            try {
                try {
                    while (rs.next()) {
                        FileAccess access = this.getDataFromResultSet(rs);
                        if (access == null) continue;
                        resultData.add(access);
                    }
                }
                catch (SQLException e) {
                    Logger.exception((Throwable)e);
                    SqlConnectionManager.releaseResultSet(rs);
                }
            }
            finally {
                SqlConnectionManager.releaseResultSet(rs);
            }
        }
        return resultData;
    }

    public FileAccess getDataFromResultSet(ResultSet rs) {
        FileAccess access = null;
        try {
            access = new FileAccess(rs.getInt(COLUMN.ACCESSOR_ID.index), rs.getInt(COLUMN.API_TYPE.index), rs.getLong(COLUMN.START_TIME.index), rs.getLong(COLUMN.END_TIME.index), rs.getString(COLUMN.TOOLTIP.index));
        }
        catch (SQLException e) {
            Logger.exception((Throwable)e);
            return null;
        }
        return access;
    }

    public void insert(FileAccess insertData) {
        ArrayList<List<Object>> insertDataList = new ArrayList<List<Object>>();
        insertDataList.add(insertData.getDBData());
        this.insertData(insertDataList);
    }

    public List<FileAccess> select() {
        String query = String.format(SELECT_QUERY, new Object[0]);
        ArrayList<FileAccess> accessList = new ArrayList();
        accessList = this.executeQueryRS(query);
        return accessList;
    }

    public static String selectAll() {
        StringBuffer selectAllColumn = new StringBuffer();
        selectAllColumn.append(COLUMN.ACCESSOR_ID.name);
        selectAllColumn.append(",");
        selectAllColumn.append(COLUMN.API_TYPE.name);
        selectAllColumn.append(",");
        selectAllColumn.append(COLUMN.START_TIME.name);
        selectAllColumn.append(",");
        selectAllColumn.append(COLUMN.END_TIME.name);
        selectAllColumn.append(",");
        selectAllColumn.append(COLUMN.TOOLTIP.name);
        return selectAllColumn.toString();
    }

    @Override
    public boolean prepare(PreparedStatement prep, List<Object> rowData) {
        boolean isPrepared = true;
        int columnsize = this.getColumnSize();
        if (columnsize != rowData.size()) {
            isPrepared = false;
        } else {
            try {
                prep.setInt(1, (Integer)rowData.get(0));
                prep.setInt(2, (Integer)rowData.get(1));
                prep.setLong(3, (Long)rowData.get(2));
                prep.setLong(4, (Long)rowData.get(3));
                prep.setString(5, (String)rowData.get(4));
            }
            catch (SQLException e) {
                Logger.exception((Throwable)e);
                isPrepared = false;
            }
        }
        return isPrepared;
    }

    public static enum COLUMN {
        ACCESSOR_ID(1, "ACCESSOR_ID"),
        API_TYPE(2, "API_TYPE"),
        START_TIME(3, "START_TIME"),
        END_TIME(4, "END_TIME"),
        TOOLTIP(5, "TOOLTIP");

        private final int index;
        private final String name;

        private COLUMN(int index, String name) {
            this.index = index;
            this.name = name;
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }
    }
}

