/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.hierarchy.tree;

import org.eclipse.draw2d.IFigure;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.tizen.dynamicanalyzer.common.DAResult;
import org.tizen.dynamicanalyzer.common.DAState;
import org.tizen.dynamicanalyzer.communicator.DACommunicator;
import org.tizen.dynamicanalyzer.communicator.UnsupportedProtocolException;
import org.tizen.dynamicanalyzer.handlers.UIActionHolder;
import org.tizen.dynamicanalyzer.nl.UIHierarchyPageLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.swap.model.data.UIHierarchyData;
import org.tizen.dynamicanalyzer.ui.hierarchy.tree.HierarchyTreeView;
import org.tizen.dynamicanalyzer.ui.hierarchy.tree.tool.HierarchyTreeExporter;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButton;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonClickEventListener;
import org.tizen.dynamicanalyzer.widgets.button.checkbox.DACheckBox;
import org.tizen.dynamicanalyzer.widgets.button.checkbox.DACheckboxSelectionListener;

public class HierarchyTreeViewToolbar
extends Composite {
    private HierarchyTreeView treeView;
    private boolean onlyElementary = true;
    private boolean requestRenderTime = false;

    public HierarchyTreeViewToolbar(Composite parent, HierarchyTreeView treeView) {
        super(parent, 0);
        this.treeView = treeView;
    }

    public void createToolbarComponent() {
        final DACheckBox elmOnlyCheckBox = new DACheckBox((Composite)this, 0);
        elmOnlyCheckBox.setEnabled(true);
        elmOnlyCheckBox.setFont(FontResources.UIHIERARCHY_TOOLBAR_FONT);
        elmOnlyCheckBox.setForeground(ColorResources.TREEVIEW_TOOLBAR_TEXT);
        elmOnlyCheckBox.setBackground(ColorResources.TREEVIEW_TOP_TOOLBAR_BG);
        elmOnlyCheckBox.setText(UIHierarchyPageLabels.UIHIERARCHY_LABEL_ELM_ONLY);
        Point checkBoxSize = elmOnlyCheckBox.computeSize(-1, -1);
        FormData data = new FormData();
        data.top = new FormAttachment(0, (22 - checkBoxSize.y) / 2);
        data.left = new FormAttachment(0, 8);
        data.width = checkBoxSize.x;
        data.height = checkBoxSize.y;
        elmOnlyCheckBox.setLayoutData((Object)data);
        elmOnlyCheckBox.addSelectionListener(new DACheckboxSelectionListener(){

            public void handleSelectionEvent(DACheckBox checkbox) {
                HierarchyTreeViewToolbar.this.onlyElementary = !HierarchyTreeViewToolbar.this.onlyElementary;
                elmOnlyCheckBox.setChecked(HierarchyTreeViewToolbar.this.onlyElementary);
            }
        });
        elmOnlyCheckBox.setChecked(this.onlyElementary);
        Canvas sunkenLine = new Canvas((Composite)this, 0);
        sunkenLine.setBackground(ColorResources.TREEVIEW_TOP_TOOLBAR_SUNKEN);
        data = new FormData();
        data.top = new FormAttachment(0, 4);
        data.left = new FormAttachment((Control)elmOnlyCheckBox, 6);
        data.height = 16;
        data.width = 1;
        sunkenLine.setLayoutData((Object)data);
        DACustomButton refreshBtn = new DACustomButton((Composite)this, ImageResources.REFRESH_BUTTON_NORMAL, ImageResources.REFRESH_BUTTON_PUSH, ImageResources.REFRESH_BUTTON_HOVER, null);
        refreshBtn.setToolTipText(UIHierarchyPageLabels.UIHIERARCHY_REFRESH_BUTTON_TOOLTIP);
        refreshBtn.setBackground(ColorResources.TREEVIEW_TOP_TOOLBAR_BG);
        data = new FormData();
        data.top = new FormAttachment(0, 1);
        data.left = new FormAttachment((Control)sunkenLine, 5);
        data.height = 22;
        data.width = 24;
        refreshBtn.setLayoutData((Object)data);
        refreshBtn.addClickListener(new DACustomButtonClickEventListener(){

            public void handleClickEvent(DACustomButton button) {
                if (DAState.isRunning()) {
                    try {
                        DAResult result = DACommunicator.requestUIHierarchy(HierarchyTreeViewToolbar.this.getRequestOption());
                        if (result.isSuccess()) {
                            HierarchyTreeViewToolbar.this.treeView.startProgress();
                        } else {
                            Logger.error((Object)result);
                            UIActionHolder.getUIAction().showWarning(result.getMessage());
                        }
                    }
                    catch (InterruptedException e) {
                        Logger.exception((Throwable)e);
                    }
                    catch (UnsupportedProtocolException e) {
                        UIActionHolder.getUIAction().showWarning(UIHierarchyPageLabels.UIHIERARCHY_NOT_SUPPORT_DEVICE);
                        Logger.exception((Throwable)e);
                    }
                }
            }
        });
        DACustomButton exportBtn = new DACustomButton((Composite)this, ImageResources.EXPORT_BUTTON_NORMAL, ImageResources.EXPORT_BUTTON_PUSH, ImageResources.EXPORT_BUTTON_HOVER, null);
        exportBtn.setToolTipText(UIHierarchyPageLabels.UIHIERARCHY_EXPORT_BUTTON_TOOLTIP);
        exportBtn.setBackground(ColorResources.TREEVIEW_TOP_TOOLBAR_BG);
        data = new FormData();
        data.top = new FormAttachment(0, 1);
        data.right = new FormAttachment(100, -8);
        data.height = 22;
        data.width = 24;
        exportBtn.setLayoutData((Object)data);
        exportBtn.addClickListener(new DACustomButtonClickEventListener(){

            public void handleClickEvent(DACustomButton button) {
                HierarchyTreeExporter.exportTreeImage((IFigure)HierarchyTreeViewToolbar.this.treeView.getTreeLayer());
            }
        });
    }

    public int getRequestOption() {
        return UIHierarchyData.getRequestOption(this.onlyElementary, this.requestRenderTime);
    }
}

