/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.memory;

import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.tizen.dynamicanalyzer.nl.MemoryPageLabels;
import org.tizen.dynamicanalyzer.ui.memory.chart.MemoryChart;
import org.tizen.dynamicanalyzer.ui.memory.chart.MemoryChartBoard;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.util.CommonUtil;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardItem;

public class StatisticsSelectionListener
extends SelectionAdapter {
    private MemoryChartBoard chartBoard = null;

    public StatisticsSelectionListener(MemoryChartBoard chartBoard) {
        this.chartBoard = chartBoard;
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.chartBoard == null || !(e.widget instanceof Grid)) {
            return;
        }
        Grid grid = (Grid)e.widget;
        int index = grid.getSelectionIndex();
        if (index < 0) {
            return;
        }
        GridItem gridItem = grid.getItem(index);
        if (gridItem == null) {
            return;
        }
        if (gridItem.getParentItem() != null) {
            this.selectLibraryChart(gridItem);
        } else {
            this.selectPidChart(gridItem);
        }
    }

    private void selectLibraryChart(GridItem gridItem) {
        DAChartBoardItem item;
        DATableDataFormat pidData = (DATableDataFormat)gridItem.getParentItem().getData();
        DATableDataFormat libData = (DATableDataFormat)gridItem.getData();
        String pidStr = (String)pidData.getData().get(0);
        if (!CommonUtil.isNumeric((String)pidStr)) {
            return;
        }
        int pid = Integer.parseInt(pidStr);
        String libName = (String)libData.getData().get(0);
        libName = this.chartBoard.getChartName(libName);
        DAChartBoardItem pidItem = null;
        int pidChartIndex = 0;
        for (MemoryChart chart : this.chartBoard.getMemoryChartList()) {
            item = chart.getChartItem();
            if (!chart.getChartName().equals(MemoryPageLabels.MEMORY_CHART_HEAP_MEMORY) || chart.getPid() != pid) continue;
            item.unFoldChild();
            pidItem = item;
            pidChartIndex = this.chartBoard.getItemList().indexOf(item);
        }
        if (pidItem == null) {
            return;
        }
        for (MemoryChart chart : this.chartBoard.getMemoryChartList()) {
            item = chart.getChartItem();
            if (chart.getPid() != pid || !chart.getChartName().equals(libName)) continue;
            int libChartIndex = pidItem.getChildItemList().indexOf(item);
            this.chartBoard.selectItem(pidChartIndex, libChartIndex);
            return;
        }
    }

    private void selectPidChart(GridItem gridItem) {
        DATableDataFormat pidData = (DATableDataFormat)gridItem.getData();
        String pidStr = (String)pidData.getData().get(0);
        if (!CommonUtil.isNumeric((String)pidStr)) {
            return;
        }
        int pid = Integer.parseInt(pidStr);
        for (MemoryChart chart : this.chartBoard.getMemoryChartList()) {
            DAChartBoardItem item = chart.getChartItem();
            if (!chart.getChartName().equals("Heap Allocation") || chart.getPid() != pid) continue;
            int pidChartIndex = this.chartBoard.getItemList().indexOf(item);
            this.chartBoard.selectItem(pidChartIndex);
            return;
        }
    }
}

