/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.opengl.data.type;

import java.util.HashMap;

public class GLES20ErrorDefine {
    private static HashMap<Long, String> gles20ErrorMap = null;
    private static HashMap<String, String> gles20ErrorDescriptionMap = null;
    public static long GL_SUCCESS = 0L;
    public static long EGL_SUCCESS = 12288L;

    private static void initialize() {
        gles20ErrorMap = new HashMap();
        gles20ErrorMap.put(new Long(GL_SUCCESS), "GL_SUCCESS");
        gles20ErrorMap.put(new Long(1280L), "GL_INVALID_ENUM");
        gles20ErrorMap.put(new Long(1281L), "GL_INVALID_VALUE");
        gles20ErrorMap.put(new Long(1282L), "GL_INVALID_OPERATION");
        gles20ErrorMap.put(new Long(1285L), "GL_OUT_OF_MEMORY");
        gles20ErrorMap.put(new Long(1286L), "GL_INVALID_FRAMEBUFFER_OPERATION");
        gles20ErrorMap.put(new Long(EGL_SUCCESS), "EGL_SUCCESS");
        gles20ErrorMap.put(new Long(12289L), "EGL_NOT_INITIALIZED");
        gles20ErrorMap.put(new Long(12290L), "EGL_BAD_ACCESS");
        gles20ErrorMap.put(new Long(12291L), "EGL_BAD_ALLOC");
        gles20ErrorMap.put(new Long(12292L), "EGL_BAD_ATTRIBUTE");
        gles20ErrorMap.put(new Long(12293L), "EGL_BAD_CONFIG");
        gles20ErrorMap.put(new Long(12294L), "EGL_BAD_CONTEXT.");
        gles20ErrorMap.put(new Long(12295L), "EGL_BAD_CURRENT_SURFACE");
        gles20ErrorMap.put(new Long(12296L), "EGL_BAD_DISPLAY");
        gles20ErrorMap.put(new Long(12297L), "EGL_BAD_MATCH");
        gles20ErrorMap.put(new Long(12298L), "EGL_BAD_NATIVE_PIXMAP");
        gles20ErrorMap.put(new Long(12299L), "EGL_BAD_NATIVE_WINDOW");
        gles20ErrorMap.put(new Long(12300L), "EGL_BAD_PARAMETER");
        gles20ErrorMap.put(new Long(12301L), "EGL_BAD_SURFACE");
        gles20ErrorMap.put(new Long(12302L), "EGL_CONTEXT_LOST");
        gles20ErrorDescriptionMap = new HashMap();
        gles20ErrorDescriptionMap.put("0", "No error");
        gles20ErrorDescriptionMap.put("500", "An unacceptable value is specified for an enumerated argument. The offending command is ignored and has no other side effect than to set the error flag.");
        gles20ErrorDescriptionMap.put("501", "A numeric argument is out of range. The offending command is ignored and has no other side effect than to set the error flag.");
        gles20ErrorDescriptionMap.put("502", "The specified operation is not allowed in the current state. The offending command is ignored and has no other side effect than to set the error flag.");
        gles20ErrorDescriptionMap.put("505", "There is not enough memory left to execute the command. The state of the GL is undefined, except for the state of the error flags, after this error is recorded.");
        gles20ErrorDescriptionMap.put("506", "The command is trying to render to or read from the framebuffer while the currently bound framebuffer is not framebuffer complete (i.e. the return value from glCheckFramebufferStatus is not GL_FRAMEBUFFER_COMPLETE). The offending command is ignored and has no other side effect than to set the error flag.");
        gles20ErrorDescriptionMap.put("glActiveTextureGL_INVALID_ENUM", "GL_INVALID_ENUM is generated if texture is not one of GL_TEXTUREi, where i ranges from 0 to (GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS - 1).");
        gles20ErrorDescriptionMap.put("glAttachShaderGL_INVALID_VALUE", "GL_INVALID_VALUE is generated if either program or shader is not a value generated by OpenGL.");
        gles20ErrorDescriptionMap.put("glAttachShaderGL_INVALID_OPERATION", "GL_INVALID_OPERATION is generated \n1. if program is not a program object.\n2. if shader is not a shader object.\n3. if shader is already attached to program, or if another shader object of the same type as shader is already attached to program.");
        gles20ErrorDescriptionMap.put("glBindAttribLocationGL_INVALID_VALUE", "GL_INVALID_VALUE is generated \n1. if index is greater than or equal to GL_MAX_VERTEX_ATTRIBS.\n2. if program is not a value");
        gles20ErrorDescriptionMap.put("glBindAttribLocationGL_INVALID_OPERATION", "GL_INVALID_OPERATION is generated \n1. if name starts with the reserved prefix \"gl_\".\n2. if program is not a program object.");
        gles20ErrorDescriptionMap.put("glBindBufferGL_INVALID_ENUM", "GL_INVALID_ENUM is generated if target is not one of the allowable values.");
        gles20ErrorDescriptionMap.put("glBindFramebufferGL_INVALID_ENUM", "GL_INVALID_ENUM is generated if target is not GL_FRAMEBUFFER.");
        gles20ErrorDescriptionMap.put("glBindRenderbufferGL_INVALID_ENUM", "GL_INVALID_ENUM is generated if target is not GL_RENDERBUFFER.");
        gles20ErrorDescriptionMap.put("glBindTextureGL_INVALID_ENUM", "GL_INVALID_ENUM is generated if target is not one of the allowable values.");
        gles20ErrorDescriptionMap.put("glBindTextureGL_INVALID_OPERATION", "GL_INVALID_OPERATION is generated if texture was previously created with a target that doesn't match that of target.");
        gles20ErrorDescriptionMap.put("glBlendEquationGL_INVALID_ENUM", "GL_INVALID_ENUM is generated if mode is not one of GL_FUNC_ADD, GL_FUNC_SUBTRACT, or GL_FUNC_REVERSE_SUBTRACT.");
        gles20ErrorDescriptionMap.put("glBlendEquationSeparateGL_INVALID_ENUM", "GL_INVALID_ENUM is generated if either modeRGB or modeAlpha is not one of GL_FUNC_ADD, GL_FUNC_SUBTRACT, or GL_FUNC_REVERSE_SUBTRACT.");
        gles20ErrorDescriptionMap.put("glBlendFuncGL_INVALID_ENUM", "GL_INVALID_ENUM is generated if either sfactor or dfactor is not an accepted value.");
        gles20ErrorDescriptionMap.put("glBlendFuncSeparateGL_INVALID_ENUM", "GL_INVALID_ENUM is generated if srcRGB, dstRGB, srcAlpha, or dstAlpha is not an accepted value.");
        gles20ErrorDescriptionMap.put("glBufferDataGL_INVALID_VALUE", "GL_INVALID_VALUE is generated if size is negative.");
        gles20ErrorDescriptionMap.put("glBufferDataGL_INVALID_ENUM", "GL_INVALID_ENUM is generated \n1. if target is not GL_ARRAY_BUFFER or GL_ELEMENT_ARRAY_BUFFER.\n2. if usage is not GL_STREAM_DRAW, GL_STATIC_DRAW, or GL_DYNAMIC_DRAW.");
        gles20ErrorDescriptionMap.put("glBufferDataGL_OUT_OF_MEMORY", "GL_OUT_OF_MEMORY is generated if the GL is unable to create a data store with the specified size.");
        gles20ErrorDescriptionMap.put("glBufferDataGL_INVALID_OPERATION", "GL_INVALID_OPERATION is generated if the reserved buffer object name 0 is bound to target.");
        gles20ErrorDescriptionMap.put("glBufferSubDataGL_INVALID_VALUE", "GL_INVALID_VALUE is generated if offset or size is negative, or if together they define a region of memory that extends beyond the buffer object's allocated data store.");
        gles20ErrorDescriptionMap.put("glBufferSubDataGL_INVALID_ENUM", "GL_INVALID_ENUM is generated if target is not GL_ARRAY_BUFFER or GL_ELEMENT_ARRAY_BUFFER.");
        gles20ErrorDescriptionMap.put("glBufferSubDataGL_INVALID_OPERATION", "GL_INVALID_OPERATION is generated if the reserved buffer object name 0 is bound to target.");
        gles20ErrorDescriptionMap.put("glCheckFramebufferStatusGL_INVALID_ENUM", "GL_INVALID_ENUM is generated if target is not GL_FRAMEBUFFER.");
        gles20ErrorDescriptionMap.put("glClearGL_INVALID_VALUE", "GL_INVALID_VALUE is generated if any bit other than the three defined bits is set in mask.");
        gles20ErrorDescriptionMap.put("glCompileShaderGL_INVALID_VALUE", "GL_INVALID_VALUE is generated if shader is not a value generated by OpenGL.");
        gles20ErrorDescriptionMap.put("glCompileShaderGL_INVALID_OPERATION", "GL_INVALID_OPERATION is generated \n1. if a shader compiler is not supported.\n2. if shader is not a shader object.");
        gles20ErrorDescriptionMap.put("glCompressedTexImage2DGL_INVALID_VALUE", "GL_INVALID_VALUE is generated \n1. if level is less than 0.\n2. if level is greater than log 2 ? max , where max is the returned value of GL_MAX_TEXTURE_SIZE when target is GL_TEXTURE_2D or GL_MAX_CUBE_MAP_TEXTURE_SIZE when target is not GL_TEXTURE_2D.\n3. if width or height is less than 0 or greater than GL_MAX_TEXTURE_SIZE when target is GL_TEXTURE_2D or GL_MAX_CUBE_MAP_TEXTURE_SIZE when target is not GL_TEXTURE_2D.\n4. if border is not 0.\n5. if imageSize is not consistent with the format, dimensions, and contents of the specified compressed image data.");
        gles20ErrorDescriptionMap.put("glCompressedTexImage2DGL_INVALID_ENUM", "GL_INVALID_ENUM is generated \n1. if target is not GL_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, or GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.\n2. if internalformat is not a supported format returned in GL_COMPRESSED_TEXTURE_FORMATS.");
        gles20ErrorDescriptionMap.put("glCompressedTexImage2DGL_INVALID_OPERATION", "GL_INVALID_OPERATION is generated if parameter combinations are not supported by the specific compressed internal format as specified in the specific texture compression extension.");
        gles20ErrorDescriptionMap.put("glCompressedTexSubImage2DGL_INVALID_VALUE", "GL_INVALID_VALUE is generated \n1. if level is less than 0.\n2. if level is greater than log 2 ? max , where max is the returned value of GL_MAX_TEXTURE_SIZE when target is GL_TEXTURE_2D or GL_MAX_CUBE_MAP_TEXTURE_SIZE when target is not GL_TEXTURE_2D.\n3. if xoffset < 0 , xoffset + width > w , yoffset < 0 , or yoffset + height > h , where w is the width and h is the height of the texture image being modified.\n4. if width or height is less than 0.\n5. if imageSize is not consistent with the format, dimensions, and contents of the specified compressed image data.");
        gles20ErrorDescriptionMap.put("glCompressedTexSubImage2DGL_INVALID_ENUM", "GL_INVALID_ENUM is generated \n1. if target is not GL_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, or GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.\n2. if format is not a supported format returned in GL_COMPRESSED_TEXTURE_FORMATS.");
        gles20ErrorDescriptionMap.put("glCompressedTexSubImage2DGL_INVALID_OPERATION", "GL_INVALID_OPERATION is generated \n1. if the texture array has not been defined by a previous glCompressedTexImage2D operation whose internalformat matches the format of glCompressedTexSubImage2D.\n2. if parameter combinations are not supported by the specific compressed internal format as specified in the specific texture compression extension.");
        gles20ErrorDescriptionMap.put("glCopyTexImage2DGL_INVALID_VALUE", "GL_INVALID_VALUE is generated \n1. if target is one of the six cube map 2D image targets and the width and height parameters are not equal.\n2. if level is less than 0.\n3. if level is greater than log 2 ? max , where max is the returned value of GL_MAX_TEXTURE_SIZE when target is GL_TEXTURE_2D or GL_MAX_CUBE_MAP_TEXTURE_SIZE when target is not GL_TEXTURE_2D.\n4. if width or height is less than 0 or greater than GL_MAX_TEXTURE_SIZE when target is GL_TEXTURE_2D or GL_MAX_CUBE_MAP_TEXTURE_SIZE when target is not GL_TEXTURE_2D.\n5. if border is not 0.");
        gles20ErrorDescriptionMap.put("glCopyTexImage2DGL_INVALID_ENUM", "GL_INVALID_ENUM is generated \n1. if target is not GL_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, or GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.\n2. if internalformat is not an accepted format.");
        gles20ErrorDescriptionMap.put("glCopyTexImage2DGL_INVALID_OPERATION", "GL_INVALID_OPERATION is generated if the currently bound framebuffer's format does not contain a superset of the components required by the base format of internalformat.");
        gles20ErrorDescriptionMap.put("glCopyTexImage2DGL_INVALID_FRAMEBUFFER_OPERATION", "GL_INVALID_FRAMEBUFFER_OPERATION is generated if the currently bound framebuffer is not framebuffer complete (i.e. the return value from glCheckFramebufferStatus is not GL_FRAMEBUFFER_COMPLETE).");
        gles20ErrorDescriptionMap.put("glCopyTexSubImage2DGL_INVALID_VALUE", "GL_INVALID_VALUE is generated \n1. if level is less than 0.\n2. if level > log 2 ? max , where max is the returned value of GL_MAX_TEXTURE_SIZE.\n3. if xoffset < 0 , xoffset + width > w , yoffset < 0 , or yoffset + height > h , where w is the width and h is the height of the texture image being modified.\n4. if width or height is less than 0.");
        gles20ErrorDescriptionMap.put("glCopyTexSubImage2DGL_INVALID_ENUM", "GL_INVALID_ENUM is generated if target is not GL_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, or GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.");
        gles20ErrorDescriptionMap.put("glCopyTexSubImage2DGL_INVALID_OPERATION", "GL_INVALID_OPERATION is generated \n1. if the texture array has not been defined by a previous glTexImage2D or glCopyTexImage2D operation.\n2. if the currently bound framebuffer's format does not contain a superset of the components required by the texture's base internal format.");
        gles20ErrorDescriptionMap.put("glCopyTexSubImage2DGL_INVALID_FRAMEBUFFER_OPERATION", "GL_INVALID_FRAMEBUFFER_OPERATION is generated if the currently bound framebuffer is not framebuffer complete (i.e. the return value from glCheckFramebufferStatus is not GL_FRAMEBUFFER_COMPLETE).");
        gles20ErrorDescriptionMap.put("glCreateShaderGL_INVALID_ENUM", "GL_INVALID_ENUM is generated if shaderType is not an accepted value.");
        gles20ErrorDescriptionMap.put("glCullFaceGL_INVALID_ENUM", "GL_INVALID_ENUM is generated if mode is not an accepted value.");
        gles20ErrorDescriptionMap.put("glDeleteBuffersGL_INVALID_VALUE", "GL_INVALID_VALUE is generated if n is negative.");
        gles20ErrorDescriptionMap.put("glDeleteFramebuffersGL_INVALID_VALUE", "GL_INVALID_VALUE is generated if n is negative.");
        gles20ErrorDescriptionMap.put("glDeleteProgramGL_INVALID_VALUE", "GL_INVALID_VALUE is generated if program is not a value generated by OpenGL.");
        gles20ErrorDescriptionMap.put("glDeleteRenderbuffersGL_INVALID_VALUE", "GL_INVALID_VALUE is generated if n is negative.");
        gles20ErrorDescriptionMap.put("glDeleteShaderGL_INVALID_VALUE", "GL_INVALID_VALUE is generated if shader is not a value generated by OpenGL.");
        gles20ErrorDescriptionMap.put("glDeleteTexturesGL_INVALID_VALUE", "GL_INVALID_VALUE is generated if n is negative.");
        gles20ErrorDescriptionMap.put("glDepthFuncGL_INVALID_ENUM", "GL_INVALID_ENUM is generated if func is not an accepted value.");
        gles20ErrorDescriptionMap.put("glDetachShaderGL_INVALID_VALUE", "GL_INVALID_VALUE is generated if either program or shader is a value that was not generated by OpenGL.");
        gles20ErrorDescriptionMap.put("glDetachShaderGL_INVALID_OPERATION", "GL_INVALID_OPERATION is generated \n1. if program is not a program object.\n2. if shader is not a shader object.\n3. if shader is not attached to program.");
        gles20ErrorDescriptionMap.put("glDrawArraysGL_INVALID_VALUE", "GL_INVALID_VALUE is generated if count is negative.");
        gles20ErrorDescriptionMap.put("glDrawArraysGL_INVALID_ENUM", "GL_INVALID_ENUM is generated if mode is not an accepted value.");
        gles20ErrorDescriptionMap.put("glDrawArraysGL_INVALID_FRAMEBUFFER_OPERATION", "GL_INVALID_FRAMEBUFFER_OPERATION is generated if the currently bound framebuffer is not framebuffer complete (i.e. the return value from glCheckFramebufferStatus is not GL_FRAMEBUFFER_COMPLETE).");
        gles20ErrorDescriptionMap.put("glDrawElementsGL_INVALID_VALUE", "GL_INVALID_VALUE is generated if count is negative.");
        gles20ErrorDescriptionMap.put("glDrawElementsGL_INVALID_ENUM", "GL_INVALID_ENUM is generated \n1. if mode is not an accepted value.\n2. if type is not GL_UNSIGNED_BYTE or GL_UNSIGNED_SHORT.");
        gles20ErrorDescriptionMap.put("glDrawElementsGL_INVALID_FRAMEBUFFER_OPERATION", "GL_INVALID_FRAMEBUFFER_OPERATION is generated if the currently bound framebuffer is not framebuffer complete (i.e. the return value from glCheckFramebufferStatus is not GL_FRAMEBUFFER_COMPLETE).");
        gles20ErrorDescriptionMap.put("glEnableGL_INVALID_ENUM", "GL_INVALID_ENUM is generated if cap is not one of the values listed previously.");
        gles20ErrorDescriptionMap.put("glEnableVertexAttribArrayGL_INVALID_VALUE", "GL_INVALID_VALUE is generated if index is greater than or equal to GL_MAX_VERTEX_ATTRIBS.");
        gles20ErrorDescriptionMap.put("glFramebufferRenderbufferGL_INVALID_ENUM", "GL_INVALID_ENUM is generated \n1. if target is not GL_FRAMEBUFFER.\n2. if renderbuffertarget is not GL_RENDERBUFFER and renderbuffer is not 0.\n3. if attachment is not an accepted attachment point.");
        gles20ErrorDescriptionMap.put("glFramebufferRenderbufferGL_INVALID_OPERATION", "GL_INVALID_OPERATION is generated \n1. if the default framebuffer object name 0 is bound.\n2. if renderbuffer is neither 0 nor the name of an existing renderbuffer object.");
        gles20ErrorDescriptionMap.put("glFramebufferTexture2DGL_INVALID_VALUE", "GL_INVALID_VALUE is generated if level is not 0 and texture is not 0.");
        gles20ErrorDescriptionMap.put("glFramebufferTexture2DGL_INVALID_ENUM", "GL_INVALID_ENUM is generated \n1. if target is not GL_FRAMEBUFFER.\n2. if textarget is not an accepted texture target and texture is not 0.\n3. if attachment is not an accepted attachment point.");
        gles20ErrorDescriptionMap.put("glFramebufferTexture2DGL_INVALID_OPERATION", "GL_INVALID_OPERATION is generated \n1. if the default framebuffer object name 0 is bound.\n2. if texture is neither 0 nor the name of an existing texture object.\n3. if texture is the name of an existing two-dimensional texture object but textarget is not GL_TEXTURE_2D or if texture is the name of an existing cube map texture object but textarget is GL_TEXTURE_2D.");
        gles20ErrorDescriptionMap.put("glFrontFaceGL_INVALID_ENUM", "GL_INVALID_ENUM is generated if mode is not an accepted value.");
        gles20ErrorDescriptionMap.put("glGenBuffersGL_INVALID_VALUE", "GL_INVALID_VALUE is generated if n is negative.");
        gles20ErrorDescriptionMap.put("glGenFramebuffersGL_INVALID_VALUE", "GL_INVALID_VALUE is generated if n is negative.");
        gles20ErrorDescriptionMap.put("glGenRenderbuffersGL_INVALID_VALUE", "GL_INVALID_VALUE is generated if n is negative.");
        gles20ErrorDescriptionMap.put("glGenTexturesGL_INVALID_VALUE", "GL_INVALID_VALUE is generated if n is negative.");
        gles20ErrorDescriptionMap.put("glGenerateMipmapGL_INVALID_ENUM", "GL_INVALID_ENUM is generated if target is not GL_TEXTURE_2D or GL_TEXTURE_CUBE_MAP.");
        gles20ErrorDescriptionMap.put("glGenerateMipmapGL_INVALID_OPERATION", "GL_INVALID_OPERATION is generated \n1. if the texture bound to target is a cube map, but its six faces do not share indentical widths, heights, formats, and types.\n2. if either the width or height of the zero level array is not a power of two.\n3. if the zero level array is stored in a compressed internal format.");
        gles20ErrorDescriptionMap.put("glGetGL_INVALID_ENUM", "GL_INVALID_ENUM is generated if pname is not one of the values listed previously.");
        gles20ErrorDescriptionMap.put("glGetActiveAttribGL_INVALID_VALUE", "GL_INVALID_VALUE is generated \n1. if program is not a value\n2. if index is greater than or equal to the number of active attribute variables in program.\n3. if bufSize is less than 0.");
        gles20ErrorDescriptionMap.put("glGetActiveAttribGL_INVALID_OPERATION", "GL_INVALID_OPERATION is generated if program is not a program object.");
        gles20ErrorDescriptionMap.put("glGetActiveUniformGL_INVALID_VALUE", "GL_INVALID_VALUE is generated \n1. if program is not a value\n2. if index is greater than or equal to the number of active uniform variables in program.\n3. if bufSize is less than 0.");
        gles20ErrorDescriptionMap.put("glGetActiveUniformGL_INVALID_OPERATION", "GL_INVALID_OPERATION is generated if program is not a program object.");
        gles20ErrorDescriptionMap.put("glGetAttachedShadersGL_INVALID_VALUE", "GL_INVALID_VALUE is generated \n1. if program is not a value\n2. if maxCount is less than 0.");
        gles20ErrorDescriptionMap.put("glGetAttachedShadersGL_INVALID_OPERATION", "GL_INVALID_OPERATION is generated if program is not a program object.");
        gles20ErrorDescriptionMap.put("glGetAttribLocationGL_INVALID_OPERATION", "GL_INVALID_OPERATION is generated \n1. if program is not a value\n2. if program is not a program object.\n3. if program has not been successfully linked.");
        gles20ErrorDescriptionMap.put("glGetBufferParameterivGL_INVALID_ENUM", "GL_INVALID_ENUM is generated if target or value is not an accepted value.");
        gles20ErrorDescriptionMap.put("glGetBufferParameterivGL_INVALID_OPERATION", "GL_INVALID_OPERATION is generated if the reserved buffer object name 0 is bound to target.");
        gles20ErrorDescriptionMap.put("glGetFramebufferAttachmentParameterivGL_INVALID_ENUM", "GL_INVALID_ENUM is generated \n1. if target is not GL_FRAMEBUFFER.\n2. if attachment is not GL_COLOR_ATTACHMENT0, GL_DEPTH_ATTACHMENT, or GL_STENCIL_ATTACHMENT.\n3. if the attached object at the named attachment point is GL_RENDERBUFFER and pname is not GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE or GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME.\n4. if the attached object at the named attachment point is GL_TEXTURE and pname is not GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE, GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME, GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL, or GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE.\n5. if there is no attached object at the named attachment point and pname is not GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE.");
        gles20ErrorDescriptionMap.put("glGetFramebufferAttachmentParameterivGL_INVALID_OPERATION", "GL_INVALID_OPERATION is generated if the default framebuffer object name 0 is bound.");
        gles20ErrorDescriptionMap.put("glGetProgramInfoLogGL_INVALID_VALUE", "GL_INVALID_VALUE is generated \n1. if program is not a value\n2. if maxLength is less than 0.");
        gles20ErrorDescriptionMap.put("glGetProgramInfoLogGL_INVALID_OPERATION", "GL_INVALID_OPERATION is generated if program is not a program object.");
        gles20ErrorDescriptionMap.put("glGetProgramivGL_INVALID_VALUE", "GL_INVALID_VALUE is generated if program is not a value generated by OpenGL.");
        gles20ErrorDescriptionMap.put("glGetProgramivGL_INVALID_ENUM", "GL_INVALID_ENUM is generated if pname is not an accepted value.");
        gles20ErrorDescriptionMap.put("glGetProgramivGL_INVALID_OPERATION", "GL_INVALID_OPERATION is generated if program does not refer to a program object.");
        gles20ErrorDescriptionMap.put("glGetRenderbufferParameterivGL_INVALID_ENUM", "GL_INVALID_ENUM is generated \n1. if target is not GL_RENDERBUFFER.\n2. if pname is not GL_RENDERBUFFER_WIDTH, GL_RENDERBUFFER_HEIGHT, GL_RENDERBUFFER_INTERNAL_FORMAT, GL_RENDERBUFFER_RED_SIZE, GL_RENDERBUFFER_GREEN_SIZE, GL_RENDERBUFFER_BLUE_SIZE, GL_RENDERBUFFER_ALPHA_SIZE, GL_RENDERBUFFER_DEPTH_SIZE, or GL_RENDERBUFFER_STENCIL_SIZE.");
        gles20ErrorDescriptionMap.put("glGetRenderbufferParameterivGL_INVALID_OPERATION", "GL_INVALID_OPERATION is generated if the reserved renderbuffer object name 0 is bound.");
        gles20ErrorDescriptionMap.put("glGetShaderInfoLogGL_INVALID_VALUE", "GL_INVALID_VALUE is generated \n1. if shader is not a value\n2. if maxLength is less than 0.");
        gles20ErrorDescriptionMap.put("glGetShaderInfoLogGL_INVALID_OPERATION", "GL_INVALID_OPERATION is generated if shader is not a shader object.");
        gles20ErrorDescriptionMap.put("glGetShaderPrecisionFormatGL_INVALID_ENUM", "GL_INVALID_ENUM is generated if shaderType or precisionType is not an accepted value.");
        gles20ErrorDescriptionMap.put("glGetShaderPrecisionFormatGL_INVALID_OPERATION", "GL_INVALID_OPERATION is generated if a shader compiler is not supported.");
        gles20ErrorDescriptionMap.put("glGetShaderSourceGL_INVALID_VALUE", "GL_INVALID_VALUE is generated \n1. if shader is not a value\n2. if bufSize is less than 0.");
        gles20ErrorDescriptionMap.put("glGetShaderSourceGL_INVALID_OPERATION", "GL_INVALID_OPERATION is generated if shader is not a shader object.");
        gles20ErrorDescriptionMap.put("glGetShaderivGL_INVALID_VALUE", "GL_INVALID_VALUE is generated if shader is not a value generated by OpenGL.");
        gles20ErrorDescriptionMap.put("glGetShaderivGL_INVALID_ENUM", "GL_INVALID_ENUM is generated if pname is not an accepted value.");
        gles20ErrorDescriptionMap.put("glGetShaderivGL_INVALID_OPERATION", "GL_INVALID_OPERATION is generated \n1. if pname is GL_COMPILE_STATUS, GL_INFO_LOG_LENGTH, or GL_SHADER_SOURCE_LENGTH but a shader compiler is not supported.\n2. if shader does not refer to a shader object.");
        gles20ErrorDescriptionMap.put("glGetStringGL_INVALID_ENUM", "GL_INVALID_ENUM is generated if name is not an accepted value.");
        gles20ErrorDescriptionMap.put("glGetTexParameterGL_INVALID_ENUM", "GL_INVALID_ENUM is generated if target or pname is not an accepted value.");
        gles20ErrorDescriptionMap.put("glGetUniformGL_INVALID_VALUE", "GL_INVALID_VALUE is generated if program is not a value generated by OpenGL.");
        gles20ErrorDescriptionMap.put("glGetUniformGL_INVALID_OPERATION", "GL_INVALID_OPERATION is generated \n1. if program is not a program object.\n2. if program has not been successfully linked.\n3. if location does not correspond to a valid uniform variable location for the specified program object.");
        gles20ErrorDescriptionMap.put("glGetUniformLocationGL_INVALID_VALUE", "GL_INVALID_VALUE is generated if program is not a value generated by OpenGL.");
        gles20ErrorDescriptionMap.put("glGetUniformLocationGL_INVALID_OPERATION", "GL_INVALID_OPERATION is generated \n1. if program is not a program object.\n2. if program has not been successfully linked.");
        gles20ErrorDescriptionMap.put("glGetVertexAttribGL_INVALID_VALUE", "GL_INVALID_VALUE is generated if index is greater than or equal to GL_MAX_VERTEX_ATTRIBS.");
        gles20ErrorDescriptionMap.put("glGetVertexAttribGL_INVALID_ENUM", "GL_INVALID_ENUM is generated if pname is not an accepted value.");
        gles20ErrorDescriptionMap.put("glGetVertexAttribPointervGL_INVALID_VALUE", "GL_INVALID_VALUE is generated if index is greater than or equal to GL_MAX_VERTEX_ATTRIBS.");
        gles20ErrorDescriptionMap.put("glGetVertexAttribPointervGL_INVALID_ENUM", "GL_INVALID_ENUM is generated if pname is not an accepted value.");
        gles20ErrorDescriptionMap.put("glHintGL_INVALID_ENUM", "GL_INVALID_ENUM is generated if either target or mode is not an accepted value.");
        gles20ErrorDescriptionMap.put("glIsEnabledGL_INVALID_ENUM", "GL_INVALID_ENUM is generated if cap is not an accepted value.");
        gles20ErrorDescriptionMap.put("glLineWidthGL_INVALID_VALUE", "GL_INVALID_VALUE is generated if width is less than or equal to 0.");
        gles20ErrorDescriptionMap.put("glLinkProgramGL_INVALID_VALUE", "GL_INVALID_VALUE is generated if program is not a value generated by OpenGL.");
        gles20ErrorDescriptionMap.put("glLinkProgramGL_INVALID_OPERATION", "GL_INVALID_OPERATION is generated if program is not a program object.");
        gles20ErrorDescriptionMap.put("glPixelStoreiGL_INVALID_VALUE", "GL_INVALID_VALUE is generated if alignment is specified as other than 1, 2, 4, or 8.");
        gles20ErrorDescriptionMap.put("glPixelStoreiGL_INVALID_ENUM", "GL_INVALID_ENUM is generated if pname is not an accepted value.");
        gles20ErrorDescriptionMap.put("glReadPixelsGL_INVALID_VALUE", "GL_INVALID_VALUE is generated if either width or height is negative.");
        gles20ErrorDescriptionMap.put("glReadPixelsGL_INVALID_ENUM", "GL_INVALID_ENUM is generated if format or type is not an accepted value.");
        gles20ErrorDescriptionMap.put("glReadPixelsGL_INVALID_OPERATION", "GL_INVALID_OPERATION is generated \n1. if type is GL_UNSIGNED_SHORT_5_6_5 and format is not GL_RGB.\n2. if type is GL_UNSIGNED_SHORT_4_4_4_4 or GL_UNSIGNED_SHORT_5_5_5_1 and format is not GL_RGBA.\n3. if format and type are neither GL_RGBA and GL_UNSIGNED_BYTE, respectively, nor the format/type pair returned by querying GL_IMPLEMENTATION_COLOR_READ_FORMAT and GL_IMPLEMENTATION_COLOR_READ_TYPE.");
        gles20ErrorDescriptionMap.put("glReadPixelsGL_INVALID_FRAMEBUFFER_OPERATION", "GL_INVALID_FRAMEBUFFER_OPERATION is generated if the currently bound framebuffer is not framebuffer complete (i.e. the return value from glCheckFramebufferStatus is not GL_FRAMEBUFFER_COMPLETE).");
        gles20ErrorDescriptionMap.put("glReleaseShaderCompilerGL_INVALID_OPERATION", "GL_INVALID_OPERATION is generated if a shader compiler is not supported.");
        gles20ErrorDescriptionMap.put("glRenderbufferStorageGL_INVALID_VALUE", "GL_INVALID_VALUE is generated if width or height is less than zero or greater than GL_MAX_RENDERBUFFER_SIZE.");
        gles20ErrorDescriptionMap.put("glRenderbufferStorageGL_INVALID_ENUM", "GL_INVALID_ENUM is generated \n1. if target is not GL_RENDERBUFFER.\n2. if internalformat is not an accepted format.");
        gles20ErrorDescriptionMap.put("glRenderbufferStorageGL_INVALID_OPERATION", "GL_INVALID_OPERATION is generated if the reserved renderbuffer object name 0 is bound.");
        gles20ErrorDescriptionMap.put("glRenderbufferStorageGL_OUT_OF_MEMORY", "GL_OUT_OF_MEMORY is generated if the implementation is unable to create a data store with the requested width and height.");
        gles20ErrorDescriptionMap.put("glScissorGL_INVALID_VALUE", "GL_INVALID_VALUE is generated if either width or height is negative.");
        gles20ErrorDescriptionMap.put("glShaderBinaryGL_INVALID_VALUE", "GL_INVALID_VALUE is generated \n1. if any value in shaders is not a vlue\n2. if the format of the data pointed to by binary does not match binaryformat.\n3. if n or length is negative.");
        gles20ErrorDescriptionMap.put("glShaderBinaryGL_INVALID_ENUM", "GL_INVALID_ENUM is generated if binaryformat is not a supported format returned in GL_SHADER_BINARY_FORMATS.");
        gles20ErrorDescriptionMap.put("glShaderBinaryGL_INVALID_OPERATION", "GL_INVALID_OPERATION is generated if any value in shaders is not a shader object, or if there is more than one vertex shader object handle or more than one fragment shader object handle in shaders.");
        gles20ErrorDescriptionMap.put("glShaderSourceGL_INVALID_VALUE", "GL_INVALID_VALUE is generated \n1. if shader is not a value\n2. if count is less than 0.");
        gles20ErrorDescriptionMap.put("glShaderSourceGL_INVALID_OPERATION", "GL_INVALID_OPERATION is generated \n1. if a shader compiler is not supported.\n2. if shader is not a shader object.");
        gles20ErrorDescriptionMap.put("glStencilFuncGL_INVALID_ENUM", "GL_INVALID_ENUM is generated if func is not one of the eight accepted values.");
        gles20ErrorDescriptionMap.put("glStencilFuncSeparateGL_INVALID_ENUM", "GL_INVALID_ENUM is generated \n1. if face is not GL_FRONT, GL_BACK, or GL_FRONT_AND_BACK.\n2. if func is not one of the eight accepted values.");
        gles20ErrorDescriptionMap.put("glStencilMaskSeparateGL_INVALID_ENUM", "GL_INVALID_ENUM is generated if face is not GL_FRONT, GL_BACK, or GL_FRONT_AND_BACK.");
        gles20ErrorDescriptionMap.put("glStencilOpGL_INVALID_ENUM", "GL_INVALID_ENUM is generated if sfail, dpfail, or dppass is any value other than the eight defined symbolic constant values.");
        gles20ErrorDescriptionMap.put("glStencilOpSeparateGL_INVALID_ENUM", "GL_INVALID_ENUM is generated \n1. if face is any value other than GL_FRONT, GL_BACK, or GL_FRONT_AND_BACK.\n2. if sfail, dpfail, or dppass is any value other than the eight defined symbolic constant values.");
        gles20ErrorDescriptionMap.put("glTexImage2DGL_INVALID_VALUE", "GL_INVALID_VALUE is generated \n1. if target is one of the six cube map 2D image targets and the width and height parameters are not equal.\n2. if level is less than 0.\n3. if level is greater than log 2 ? max , where max is the returned value of GL_MAX_TEXTURE_SIZE when target is GL_TEXTURE_2D or GL_MAX_CUBE_MAP_TEXTURE_SIZE when target is not GL_TEXTURE_2D.\n4. if internalformat is not an accepted format.\n5. if width or height is less than 0 or greater than GL_MAX_TEXTURE_SIZE when target is GL_TEXTURE_2D or GL_MAX_CUBE_MAP_TEXTURE_SIZE when target is not GL_TEXTURE_2D.\n6. if border is not 0.");
        gles20ErrorDescriptionMap.put("glTexImage2DGL_INVALID_ENUM", "GL_INVALID_ENUM is generated \n1. if target is not GL_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, or GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.\n2. if format or type is not an accepted value.");
        gles20ErrorDescriptionMap.put("glTexImage2DGL_INVALID_OPERATION", "GL_INVALID_OPERATION is generated \n1. if format does not match internalformat.\n2. if type is GL_UNSIGNED_SHORT_5_6_5 and format is not GL_RGB.\n3. if type is GL_UNSIGNED_SHORT_4_4_4_4 or GL_UNSIGNED_SHORT_5_5_5_1 and format is not GL_RGBA.");
        gles20ErrorDescriptionMap.put("glTexParameterGL_INVALID_ENUM", "GL_INVALID_ENUM is generated \n1. if target or pname is not one of the accepted defined values.\n2. if params should have a defined symbolic constant value (based on the value of pname) and does not.");
        gles20ErrorDescriptionMap.put("glTexSubImage2DGL_INVALID_VALUE", "GL_INVALID_VALUE is generated \n1. if level is less than 0.\n2. if level is greater than log 2 max, where max is the returned value of GL_MAX_TEXTURE_SIZE.\n3. if xoffset < 0 , xoffset + width > w , yoffset < 0 , or yoffset + height > h , where w is the width and h is the height of the texture image being modified.\n4. if width or height is less than 0.");
        gles20ErrorDescriptionMap.put("glTexSubImage2DGL_INVALID_ENUM", "GL_INVALID_ENUM is generated \n1. if target is not GL_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, or GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.\n2. if format or type is not an accepted value.");
        gles20ErrorDescriptionMap.put("glTexSubImage2DGL_INVALID_OPERATION", "GL_INVALID_OPERATION is generated \n1. if the texture array has not been defined by a previous glTexImage2D or glCopyTexImage2D operation whose internalformat matches the format of glTexSubImage2D.\n2. if type is GL_UNSIGNED_SHORT_5_6_5 and format is not GL_RGB.\n3. if type is GL_UNSIGNED_SHORT_4_4_4_4 or GL_UNSIGNED_SHORT_5_5_5_1 and format is not GL_RGBA.");
        gles20ErrorDescriptionMap.put("glUniformGL_INVALID_VALUE", "GL_INVALID_VALUE is generated \n1. if count is less than 0.\n2. if transpose is not GL_FALSE.");
        gles20ErrorDescriptionMap.put("glUniformGL_INVALID_OPERATION", "GL_INVALID_OPERATION is generated \n1. if there is no current program object.\n2. if the size of the uniform variable declared in the shader does not match the size indicated by the glUniform command.\n3. if one of the integer variants of this function is used to load a uniform variable of type float, vec2, vec3, vec4, or an array of these, or if one of the floating-point variants of this function is used to load a uniform variable of type int, ivec2, ivec3, or ivec4, or an array of these.\n4. if location is an invalid uniform location for the current program object and location is not equal to -1.\n5. if count is greater than 1 and the indicated uniform variable is not an array variable.\n6. if a sampler is loaded using a command other than glUniform1i and glUniform1iv.");
        gles20ErrorDescriptionMap.put("glUseProgramGL_INVALID_VALUE", "GL_INVALID_VALUE is generated if program is neither 0 nor a value generated by OpenGL.");
        gles20ErrorDescriptionMap.put("glUseProgramGL_INVALID_OPERATION", "GL_INVALID_OPERATION is generated \n1. if program is not a program object.\n2. if program could not be made part of current state.");
        gles20ErrorDescriptionMap.put("glValidateProgramGL_INVALID_VALUE", "GL_INVALID_VALUE is generated if program is not a value generated by OpenGL.");
        gles20ErrorDescriptionMap.put("glValidateProgramGL_INVALID_OPERATION", "GL_INVALID_OPERATION is generated if program is not a program object.");
        gles20ErrorDescriptionMap.put("glVertexAttribGL_INVALID_VALUE", "GL_INVALID_VALUE is generated if index is greater than or equal to GL_MAX_VERTEX_ATTRIBS.");
        gles20ErrorDescriptionMap.put("glVertexAttribPointerGL_INVALID_VALUE", "GL_INVALID_VALUE is generated \n1. if index is greater than or equal to GL_MAX_VERTEX_ATTRIBS.\n2. if size is not 1, 2, 3, or 4.\n3. if stride is negative.");
        gles20ErrorDescriptionMap.put("glVertexAttribPointerGL_INVALID_ENUM", "GL_INVALID_ENUM is generated if type is not an accepted value.");
        gles20ErrorDescriptionMap.put("glViewportGL_INVALID_VALUE", "GL_INVALID_VALUE is generated if either width or height is negative.");
    }

    public static String getError(Long key) {
        if (gles20ErrorMap == null) {
            GLES20ErrorDefine.initialize();
        }
        return gles20ErrorMap.get(key);
    }

    public static String getErrorDescription(String key) {
        if (gles20ErrorDescriptionMap == null) {
            GLES20ErrorDefine.initialize();
        }
        return gles20ErrorDescriptionMap.get(key);
    }
}

