/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.summary.warning;

import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.ui.summary.warning.WarningCase;
import org.tizen.dynamicanalyzer.ui.summary.warning.WarningData;

public class WarningChecker {
    private List<WarningData> warningData = null;

    public void clear() {
        this.getWarningData().clear();
        WarningData.resetSeq();
    }

    public List<WarningData> getWarningData() {
        if (this.warningData == null) {
            this.warningData = new ArrayList<WarningData>();
        }
        return this.warningData;
    }

    public WarningData getWarningDataByLogSeq(long seq) {
        int size = this.getWarningData().size();
        int i = 0;
        while (i < size) {
            WarningData data = this.getWarningData().get(i);
            LogData logData = data.getLogData();
            if (logData != null && logData.getSeq() == seq) {
                return data;
            }
            ++i;
        }
        return null;
    }

    public boolean isChecked(String key, int type) {
        int size = this.getWarningData().size();
        int i = 0;
        while (i < size) {
            String fileKey = this.warningData.get(i).getKey();
            int warningType = this.warningData.get(i).getWarningCase();
            if (key.equals(fileKey) && warningType == type) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean removeData(String key, int type) {
        int size = this.getWarningData().size();
        int i = 0;
        while (i < size) {
            String fileKey = this.warningData.get(i).getKey();
            int warningType = this.warningData.get(i).getWarningCase();
            if (key.equals(fileKey) && warningType == type) {
                this.warningData.remove(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String messageMaker(WarningData warning, boolean isShort) {
        int warningCase = warning.getWarningCase();
        if (warningCase == WarningCase.DUPLICATE_OPEN.getType()) {
            if (isShort) {
                return WarningCase.DUPLICATE_OPEN.getShortMessage();
            }
            return WarningCase.DUPLICATE_OPEN.getMessage(warning.getKey());
        }
        if (warningCase == WarningCase.WITHOUT_USING.getType()) {
            if (isShort) {
                return WarningCase.WITHOUT_USING.getShortMessage();
            }
            return WarningCase.WITHOUT_USING.getMessage(warning.getKey());
        }
        if (warningCase == WarningCase.JOINABLE_LEAK.getType()) {
            if (isShort) {
                return WarningCase.JOINABLE_LEAK.getShortMessage();
            }
            return WarningCase.JOINABLE_LEAK.getMessage(warning.getKey());
        }
        return "";
    }
}

