/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.thread.chart;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.tizen.dynamicanalyzer.ui.thread.chart.ThreadChartBoard;
import org.tizen.dynamicanalyzer.ui.thread.type.ThreadPageThreadData;
import org.tizen.dynamicanalyzer.widgets.chart.DAChart;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartRenderer;
import org.tizen.dynamicanalyzer.widgets.helper.ColorResources;

public class ThreadChartRenderer
extends DAChartRenderer {
    private static final int MAIN_THREAD_CALLER_TID = -1;
    ThreadChartBoard chartBoard = null;

    ThreadChartRenderer(ThreadChartBoard chartBoard) {
        this.chartBoard = chartBoard;
    }

    public void draw(GC gc, DAChart chart, Image buffer) {
        super.draw(gc, chart, buffer);
        if (this.chartBoard.getSelectItem() == null) {
            return;
        }
        if (!(this.chartBoard.getSelectItem().getData() instanceof ThreadPageThreadData)) {
            return;
        }
        ThreadPageThreadData selectedData = (ThreadPageThreadData)this.chartBoard.getSelectItem().getData();
        if (this.isCreateChart(chart, selectedData)) {
            this.drawCreateLine(gc, chart, selectedData);
        }
        if (this.isJoinChart(chart, selectedData)) {
            this.drawJoinLine(gc, chart, selectedData);
        }
    }

    private boolean isCreateChart(DAChart chart, ThreadPageThreadData selectedData) {
        int chartTID = (Integer)chart.getData();
        if (chartTID == -2) {
            return true;
        }
        int createTID = selectedData.getCreateTID();
        if (createTID == -1) {
            return false;
        }
        int selectionTID = selectedData.getTid();
        if (this.isSyncChart(chart) && chartTID == selectionTID) {
            return false;
        }
        return createTID <= chartTID && chartTID <= selectionTID;
    }

    public void drawCreateLine(GC gc, DAChart chart, ThreadPageThreadData selectedData) {
        Rectangle r = chart.getClientArea();
        double start = (double)selectedData.getStartTime() / 1000000.0;
        int startTime = this.plot.getXPixelFromX(start);
        gc.setForeground(ColorResources.RED);
        gc.setAlpha(150);
        gc.setLineWidth(2);
        int chartTID = (Integer)chart.getData();
        if (this.isSyncChart(chart)) {
            gc.drawLine(startTime, r.y, startTime, r.height);
            return;
        }
        if (chartTID == selectedData.getCreateTID()) {
            this.drawLineToStartOfDownArrow(gc, startTime);
        } else if (chartTID == selectedData.getTid()) {
            this.drawLineToEndOfDownArrow(gc, startTime);
        } else {
            this.drawMiddleLine(gc, startTime);
        }
    }

    private boolean isJoinChart(DAChart chart, ThreadPageThreadData selectedData) {
        int chartTID = (Integer)chart.getData();
        if (chartTID == -2) {
            return true;
        }
        int joinTID = selectedData.getJoinTID();
        if (joinTID == -1) {
            return false;
        }
        int selectionTID = selectedData.getTid();
        if (this.isSyncChart(chart) && chartTID == selectionTID) {
            return false;
        }
        if (joinTID < selectionTID) {
            return joinTID <= chartTID && chartTID <= selectionTID;
        }
        return selectionTID <= chartTID && chartTID <= joinTID;
    }

    public void drawJoinLine(GC gc, DAChart chart, ThreadPageThreadData selectedData) {
        Rectangle r = chart.getClientArea();
        double end = (double)selectedData.getEndTime() / 1000000.0;
        int endTime = this.plot.getXPixelFromX(end);
        gc.setForeground(ColorResources.RED);
        gc.setAlpha(150);
        gc.setLineWidth(2);
        int chartTID = (Integer)chart.getData();
        if (this.isSyncChart(chart)) {
            gc.drawLine(endTime, r.y, endTime, r.height);
            return;
        }
        int selectionTID = selectedData.getTid();
        int joinTID = selectedData.getJoinTID();
        if (joinTID < selectionTID) {
            if (chartTID == joinTID) {
                this.drawLineToStartOfUpArrow(gc, endTime);
            } else if (chartTID == selectionTID) {
                this.drawLineToEndOfUpArrow(gc, endTime);
            } else {
                this.drawMiddleLine(gc, endTime);
            }
        } else if (chartTID == selectionTID) {
            this.drawLineToStartOfDownArrow(gc, endTime);
        } else if (chartTID == joinTID) {
            this.drawLineToEndOfDownArrow(gc, endTime);
        } else {
            this.drawMiddleLine(gc, endTime);
        }
    }

    private void drawLineToStartOfDownArrow(GC gc, int time) {
        gc.drawLine(time, this.r.height / 5 * 2, time, this.r.height);
        gc.drawOval(time - 2, this.r.height / 5 * 2, 4, 4);
    }

    private void drawLineToEndOfDownArrow(GC gc, int time) {
        gc.drawLine(time, this.r.y, time, this.r.height / 5 * 3 + 3);
        gc.drawLine(time - 4, this.r.height / 5 * 3, time + 4, this.r.height / 5 * 3);
        gc.drawLine(time - 3, this.r.height / 5 * 3, time, this.r.height / 5 * 3 + 6);
        gc.drawLine(time, this.r.height / 5 * 3 + 5, time + 4, this.r.height / 5 * 3);
    }

    private void drawLineToStartOfUpArrow(GC gc, int time) {
        gc.drawLine(time, this.r.height / 6 * 5, time, this.r.height);
        gc.drawLine(time - 4, this.r.height / 6 * 5 + 4, time + 4, this.r.height / 6 * 5 + 4);
        gc.drawLine(time - 3, this.r.height / 6 * 5 + 4, time, this.r.height / 6 * 5);
        gc.drawLine(time, this.r.height / 6 * 5 + 1, time + 4, this.r.height / 6 * 5 + 4);
    }

    private void drawLineToEndOfUpArrow(GC gc, int time) {
        gc.drawLine(time, this.r.y, time, this.r.height / 6 * 4 + 3);
        gc.drawOval(time - 2, this.r.height / 6 * 4, 4, 4);
    }

    private void drawMiddleLine(GC gc, int time) {
        gc.drawLine(time, this.r.y, time, this.r.height);
    }

    private boolean isSyncChart(DAChart chart) {
        return chart.getSeriesList().size() == 2;
    }
}

