/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.thread.type;

import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.nl.ThreadPageLabels;
import org.tizen.dynamicanalyzer.ui.thread.type.ThreadPageData;
import org.tizen.dynamicanalyzer.util.Logger;

public class ThreadPageSyncData
extends ThreadPageData {
    private List<ThreadPageSyncData> children = new ArrayList<ThreadPageSyncData>();
    public static final byte SYNC_PARENT = 0;
    public static final byte SYNC_CHILD = 1;
    public static final byte THREAD_CHILD = 2;
    private static int internalSeq = 0;
    private int syncDataID = -1;
    private byte syncDataType = (byte)-1;
    private int parentID = -1;

    public ThreadPageSyncData(int type, String name, String pid, int tid, String attrType, byte syncDataType) {
        super(type, name, pid, tid, attrType);
        this.syncDataType = syncDataType;
        this.syncDataID = internalSeq++;
    }

    public ThreadPageSyncData(int id, int pid, int tid, int type, long syncValue, String attrType, byte syncDataType, int parentID) {
        super(type, String.valueOf(syncValue), String.valueOf(pid), tid, attrType);
        this.syncDataID = id;
        this.syncDataType = syncDataType;
        this.parentID = parentID;
    }

    public void pushSync(ThreadPageSyncData sync) {
        this.children.add(sync);
    }

    public ThreadPageSyncData findChildData(int tId) {
        int size = this.children.size();
        int i = 0;
        while (i < size) {
            ThreadPageSyncData ret = this.children.get(i);
            if (ret.getTid() == tId) {
                return ret;
            }
            ++i;
        }
        return null;
    }

    public List<ThreadPageSyncData> getChildren() {
        return this.children;
    }

    public static boolean isSyncApi(int apiType) {
        if (apiType == 1) {
            return false;
        }
        return apiType != 5;
    }

    public String getTypeString() {
        switch (this.getType()) {
            case 0: {
                return ThreadPageLabels.SYNC_TYPE_TIZEN_MUTEX;
            }
            case 1: {
                return ThreadPageLabels.SYNC_TYPE_TIZEN_MONITOR;
            }
            case 2: {
                return ThreadPageLabels.SYNC_TYPE_TIZEN_SEMAPHORE;
            }
            case 3: {
                return ThreadPageLabels.SYNC_TYPE_PTHREAD_MUTEX;
            }
            case 4: {
                return ThreadPageLabels.SYNC_TYPE_PTHREAD_COND_VARIABLE;
            }
            case 5: {
                return ThreadPageLabels.SYNC_TYPE_PTHREAD_RWLOCK;
            }
            case 6: {
                return ThreadPageLabels.SYNC_TYPE_PTHREAD_SPINLOCK;
            }
            case 7: {
                return ThreadPageLabels.SYNC_TYPE_PTHREAD_BARRIER;
            }
        }
        Logger.error((Object)"unknown sync type!!");
        return "";
    }

    public int getSyncDataID() {
        return this.syncDataID;
    }

    public byte getSyncDataType() {
        return this.syncDataType;
    }

    public int getParentID() {
        return this.parentID;
    }

    public void setParentID(int parentID) {
        this.parentID = parentID;
    }

    public static void clear() {
        internalSeq = 0;
    }
}

