/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.timeline.chart;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.nl.TimelineChartLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.ui.timeline.SystemDataDBTable;
import org.tizen.dynamicanalyzer.ui.timeline.TargetProcessDBTable;
import org.tizen.dynamicanalyzer.ui.timeline.chart.TimelineChart;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.utils.Formatter;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlot;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeries;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeriesItem;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoard;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardItem;

public class SystemMemoryChart
extends TimelineChart {
    private DAChartSeries processSeries;
    private DAChartSeries systemSeries;
    private DAChartSeries totalSeries;

    public SystemMemoryChart(String pageID) {
        super(pageID);
        this.chartType = -106;
        this.probeType = 5;
        this.chartName = TimelineChartLabels.SYSTEM_MEMORY_CHART_TITLE;
        this.chartDescriptor = TimelineChartLabels.SYSTEM_MEMORY_CHART_DESCRIPTOR;
        this.chartIcon = ImageResources.FEATURE_MEM_SYSTEM_SMALL_NOR;
        this.addIcon = ImageResources.FEATURE_MEM_SYSTEM_SMALL_NOR;
        this.processSeries = new DAChartSeries(TimelineChartLabels.SYSTEM_MEMORY_CHART_SERIES_NAME_PROC_RESIDENT, 3, ColorResources.CHART_SERIES_PINK);
        this.systemSeries = new DAChartSeries(TimelineChartLabels.SYSTEM_MEMORY_CHART_SERIES_NAME_SYSTEM, 3, ColorResources.CHART_SERIES_BLUE);
        this.totalSeries = new DAChartSeries(TimelineChartLabels.SYSTEM_MEMORY_CHART_SERIES_NAME_TOTAL, 3, ColorResources.CHART_SERIES_EMERALD);
    }

    @Override
    public DAChartBoardItem createBoardItem(DAChartBoard board) {
        DAChartBoardItem item = super.createBoardItem(board);
        this.chart.addSeries(this.totalSeries);
        this.chart.addSeries(this.systemSeries);
        this.chart.addSeries(this.processSeries);
        this.chart.getPlot().setAxisUnit("B");
        this.chart.getPlot().setAxisUnitType(DAChartPlot.UnitType.BINARY);
        this.chart.getPlot().setShowAxis(true);
        return item;
    }

    @Override
    public void inputChartSeries(List<Object> dataList) {
        this.processSeries.clear();
        this.systemSeries.clear();
        this.totalSeries.clear();
        if (Global.getProject() == null) {
            return;
        }
        long systemMemorySize = Global.getProject().getDeviceStatusInfo().getSystemMemorySize();
        List systemData = (List)dataList.get(0);
        Map targetProcessDataMap = (Map)dataList.get(1);
        double maxTime = 0.0;
        int i = 0;
        while (i < systemData.size()) {
            List row = (List)systemData.get(i);
            double time = (double)((Long)row.get(SystemDataDBTable.COLUMN.SAMPLING_TIME.ordinal())).longValue() / 1000000.0;
            try {
                long systemMemoryUsage = (Long)row.get(SystemDataDBTable.COLUMN.MEMORY_USAGE_SYSTEM.ordinal());
                this.totalSeries.addSeriesItem(new DAChartSeriesItem(time, (double)systemMemorySize, Formatter.toByteFormat(systemMemorySize)));
                this.systemSeries.addSeriesItem(new DAChartSeriesItem(time, (double)systemMemoryUsage, Formatter.toByteFormat(systemMemoryUsage)));
            }
            catch (NumberFormatException ne) {
                Logger.exception((Throwable)ne);
            }
            maxTime = time;
            ++i;
        }
        Iterator iter = targetProcessDataMap.keySet().iterator();
        HashMap<Long, Long> processLoadSumMap = new HashMap<Long, Long>();
        while (iter.hasNext()) {
            Integer pid = (Integer)iter.next();
            List data = (List)targetProcessDataMap.get(pid);
            int i2 = 0;
            while (i2 < data.size()) {
                List oneTime = (List)data.get(i2);
                Long time = (Long)oneTime.get(TargetProcessDBTable.COLUMN.SAMPLING_TIME.ordinal());
                Long processMemorySize = (Long)oneTime.get(TargetProcessDBTable.COLUMN.MEMORY_RESIDENT.ordinal());
                Long processMemorySizeSum = (Long)processLoadSumMap.get(time);
                if (processMemorySizeSum == null) {
                    processLoadSumMap.put(time, processMemorySize);
                } else {
                    processLoadSumMap.put(time, processMemorySizeSum + processMemorySize);
                }
                ++i2;
            }
        }
        ArrayList timeSortedLoadList = new ArrayList(processLoadSumMap.keySet());
        Collections.sort(timeSortedLoadList);
        for (Long time : timeSortedLoadList) {
            Long processMemorySizeSum = (Long)processLoadSumMap.get(time);
            if (!(maxTime >= (double)time.longValue() / 1000000.0)) continue;
            this.processSeries.addSeriesItem(new DAChartSeriesItem((double)time.longValue() / 1000000.0, (double)processMemorySizeSum.longValue(), Formatter.toByteFormat(processMemorySizeSum)));
        }
    }
}

