/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.timeline.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.tizen.dynamicanalyzer.nl.TimelineChartLabels;
import org.tizen.dynamicanalyzer.nl.WidgetLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.setting.UILayoutDataManager;
import org.tizen.dynamicanalyzer.ui.timeline.chart.TimelineChart;
import org.tizen.dynamicanalyzer.ui.timeline.common.TimelineChartManager;
import org.tizen.dynamicanalyzer.util.CommonUtil;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButton;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonClickEventListener;
import org.tizen.dynamicanalyzer.widgets.da.base.DAButton;
import org.tizen.dynamicanalyzer.widgets.da.base.DAMessageBox;

public class TimelineEditItemsDialog
extends DAMessageBox {
    private static final int COLUMN_TITLE = 0;
    private static final int COLUMN_TEXT = 1;
    private static final int TABLE_HEIGHT = 65;
    private static final int ENABLE_IMAGE_OFFSET_X = 5;
    private static final int ENABLE_IMAGE_OFFSET_Y = 6;
    private static final int TITLE_TEXT_POINT_X = 92;
    private static final int TITLE_TEXT_OFFSET_Y = 17;
    private static final int DESCRIPT_TEXT_OFFSET_Y = 39;
    private static final int TITLE_COLUMN_WIDTH = 76;
    private static final int TEXT_COLUMN_WIDTH = 345;
    private static final int MULTILINE_MARGIN = 8;
    protected TableViewer chartTableViewer;
    protected List<TimelineChart> chartList = TimelineChartManager.getInstance().getChartList();
    private boolean DragItemStartPlg = true;
    private int swapItemIndexA = 0;
    private int swapItemIndexB = 0;
    protected static boolean RunningDialog = false;
    private Map<Integer, Image> imageMap = new HashMap<Integer, Image>();
    private int maxTextWidth = 0;
    private DACustomButtonClickEventListener okButtonListener = new DACustomButtonClickEventListener(){

        public void handleClickEvent(DACustomButton button) {
            TableItem[] tableitems = TimelineEditItemsDialog.this.chartTableViewer.getTable().getItems();
            ArrayList<Integer> order = new ArrayList<Integer>();
            ArrayList<Boolean> showInfo = new ArrayList<Boolean>();
            ArrayList<String> strSaveSelectedChartNameList = new ArrayList<String>();
            TableItem[] tableItemArray = tableitems;
            int n = tableitems.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                TableItemData itemData = (TableItemData)item.getData();
                if (itemData.isEnabled) {
                    strSaveSelectedChartNameList.add(itemData.titleText);
                    showInfo.add(Boolean.TRUE);
                } else {
                    showInfo.add(Boolean.FALSE);
                }
                order.add(itemData.index);
                ++n2;
            }
            AnalyzerUtil.getTimelineComposite().reArrangeChart(order, showInfo);
            UILayoutDataManager.INSTANCE.setSelectedChartSet(strSaveSelectedChartNameList);
            TimelineEditItemsDialog.this.shell.dispose();
            RunningDialog = false;
        }
    };
    private DACustomButtonClickEventListener cancelButtonListener = new DACustomButtonClickEventListener(){

        public void handleClickEvent(DACustomButton button) {
            TimelineEditItemsDialog.this.shell.dispose();
            RunningDialog = false;
            TimelineEditItemsDialog.this.imageMap.clear();
        }
    };
    private ShellListener shellListener = new ShellAdapter(){

        public void shellClosed(ShellEvent e) {
            RunningDialog = false;
        }
    };
    private Listener tablePaintListener = new Listener(){

        public void handleEvent(Event event) {
            switch (event.type) {
                case 41: {
                    TableItem item = (TableItem)event.item;
                    String text = item.getText(event.index + 1);
                    Point size = event.gc.textExtent(text);
                    event.width = size.x;
                    event.height = 64;
                    break;
                }
                case 42: {
                    int width = TimelineEditItemsDialog.this.chartTableViewer.getTable().getClientArea().width;
                    TableItem item = (TableItem)event.item;
                    TableItemData itemData = (TableItemData)item.getData();
                    GC gc = event.gc;
                    gc.setAdvanced(true);
                    Rectangle rect = event.getBounds();
                    Color foreground = gc.getForeground();
                    Color background = gc.getBackground();
                    if (itemData.isEnabled) {
                        if (itemData.isHovered) {
                            gc.setBackground(ColorResources.ADD_CHART_ENABLE_HOVER_COLOR);
                        } else {
                            gc.setBackground(ColorResources.ADD_CHART_ENABLE_COLOR);
                        }
                        gc.fillRectangle(0, rect.y, width, 65);
                    } else {
                        if (itemData.isHovered) {
                            gc.setBackground(ColorResources.ADD_CHART_DISABLE_HOVER_COLOR);
                        } else {
                            gc.setBackground(ColorResources.ADD_CHART_DISABLE_COLOR);
                        }
                        gc.fillRectangle(0, rect.y, width, 65);
                    }
                    if (itemData.isDrag) {
                        gc.setBackground(ColorResources.ADD_CHART_DRAG_COLOR);
                        gc.setAlpha(204);
                        gc.fillRectangle(0, rect.y, width, 65);
                    }
                    gc.setForeground(foreground);
                    gc.setBackground(background);
                    event.detail &= 0xFFFFFFFD;
                    if (event.index == 0) {
                        if (!itemData.isEnabled) {
                            gc.setAlpha(51);
                        }
                        Rectangle bounds = itemData.titleImage.getBounds();
                        gc.drawImage(itemData.titleImage, 38 - bounds.width / 2, event.y + 32 - bounds.height / 2);
                        break;
                    }
                    if (event.index != 1) break;
                    Image statusImage = ImageResources.ADD_CHART_OFF;
                    Color titleColor = ColorResources.ADD_CHART_DISABLE_TITLE_COLOR;
                    Color descriptColor = ColorResources.ADD_CHART_DISABLE_DESCRIPT_COLOR;
                    if (itemData.isEnabled) {
                        statusImage = ImageResources.ADD_CHART_ON;
                        titleColor = ColorResources.ADD_CHART_ENABLE_TITLE_COLOR;
                        descriptColor = ColorResources.ADD_CHART_ENABLE_DESCRIPT_COLOR;
                    }
                    String[] temp = itemData.description.split("\n");
                    int title_point_y = 17;
                    int descript_point_y = 39;
                    if (temp.length == 2) {
                        title_point_y = 9;
                        descript_point_y = 31;
                    }
                    gc.setForeground(titleColor);
                    gc.setFont(FontResources.EDIT_CHART_DLG_ITEM_NAME);
                    gc.drawText(itemData.titleText, 92, event.y + title_point_y, true);
                    gc.setForeground(descriptColor);
                    gc.setFont(FontResources.EDIT_CHART_DLG_ITEM_SUB_NAME);
                    FontData[] fontData = FontResources.EDIT_CHART_DLG_ITEM_SUB_NAME.getFontData();
                    Font font = null;
                    if (TimelineEditItemsDialog.this.maxTextWidth > width - 92) {
                        int i = 0;
                        while (i < fontData.length) {
                            fontData[i].setHeight(fontData[i].getHeight() - 1);
                            ++i;
                        }
                        font = new Font((Device)Display.getCurrent(), fontData);
                        gc.setFont(font);
                    }
                    gc.drawText(itemData.description, 92, event.y + descript_point_y, true);
                    int imageStartX = width - statusImage.getBounds().width - 5;
                    if (CommonUtil.isMac() && TimelineEditItemsDialog.this.chartTableViewer.getTable().getVerticalBar() != null) {
                        imageStartX -= TimelineEditItemsDialog.this.chartTableViewer.getTable().getVerticalBar().getSize().x;
                    }
                    gc.drawImage(statusImage, imageStartX, event.y + 6);
                    Image itemImage = (Image)TimelineEditItemsDialog.this.imageMap.get(itemData.chartType);
                    if (itemImage == null) {
                        itemImage = new Image((Device)Display.getDefault(), width - 1, 65);
                        TimelineEditItemsDialog.this.imageMap.put(itemData.chartType, itemImage);
                    }
                    gc.copyArea(itemImage, 0, event.y);
                    if (font == null) break;
                    font.dispose();
                    break;
                }
                case 40: {
                    event.detail &= 0xFFFFFFEF;
                    break;
                }
            }
        }
    };
    private DropTargetListener dropTargetListener = new DropTargetAdapter(){

        public void dragEnter(DropTargetEvent event) {
            if (TimelineEditItemsDialog.this.DragItemStartPlg) {
                TimelineEditItemsDialog.this.swapItemIndexA = TimelineEditItemsDialog.this.chartTableViewer.getTable().getSelectionIndex();
                TimelineEditItemsDialog.this.DragItemStartPlg = false;
            } else {
                TimelineEditItemsDialog.this.chartTableViewer.getTable().deselectAll();
            }
            if (event.detail == 16) {
                event.detail = (event.operations & 2) != 0 ? 2 : 0;
            }
            int i = 0;
            int n = event.dataTypes.length;
            while (i < n) {
                if (TextTransfer.getInstance().isSupportedType(event.dataTypes[i])) {
                    event.currentDataType = event.dataTypes[i];
                }
                ++i;
            }
        }

        public void dragOver(DropTargetEvent event) {
            event.feedback = 9;
        }

        public void drop(DropTargetEvent event) {
            Point point;
            DropTarget target = (DropTarget)event.widget;
            Table table = (Table)target.getControl();
            TableItem tblItemTarget = table.getItem(point = TimelineEditItemsDialog.this.shell.getDisplay().map(null, (Control)table, event.x, event.y));
            if (tblItemTarget == null) {
                return;
            }
            TimelineEditItemsDialog.this.swapItemIndexB = table.indexOf(tblItemTarget);
            if (TimelineEditItemsDialog.this.swapItemIndexA != TimelineEditItemsDialog.this.swapItemIndexB) {
                TableItem[] chartTableItems = TimelineEditItemsDialog.this.chartTableViewer.getTable().getItems();
                TableItemData itemData_A = (TableItemData)chartTableItems[TimelineEditItemsDialog.this.swapItemIndexA].getData();
                TableItemData itemData_B = (TableItemData)chartTableItems[TimelineEditItemsDialog.this.swapItemIndexB].getData();
                TableItemData itemData_tmp = itemData_A;
                chartTableItems[TimelineEditItemsDialog.this.swapItemIndexA].setData((Object)itemData_B);
                chartTableItems[TimelineEditItemsDialog.this.swapItemIndexB].setData((Object)itemData_tmp);
            }
            TableItem[] items = TimelineEditItemsDialog.this.chartTableViewer.getTable().getItems();
            int i = 0;
            while (i < items.length) {
                ((TableItemData)items[i].getData()).isDrag = false;
                ++i;
            }
            TimelineEditItemsDialog.this.chartTableViewer.getTable().redraw();
        }
    };
    private MouseListener itemZoomMouseListener = new MouseAdapter(){

        public void mouseUp(MouseEvent event) {
            Table table = TimelineEditItemsDialog.this.chartTableViewer.getTable();
            int selectItemIndex = table.getSelectionIndex();
            if (selectItemIndex < 0) {
                return;
            }
            TableItem[] chartTableItems = TimelineEditItemsDialog.this.chartTableViewer.getTable().getItems();
            TableItemData itemData = (TableItemData)chartTableItems[selectItemIndex].getData();
            itemData.isEnabled = !itemData.isEnabled;
            table.deselectAll();
            TimelineEditItemsDialog.this.chartTableViewer.getTable().redraw();
        }
    };
    private MouseTrackListener mouseTrackListener = new MouseTrackAdapter(){

        public void mouseExit(MouseEvent e) {
            TableItem[] items = TimelineEditItemsDialog.this.chartTableViewer.getTable().getItems();
            int i = 0;
            while (i < items.length) {
                ((TableItemData)items[i].getData()).isHovered = false;
                ++i;
            }
            TimelineEditItemsDialog.this.chartTableViewer.getTable().redraw();
        }
    };
    private MouseMoveListener mouseMoveListener = new MouseMoveListener(){

        public void mouseMove(MouseEvent e) {
            TableItem targetItem = TimelineEditItemsDialog.this.findTableItem(e.x, e.y);
            TableItem[] items = TimelineEditItemsDialog.this.chartTableViewer.getTable().getItems();
            int i = 0;
            while (i < items.length) {
                ((TableItemData)items[i].getData()).isHovered = items[i] == targetItem;
                ++i;
            }
            TimelineEditItemsDialog.this.chartTableViewer.getTable().redraw();
        }
    };

    public TimelineEditItemsDialog(Shell parent) {
        super(parent);
    }

    public boolean isRunningDialog() {
        return RunningDialog;
    }

    public void setOkButtonListener(DACustomButtonClickEventListener okButtonListener) {
        this.okButtonListener = okButtonListener;
    }

    protected Set<String> getSelectedChartSet() {
        return UILayoutDataManager.INSTANCE.getSelectedChartSet();
    }

    protected boolean run() {
        this.shell.setText(TimelineChartLabels.EDIT_CHART_DLG_TITLE);
        this.shell.setBackground(ColorResources.WINDOW_BG_COLOR);
        this.shell.setSize(446, 450);
        this.shell.setLayout((Layout)new FormLayout());
        GridLayout editoeLayout = new GridLayout();
        Composite editorContainer = new Composite((Composite)this.shell, 0);
        editorContainer.setLayout((Layout)editoeLayout);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, -49);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        editorContainer.setLayoutData((Object)data);
        editorContainer.setBackground(ColorResources.EDIT_CHART_DIALOG_UPPER);
        this.chartTableViewer = new TableViewer(editorContainer, 66064);
        GridData tableGridData = new GridData(1808);
        this.chartTableViewer.getTable().setLayoutData((Object)tableGridData);
        this.chartTableViewer.getTable().setLinesVisible(true);
        if (CommonUtil.isWin() || CommonUtil.isMac()) {
            this.chartTableViewer.getTable().setBackground(ColorResources.EDIT_CHART_DIALOG_UPPER);
        } else {
            this.chartTableViewer.getTable().setBackground(ColorResources.EDIT_CHART_TABLE_SEPARATE_COLOR);
        }
        new TableColumn(this.chartTableViewer.getTable(), 0).setWidth(76);
        new TableColumn(this.chartTableViewer.getTable(), 0).setWidth(345);
        Set<String> selectedChartSet = this.getSelectedChartSet();
        GC gc = new GC((Drawable)Display.getCurrent());
        gc.setFont(FontResources.EDIT_CHART_DLG_ITEM_SUB_NAME);
        int chartListSize = this.chartList.size();
        TableItem[] items = new TableItem[chartListSize];
        int i = 0;
        while (i < chartListSize) {
            items[i] = new TableItem(this.chartTableViewer.getTable(), 0, i);
            items[i].setText(this.chartList.get(i).getChartName());
            items[i].setFont(FontResources.EDIT_CHART_DLG_ITEM_NAME);
            TableItemData itemData = new TableItemData();
            itemData.index = i;
            itemData.chartType = this.chartList.get(i).getChartType();
            itemData.titleImage = this.chartList.get(i).getAddIcon();
            itemData.titleText = this.chartList.get(i).getChartName();
            itemData.description = this.chartList.get(i).getChartDescriptor();
            int textWidth = gc.textExtent((String)itemData.description).x;
            this.maxTextWidth = this.maxTextWidth > textWidth ? this.maxTextWidth : textWidth;
            itemData.isEnabled = false;
            itemData.isHovered = false;
            if (selectedChartSet.contains(itemData.titleText)) {
                itemData.isEnabled = true;
            }
            items[i].setData((Object)itemData);
            ++i;
        }
        gc.dispose();
        this.chartTableViewer.getTable().addListener(41, this.tablePaintListener);
        this.chartTableViewer.getTable().addListener(42, this.tablePaintListener);
        this.chartTableViewer.getTable().addListener(40, this.tablePaintListener);
        this.chartTableViewer.getTable().addMouseListener(this.itemZoomMouseListener);
        this.chartTableViewer.getTable().addMouseTrackListener(this.mouseTrackListener);
        this.chartTableViewer.getTable().addMouseMoveListener(this.mouseMoveListener);
        Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
        DragSource source = new DragSource((Control)this.chartTableViewer.getTable(), 2);
        source.setTransfer(types);
        source.addDragListener((DragSourceListener)new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent event) {
                TableItem sourceItem = TimelineEditItemsDialog.this.findTableItem(event.x, event.y);
                if (sourceItem == null) {
                    Logger.warning((Object)"drag sourceItem is null.");
                    return;
                }
                event.data = sourceItem.getText();
                TimelineEditItemsDialog.this.chartTableViewer.getTable().redraw();
            }

            public void dragStart(DragSourceEvent event) {
                TableItem selection = TimelineEditItemsDialog.this.findTableItem(event.x, event.y);
                if (selection == null) {
                    Logger.warning((Object)"drag selection is null.");
                    return;
                }
                Image dropImage = (Image)TimelineEditItemsDialog.this.imageMap.get(((TableItemData)selection.getData()).chartType);
                ((TableItemData)selection.getData()).isDrag = true;
                event.image = dropImage;
                TimelineEditItemsDialog.this.DragItemStartPlg = true;
                TimelineEditItemsDialog.this.chartTableViewer.getTable().redraw();
            }
        });
        DropTarget target = new DropTarget((Control)this.chartTableViewer.getTable(), 2);
        target.setTransfer(types);
        target.addDropListener(this.dropTargetListener);
        Composite buttonComp = new Composite((Composite)this.shell, 0);
        buttonComp.setBackground(ColorResources.EDIT_CHART_DIALOG_LOWER);
        buttonComp.setLayout((Layout)new FormLayout());
        data = new FormData();
        data.top = new FormAttachment((Control)editorContainer, 0);
        data.bottom = new FormAttachment(100, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        buttonComp.setLayoutData((Object)data);
        DAButton okButton = new DAButton(buttonComp, 8);
        this.setEditDialogButtonStyle(okButton);
        okButton.addClickListener(this.okButtonListener);
        okButton.setText(WidgetLabels.OK);
        okButton.setFont(FontResources.EDIT_CHART_DLG_BUTTON);
        data = new FormData();
        data.top = new FormAttachment(0, 11);
        data.left = new FormAttachment(0, 119);
        data.width = 86;
        data.height = 24;
        okButton.setLayoutData((Object)data);
        DAButton cancelButton = new DAButton(buttonComp, 8);
        this.setEditDialogButtonStyle(cancelButton);
        cancelButton.addClickListener(this.cancelButtonListener);
        cancelButton.setText(WidgetLabels.CANCEL);
        cancelButton.setFont(FontResources.EDIT_CHART_DLG_BUTTON);
        data = new FormData();
        data.top = new FormAttachment(0, 11);
        data.left = new FormAttachment((Control)okButton, 8);
        data.width = 86;
        data.height = 24;
        cancelButton.setLayoutData((Object)data);
        buttonComp.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Composite comp = (Composite)e.widget;
                Rectangle rect = comp.getClientArea();
                e.gc.setForeground(ColorResources.DIALOG_SUNKEN_1);
                e.gc.drawLine(rect.x, rect.y, rect.x + rect.width, rect.y);
                e.gc.setForeground(ColorResources.DIALOG_SUNKEN_2);
                e.gc.drawLine(rect.x, rect.y + 1, rect.x + rect.width, rect.y + 1);
            }
        });
        RunningDialog = true;
        this.shell.addShellListener(this.shellListener);
        return true;
    }

    private void setEditDialogButtonStyle(DAButton button) {
        button.setGradation(ColorResources.EDIT_CHART_BUTTON_NORMAL_COLOR_START, ColorResources.EDIT_CHART_BUTTON_NORMAL_COLOR_END, ColorResources.EDIT_CHART_BUTTON_PUSH_COLOR_START, ColorResources.EDIT_CHART_BUTTON_PUSH_COLOR_END, ColorResources.EDIT_CHART_BUTTON_HOVER_COLOR_START, ColorResources.EDIT_CHART_BUTTON_HOVER_COLOR_END, null, null);
        button.setOutlineColors(ColorResources.EDIT_CHART_BUTTON_OUTLINE_NORMAL_COLOR, ColorResources.EDIT_CHART_BUTTON_OUTLINE_PUSH_COLOR, ColorResources.EDIT_CHART_BUTTON_OUTLINE_HOVER_COLOR, null);
        button.setOutlineInColors(ColorResources.EDIT_CHART_BUTTON_INLINE_NORMAL_COLOR, ColorResources.EDIT_CHART_BUTTON_INLINE_PUSH_COLOR, ColorResources.EDIT_CHART_BUTTON_INLINE_HOVER_COLOR, null);
    }

    private TableItem findTableItem(int x, int y) {
        return this.chartTableViewer.getTable().getItem(new Point(x, y));
    }

    protected static class TableItemData {
        public int index;
        public int chartType;
        public Image titleImage;
        public String titleText;
        public String description = "";
        public boolean isEnabled = false;
        public boolean isHovered = false;
        public boolean isDrag = false;

        protected TableItemData() {
        }
    }
}

