/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.utils;

import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.tizen.dynamicanalyzer.util.Logger;

public class JsonUtil {
    public static final String CMD_SCREENDUMP = "screendump";
    public static final String CMD_EXECUTE = "execute";
    public static final String CMD_ARGS = "arguments";
    public static final String ARG_FILENAME = "filename";
    private static JSONParser parser = new JSONParser();

    public static JSONObject decodeObject(String message) {
        JSONObject obj = null;
        if (message == null) {
            Logger.debug((Object)"decodeObject - message string is null.");
            return obj;
        }
        try {
            obj = (JSONObject)parser.parse(message);
        }
        catch (ParseException e) {
            Logger.exception((Throwable)e);
            Logger.info((Object)("position: " + e.getPosition()));
            Logger.info((Object)e.toString());
        }
        return obj;
    }

    public static JSONArray decodeArray(String message) {
        JSONArray obj = null;
        if (message == null) {
            Logger.debug((Object)"decodeArray - message string is null.");
            return obj;
        }
        try {
            obj = (JSONArray)parser.parse(message);
        }
        catch (ParseException e) {
            Logger.info((Object)("position: " + e.getPosition()));
            Logger.info((Object)e.toString());
        }
        return obj;
    }

    public static String decodeString(String message) {
        if (message == null) {
            Logger.debug((Object)"decodeArray - message string is null.");
            return null;
        }
        JSONObject obj = JsonUtil.decodeObject(message);
        if (obj == null) {
            return null;
        }
        return obj.toJSONString();
    }

    public static String encodeString(String key, String value) {
        if (value == null) {
            return null;
        }
        JSONObject obj = new JSONObject();
        obj.put((Object)key, (Object)value);
        return obj.toJSONString().trim();
    }

    public static String encodeString(String key1, String value1, String key2, String value2) {
        JSONObject obj = new JSONObject();
        obj.put((Object)key1, (Object)value1);
        obj.put((Object)key2, (Object)value2);
        return obj.toJSONString().trim();
    }

    public static String encodeString(String key1, String value1, String key2, JSONObject objs) {
        JSONObject obj = new JSONObject();
        obj.put((Object)key1, (Object)value1);
        obj.put((Object)key2, (Object)objs);
        return obj.toJSONString().trim();
    }

    public static String encodeString(String key1, String value1, String key2, JSONObject objs, String type) {
        JSONObject obj = new JSONObject();
        obj.put((Object)key1, (Object)value1);
        obj.put((Object)key2, (Object)objs);
        obj.put((Object)"type", (Object)type);
        return obj.toJSONString().trim();
    }

    public static JSONObject encodeObject(String key, String value) {
        JSONObject obj = new JSONObject();
        obj.put((Object)key, (Object)value);
        return obj;
    }
}

