/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.da.base;

import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.tizen.dynamicanalyzer.util.Logger;

public class DAMessageBox {
    protected Object result = null;
    protected boolean initSuccess = false;
    protected Shell parentShell = null;
    protected Shell shell = null;
    protected boolean block = false;
    protected static Window.IExceptionHandler exceptionHandler = new DefaultExceptionHandler();

    public DAMessageBox(Shell parentShell) {
        this.parentShell = parentShell;
        this.shell = new Shell(parentShell, 67680);
    }

    public Object open() {
        this.block = true;
        this.parentShell.setEnabled(false);
        this.initSuccess = this.run();
        if (this.initSuccess) {
            this.shell.open();
            if (this.block) {
                this.runEventLoop(this.shell);
            }
        }
        this.shell.dispose();
        if (!this.parentShell.isDisposed()) {
            this.parentShell.setEnabled(true);
        }
        this.closeAction();
        return this.result;
    }

    protected void setResult(Object result) {
        this.result = result;
    }

    protected boolean run() {
        return true;
    }

    protected Object closeAction() {
        return this.result;
    }

    protected void runEventLoop(Shell loopShell) {
        Display display = this.shell == null ? Display.getCurrent() : loopShell.getDisplay();
        while (loopShell != null && !loopShell.isDisposed()) {
            try {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            catch (SWTException e) {
                exceptionHandler.handleException((Throwable)e);
            }
        }
        if (!display.isDisposed()) {
            display.update();
        }
    }

    private static class DefaultExceptionHandler
    implements Window.IExceptionHandler {
        private DefaultExceptionHandler() {
        }

        public void handleException(Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            Logger.exception((Throwable)t);
        }
    }
}

