/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.scale;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.tizen.dynamicanalyzer.widgets.scale.DACustomScaleRenderer;
import org.tizen.dynamicanalyzer.widgets.scale.DAScaleAttribute;
import org.tizen.dynamicanalyzer.widgets.scale.DAScaleDefaultRenderer;
import org.tizen.dynamicanalyzer.widgets.scale.DAScaleSelectionListener;

public class DAScale
extends Canvas {
    private static final int DEFAULT_LEFT_AREA_WIDTH = 20;
    private static final int DEFAULT_RIGHT_AREA_WIDTH = 20;
    private static final int LEFT_MARGIN = 3;
    private static final int RIGHT_MARGIN = 3;
    private static final int DEFAULT_AREA_HEIGHT = 1;
    private static final int SCALE_BAR_HEIGHT = 1;
    private static final int THUMB_HEIGHT = 7;
    private static final int THUMB_WIDTH = 7;
    public static final int DEFAULT_SCALE_INDEX = 2;
    private DAScaleAttribute attr;
    private DAScaleDefaultRenderer renderer;
    private DAScaleSelectionListener selectionListener = null;
    private List<Integer> selectPositions = null;
    private int selection = 0;
    private int increment = 1;
    private int pageIncrement = 1;
    private int maximum;
    private int minimum = 0;
    private int areaWidth = 0;
    private int areaHeight = 0;
    private int leftWidth = 20;
    private int rightWidth = 20;
    private int thumbAreaStart = 27;
    private boolean mouseDown = false;
    private Rectangle thumbRect = null;
    private Rectangle areaRect = null;
    private Rectangle leftRect = null;
    private Rectangle rightRect = null;
    private Listener mouseListener = new Listener(){

        public void handleEvent(Event event) {
            if (event.type == 3) {
                if (DAScale.this.pointInRect(DAScale.this.thumbRect, new Point(event.x, event.y))) {
                    DAScale.this.mouseDown = true;
                } else if (event.x >= ((DAScale)DAScale.this).areaRect.x && event.x <= ((DAScale)DAScale.this).areaRect.x + ((DAScale)DAScale.this).areaRect.width) {
                    int thumbX = ((DAScale)DAScale.this).thumbRect.x + 3;
                    if (event.x < thumbX) {
                        DAScale.this.changeScale(false);
                    } else {
                        DAScale.this.changeScale(true);
                    }
                }
            }
            if (event.type == 4) {
                DAScale.this.mouseDown = false;
                if (DAScale.this.pointInRect(DAScale.this.leftRect, new Point(event.x, event.y))) {
                    DAScale.this.changeScale(false);
                }
                if (DAScale.this.pointInRect(DAScale.this.rightRect, new Point(event.x, event.y))) {
                    DAScale.this.changeScale(true);
                }
            }
            if (event.type == 5 && DAScale.this.mouseDown) {
                DAScale.this.setSelectionInternal(event.x);
                DAScale.this.thumbRect = DAScale.this.getThumbRect(event.x);
                DAScale.this.redraw();
            }
            if (DAScale.this.selectionListener != null) {
                DAScale.this.selectionListener.widgetSelected();
            }
        }
    };
    private PaintListener paintListener = new PaintListener(){

        public void paintControl(PaintEvent e) {
            DAScale.this.attr.setAreaRect(DAScale.this.areaRect);
            DAScale.this.attr.setLeftRect(DAScale.this.leftRect);
            DAScale.this.attr.setRightRect(DAScale.this.rightRect);
            DAScale.this.attr.setThumbRect(DAScale.this.thumbRect);
            DAScale.this.renderer.draw(e.gc, (Canvas)e.widget, DAScale.this.attr);
        }
    };
    private ControlListener controlListener = new ControlListener(){

        public void controlResized(ControlEvent e) {
            Canvas canvas = (Canvas)e.widget;
            Rectangle rect = canvas.getClientArea();
            if (DAScale.this.attr.getLeftImage() != null && DAScale.this.attr.getRightImage() != null) {
                DAScale.this.leftRect = DAScale.this.attr.getLeftImage().getBounds();
                if (((DAScale)DAScale.this).leftRect.height < rect.height) {
                    ((DAScale)DAScale.this).leftRect.y += (rect.height - ((DAScale)DAScale.this).leftRect.height) / 2;
                }
                DAScale.this.rightRect = DAScale.this.attr.getRightImage().getBounds();
                if (((DAScale)DAScale.this).rightRect.height < rect.height) {
                    ((DAScale)DAScale.this).rightRect.y += (rect.height - ((DAScale)DAScale.this).rightRect.height) / 2;
                }
                DAScale.this.rightRect = new Rectangle(163, ((DAScale)DAScale.this).rightRect.y, ((DAScale)DAScale.this).rightRect.width, ((DAScale)DAScale.this).rightRect.height);
            } else {
                DAScale.this.leftRect = new Rectangle(rect.x, rect.y, DAScale.this.leftWidth, rect.height);
                DAScale.this.rightRect = new Rectangle(rect.x + rect.width - DAScale.this.rightWidth, rect.y, DAScale.this.rightWidth, rect.height);
            }
            DAScale.this.areaWidth = 190 - (((DAScale)DAScale.this).leftRect.width + ((DAScale)DAScale.this).rightRect.width);
            DAScale.this.areaHeight = 1;
            int areaY = rect.y + (rect.height - DAScale.this.areaHeight) / 2;
            DAScale.this.areaRect = new Rectangle(rect.x + DAScale.this.thumbAreaStart, areaY, DAScale.this.areaWidth, DAScale.this.areaHeight);
            DAScale.this.initSelectPosition();
            if (DAScale.this.thumbRect == null) {
                int thumbPos = (Integer)DAScale.this.selectPositions.get(DAScale.this.selection);
                DAScale.this.thumbRect = DAScale.this.getThumbRect(thumbPos);
            }
        }

        public void controlMoved(ControlEvent e) {
        }
    };

    public DAScale(Composite parent, int maximum, int style) {
        this(parent, maximum, 2, style);
    }

    public DAScale(Composite parent, int maximum, int selection, int style) {
        super(parent, style);
        this.maximum = maximum;
        this.selection = selection;
        this.attr = new DAScaleAttribute();
        this.renderer = new DACustomScaleRenderer();
        this.selectPositions = new ArrayList<Integer>();
        this.addListener(3, this.mouseListener);
        this.addListener(4, this.mouseListener);
        this.addListener(5, this.mouseListener);
        this.addPaintListener(this.paintListener);
        this.addControlListener(this.controlListener);
    }

    public void setIncrement(int increment) {
        this.increment = increment;
    }

    public int getIncrement() {
        return this.increment;
    }

    public void setPageIncrement(int increment) {
        this.pageIncrement = increment;
    }

    public int getPageIncrement() {
        return this.pageIncrement;
    }

    public void setMaximum(int max) {
        this.maximum = max;
    }

    public int getSelection() {
        if (this.areaRect == null) {
            return this.selection;
        }
        int tick = this.getTickSize();
        int thumbX = this.thumbRect.x + 3;
        int width = thumbX - this.areaRect.x;
        if (width == 0) {
            return this.minimum;
        }
        if (this.areaRect.width == width) {
            return this.maximum;
        }
        int quotient = width / tick;
        int reminder = width % tick;
        int result = 0;
        result = reminder == 0 ? quotient + this.minimum : quotient + this.minimum + 1;
        return result;
    }

    public void setLeftImage(Image left) {
        this.attr.setLeftImage(left);
    }

    public void setRightImage(Image right) {
        this.attr.setRightImage(right);
    }

    public void setThumbImage(Image thumb) {
        this.attr.setThumbImage(thumb);
    }

    public void setSelection(int selection) {
        if (selection > this.maximum) {
            selection = this.maximum;
        } else if (selection < this.minimum) {
            selection = this.minimum;
        }
        this.selection = selection - this.minimum;
        int thumbPos = this.selectPositions.get(this.selection);
        this.thumbRect = this.getThumbRect(thumbPos);
        this.redraw();
    }

    public void addSelectionListener(DAScaleSelectionListener listener) {
        if (listener == null) {
            return;
        }
        this.selectionListener = listener;
    }

    public void setRenderer(DAScaleDefaultRenderer renderer) {
        this.renderer = renderer;
    }

    public void setLeftWidth(int leftWidth) {
        this.leftWidth = leftWidth;
        this.thumbAreaStart = leftWidth + 3;
    }

    public void setRightWidth(int rightWidth) {
        this.rightWidth = rightWidth;
    }

    private boolean pointInRect(Rectangle rect, Point p) {
        return p.x > rect.x && p.x > rect.y && p.x < rect.x + rect.width && p.y < rect.y + rect.height;
    }

    private Rectangle getThumbRect(int pointX) {
        int thumbHeight = 7;
        int thumbWidth = 7;
        if (this.attr.getThumbImage() != null) {
            Rectangle thumbImageRect = this.attr.getThumbImage().getBounds();
            thumbHeight = thumbImageRect.height;
            thumbWidth = thumbImageRect.width;
        }
        if (pointX < this.areaRect.x) {
            pointX = this.areaRect.x;
        } else if (pointX > this.areaRect.x + this.areaRect.width) {
            pointX = this.areaRect.x + this.areaRect.width;
        }
        int y = this.areaRect.y - (thumbHeight - this.areaRect.height) / 2;
        int x = pointX - thumbWidth / 2;
        return new Rectangle(x, y, thumbWidth, thumbHeight);
    }

    private void setSelectionInternal(int pointX) {
        if (pointX <= this.areaRect.x) {
            this.selection = 0;
        } else if (pointX >= this.areaRect.x + this.areaRect.width) {
            this.selection = this.maximum - this.minimum;
        } else {
            int tick = this.getTickSize();
            int width = pointX - this.areaRect.x;
            int quotient = width / tick;
            int reminder = width % tick;
            this.selection = reminder == 0 ? quotient : quotient + 1;
        }
    }

    private int getTickSize() {
        return this.areaRect.width / (this.maximum - this.minimum);
    }

    private void increaseSelection() {
        if (this.selection < this.maximum - this.minimum) {
            ++this.selection;
        }
    }

    private void decreaseSelection() {
        if (this.selection > 0) {
            --this.selection;
        }
    }

    public void changeScale(boolean isIncrease) {
        if (isIncrease) {
            this.increaseSelection();
        } else {
            this.decreaseSelection();
        }
        int delta = this.selectPositions.get(this.selection);
        this.thumbRect = this.getThumbRect(delta);
        this.redraw();
    }

    private void initSelectPosition() {
        this.selectPositions.clear();
        int size = this.maximum - this.minimum + 1;
        int tickSize = this.getTickSize();
        int i = 0;
        while (i < size) {
            if (i == 0) {
                this.selectPositions.add(this.areaRect.x);
            } else if (i == size - 1) {
                this.selectPositions.add(this.areaRect.x + this.areaRect.width);
            } else {
                int pos = tickSize * i + this.areaRect.x;
                this.selectPositions.add(pos);
            }
            ++i;
        }
    }
}

