/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions;

import java.math.BigInteger;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.CompoundInstruction;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.GetValue;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.OperandValue;
import org.eclipse.cdt.debug.edc.symbols.IType;
import org.eclipse.core.runtime.CoreException;

public abstract class BinaryLogicalOperator
extends CompoundInstruction {
    protected BinaryLogicalOperator(int resultId, boolean isAssignmentOperator, int start) {
        super(start);
    }

    @Override
    public void execute() throws CoreException {
        OperandValue right = this.popValue();
        OperandValue left = this.popValue();
        right = this.convertForPromotion(right);
        left = this.convertForPromotion(left);
        int promotedType = this.getJavaBinaryPromotionType(right, left);
        IType type = this.fInterpreter.getTypeEngine().getBooleanType(1);
        switch (promotedType) {
            case 11: {
                this.pushNewValue(type, this.getStringResult(GetValue.getStringValue(left), GetValue.getStringValue(right)));
                break;
            }
            case 8: {
                this.pushNewValue(type, this.getDoubleResult(GetValue.getDoubleValue(left), GetValue.getDoubleValue(right)));
                break;
            }
            case 9: {
                this.pushNewValue(type, this.getFloatResult(GetValue.getFloatValue(left), GetValue.getFloatValue(right)));
                break;
            }
            case 7: {
                this.pushNewValue(type, this.getLongResult(GetValue.getLongValue(left), GetValue.getLongValue(right)));
                break;
            }
            case 10: {
                this.pushNewValue(type, this.getIntResult(GetValue.getIntValue(left), GetValue.getIntValue(right)));
                break;
            }
            case 5: {
                this.pushNewValue(type, this.getBooleanResult(GetValue.getBooleanValue(left), GetValue.getBooleanValue(right)));
                break;
            }
            case 13: {
                this.pushNewValue(type, this.getBigIntegerResult(GetValue.getBigIntegerValue(left), GetValue.getBigIntegerValue(right)));
            }
        }
    }

    protected abstract boolean getIntResult(int var1, int var2) throws CoreException;

    protected abstract boolean getLongResult(long var1, long var3) throws CoreException;

    protected abstract boolean getBigIntegerResult(BigInteger var1, BigInteger var2) throws CoreException;

    protected abstract boolean getFloatResult(float var1, float var2);

    protected abstract boolean getDoubleResult(double var1, double var3);

    protected abstract boolean getBooleanResult(boolean var1, boolean var2);

    protected abstract boolean getStringResult(String var1, String var2) throws CoreException;
}

