/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.symbols.elf;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.eclipse.cdt.debug.edc.internal.FileStreamBuffer;
import org.eclipse.cdt.debug.edc.internal.symbols.elf.IRandomReadAccessFile;

public class BufferedRandomReadAccessFile
implements IRandomReadAccessFile {
    private RandomAccessFile file;
    private FileStreamBuffer buffer;
    private FileStreamBuffer bigEndianBuffer;
    private long filePointer;

    public BufferedRandomReadAccessFile(String file, boolean isle) throws IOException {
        this.file = new RandomAccessFile(file, "r");
        this.buffer = new FileStreamBuffer(this.file, isle ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
        this.bigEndianBuffer = new FileStreamBuffer(this.file, ByteOrder.BIG_ENDIAN);
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        try {
            this.bigEndianBuffer.get(b);
        }
        finally {
            this.buffer.position(this.bigEndianBuffer.position());
        }
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        try {
            this.bigEndianBuffer.get(b, off, len);
        }
        finally {
            this.buffer.position(this.bigEndianBuffer.position());
        }
    }

    @Override
    public int skipBytes(int n) throws IOException {
        long cap = this.bigEndianBuffer.capacity();
        long cur = this.bigEndianBuffer.position();
        long pos = Math.min(cap, cur + (long)n);
        this.bigEndianBuffer.position(pos);
        this.buffer.position(pos);
        return (int)(pos - cur);
    }

    @Override
    public boolean readBoolean() throws IOException {
        try {
            boolean bl = this.bigEndianBuffer.get() != 0;
            return bl;
        }
        finally {
            this.buffer.position(this.bigEndianBuffer.position());
        }
    }

    @Override
    public byte readByte() throws IOException {
        try {
            byte by = this.bigEndianBuffer.get();
            return by;
        }
        finally {
            this.buffer.position(this.bigEndianBuffer.position());
        }
    }

    @Override
    public int readUnsignedByte() throws IOException {
        try {
            int n = this.bigEndianBuffer.get() & 0xFF;
            return n;
        }
        finally {
            this.buffer.position(this.bigEndianBuffer.position());
        }
    }

    @Override
    public short readShort() throws IOException {
        try {
            short s = this.bigEndianBuffer.getShort();
            return s;
        }
        finally {
            this.buffer.position(this.bigEndianBuffer.position());
        }
    }

    @Override
    public int readUnsignedShort() throws IOException {
        try {
            int n = this.bigEndianBuffer.getShort() & 0xFFFF;
            return n;
        }
        finally {
            this.buffer.position(this.bigEndianBuffer.position());
        }
    }

    @Override
    public char readChar() throws IOException {
        try {
            char c = this.bigEndianBuffer.getChar();
            return c;
        }
        finally {
            this.buffer.position(this.bigEndianBuffer.position());
        }
    }

    @Override
    public int readInt() throws IOException {
        try {
            int n = this.bigEndianBuffer.getInt();
            return n;
        }
        finally {
            this.buffer.position(this.bigEndianBuffer.position());
        }
    }

    @Override
    public long readLong() throws IOException {
        try {
            long l = this.bigEndianBuffer.getLong();
            return l;
        }
        finally {
            this.buffer.position(this.bigEndianBuffer.position());
        }
    }

    @Override
    public float readFloat() throws IOException {
        try {
            float f = Float.intBitsToFloat(this.bigEndianBuffer.getInt());
            return f;
        }
        finally {
            this.buffer.position(this.bigEndianBuffer.position());
        }
    }

    @Override
    public double readDouble() throws IOException {
        try {
            double d = Double.longBitsToDouble(this.bigEndianBuffer.getLong());
            return d;
        }
        finally {
            this.buffer.position(this.bigEndianBuffer.position());
        }
    }

    @Override
    public String readLine() throws IOException {
        try {
            StringBuilder sb;
            block7: {
                sb = new StringBuilder();
                try {
                    byte b;
                    while ((b = this.bigEndianBuffer.get()) != 0) {
                        sb.append((char)(b & 0xFF));
                    }
                }
                catch (BufferUnderflowException bufferUnderflowException) {
                    if (sb.length() != 0) break block7;
                    this.buffer.position(this.bigEndianBuffer.position());
                    return null;
                }
            }
            String string = sb.toString();
            return string;
        }
        finally {
            this.buffer.position(this.bigEndianBuffer.position());
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String readUTF() throws IOException {
        try {
            StringBuilder sb;
            block7: {
                short s;
                short length;
                block6: {
                    length = this.bigEndianBuffer.getShort();
                    sb = new StringBuilder();
                    if (!true) break block6;
                    s = length;
                    length = (short)(s - 1);
                    if (s <= 0) break block7;
                }
                do {
                    int c;
                    if ((c = this.bigEndianBuffer.get() & 0xFF) >= 128) assert (false);
                    sb.append(c);
                    s = length;
                    length = (short)(s - 1);
                } while (s > 0);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            this.buffer.position(this.bigEndianBuffer.position());
        }
    }

    @Override
    public void close() throws IOException {
        this.file.close();
    }

    @Override
    public void setEndian(boolean le) {
        this.buffer.setOrder(le ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
    }

    @Override
    public void setFileOffset(long offset) throws IOException {
        this.filePointer = offset;
        try {
            try {
                this.buffer.position(offset);
            }
            catch (IllegalArgumentException e) {
                throw (IOException)new IOException().initCause(e);
            }
        }
        finally {
            this.bigEndianBuffer.position(offset);
        }
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.filePointer;
    }

    @Override
    public void seek(long pos) throws IOException {
        try {
            try {
                this.buffer.position(pos + this.filePointer);
            }
            catch (IllegalArgumentException e) {
                throw (IOException)new IOException().initCause(e);
            }
        }
        finally {
            this.bigEndianBuffer.position(pos + this.filePointer);
        }
    }

    @Override
    public short readShortE() throws IOException {
        try {
            short s = this.buffer.getShort();
            return s;
        }
        finally {
            this.bigEndianBuffer.position(this.buffer.position());
        }
    }

    @Override
    public long readIntE() throws IOException {
        try {
            long l = this.buffer.getInt();
            return l;
        }
        finally {
            this.bigEndianBuffer.position(this.buffer.position());
        }
    }

    @Override
    public long readLongE() throws IOException {
        try {
            long l = this.buffer.getLong();
            return l;
        }
        finally {
            this.bigEndianBuffer.position(this.buffer.position());
        }
    }

    @Override
    public void readFullyE(byte[] bytes) throws IOException {
        try {
            this.buffer.get(bytes);
            if (this.buffer.getOrder() != ByteOrder.BIG_ENDIAN) {
                int i = 0;
                while (i < bytes.length / 2) {
                    byte tmp = bytes[i];
                    bytes[i] = bytes[bytes.length - i - 1];
                    bytes[bytes.length - i - 1] = tmp;
                    ++i;
                }
            }
        }
        finally {
            this.bigEndianBuffer.position(this.buffer.position());
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        try {
            long max = this.bigEndianBuffer.capacity();
            int toRead = (int)Math.min(max - (long)(off + len), (long)len);
            this.buffer.get(b, off, toRead);
            int n = toRead;
            return n;
        }
        finally {
            this.bigEndianBuffer.position(this.buffer.position());
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public long length() throws IOException {
        return this.buffer.capacity();
    }

    @Override
    public ByteBuffer createReadByteBuffer(long offset, long size) throws IOException {
        assert (false);
        try {
            byte[] contents = new byte[(int)size];
            long cur = this.buffer.position();
            this.buffer.position(offset);
            this.buffer.get(contents);
            this.buffer.position(cur);
            return ByteBuffer.wrap(contents);
        }
        catch (IllegalArgumentException e) {
            throw (IOException)new IOException().initCause(e);
        }
    }
}

