/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.services;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.edc.disassembler.CodeBufferUnderflowException;
import org.eclipse.cdt.debug.edc.disassembler.DisassembledInstruction;
import org.eclipse.cdt.debug.edc.disassembler.EDCInstruction;
import org.eclipse.cdt.debug.edc.disassembler.EDCInstructionFunctionInfo;
import org.eclipse.cdt.debug.edc.disassembler.EDCMixedInstruction;
import org.eclipse.cdt.debug.edc.disassembler.IDisassembledInstruction;
import org.eclipse.cdt.debug.edc.disassembler.IDisassembler;
import org.eclipse.cdt.debug.edc.internal.services.dsf.EDCServicesMessages;
import org.eclipse.cdt.debug.edc.launch.EDCLaunch;
import org.eclipse.cdt.debug.edc.services.AbstractEDCService;
import org.eclipse.cdt.debug.edc.services.IEDCModuleDMContext;
import org.eclipse.cdt.debug.edc.services.IEDCModules;
import org.eclipse.cdt.debug.edc.services.IEDCSymbols;
import org.eclipse.cdt.debug.edc.services.ITargetEnvironment;
import org.eclipse.cdt.debug.edc.symbols.ILineEntry;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IDisassembly;
import org.eclipse.cdt.dsf.debug.service.IInstruction;
import org.eclipse.cdt.dsf.debug.service.IMemory;
import org.eclipse.cdt.dsf.debug.service.IMixedInstruction;
import org.eclipse.cdt.dsf.debug.service.IModules;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.utils.Addr64;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.tm.tcf.services.IMemory;

public class Disassembly
extends AbstractEDCService
implements IDisassembly {
    private static final int asmFence = 32;

    public Disassembly(DsfSession session, String[] classNames) {
        super(session, Disassembly.massageClassNames(classNames, new String[]{IDisassembly.class.getName(), Disassembly.class.getName()}));
    }

    public static IStatus statusNoDisassembler() {
        return new Status(4, "org.eclipse.cdt.debug.edc", 10004, EDCServicesMessages.Disassembly_NoDisassemblerYet, null);
    }

    private static IStatus statusCannotReadMemory(String memoryAt, Integer memoryLength) {
        return new Status(4, "org.eclipse.cdt.debug.edc", 10004, Disassembly.cantReadMemory(memoryAt, memoryLength.toString()), null);
    }

    private static String cantReadMemory(String memoryAt, String memoryLength) {
        memoryLength = memoryLength == null ? "unknown" : memoryLength;
        return MessageFormat.format(EDCServicesMessages.Disassembly_CannotReadMemoryAt, memoryAt, memoryLength);
    }

    public static ByteBuffer translateMemoryBytes(MemoryByte[] memBytes, IAddress start, RequestMonitor rm) {
        byte[] bytes = new byte[memBytes.length];
        int i = 0;
        while (i < memBytes.length) {
            if (!memBytes[i].isReadable()) {
                rm.setStatus(Disassembly.statusCannotReadMemory(start.add((long)i).toHexAddressString(), memBytes.length - i));
                rm.done();
                return null;
            }
            bytes[i] = memBytes[i].getValue();
            ++i;
        }
        return ByteBuffer.wrap(bytes);
    }

    private ByteBuffer translateMemoryBytes(List<MemoryByte> memBytes) {
        byte[] bytes = new byte[memBytes.size()];
        boolean firstIsReadable = memBytes.get(0).isReadable();
        int count = 0;
        for (MemoryByte memByte : memBytes) {
            if (memByte.isReadable() != firstIsReadable) break;
            byte by = bytes[count++] = firstIsReadable ? memByte.getValue() : (byte)0;
        }
        return ByteBuffer.wrap(bytes, 0, count);
    }

    public void getInstructions(IDisassembly.IDisassemblyDMContext context, BigInteger startAddress, BigInteger endAddress, final DataRequestMonitor<IInstruction[]> drm) {
        IDisassembler disassembler;
        ITargetEnvironment env = this.getTargetEnvironmentService();
        IDisassembler iDisassembler = disassembler = env != null ? env.getDisassembler() : null;
        if (disassembler == null) {
            drm.setStatus(Disassembly.statusNoDisassembler());
            drm.done();
            return;
        }
        DsfServicesTracker services = this.getServicesTracker();
        if (services == null) {
            return;
        }
        IMemory memoryService = (IMemory)services.getService(IMemory.class);
        if (memoryService == null) {
            return;
        }
        int size = endAddress.intValue() - startAddress.intValue() + 16;
        IMemory.IMemoryDMContext mem_dmc = (IMemory.IMemoryDMContext)DMContexts.getAncestorOfType((IDMContext)context, IMemory.IMemoryDMContext.class);
        Addr64 start = new Addr64(startAddress);
        memoryService.getMemory(mem_dmc, (IAddress)start, 0L, 1, size, (DataRequestMonitor)new DataRequestMonitor<MemoryByte[]>((Executor)this.getExecutor(), drm, (IAddress)start, size, context, disassembler){
            private final /* synthetic */ IAddress val$start;
            private final /* synthetic */ int val$size;
            private final /* synthetic */ IDisassembly.IDisassemblyDMContext val$context;
            private final /* synthetic */ IDisassembler val$disassembler;
            {
                this.val$start = iAddress;
                this.val$size = n;
                this.val$context = iDisassemblyDMContext;
                this.val$disassembler = iDisassembler;
                super($anonymous0, $anonymous1);
            }

            protected void handleError() {
                IStatus s = this.getStatus();
                Throwable e = s.getException();
                if (e instanceof IMemory.MemoryError && s.getMessage().contains("Fail to read memory")) {
                    drm.setData((Object)Disassembly.failedMemoryDsfPseudoInstructions(this.val$start, this.val$size, s.getMessage()));
                    drm.done();
                } else {
                    super.handleError();
                }
            }

            protected void handleSuccess() {
                List<MemoryByte> memBytes = Arrays.asList((MemoryByte[])this.getData());
                HashMap<String, Object> options = new HashMap<String, Object>();
                try {
                    ArrayList<IInstruction> instrs = Disassembly.this.fillDisassemblyViewInstructions(memBytes, this.val$start, this.val$context, this.val$disassembler, options);
                    drm.setData((Object)instrs.toArray(new IInstruction[instrs.size()]));
                }
                catch (CoreException e) {
                    drm.setStatus(e.getStatus());
                }
                drm.done();
            }
        });
    }

    public void getInstructions(final IDisassembly.IDisassemblyDMContext context, String filename, int linenum, final int lines, final DataRequestMonitor<IInstruction[]> drm) {
        IModules modulesService = (IModules)this.getServicesTracker().getService(IModules.class);
        IModules.ISymbolDMContext sym_dmc = (IModules.ISymbolDMContext)DMContexts.getAncestorOfType((IDMContext)context, IModules.ISymbolDMContext.class);
        filename = EDCLaunch.getLaunchForSession(this.getSession().getId()).getCompilationPath(filename);
        modulesService.calcAddressInfo(sym_dmc, filename, linenum, 0, (DataRequestMonitor)new DataRequestMonitor<IModules.AddressRange[]>((Executor)this.getExecutor(), drm){

            protected void handleSuccess() {
                IModules.AddressRange[] addr_ranges = (IModules.AddressRange[])this.getData();
                IAddress start = addr_ranges[0].getStartAddress();
                IAddress end = start.add((long)(lines * 4));
                Disassembly.this.getInstructions(context, start.getValue(), end.getValue(), (DataRequestMonitor<IInstruction[]>)drm);
            }
        });
    }

    public void getMixedInstructions(IDisassembly.IDisassemblyDMContext context, BigInteger startAddress, BigInteger endAddress, final DataRequestMonitor<IMixedInstruction[]> drm) {
        Addr64 end;
        IAddress start;
        DsfServicesTracker services = this.getServicesTracker();
        if (services == null) {
            return;
        }
        IEDCSymbols symbolsService = (IEDCSymbols)services.getService(IEDCSymbols.class);
        if (symbolsService == null) {
            return;
        }
        IEDCModules modulesService = (IEDCModules)services.getService(IEDCModules.class);
        if (modulesService == null) {
            return;
        }
        IModules.ISymbolDMContext sym_dmc = (IModules.ISymbolDMContext)DMContexts.getAncestorOfType((IDMContext)context, IModules.ISymbolDMContext.class);
        ILineEntry startEntry = symbolsService.getLineEntryForAddress(sym_dmc, start = Disassembly.getStartAddressForLineEntryContainingAddress(symbolsService, modulesService, sym_dmc, (IAddress)new Addr64(startAddress), (IAddress)(end = new Addr64(endAddress))));
        if (startEntry == null) {
            this.getInstructions(context, startAddress, endAddress, new DataRequestMonitor<IInstruction[]>((Executor)this.getExecutor(), drm){

                protected void handleSuccess() {
                    IMixedInstruction[] ret = new IMixedInstruction[]{new EDCMixedInstruction("unknown", 0, (IInstruction[])this.getData())};
                    drm.setData((Object)ret);
                    drm.done();
                }
            });
        } else {
            final IEDCModuleDMContext module = modulesService.getModuleByAddress(sym_dmc, start);
            final List<ILineEntry> codeLines = symbolsService.getLineEntriesForAddressRange(sym_dmc, start, (IAddress)end);
            this.getInstructions(context, startAddress, endAddress, new DataRequestMonitor<IInstruction[]>((Executor)this.getExecutor(), drm){

                protected void handleSuccess() {
                    ArrayList<IMixedInstruction> mixedInstructions = new ArrayList<IMixedInstruction>();
                    Disassembly.this.mixSource(mixedInstructions, null, module, codeLines, (IInstruction[])this.getData());
                    drm.setData((Object)mixedInstructions.toArray(new IMixedInstruction[mixedInstructions.size()]));
                    drm.done();
                }
            });
        }
    }

    public void getMixedInstructions(final IDisassembly.IDisassemblyDMContext context, String filename, int linenum, final int lines, final DataRequestMonitor<IMixedInstruction[]> drm) {
        IDisassembler disassembler;
        ITargetEnvironment env = this.getTargetEnvironmentService();
        IDisassembler iDisassembler = disassembler = env != null ? env.getDisassembler() : null;
        if (disassembler == null) {
            drm.setStatus(Disassembly.statusNoDisassembler());
            drm.done();
            return;
        }
        IModules modulesService = (IModules)this.getServicesTracker().getService(IModules.class);
        IModules.ISymbolDMContext sym_dmc = (IModules.ISymbolDMContext)DMContexts.getAncestorOfType((IDMContext)context, IModules.ISymbolDMContext.class);
        filename = EDCLaunch.getLaunchForSession(this.getSession().getId()).getCompilationPath(filename);
        modulesService.calcAddressInfo(sym_dmc, filename, linenum, 0, (DataRequestMonitor)new DataRequestMonitor<IModules.AddressRange[]>((Executor)this.getExecutor(), drm){

            protected void handleSuccess() {
                IModules.AddressRange[] addr_ranges = (IModules.AddressRange[])this.getData();
                IAddress start = addr_ranges[0].getStartAddress();
                IAddress end = start.add((long)(lines * 4));
                Disassembly.this.getMixedInstructions(context, start.getValue(), end.getValue(), (DataRequestMonitor<IMixedInstruction[]>)drm);
            }
        });
    }

    private static EDCInstruction pseudoInstruction(IAddress address, int size, String pseudoMnemonic) {
        DisassembledInstruction pseudoInstruction = new DisassembledInstruction();
        pseudoInstruction.setAddress(address);
        pseudoInstruction.setSize(size);
        pseudoInstruction.setMnemonics(pseudoMnemonic);
        return new EDCInstruction(pseudoInstruction);
    }

    protected static IInstruction[] failedMemoryDsfPseudoInstructions(IAddress start, int size, String msg) {
        ArrayList<EDCInstruction> pseudoInstr = new ArrayList<EDCInstruction>();
        int offset = 0;
        int chunkSize = Math.min(size, 32 - start.getValue().intValue() % 32);
        do {
            pseudoInstr.add(Disassembly.pseudoInstruction(start.add((long)offset), chunkSize, String.valueOf(msg) + "..[length=" + chunkSize + ']'));
            chunkSize = Math.min(32, size - (offset += chunkSize));
        } while (offset < size);
        return pseudoInstr.toArray(new IInstruction[pseudoInstr.size()]);
    }

    protected ArrayList<IInstruction> fillDisassemblyViewInstructions(List<MemoryByte> memBytes, IAddress start, IDisassembly.IDisassemblyDMContext context, IDisassembler disassembler, Map<String, Object> options) throws CoreException {
        ArrayList<IInstruction> ret = new ArrayList<IInstruction>();
        int offset = 0;
        int last = memBytes.size();
        while (offset < last) {
            ByteBuffer codeBuf = this.translateMemoryBytes(memBytes.subList(offset, last));
            int codeBufSize = codeBuf.limit();
            IAddress block = start.add((long)offset);
            if (memBytes.get(offset).isReadable()) {
                try {
                    List<IDisassembledInstruction> insts = disassembler.disassembleInstructions(block, block.add((long)codeBufSize), codeBuf, options, context);
                    if (insts.size() == 0) break;
                    int i = 0;
                    while (i < insts.size()) {
                        ret.add((IInstruction)new EDCInstruction(insts.get(i)));
                        offset += insts.get(i).getSize();
                        ++i;
                    }
                }
                catch (CodeBufferUnderflowException codeBufferUnderflowException) {
                    if (offset == 0 && codeBufSize == last) {
                        ret.add((IInstruction)Disassembly.pseudoInstruction(start, codeBufSize, "Buffer Underflow during disassembly"));
                    }
                    offset += codeBufSize;
                }
                continue;
            }
            ret.add((IInstruction)Disassembly.pseudoInstruction(block, codeBufSize, Disassembly.cantReadMemory(block.toHexAddressString(), Integer.valueOf(codeBufSize).toString())));
            offset += codeBufSize;
        }
        return ret;
    }

    protected void mixSource(List<IMixedInstruction> mixedInstructions, EDCInstructionFunctionInfo wholeBlockInfo, IEDCModuleDMContext module, List<ILineEntry> codeLines, IInstruction[] instructions) {
        ArrayList<EDCInstruction> instsForLine = new ArrayList<EDCInstruction>();
        IPath filePath = null;
        String osString = null;
        EDCInstructionFunctionInfo functionInfo = wholeBlockInfo;
        int k = 0;
        int instsCnt = instructions.length;
        int lineCnt = codeLines.size();
        int i = 0;
        while (i < lineCnt && k < instsCnt) {
            instsForLine.clear();
            ILineEntry line = codeLines.get(i);
            if (wholeBlockInfo == null && module != null) {
                functionInfo = new EDCInstructionFunctionInfo(module, line);
            }
            while (k < instsCnt) {
                EDCInstruction inst = (EDCInstruction)instructions[k];
                IAddress linkAddress = module.toLinkAddress((IAddress)new Addr64(inst.getAdress()));
                if (linkAddress.compareTo((Object)line.getHighAddress()) >= 0) break;
                if (functionInfo != null) {
                    inst.setFunctionName(functionInfo.getFunctionName());
                    IAddress functionBase = functionInfo.getFunctionStartAddress();
                    if (functionBase != null) {
                        inst.setOffset(functionBase.distanceTo(linkAddress).intValue());
                    }
                }
                instsForLine.add(inst);
                ++k;
            }
            if (line.getFilePath() != filePath) {
                filePath = line.getFilePath();
                osString = filePath != null ? filePath.toOSString() : null;
            }
            mixedInstructions.add(new EDCMixedInstruction(osString, line.getLineNumber(), instsForLine.toArray(new IInstruction[instsForLine.size()])));
            ++i;
        }
    }

    protected static IAddress getStartAddressForLineEntryContainingAddress(IEDCSymbols symbolsService, IEDCModules modulesService, IModules.ISymbolDMContext sym_dmc, IAddress initialStartAddress, IAddress endAddress) {
        List<ILineEntry> allLines;
        IEDCModuleDMContext module;
        assert (symbolsService != null && modulesService != null);
        if (symbolsService == null || modulesService == null) {
            return initialStartAddress;
        }
        if (sym_dmc != null && symbolsService.getLineEntryForAddress(sym_dmc, initialStartAddress) != null && (module = modulesService.getModuleByAddress(sym_dmc, initialStartAddress)) != null && (allLines = symbolsService.getLineEntriesForAddressRange(sym_dmc, initialStartAddress, endAddress)) != null && !allLines.isEmpty()) {
            return module.toRuntimeAddress(allLines.get(0).getLowAddress());
        }
        return initialStartAddress;
    }
}

