/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.cli.tracing;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.tizen.dynamicanalyzer.setting.PrimitiveFeature;
import org.tizen.dynamicanalyzer.util.Logger;

public class TracingArguments
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -629159798713778033L;
    private String device;
    private String applicationID;
    private Set<PrimitiveFeature> featuresSet = new HashSet<PrimitiveFeature>();
    private String output;
    private long durationSec = 0L;
    private int screenshotPeriod = 0;
    private boolean screenshotOnSceneTransition = false;
    private boolean lsanSelected = false;
    private String errMessage = "";

    public TracingArguments clone() {
        TracingArguments copy = null;
        try {
            copy = (TracingArguments)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
        return copy;
    }

    public boolean isValid() {
        boolean result = true;
        String msg = "Arguments are invalid:%n";
        if (this.device == null || this.device.isEmpty()) {
            result = false;
            msg = msg + " * Device is not specified%n";
        }
        if (this.applicationID == null || this.applicationID.isEmpty()) {
            result = false;
            msg = msg + " * Application is not specified%n";
        }
        if (this.durationSec < 0L) {
            result = false;
            msg = msg + " * Duration is negative%n";
        }
        if (this.screenshotPeriod < 0) {
            result = false;
            msg = msg + " * Screenshot period is negative%n";
        }
        if (this.featuresSet.isEmpty()) {
            result = false;
            msg = msg + " * At least one feature for tracing must be selected%n";
        } else if (this.lsanSelected) {
            if (!this.featuresSet.contains(PrimitiveFeature.MEMORY_ALLOC)) {
                result = false;
                msg = msg + " * LeakSanitizer works only with Heap Allocation feature%n";
            }
            if (this.featuresSet.contains(PrimitiveFeature.THREAD_ANALYSIS)) {
                result = false;
                msg = msg + " * LeakSanitizer does not work with Thread Analysis feature%n";
            }
        }
        this.errMessage = result ? "" : String.format(msg, new Object[0]).trim();
        return result;
    }

    public String getErrorMessage() {
        return this.errMessage;
    }

    public String getDevice() {
        return this.device;
    }

    public TracingArguments setDevice(String device) {
        this.device = device;
        return this;
    }

    public String getApplicationID() {
        return this.applicationID;
    }

    public TracingArguments setApplicationID(String applicationID) {
        this.applicationID = applicationID;
        return this;
    }

    public long getDuration() {
        return this.durationSec;
    }

    public TracingArguments setDuration(long duration) {
        this.durationSec = duration;
        return this;
    }

    public String getOutput() {
        return this.output;
    }

    public TracingArguments setOutput(String output) {
        if (output == null) {
            return this;
        }
        if (!output.endsWith(".zip")) {
            output = output + ".zip";
        }
        String out = null;
        try {
            out = new File(output).getCanonicalPath();
        }
        catch (IOException e) {
            Logger.error((Object)e);
        }
        this.output = out;
        return this;
    }

    public int getScreenshotPeriod() {
        return this.screenshotPeriod;
    }

    public TracingArguments setScreenshotPeriod(int period) {
        this.screenshotPeriod = period;
        this.featuresSet.add(PrimitiveFeature.SCREENSHOT);
        return this;
    }

    public boolean getScreenshotOnSceneTransition() {
        return this.screenshotOnSceneTransition;
    }

    public TracingArguments setScreenshotOnSceneTransition(boolean flag) {
        this.screenshotOnSceneTransition = flag;
        if (flag) {
            this.featuresSet.add(PrimitiveFeature.SCREENSHOT);
        }
        return this;
    }

    public boolean getLSanPreference() {
        return this.lsanSelected;
    }

    public TracingArguments setLSanPreference(boolean selected) {
        this.lsanSelected = selected;
        return this;
    }

    public Set<PrimitiveFeature> getFeatures() {
        return this.featuresSet;
    }

    public TracingArguments addFeature(PrimitiveFeature feature) {
        this.featuresSet.add(feature);
        return this;
    }
}

