/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.cli.tracing;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Arrays;
import org.apache.commons.cli.ParseException;
import org.tizen.dynamicanalyzer.cli.CliInternals;
import org.tizen.dynamicanalyzer.cli.tracing.SystemExit;
import org.tizen.dynamicanalyzer.cli.tracing.TracingArguments;
import org.tizen.dynamicanalyzer.cli.tracing.TracingArgumentsParser;
import org.tizen.dynamicanalyzer.cli.utils.Communicator;
import org.tizen.dynamicanalyzer.cli.utils.ProcessCommunicationProcessor;
import org.tizen.dynamicanalyzer.common.DAResult;
import org.tizen.dynamicanalyzer.common.DAState;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.common.path.PathManager;
import org.tizen.dynamicanalyzer.util.Logger;

public class TracingProcess {
    private volatile DAResult.ErrorCode status = DAResult.ErrorCode.ERR_UNKNOWN;
    private final TracingArguments args;
    private ProcessCommunicationProcessor communicationProcessor;
    private long startTime;
    private volatile long tracingTime;

    public TracingProcess(TracingArguments args) {
        this.args = args;
    }

    public synchronized DAResult.ErrorCode startTrace() {
        DAResult.ErrorCode result = CliInternals.startTracing(this.args);
        if (result != DAResult.ErrorCode.SUCCESS) {
            this.communicationProcessor.errorOccured(result.getErrorNumber());
            return result;
        }
        try {
            DAState.waitPrepared();
        }
        catch (InterruptedException e) {
            Logger.error((Object)e);
            return DAResult.ErrorCode.ERR_EXCEPTION_OCCURRED;
        }
        if (!DAState.isRunning() && result == DAResult.ErrorCode.SUCCESS) {
            result = DAResult.ErrorCode.ERR_EXCEPTION_OCCURRED;
        }
        this.startTime = System.nanoTime() / 1000L;
        return result;
    }

    public synchronized void stopTrace() {
        this.tracingTime = System.nanoTime() / 1000L - this.startTime;
        if (Global.getProject() == null) {
            this.communicationProcessor.errorOccured(DAResult.ErrorCode.ERR_TRACING_NOT_RUNNING.getErrorNumber());
            return;
        }
        Global.getProject().setTotalStopTime(this.tracingTime);
        CliInternals.stopTracing();
    }

    public boolean saveTrace(String dest) {
        if (dest == null || dest.isEmpty()) {
            return CliInternals.saveTrace(this.args.getOutput());
        }
        return CliInternals.saveTrace(dest);
    }

    public void waitForCompletion() throws InterruptedException {
        DAState.waitDone();
    }

    public synchronized DAResult.ErrorCode getStatus() {
        return this.status;
    }

    private static DAResult.ErrorCode performAllTasks(String[] args) {
        Logger.init((int)1);
        int port = Integer.parseInt(args[0]);
        TracingArguments argsParsed = null;
        args = Arrays.copyOfRange(args, 1, args.length);
        try {
            argsParsed = TracingArgumentsParser.parse(args);
        }
        catch (ParseException e) {
            Logger.error((String)"Error while parsing arguments: %s.", (Object[])new Object[]{e.toString()});
            Logger.error((String)"Start tracing arguments was: %s.", (Object[])new Object[]{Arrays.toString(args)});
            return DAResult.ErrorCode.ERR_WRONG_MESSAGE_FORMAT;
        }
        TracingProcess tracingProcess = new TracingProcess(argsParsed);
        Thread commThread = null;
        try {
            Socket socket = new Socket(InetAddress.getLocalHost(), port);
            ObjectInputStream ois = new ObjectInputStream(socket.getInputStream());
            ObjectOutputStream oos = new ObjectOutputStream(socket.getOutputStream());
            oos.flush();
            tracingProcess.communicationProcessor = new ProcessCommunicationProcessor(new Communicator(ois, oos), tracingProcess);
            commThread = new Thread((Runnable)tracingProcess.communicationProcessor, ProcessCommunicationProcessor.class.getSimpleName());
            commThread.start();
        }
        catch (IOException ioe) {
            Logger.error((Object)"IOException in socket connection.");
        }
        Logger.info((String)"Going to start tracing on device '%s'.", (Object[])new Object[]{argsParsed.getDevice()});
        DAResult.ErrorCode result = tracingProcess.startTrace();
        if (result != DAResult.ErrorCode.SUCCESS) {
            Logger.error((String)"Error while start tracing: %s.", (Object[])new Object[]{result.toString()});
            return result;
        }
        try {
            tracingProcess.waitForCompletion();
        }
        catch (InterruptedException e) {
            Logger.error((Object)"Main tracing thread was interrupted.");
            return DAResult.ErrorCode.ERR_EXCEPTION_OCCURRED;
        }
        if (!tracingProcess.saveTrace(null)) {
            Logger.error((Object)"Failed to save tracing results.%nSaving results in temp folder.");
            tracingProcess.saveTrace(PathManager.DA_TEMP_FOLDER_PATH + File.separator + "unsaved_trace.zip");
            return DAResult.ErrorCode.ERR_EXCEPTION_OCCURRED;
        }
        try {
            if (commThread != null) {
                commThread.join();
            }
        }
        catch (InterruptedException e) {
            Logger.error((Object)"Tracing Process was interrupted, while waiting for communication to be closed");
        }
        return tracingProcess.getStatus();
    }

    public static void main(String[] args) {
        DAResult.ErrorCode exitCode = TracingProcess.performAllTasks(args);
        SystemExit.exit(exitCode.getErrorNumber());
    }

    public long getTracingTime() {
        return this.tracingTime;
    }
}

