/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.templateengine.process.processes;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.TemplateEngineHelper;
import org.eclipse.cdt.core.templateengine.process.ProcessArgument;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.ProcessHelper;
import org.eclipse.cdt.core.templateengine.process.ProcessRunner;
import org.eclipse.cdt.core.templateengine.process.processes.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class AddFile
extends ProcessRunner {
    public void process(TemplateCore template, ProcessArgument[] args, String processId, IProgressMonitor monitor) throws ProcessFailureException {
        URL path;
        String projectName = args[0].getSimpleValue();
        ProcessArgument file = args[1];
        ProcessArgument[] fileMembers = file.getComplexValue();
        String fileSourcePath = fileMembers[0].getSimpleValue();
        String fileTargetPath = fileMembers[1].getSimpleValue();
        boolean replaceable = fileMembers[2].getSimpleValue().equals("true");
        IProject projectHandle = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        try {
            path = TemplateEngineHelper.getTemplateResourceURLRelativeToTemplate(template, fileSourcePath);
            if (path == null) {
                throw new ProcessFailureException(this.getProcessMessage(processId, 4, String.valueOf(Messages.getString("AddFile.0")) + fileSourcePath));
            }
        }
        catch (IOException iOException) {
            throw new ProcessFailureException(this.getProcessMessage(processId, 4, String.valueOf(Messages.getString("AddFile.1")) + fileSourcePath));
        }
        InputStream contents = null;
        if (replaceable) {
            String fileContents;
            try {
                fileContents = ProcessHelper.readFromFile(path);
            }
            catch (IOException iOException) {
                throw new ProcessFailureException(this.getProcessMessage(processId, 4, String.valueOf(Messages.getString("AddFile.2")) + fileSourcePath));
            }
            fileContents = ProcessHelper.getValueAfterExpandingMacros(fileContents, ProcessHelper.getReplaceKeys(fileContents), template.getValueStore());
            contents = new ByteArrayInputStream(fileContents.getBytes());
        } else {
            try {
                contents = path.openStream();
            }
            catch (IOException iOException) {
                throw new ProcessFailureException(this.getProcessMessage(processId, 4, String.valueOf(Messages.getString("AddFile.3")) + fileSourcePath));
            }
        }
        try {
            IFile iFile = projectHandle.getFile(fileTargetPath);
            if (!iFile.getParent().exists()) {
                ProcessHelper.mkdirs(projectHandle, projectHandle.getFolder(iFile.getParent().getProjectRelativePath()));
            }
            iFile.create(contents, true, null);
            iFile.refreshLocal(1, null);
            projectHandle.refreshLocal(2, null);
        }
        catch (CoreException e) {
            throw new ProcessFailureException(this.getProcessMessage(processId, 4, String.valueOf(Messages.getString("AddFile.4")) + e.getMessage()), e);
        }
    }
}

